/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.storage;

import java.io.IOException;
import org.apache.pulsar.broker.BookKeeperClientFactory;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public interface ManagedLedgerStorage
extends AutoCloseable {
    public void initialize(ServiceConfiguration var1, MetadataStoreExtended var2, BookKeeperClientFactory var3, EventLoopGroup var4) throws Exception;

    public ManagedLedgerFactory getManagedLedgerFactory();

    public StatsProvider getStatsProvider();

    public BookKeeper getBookKeeperClient();

    @Override
    public void close() throws IOException;

    public static ManagedLedgerStorage create(ServiceConfiguration conf, MetadataStoreExtended metadataStore, BookKeeperClientFactory bkProvider, EventLoopGroup eventLoopGroup) throws Exception {
        Class<?> storageClass = Class.forName(conf.getManagedLedgerStorageClassName());
        ManagedLedgerStorage storage = (ManagedLedgerStorage)storageClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        storage.initialize(conf, metadataStore, bkProvider, eventLoopGroup);
        return storage;
    }
}

