/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.pulsar.shade.javax.websocket.Encoder;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.annotated.InvalidSignatureException;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.util.ReflectUtils;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.MessageType;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.metadata.CoderMetadataSet;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.metadata.EncoderMetadata;

public class EncoderMetadataSet
extends CoderMetadataSet<Encoder, EncoderMetadata> {
    @Override
    protected List<EncoderMetadata> discover(Class<? extends Encoder> encoder) {
        Class<?> objType;
        ArrayList<EncoderMetadata> metadatas = new ArrayList<EncoderMetadata>();
        if (Encoder.Binary.class.isAssignableFrom(encoder)) {
            objType = this.getEncoderType(encoder, Encoder.Binary.class);
            metadatas.add(new EncoderMetadata(encoder, objType, MessageType.BINARY, false));
        }
        if (Encoder.BinaryStream.class.isAssignableFrom(encoder)) {
            objType = this.getEncoderType(encoder, Encoder.BinaryStream.class);
            metadatas.add(new EncoderMetadata(encoder, objType, MessageType.BINARY, true));
        }
        if (Encoder.Text.class.isAssignableFrom(encoder)) {
            objType = this.getEncoderType(encoder, Encoder.Text.class);
            metadatas.add(new EncoderMetadata(encoder, objType, MessageType.TEXT, false));
        }
        if (Encoder.TextStream.class.isAssignableFrom(encoder)) {
            objType = this.getEncoderType(encoder, Encoder.TextStream.class);
            metadatas.add(new EncoderMetadata(encoder, objType, MessageType.TEXT, true));
        }
        if (!ReflectUtils.isDefaultConstructable(encoder)) {
            throw new InvalidSignatureException("Encoder must have public, no-args constructor: " + encoder.getName());
        }
        if (metadatas.size() <= 0) {
            throw new InvalidSignatureException("Not a valid Encoder class: " + encoder.getName() + " implements no " + Encoder.class.getName() + " interfaces");
        }
        return metadatas;
    }

    private Class<?> getEncoderType(Class<? extends Encoder> encoder, Class<?> interfaceClass) {
        Class<?> decoderClass = ReflectUtils.findGenericClassFor(encoder, interfaceClass);
        if (decoderClass == null) {
            StringBuilder err = new StringBuilder();
            err.append("Invalid type declared for interface ");
            err.append(interfaceClass.getName());
            err.append(" on class ");
            err.append(encoder);
            throw new InvalidWebSocketException(err.toString());
        }
        return decoderClass;
    }

    protected final void register(Class<?> type, Class<? extends Encoder> encoder, MessageType msgType, boolean streamed) {
        EncoderMetadata metadata = new EncoderMetadata(encoder, type, msgType, streamed);
        this.trackMetadata(metadata);
    }
}

