/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.cli;

import org.apache.pulsar.shade.org.apache.commons.cli.CommandLine;
import org.apache.pulsar.shade.org.apache.commons.cli.DefaultParser;
import org.apache.pulsar.shade.org.apache.commons.cli.Options;
import org.apache.pulsar.shade.org.apache.commons.cli.ParseException;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.cli.CliCommand;
import org.apache.pulsar.shade.org.apache.zookeeper.cli.CliException;
import org.apache.pulsar.shade.org.apache.zookeeper.cli.CliParseException;
import org.apache.pulsar.shade.org.apache.zookeeper.cli.CliWrapperException;
import org.apache.pulsar.shade.org.apache.zookeeper.cli.StatPrinter;
import org.apache.pulsar.shade.org.apache.zookeeper.data.Stat;
import org.apache.pulsar.shade.org.apache.zookeeper.server.util.ConfigUtils;

public class GetConfigCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public GetConfigCommand() {
        super("config", "[-c] [-w] [-s]");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 1) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        byte[] data;
        boolean watch = this.cl.hasOption("w");
        Stat stat = new Stat();
        try {
            data = this.zk.getConfig(watch, stat);
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        byte[] byArray = data = data == null ? "null".getBytes() : data;
        if (this.cl.hasOption("c")) {
            this.out.println(ConfigUtils.getClientConfigStr(new String(data)));
        } else {
            this.out.println(new String(data));
        }
        if (this.cl.hasOption("s")) {
            new StatPrinter(this.out).print(stat);
        }
        return watch;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("w", false, "watch");
        options.addOption("c", false, "client connection string");
    }
}

