/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.replication;

import java.util.function.Function;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;

public abstract class ReplicationException
extends Exception {
    public static final Function<Throwable, ReplicationException> EXCEPTION_HANDLER = cause -> {
        if (cause instanceof ReplicationException) {
            return (ReplicationException)cause;
        }
        return new UnavailableException(cause.getMessage(), (Throwable)cause);
    };

    public static UnavailableException fromKeeperException(String message, KeeperException ke) {
        if (ke instanceof KeeperException.ConnectionLossException || ke instanceof KeeperException.SessionExpiredException) {
            return new NonRecoverableReplicationException(message, ke);
        }
        return new UnavailableException(message, ke);
    }

    protected ReplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    protected ReplicationException(String message) {
        super(message);
    }

    public static class BKAuditException
    extends ReplicationException {
        private static final long serialVersionUID = 95551905L;

        BKAuditException(String message, Throwable cause) {
            super(message, cause);
        }

        BKAuditException(String message) {
            super(message);
        }
    }

    public static class CompatibilityException
    extends ReplicationException {
        private static final long serialVersionUID = 98551903L;

        public CompatibilityException(String message, Throwable cause) {
            super(message, cause);
        }

        public CompatibilityException(String message) {
            super(message);
        }
    }

    public static class NonRecoverableReplicationException
    extends UnavailableException {
        private static final long serialVersionUID = 31872211L;

        public NonRecoverableReplicationException(String message, Throwable cause) {
            super(message, cause);
        }

        public NonRecoverableReplicationException(String message) {
            super(message);
        }
    }

    public static class UnavailableException
    extends ReplicationException {
        private static final long serialVersionUID = 31872209L;

        public UnavailableException(String message, Throwable cause) {
            super(message, cause);
        }

        public UnavailableException(String message) {
            super(message);
        }
    }
}

