/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.mledger;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.com.google.common.base.Predicate;
import org.apache.pulsar.shade.com.google.common.collect.Range;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedCursorMXBean;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface ManagedCursor {
    public String getName();

    public long getLastActive();

    public void updateLastActive();

    public Map<String, Long> getProperties();

    public Map<String, String> getCursorProperties();

    default public CompletableFuture<Void> setCursorProperties(Map<String, String> cursorProperties) {
        return CompletableFuture.completedFuture(null);
    }

    public boolean putProperty(String var1, Long var2);

    public boolean removeProperty(String var1);

    public List<Entry> readEntries(int var1) throws InterruptedException, ManagedLedgerException;

    public void asyncReadEntries(int var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3, PositionImpl var4);

    public void asyncReadEntries(int var1, long var2, AsyncCallbacks.ReadEntriesCallback var4, Object var5, PositionImpl var6);

    public Entry getNthEntry(int var1, IndividualDeletedEntries var2) throws InterruptedException, ManagedLedgerException;

    public void asyncGetNthEntry(int var1, IndividualDeletedEntries var2, AsyncCallbacks.ReadEntryCallback var3, Object var4);

    public List<Entry> readEntriesOrWait(int var1) throws InterruptedException, ManagedLedgerException;

    public List<Entry> readEntriesOrWait(int var1, long var2) throws InterruptedException, ManagedLedgerException;

    public void asyncReadEntriesOrWait(int var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3, PositionImpl var4);

    public void asyncReadEntriesOrWait(int var1, long var2, AsyncCallbacks.ReadEntriesCallback var4, Object var5, PositionImpl var6);

    public boolean cancelPendingReadRequest();

    public boolean hasMoreEntries();

    public long getNumberOfEntries();

    public long getNumberOfEntriesInBacklog(boolean var1);

    public void markDelete(Position var1) throws InterruptedException, ManagedLedgerException;

    public void markDelete(Position var1, Map<String, Long> var2) throws InterruptedException, ManagedLedgerException;

    public void asyncMarkDelete(Position var1, AsyncCallbacks.MarkDeleteCallback var2, Object var3);

    public void asyncMarkDelete(Position var1, Map<String, Long> var2, AsyncCallbacks.MarkDeleteCallback var3, Object var4);

    public void delete(Position var1) throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(Position var1, AsyncCallbacks.DeleteCallback var2, Object var3);

    public void delete(Iterable<Position> var1) throws InterruptedException, ManagedLedgerException;

    public void asyncDelete(Iterable<Position> var1, AsyncCallbacks.DeleteCallback var2, Object var3);

    public Position getReadPosition();

    public Position getMarkDeletedPosition();

    public Position getPersistentMarkDeletedPosition();

    public void rewind();

    default public void seek(Position newReadPosition) {
        this.seek(newReadPosition, false);
    }

    public void seek(Position var1, boolean var2);

    public void clearBacklog() throws InterruptedException, ManagedLedgerException;

    public void asyncClearBacklog(AsyncCallbacks.ClearBacklogCallback var1, Object var2);

    public void skipEntries(int var1, IndividualDeletedEntries var2) throws InterruptedException, ManagedLedgerException;

    public void asyncSkipEntries(int var1, IndividualDeletedEntries var2, AsyncCallbacks.SkipEntriesCallback var3, Object var4);

    public Position findNewestMatching(Predicate<Entry> var1) throws InterruptedException, ManagedLedgerException;

    public Position findNewestMatching(FindPositionConstraint var1, Predicate<Entry> var2) throws InterruptedException, ManagedLedgerException;

    public void asyncFindNewestMatching(FindPositionConstraint var1, Predicate<Entry> var2, AsyncCallbacks.FindEntryCallback var3, Object var4);

    public void asyncFindNewestMatching(FindPositionConstraint var1, Predicate<Entry> var2, AsyncCallbacks.FindEntryCallback var3, Object var4, boolean var5);

    public void resetCursor(Position var1) throws InterruptedException, ManagedLedgerException;

    public void asyncResetCursor(Position var1, boolean var2, AsyncCallbacks.ResetCursorCallback var3);

    public List<Entry> replayEntries(Set<? extends Position> var1) throws InterruptedException, ManagedLedgerException;

    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3);

    public Set<? extends Position> asyncReplayEntries(Set<? extends Position> var1, AsyncCallbacks.ReadEntriesCallback var2, Object var3, boolean var4);

    public void close() throws InterruptedException, ManagedLedgerException;

    public void asyncClose(AsyncCallbacks.CloseCallback var1, Object var2);

    public Position getFirstPosition();

    public void setActive();

    public void setInactive();

    public void setAlwaysInactive();

    public boolean isActive();

    public boolean isDurable();

    public long getNumberOfEntriesSinceFirstNotAckedMessage();

    public int getTotalNonContiguousDeletedMessagesRange();

    public int getNonContiguousDeletedMessagesRangeSerializedSize();

    public long getEstimatedSizeSinceMarkDeletePosition();

    default public void skipNonRecoverableLedger(long ledgerId) {
    }

    public double getThrottleMarkDelete();

    public void setThrottleMarkDelete(double var1);

    public ManagedLedger getManagedLedger();

    public Range<PositionImpl> getLastIndividualDeletedRange();

    public void trimDeletedEntries(List<Entry> var1);

    public long[] getDeletedBatchIndexesAsLongArray(PositionImpl var1);

    public ManagedCursorMXBean getStats();

    public boolean checkAndUpdateReadPositionChanged();

    public boolean isClosed();

    public static enum IndividualDeletedEntries {
        Include,
        Exclude;

    }

    public static enum FindPositionConstraint {
        SearchActiveEntries,
        SearchAllAvailableEntries;

    }
}

