/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.StringUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.AsyncCallback;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHierarchicalLedgerManager
extends AbstractZkLedgerManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHierarchicalLedgerManager.class);

    public AbstractHierarchicalLedgerManager(AbstractConfiguration conf, ZooKeeper zk) {
        super(conf, zk);
    }

    void asyncProcessLevelNodes(String path, final BookkeeperInternalCallbacks.Processor<String> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
        this.zk.sync(path, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    finalCb.processResult(successRc, null, context);
                    return;
                }
                if (rc != KeeperException.Code.OK.intValue()) {
                    LOG.error("Error syncing path " + path + " when getting its chidren: ", (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                    finalCb.processResult(failureRc, null, context);
                    return;
                }
                AbstractHierarchicalLedgerManager.this.zk.getChildren(path, false, new AsyncCallback.ChildrenCallback(){

                    @Override
                    public void processResult(int rc, String path, Object ctx, List<String> levelNodes) {
                        if (rc == KeeperException.Code.NONODE.intValue()) {
                            finalCb.processResult(successRc, null, context);
                            return;
                        }
                        if (rc != KeeperException.Code.OK.intValue()) {
                            LOG.error("Error polling hash nodes of " + path, (Throwable)KeeperException.create(KeeperException.Code.get(rc), path));
                            finalCb.processResult(failureRc, null, context);
                            return;
                        }
                        AsyncListProcessor<String> listProcessor = new AsyncListProcessor<String>(AbstractHierarchicalLedgerManager.this.scheduler);
                        listProcessor.process(levelNodes, processor, finalCb, context, successRc, failureRc);
                    }
                }, null);
            }
        }, null);
    }

    long getLedgerId(String ... levelNodes) throws IOException {
        return StringUtils.stringToHierarchicalLedgerId(levelNodes);
    }

    @Override
    protected NavigableSet<Long> ledgerListToSet(List<String> ledgerNodes, String path) {
        char ch;
        TreeSet<Long> zkActiveLedgers = new TreeSet<Long>();
        if (!path.startsWith(this.ledgerRootPath)) {
            LOG.warn("Ledger path [{}] is not a valid path name, it should start wth {}", (Object)path, (Object)this.ledgerRootPath);
            return zkActiveLedgers;
        }
        long ledgerIdPrefix = 0L;
        for (int i = this.ledgerRootPath.length() + 1; i < path.length(); ++i) {
            ch = path.charAt(i);
            if (ch < '0' || ch > '9') continue;
            ledgerIdPrefix = ledgerIdPrefix * 10L + (long)(ch - 48);
        }
        for (String ledgerNode : ledgerNodes) {
            if (AbstractHierarchicalLedgerManager.isSpecialZnode(ledgerNode)) continue;
            long ledgerId = ledgerIdPrefix;
            for (int i = 0; i < ledgerNode.length(); ++i) {
                ch = ledgerNode.charAt(i);
                if (ch < '0' || ch > '9') continue;
                ledgerId = ledgerId * 10L + (long)(ch - 48);
            }
            zkActiveLedgers.add(ledgerId);
        }
        return zkActiveLedgers;
    }

    private static class AsyncListProcessor<T> {
        ScheduledExecutorService scheduler;

        public AsyncListProcessor(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
        }

        public void process(final List<T> data, final BookkeeperInternalCallbacks.Processor<T> processor, final AsyncCallback.VoidCallback finalCb, final Object context, final int successRc, final int failureRc) {
            if (data == null || data.size() == 0) {
                finalCb.processResult(successRc, null, context);
                return;
            }
            final int size = data.size();
            final AtomicInteger current = new AtomicInteger(0);
            AsyncCallback.VoidCallback stubCallback = new AsyncCallback.VoidCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx) {
                    if (rc != successRc) {
                        finalCb.processResult(failureRc, null, context);
                        return;
                    }
                    int next = current.incrementAndGet();
                    if (next >= size) {
                        finalCb.processResult(successRc, null, context);
                        return;
                    }
                    final Object dataToProcess = data.get(next);
                    final 1 stub = this;
                    scheduler.submit(new Runnable(){

                        @Override
                        public void run() {
                            processor.process(dataToProcess, stub);
                        }
                    });
                }
            };
            T firstElement = data.get(0);
            processor.process(firstElement, stubCallback);
        }
    }
}

