/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance.state;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.functions.api.StateStore;
import org.apache.pulsar.functions.instance.state.BKStateStoreImpl;
import org.apache.pulsar.functions.instance.state.StateStoreProvider;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.shade.com.google.common.base.Stopwatch;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.StorageClient;
import org.apache.pulsar.shade.org.apache.bookkeeper.api.kv.Table;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.admin.SimpleStorageAdminClientImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.exceptions.ClientException;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.exceptions.NamespaceNotFoundException;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.exceptions.StreamNotFoundException;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.Backoff;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.StorageType;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.stream.protocol.ProtocolConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKStateStoreProviderImpl
implements StateStoreProvider {
    private static final Logger log = LoggerFactory.getLogger(BKStateStoreProviderImpl.class);
    private String stateStorageServiceUrl;
    private Map<String, StorageClient> clients;

    @Override
    public void init(Map<String, Object> config, Function.FunctionDetails functionDetails) throws Exception {
        this.stateStorageServiceUrl = (String)config.get("stateStorageServiceUrl");
        this.clients = new HashMap<String, StorageClient>();
    }

    private StorageClient getStorageClient(String tenant, String namespace) {
        String tableNs = FunctionCommon.getStateNamespace(tenant, namespace);
        StorageClient client = this.clients.get(tableNs);
        if (null != client) {
            return client;
        }
        StorageClientSettings settings = StorageClientSettings.newBuilder().serviceUri(this.stateStorageServiceUrl).enableServerSideRouting(true).clientName("function-" + tableNs).backoffPolicy(Backoff.Jitter.of(Backoff.Jitter.Type.EXPONENTIAL, 100L, 2000L, 60L)).build();
        StorageClient storageClient = StorageClientBuilder.newBuilder().withSettings(settings).withNamespace(tableNs).build();
        this.clients.put(tableNs, storageClient);
        return storageClient;
    }

    private void createStateTable(String stateStorageServiceUrl, String tenant, String namespace, String name) throws Exception {
        String tableNs = FunctionCommon.getStateNamespace(tenant, namespace);
        String tableName = name;
        try (SimpleStorageAdminClientImpl storageAdminClient = new SimpleStorageAdminClientImpl(StorageClientSettings.newBuilder().serviceUri(stateStorageServiceUrl).build(), ClientResources.create().scheduler());){
            StreamConfiguration streamConf = StreamConfiguration.newBuilder(ProtocolConstants.DEFAULT_STREAM_CONF).setInitialNumRanges(4).setMinNumRanges(4).setStorageType(StorageType.TABLE).build();
            Stopwatch elapsedWatch = Stopwatch.createStarted();
            Exception lastException = null;
            while (elapsedWatch.elapsed(TimeUnit.MINUTES) < 1L) {
                try {
                    FutureUtils.result(storageAdminClient.getStream(tableNs, tableName));
                    return;
                }
                catch (NamespaceNotFoundException nnfe) {
                    try {
                        FutureUtils.result(storageAdminClient.createNamespace(tableNs, NamespaceConfiguration.newBuilder().setDefaultStreamConf(streamConf).build()));
                    }
                    catch (Exception e) {
                        lastException = e;
                        log.warn("Encountered exception when creating namespace {} for state table", (Object)tableName, (Object)e);
                    }
                    try {
                        FutureUtils.result(storageAdminClient.createStream(tableNs, tableName, streamConf));
                    }
                    catch (Exception e) {
                        lastException = e;
                        log.warn("Encountered exception when creating table {}/{}", new Object[]{tableNs, tableName, e});
                    }
                }
                catch (StreamNotFoundException snfe) {
                    try {
                        FutureUtils.result(storageAdminClient.createStream(tableNs, tableName, streamConf));
                    }
                    catch (Exception e) {
                        lastException = e;
                        log.warn("Encountered exception when creating table {}/{}", new Object[]{tableNs, tableName, e});
                    }
                }
                catch (ClientException ce) {
                    log.warn("Encountered issue {} on fetching state stable metadata, re-attempting in 100 milliseconds", (Object)ce.getMessage());
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
            }
            throw new IOException(String.format("Failed to setup / verify state table for function %s/%s/%s within timeout", tenant, name, name), lastException);
        }
    }

    private Table<ByteBuf, ByteBuf> openStateTable(String tenant, String namespace, String name) throws Exception {
        StorageClient client = this.getStorageClient(tenant, namespace);
        log.info("Opening state table for function {}/{}/{}", new Object[]{tenant, namespace, name});
        Stopwatch openSw = Stopwatch.createStarted();
        while (openSw.elapsed(TimeUnit.MINUTES) < 1L) {
            try {
                return FutureUtils.result(client.openTable(name), 1L, TimeUnit.MINUTES);
            }
            catch (InternalServerException ise) {
                log.warn("Encountered internal server on opening state table '{}/{}/{}', re-attempt in 100 milliseconds : {}", new Object[]{tenant, namespace, name, ise.getMessage()});
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (TimeoutException e) {
                throw new RuntimeException("Failed to open state table for function " + tenant + "/" + namespace + "/" + name + " within timeout period", e);
            }
        }
        throw new IOException("Failed to open state table for function " + tenant + "/" + namespace + "/" + name);
    }

    @Override
    public <S extends StateStore> S getStateStore(String tenant, String namespace, String name) throws Exception {
        this.createStateTable(this.stateStorageServiceUrl, tenant, namespace, name);
        Table<ByteBuf, ByteBuf> table = this.openStateTable(tenant, namespace, name);
        return (S)new BKStateStoreImpl(tenant, namespace, name, table);
    }

    @Override
    public void close() {
        this.clients.forEach((name, client) -> client.closeAsync().exceptionally(cause -> {
            log.warn("Failed to close state storage client", cause);
            return null;
        }));
        this.clients.clear();
    }
}

