/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.client.util.WithSNISslEngineFactory;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslProvider;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.apache.pulsar.shade.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    protected static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    protected static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    protected final AsyncHttpClient httpClient;
    protected final ServiceNameResolver serviceNameResolver;
    protected final Authentication authentication;

    protected HttpClient(ClientConfigurationData conf, EventLoopGroup eventLoopGroup) throws PulsarClientException {
        this.authentication = conf.getAuthentication();
        this.serviceNameResolver = new PulsarServiceNameResolver();
        this.serviceNameResolver.updateServiceUrl(conf.getServiceUrl());
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setUseProxyProperties(true);
        confBuilder.setFollowRedirect(true);
        confBuilder.setMaxRedirects(conf.getMaxLookupRedirects());
        confBuilder.setConnectTimeout(10000);
        confBuilder.setReadTimeout(30000);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(InetSocketAddress remoteAddress, Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(remoteAddress, ahcRequest, request, response);
            }
        });
        if ("https".equals(this.serviceNameResolver.getServiceUri().getServiceName())) {
            try {
                AuthenticationDataProvider authData = this.authentication.getAuthData();
                if (conf.isUseKeyStoreTls()) {
                    SSLContext sslCtx = null;
                    KeyStoreParams params = authData.hasDataForTls() ? authData.getTlsKeyStoreParams() : null;
                    sslCtx = KeyStoreSSLContext.createClientSslContext(conf.getSslProvider(), params != null ? params.getKeyStoreType() : null, params != null ? params.getKeyStorePath() : null, params != null ? params.getKeyStorePassword() : null, conf.isTlsAllowInsecureConnection(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols());
                    JsseSslEngineFactory sslEngineFactory = new JsseSslEngineFactory(sslCtx);
                    confBuilder.setSslEngineFactory(sslEngineFactory);
                } else {
                    SslProvider sslProvider = null;
                    if (conf.getSslProvider() != null) {
                        sslProvider = SslProvider.valueOf(conf.getSslProvider());
                    }
                    SslContext sslCtx = null;
                    sslCtx = authData.hasDataForTls() ? (authData.getTlsTrustStoreStream() == null ? SecurityUtility.createNettySslContextForClient(sslProvider, conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), authData.getTlsCertificates(), authData.getTlsPrivateKey(), conf.getTlsCiphers(), conf.getTlsProtocols()) : SecurityUtility.createNettySslContextForClient(sslProvider, conf.isTlsAllowInsecureConnection(), authData.getTlsTrustStoreStream(), authData.getTlsCertificates(), authData.getTlsPrivateKey(), conf.getTlsCiphers(), conf.getTlsProtocols())) : SecurityUtility.createNettySslContextForClient(sslProvider, conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), conf.getTlsCiphers(), conf.getTlsProtocols());
                    confBuilder.setSslContext(sslCtx);
                    if (!conf.isTlsHostnameVerificationEnable()) {
                        confBuilder.setSslEngineFactory(new WithSNISslEngineFactory(this.serviceNameResolver.resolveHostUri().getHost()));
                    }
                }
                confBuilder.setUseInsecureTrustManager(conf.isTlsAllowInsecureConnection());
                confBuilder.setDisableHttpsEndpointIdentificationAlgorithm(!conf.isTlsHostnameVerificationEnable());
            }
            catch (GeneralSecurityException e) {
                throw new PulsarClientException.InvalidConfigurationException(e);
            }
            catch (Exception e) {
                throw new PulsarClientException.InvalidConfigurationException(e);
            }
        }
        confBuilder.setEventLoopGroup(eventLoopGroup);
        DefaultAsyncHttpClientConfig config = confBuilder.build();
        this.httpClient = new DefaultAsyncHttpClient(config);
        log.debug("Using HTTP url: {}", (Object)conf.getServiceUrl());
    }

    String getServiceUrl() {
        return this.serviceNameResolver.getServiceUrl();
    }

    void setServiceUrl(String serviceUrl) throws PulsarClientException {
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public <T> CompletableFuture<T> get(String path, Class<T> clazz) {
        CompletableFuture future = new CompletableFuture();
        try {
            URI hostUri = this.serviceNameResolver.resolveHostUri();
            String requestUrl = new URL(hostUri.toURL(), path).toString();
            String remoteHostName = hostUri.getHost();
            AuthenticationDataProvider authData = this.authentication.getAuthData(remoteHostName);
            CompletableFuture<Map<String, String>> authFuture = new CompletableFuture<Map<String, String>>();
            if (authData.hasDataForHttp()) {
                this.authentication.authenticationStage(requestUrl, authData, null, authFuture);
            } else {
                authFuture.complete(null);
            }
            authFuture.whenComplete((respHeaders, ex) -> {
                if (ex != null) {
                    log.warn("[{}] Failed to perform http request at authentication stage: {}", (Object)requestUrl, (Object)ex.getMessage());
                    future.completeExceptionally(new PulsarClientException((Throwable)ex));
                    return;
                }
                BoundRequestBuilder builder = (BoundRequestBuilder)this.httpClient.prepareGet(requestUrl).setHeader((CharSequence)"Accept", "application/json");
                if (authData.hasDataForHttp()) {
                    Set<Map.Entry<String, String>> headers;
                    try {
                        headers = this.authentication.newRequestHeader(requestUrl, authData, (Map<String, String>)respHeaders);
                    }
                    catch (Exception e) {
                        log.warn("[{}] Error during HTTP get headers: {}", (Object)requestUrl, (Object)e.getMessage());
                        future.completeExceptionally(new PulsarClientException(e));
                        return;
                    }
                    if (headers != null) {
                        headers.forEach(entry -> builder.addHeader((CharSequence)entry.getKey(), (String)entry.getValue()));
                    }
                }
                builder.execute().toCompletableFuture().whenComplete((response2, t) -> {
                    if (t != null) {
                        log.warn("[{}] Failed to perform http request: {}", (Object)requestUrl, (Object)t.getMessage());
                        future.completeExceptionally(new PulsarClientException((Throwable)t));
                        return;
                    }
                    if (response2.getStatusCode() != 200) {
                        log.warn("[{}] HTTP get request failed: {}", (Object)requestUrl, (Object)response2.getStatusText());
                        PulsarClientException e = response2.getStatusCode() == 404 ? new PulsarClientException.NotFoundException("Not found: " + response2.getStatusText()) : new PulsarClientException("HTTP get request failed: " + response2.getStatusText());
                        future.completeExceptionally(e);
                        return;
                    }
                    try {
                        Object data = ObjectMapperFactory.getThreadLocal().readValue(response2.getResponseBodyAsBytes(), clazz);
                        future.complete(data);
                    }
                    catch (Exception e) {
                        log.warn("[{}] Error during HTTP get request: {}", (Object)requestUrl, (Object)e.getMessage());
                        future.completeExceptionally(new PulsarClientException(e));
                    }
                });
            });
        }
        catch (Exception e) {
            log.warn("[{}]PulsarClientImpl: {}", (Object)path, (Object)e.getMessage());
            if (e instanceof PulsarClientException) {
                future.completeExceptionally(e);
            }
            future.completeExceptionally(new PulsarClientException(e));
        }
        return future;
    }
}

