/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.common.naming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;

public class TopicCountEquallyDivideBundleSplitAlgorithm
implements NamespaceBundleSplitAlgorithm {
    @Override
    public CompletableFuture<Long> getSplitBoundary(NamespaceService service, NamespaceBundle bundle) {
        return service.getOwnedTopicListForNamespaceBundle(bundle).thenCompose(topics -> {
            if (topics == null || topics.size() <= 1) {
                return CompletableFuture.completedFuture(null);
            }
            ArrayList<Long> topicNameHashList = new ArrayList<Long>(topics.size());
            for (String topic : topics) {
                topicNameHashList.add(bundle.getNamespaceBundleFactory().getLongHashCode(topic));
            }
            Collections.sort(topicNameHashList);
            long splitStart = (Long)topicNameHashList.get(Math.max(topicNameHashList.size() / 2 - 1, 0));
            long splitEnd = (Long)topicNameHashList.get(topicNameHashList.size() / 2);
            long splitMiddle = splitStart + (splitEnd - splitStart) / 2L;
            return CompletableFuture.completedFuture(splitMiddle);
        });
    }
}

