/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk;

import java.util.Optional;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataBookieDriver
extends ZKMetadataDriverBase
implements MetadataBookieDriver {
    private static final Logger log = LoggerFactory.getLogger(ZKMetadataBookieDriver.class);
    ServerConfiguration serverConf;
    RegistrationManager regManager;
    RegistrationManager.RegistrationListener listener;

    @Override
    public synchronized MetadataBookieDriver initialize(ServerConfiguration conf, RegistrationManager.RegistrationListener listener, StatsLogger statsLogger) throws MetadataException {
        super.initialize(conf, statsLogger.scope("bookie"), new BoundExponentialBackoffRetryPolicy(conf.getZkRetryBackoffStartMs(), conf.getZkRetryBackoffMaxMs(), conf.getZkRetryBackoffMaxRetries()), Optional.empty());
        this.serverConf = conf;
        this.listener = listener;
        this.statsLogger = statsLogger;
        return this;
    }

    @VisibleForTesting
    public synchronized void setRegManager(RegistrationManager regManager) {
        this.regManager = regManager;
    }

    @Override
    public synchronized RegistrationManager getRegistrationManager() {
        if (null == this.regManager) {
            this.regManager = new ZKRegistrationManager(this.serverConf, this.zk, this.listener);
        }
        return this.regManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RegistrationManager rmToClose;
        ZKMetadataBookieDriver zKMetadataBookieDriver = this;
        synchronized (zKMetadataBookieDriver) {
            rmToClose = this.regManager;
            this.regManager = null;
        }
        if (null != rmToClose) {
            rmToClose.close();
        }
        super.close();
    }

    static {
        MetadataDrivers.registerBookieDriver("zk", ZKMetadataBookieDriver.class);
    }
}

