/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.clients;

import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.impl.container.StorageContainerClientInterceptor;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.GrpcChannels;
import org.apache.pulsar.shade.org.apache.bookkeeper.clients.utils.RetryUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.AbstractAutoAsyncCloseable;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SharedResourceManager;

public class SimpleClientBase
extends AbstractAutoAsyncCloseable {
    protected final StorageClientSettings settings;
    protected final SharedResourceManager.Resource<OrderedScheduler> schedulerResource;
    protected final OrderedScheduler scheduler;
    protected final ManagedChannel managedChannel;
    protected final boolean ownChannel;
    protected final Channel channel;
    protected final RetryUtils retryUtils;

    protected SimpleClientBase(StorageClientSettings settings) {
        this(settings, ClientResources.create().scheduler());
    }

    protected SimpleClientBase(StorageClientSettings settings, SharedResourceManager.Resource<OrderedScheduler> schedulerResource) {
        this(settings, schedulerResource, GrpcChannels.createChannelBuilder(settings.serviceUri(), settings).build(), true);
    }

    protected SimpleClientBase(StorageClientSettings settings, SharedResourceManager.Resource<OrderedScheduler> schedulerResource, ManagedChannel managedChannel, boolean ownChannel) {
        this.settings = settings;
        this.managedChannel = managedChannel;
        this.ownChannel = ownChannel;
        this.channel = ClientInterceptors.intercept((Channel)managedChannel, (ClientInterceptor[])new ClientInterceptor[]{new StorageContainerClientInterceptor(0L)});
        this.schedulerResource = schedulerResource;
        this.scheduler = SharedResourceManager.shared().get(schedulerResource);
        this.retryUtils = RetryUtils.create(settings.backoffPolicy(), this.scheduler);
    }

    @Override
    protected void closeAsyncOnce(CompletableFuture<Void> closeFuture) {
        if (this.ownChannel) {
            this.managedChannel.shutdown();
        }
        SharedResourceManager.shared().release(this.schedulerResource, this.scheduler);
        closeFuture.complete(null);
    }
}

