/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.client;

import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.RejectedExecutionException;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.AsyncCallback;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BKException;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.BookKeeper;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.ClientContext;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.EnsembleUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.ExplicitLacFlushPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerHandle;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerMetadataUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.LedgerRecoveryOp;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.MetadataUpdateLoop;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.SafeRunnable;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Version;
import org.apache.pulsar.shade.org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadOnlyLedgerHandle
extends LedgerHandle
implements BookkeeperInternalCallbacks.LedgerMetadataListener {
    private static final Logger LOG = LoggerFactory.getLogger(ReadOnlyLedgerHandle.class);
    private Object metadataLock = new Object();
    private final NavigableMap<Long, List<BookieId>> newEnsemblesFromRecovery = new TreeMap<Long, List<BookieId>>();

    ReadOnlyLedgerHandle(ClientContext clientCtx, long ledgerId, Versioned<LedgerMetadata> metadata, BookKeeper.DigestType digestType, byte[] password, boolean watch) throws GeneralSecurityException, NumberFormatException {
        super(clientCtx, ledgerId, metadata, digestType, password, WriteFlag.NONE);
        if (watch) {
            clientCtx.getLedgerManager().registerLedgerMetadataListener(ledgerId, this);
        }
    }

    @Override
    public void close() throws InterruptedException, BKException {
        this.clientCtx.getLedgerManager().unregisterLedgerMetadataListener(this.ledgerId, this);
    }

    @Override
    public void asyncClose(AsyncCallback.CloseCallback cb, Object ctx) {
        this.clientCtx.getLedgerManager().unregisterLedgerMetadataListener(this.ledgerId, this);
        cb.closeComplete(0, this, ctx);
    }

    @Override
    public long addEntry(byte[] data) throws InterruptedException, BKException {
        return this.addEntry(data, 0, data.length);
    }

    @Override
    public long addEntry(byte[] data, int offset, int length) throws InterruptedException, BKException {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        throw BKException.create(-100);
    }

    @Override
    public void asyncAddEntry(byte[] data, AsyncCallback.AddCallback cb, Object ctx) {
        this.asyncAddEntry(data, 0, data.length, cb, ctx);
    }

    @Override
    public void asyncAddEntry(byte[] data, int offset, int length, AsyncCallback.AddCallback cb, Object ctx) {
        LOG.error("Tried to add entry on a Read-Only ledger handle, ledgerid=" + this.ledgerId);
        cb.addComplete(-100, this, -1L, ctx);
    }

    @Override
    public void onChanged(long lid, Versioned<LedgerMetadata> newMetadata) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received ledger metadata update on {} : {}", (Object)lid, newMetadata);
        }
        if (this.ledgerId != lid) {
            return;
        }
        if (null == newMetadata) {
            return;
        }
        Versioned<LedgerMetadata> currentMetadata = this.getVersionedLedgerMetadata();
        Version.Occurred occurred = currentMetadata.getVersion().compare(newMetadata.getVersion());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Try to update metadata from {} to {} : {}", new Object[]{currentMetadata, newMetadata, occurred});
        }
        if (Version.Occurred.BEFORE == occurred) {
            try {
                this.clientCtx.getMainWorkerPool().executeOrdered(this.ledgerId, (SafeRunnable)new MetadataUpdater(newMetadata));
            }
            catch (RejectedExecutionException ree) {
                LOG.error("Failed on submitting updater to update ledger metadata on ledger {} : {}", (Object)this.ledgerId, newMetadata);
            }
        }
    }

    public String toString() {
        return String.format("ReadOnlyLedgerHandle(lid = %d, id = %d)", this.ledgerId, super.hashCode());
    }

    @Override
    protected void initializeWriteHandleState() {
        this.explicitLacFlushPolicy = ExplicitLacFlushPolicy.VOID_EXPLICITLAC_FLUSH_POLICY;
    }

    @Override
    public void asyncReadLastEntry(final AsyncCallback.ReadCallback cb, Object ctx) {
        this.asyncReadLastConfirmed(new AsyncCallback.ReadLastConfirmedCallback(){

            @Override
            public void readLastConfirmedComplete(int rc, long lastConfirmed, Object ctx) {
                if (rc == 0) {
                    if (lastConfirmed < 0L) {
                        cb.readComplete(-13, ReadOnlyLedgerHandle.this, null, ctx);
                    } else {
                        ReadOnlyLedgerHandle.this.asyncReadEntriesInternal(lastConfirmed, lastConfirmed, cb, ctx, false);
                    }
                } else {
                    LOG.error("ReadException in asyncReadLastEntry, ledgerId: {}, lac: {}, rc:{}", new Object[]{lastConfirmed, ReadOnlyLedgerHandle.this.ledgerId, rc});
                    cb.readComplete(rc, ReadOnlyLedgerHandle.this, null, ctx);
                }
            }
        }, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleBookieFailure(Map<Integer, BookieId> failedBookies) {
        Object object = this.metadataLock;
        synchronized (object) {
            String logContext = String.format("[RecoveryEnsembleChange(ledger:%d)]", this.ledgerId);
            long lac = this.getLastAddConfirmed();
            LedgerMetadata metadata = this.getLedgerMetadata();
            List<BookieId> currentEnsemble = this.getCurrentEnsemble();
            try {
                List<BookieId> newEnsemble = EnsembleUtils.replaceBookiesInEnsemble(this.clientCtx.getBookieWatcher(), metadata, currentEnsemble, failedBookies, logContext);
                Set<Integer> replaced = EnsembleUtils.diffEnsemble(currentEnsemble, newEnsemble);
                if (!replaced.isEmpty()) {
                    this.newEnsemblesFromRecovery.put(lac + 1L, newEnsemble);
                    this.unsetSuccessAndSendWriteRequest(newEnsemble, replaced);
                }
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                LOG.error("Could not get additional bookie to remake ensemble, closing ledger: {}", (Object)this.ledgerId);
                this.handleUnrecoverableErrorDuringAdd(e.getCode());
                return;
            }
        }
    }

    @Override
    void handleUnrecoverableErrorDuringAdd(int rc) {
        this.errorOutPendingAdds(rc);
    }

    void recover(BookkeeperInternalCallbacks.GenericCallback<Void> finalCb) {
        this.recover(finalCb, null, false);
    }

    void recover(BookkeeperInternalCallbacks.GenericCallback<Void> finalCb, @VisibleForTesting BookkeeperInternalCallbacks.ReadEntryListener listener, boolean forceRecovery) {
        BookkeeperInternalCallbacks.TimedGenericCallback<Void> cb = new BookkeeperInternalCallbacks.TimedGenericCallback<Void>(finalCb, 0, this.clientCtx.getClientStats().getRecoverOpLogger());
        MetadataUpdateLoop.NeedsUpdatePredicate needsUpdate = metadata -> metadata.getState() == LedgerMetadata.State.OPEN;
        if (forceRecovery) {
            needsUpdate = metadata -> metadata.getState() != LedgerMetadata.State.IN_RECOVERY;
        }
        ((CompletableFuture)((CompletableFuture)new MetadataUpdateLoop(this.clientCtx.getLedgerManager(), this.getId(), this::getVersionedLedgerMetadata, needsUpdate, metadata -> LedgerMetadataBuilder.from(metadata).withInRecoveryState().build(), this::setLedgerMetadata).run().thenCompose(metadata -> {
            if (((LedgerMetadata)metadata.getValue()).isClosed()) {
                return CompletableFuture.completedFuture(this);
            }
            return new LedgerRecoveryOp(this, this.clientCtx).setEntryListener(listener).initiate();
        })).thenCompose(ignore -> this.closeRecovered())).whenComplete((ignore, ex) -> {
            if (ex != null) {
                cb.operationComplete(BKException.getExceptionCode(ex, -999), null);
            } else {
                cb.operationComplete(0, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Versioned<LedgerMetadata>> closeRecovered() {
        long len;
        long lac;
        ReadOnlyLedgerHandle readOnlyLedgerHandle = this;
        synchronized (readOnlyLedgerHandle) {
            lac = this.lastAddConfirmed;
            len = this.length;
        }
        LOG.info("Closing recovered ledger {} at entry {}", (Object)this.getId(), (Object)lac);
        CompletableFuture<Versioned<LedgerMetadata>> f = new MetadataUpdateLoop(this.clientCtx.getLedgerManager(), this.getId(), this::getVersionedLedgerMetadata, metadata -> metadata.getState() == LedgerMetadata.State.IN_RECOVERY, metadata -> {
            LedgerMetadataBuilder builder = LedgerMetadataBuilder.from(metadata);
            Long lastEnsembleKey = LedgerMetadataUtils.getLastEnsembleKey(metadata);
            Object object = this.metadataLock;
            synchronized (object) {
                this.newEnsemblesFromRecovery.entrySet().forEach(e -> {
                    Preconditions.checkState((Long)e.getKey() >= lastEnsembleKey, "Once a ledger is in recovery, noone can add ensembles without closing");
                    if (lastEnsembleKey.equals(e.getKey())) {
                        builder.replaceEnsembleEntry((Long)e.getKey(), (List)e.getValue());
                    } else {
                        builder.newEnsembleEntry((Long)e.getKey(), (List)e.getValue());
                    }
                });
            }
            return builder.withClosedState().withLastEntryId(lac).withLength(len).build();
        }, this::setLedgerMetadata).run();
        f.whenComplete((result, exception) -> {
            Object object = this.metadataLock;
            synchronized (object) {
                this.newEnsemblesFromRecovery.clear();
            }
            if (exception != null) {
                LOG.error("When closeRecovered,failed on clearing newEnsemblesFromRecovery.", exception);
            }
        });
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<BookieId> getCurrentEnsemble() {
        Object object = this.metadataLock;
        synchronized (object) {
            if (!this.newEnsemblesFromRecovery.isEmpty()) {
                return this.newEnsemblesFromRecovery.lastEntry().getValue();
            }
            return super.getCurrentEnsemble();
        }
    }

    class MetadataUpdater
    extends org.apache.pulsar.shade.org.apache.bookkeeper.util.SafeRunnable {
        final Versioned<LedgerMetadata> newMetadata;

        MetadataUpdater(Versioned<LedgerMetadata> metadata) {
            this.newMetadata = metadata;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void safeRun() {
            Versioned<LedgerMetadata> currentMetadata;
            Version.Occurred occurred;
            while (Version.Occurred.BEFORE == (occurred = (currentMetadata = ReadOnlyLedgerHandle.this.getVersionedLedgerMetadata()).getVersion().compare(this.newMetadata.getVersion()))) {
                ReadOnlyLedgerHandle readOnlyLedgerHandle = ReadOnlyLedgerHandle.this;
                synchronized (readOnlyLedgerHandle) {
                    if (ReadOnlyLedgerHandle.this.setLedgerMetadata(currentMetadata, this.newMetadata)) {
                        LOG.info("Updated ledger metadata for ledger {} to {}, version {}.", new Object[]{ReadOnlyLedgerHandle.this.ledgerId, this.newMetadata.getValue().toSafeString(), this.newMetadata.getVersion()});
                        break;
                    }
                }
            }
        }

        public String toString() {
            return String.format("MetadataUpdater(%d)", ReadOnlyLedgerHandle.this.ledgerId);
        }
    }
}

