/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.util;

import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonFactory;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.Module;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.SerializationConfig;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import org.apache.pulsar.shade.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.pulsar.shade.io.swagger.jackson.ModelSerializer;
import org.apache.pulsar.shade.io.swagger.jackson.PropertySerializer;
import org.apache.pulsar.shade.io.swagger.jackson.mixin.OperationResponseMixin;
import org.apache.pulsar.shade.io.swagger.jackson.mixin.ResponseSchemaMixin;
import org.apache.pulsar.shade.io.swagger.models.Model;
import org.apache.pulsar.shade.io.swagger.models.Operation;
import org.apache.pulsar.shade.io.swagger.models.Response;
import org.apache.pulsar.shade.io.swagger.models.properties.Property;
import org.apache.pulsar.shade.io.swagger.util.DeserializationModule;
import org.apache.pulsar.shade.io.swagger.util.ReferenceSerializationConfigurer;

public class ObjectMapperFactory {
    protected static ObjectMapper createJson() {
        return ObjectMapperFactory.createJson(true, true);
    }

    protected static ObjectMapper createJson(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(null, includePathDeserializer, includeResponseDeserializer);
    }

    protected static ObjectMapper createYaml() {
        return ObjectMapperFactory.createYaml(true, true);
    }

    protected static ObjectMapper createYaml(boolean includePathDeserializer, boolean includeResponseDeserializer) {
        return ObjectMapperFactory.create(new YAMLFactory(), includePathDeserializer, includeResponseDeserializer);
    }

    private static ObjectMapper create(JsonFactory jsonFactory, boolean includePathDeserializer, boolean includeResponseDeserializer) {
        ObjectMapper mapper = jsonFactory == null ? new ObjectMapper() : new ObjectMapper(jsonFactory);
        mapper.registerModule(new SimpleModule(){

            @Override
            public void setupModule(Module.SetupContext context) {
                super.setupModule(context);
                context.addBeanSerializerModifier(new BeanSerializerModifier(){

                    @Override
                    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription desc, JsonSerializer<?> serializer) {
                        if (Property.class.isAssignableFrom(desc.getBeanClass())) {
                            return new PropertySerializer(serializer);
                        }
                        if (Model.class.isAssignableFrom(desc.getBeanClass())) {
                            return new ModelSerializer(serializer);
                        }
                        return serializer;
                    }
                });
            }
        });
        DeserializationModule deserializerModule = new DeserializationModule(includePathDeserializer, includeResponseDeserializer);
        mapper.registerModule(deserializerModule);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.addMixIn(Response.class, ResponseSchemaMixin.class);
        mapper.addMixIn(Operation.class, OperationResponseMixin.class);
        ReferenceSerializationConfigurer.serializeAsComputedRef(mapper);
        return mapper;
    }
}

