/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.swagger.models.auth;

import java.net.URL;
import java.util.Objects;
import org.apache.pulsar.shade.io.swagger.models.auth.UrlMatcher;

public class AuthorizationValue {
    private String value;
    private String type;
    private String keyName;
    private UrlMatcher urlMatcher;

    public AuthorizationValue() {
    }

    public AuthorizationValue(String keyName, String value, String type, UrlMatcher urlMatcher) {
        this.setKeyName(keyName);
        this.setValue(value);
        this.setType(type);
        this.setUrlMatcher(urlMatcher);
    }

    public AuthorizationValue(String keyName, String value, String type) {
        this(keyName, value, type, new UrlMatcher(){

            @Override
            public boolean test(URL url) {
                return true;
            }
        });
    }

    public AuthorizationValue value(String value) {
        this.value = value;
        return this;
    }

    public AuthorizationValue type(String type) {
        this.type = type;
        return this;
    }

    public AuthorizationValue keyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public AuthorizationValue urlMatcher(UrlMatcher urlMatcher) {
        this.setUrlMatcher(urlMatcher);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public UrlMatcher getUrlMatcher() {
        return this.urlMatcher;
    }

    public void setUrlMatcher(UrlMatcher urlMatcher) {
        this.urlMatcher = Objects.requireNonNull(urlMatcher);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyName == null ? 0 : this.keyName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.urlMatcher == null ? 0 : this.urlMatcher.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationValue other = (AuthorizationValue)obj;
        if (this.keyName == null ? other.keyName != null : !this.keyName.equals(other.keyName)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.urlMatcher == null ? other.urlMatcher != null : !this.urlMatcher.equals(other.urlMatcher) && !this.urlMatcher.equals(other.urlMatcher));
    }
}

