/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.com.carrotsearch.hppc;

import org.apache.pulsar.shade.com.carrotsearch.hppc.BitMixer;
import org.apache.pulsar.shade.com.carrotsearch.hppc.CharIntHashMap;
import org.apache.pulsar.shade.com.carrotsearch.hppc.HashOrderMixing;

public class CharIntScatterMap
extends CharIntHashMap {
    public CharIntScatterMap() {
        this(4);
    }

    public CharIntScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharIntScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static CharIntScatterMap from(char[] keys, int[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharIntScatterMap map = new CharIntScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

