/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v3;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;
import org.apache.pulsar.functions.worker.service.api.Sinks;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiParam;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.PUT;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.UpdateOptionsImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.ConfigFieldDefinition;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.shade.org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SinkStatus;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.apache.pulsar.shade.org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="/sinks", description="Sinks admin apis", tags={"sinks"})
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/sinks")
public class SinksApiV3Resource
extends FunctionApiResource {
    private static final Logger log = LoggerFactory.getLogger(SinksApiV3Resource.class);

    Sinks<? extends WorkerService> sinks() {
        return this.get().getSinks();
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    @Consumes(value={"multipart/form-data"})
    public void registerSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="sinkConfig") SinkConfig sinkConfig) {
        this.sinks().registerSink(tenant, namespace, sinkName, uploadedInputStream, fileDetail, functionPkgUrl, sinkConfig, this.authParams());
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    @Consumes(value={"multipart/form-data"})
    public void updateSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="sinkConfig") SinkConfig sinkConfig, @FormDataParam(value="updateOptions") UpdateOptionsImpl updateOptions) {
        this.sinks().updateSink(tenant, namespace, sinkName, uploadedInputStream, fileDetail, functionPkgUrl, sinkConfig, this.authParams(), updateOptions);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    public void deregisterSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sinks().deregisterFunction(tenant, namespace, sinkName, this.authParams());
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    public SinkConfig getSinkInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) throws IOException {
        return this.sinks().getSinkInfo(tenant, namespace, sinkName, this.authParams());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Sink instance", response=SinkStatus.SinkInstanceStatus.SinkInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this sink"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The sink doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/status")
    public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData getSinkInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.sinks().getSinkInstanceStatus(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Sink running in cluster mode", response=SinkStatus.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this sink"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The sink doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sinkName}/status")
    public SinkStatus getSinkStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) throws IOException {
        return this.sinks().getSinkStatus(tenant, namespace, sinkName, this.uri.getRequestUri(), this.authParams());
    }

    @GET
    @Path(value="/{tenant}/{namespace}")
    public List<String> listSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        return this.sinks().listFunctions(tenant, namespace, this.authParams());
    }

    @POST
    @ApiOperation(value="Restart sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this sink"), @ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) {
        this.sinks().restartFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @POST
    @ApiOperation(value="Restart all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/restart")
    @Consumes(value={"application/json"})
    public void restartSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sinks().restartFunctionInstances(tenant, namespace, sinkName, this.authParams());
    }

    @POST
    @ApiOperation(value="Stop sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) {
        this.sinks().stopFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @POST
    @ApiOperation(value="Stop all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/stop")
    @Consumes(value={"application/json"})
    public void stopSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sinks().stopFunctionInstances(tenant, namespace, sinkName, this.authParams());
    }

    @POST
    @ApiOperation(value="Start sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) {
        this.sinks().startFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri(), this.authParams());
    }

    @POST
    @ApiOperation(value="Start all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/start")
    @Consumes(value={"application/json"})
    public void startSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sinks().startFunctionInstances(tenant, namespace, sinkName, this.authParams());
    }

    @GET
    @Path(value="/builtinsinks")
    public List<ConnectorDefinition> getSinkList() {
        return this.sinks().getSinkList();
    }

    @GET
    @ApiOperation(value="Fetches information about config fields associated with the specified builtin sink", response=ConfigFieldDefinition.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="builtin sink does not exist"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later.")})
    @Produces(value={"application/json"})
    @Path(value="/builtinsinks/{name}/configdefinition")
    public List<ConfigFieldDefinition> getSinkConfigDefinition(@ApiParam(value="The name of the builtin sink") @PathParam(value="name") String name) throws IOException {
        return this.sinks().getSinkConfigDefinition(name);
    }

    @POST
    @ApiOperation(value="Reload the built-in connectors, including Sources and Sinks", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=401, message="This operation requires super-user access"), @ApiResponse(code=503, message="Function worker service is now initializing. Please try again later."), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/reloadBuiltInSinks")
    public void reloadSinks() {
        this.sinks().reloadConnectors(this.authParams());
    }
}

