/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.Position;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.pulsar.shade.org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.shade.org.apache.pulsar.common.stats.Rate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentMessageExpiryMonitor
implements AsyncCallbacks.FindEntryCallback {
    private final ManagedCursor cursor;
    private final String subName;
    private final PersistentTopic topic;
    private final String topicName;
    private final Rate msgExpired;
    private final LongAdder totalMsgExpired;
    private final boolean autoSkipNonRecoverableData;
    private final PersistentSubscription subscription;
    private static final int FALSE = 0;
    private static final int TRUE = 1;
    private volatile int expirationCheckInProgress = 0;
    private static final AtomicIntegerFieldUpdater<PersistentMessageExpiryMonitor> expirationCheckInProgressUpdater = AtomicIntegerFieldUpdater.newUpdater(PersistentMessageExpiryMonitor.class, "expirationCheckInProgress");
    private static final Logger log = LoggerFactory.getLogger(PersistentMessageExpiryMonitor.class);
    private final AsyncCallbacks.MarkDeleteCallback markDeleteCallback = new AsyncCallbacks.MarkDeleteCallback(){

        @Override
        public void markDeleteComplete(Object ctx) {
            long numMessagesExpired = (Long)ctx - PersistentMessageExpiryMonitor.this.cursor.getNumberOfEntriesInBacklog(false);
            PersistentMessageExpiryMonitor.this.msgExpired.recordMultipleEvents(numMessagesExpired, 0L);
            PersistentMessageExpiryMonitor.this.totalMsgExpired.add(numMessagesExpired);
            PersistentMessageExpiryMonitor.this.updateRates();
            if (PersistentMessageExpiryMonitor.this.subscription != null && PersistentMessageExpiryMonitor.this.subscription.getType() == CommandSubscribe.SubType.Key_Shared) {
                PersistentMessageExpiryMonitor.this.subscription.getDispatcher().markDeletePositionMoveForward();
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Mark deleted {} messages", new Object[]{PersistentMessageExpiryMonitor.this.topicName, PersistentMessageExpiryMonitor.this.subName, numMessagesExpired});
            }
        }

        @Override
        public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
            log.warn("[{}][{}] Message expiry failed - mark delete failed", new Object[]{PersistentMessageExpiryMonitor.this.topicName, PersistentMessageExpiryMonitor.this.subName, exception});
            PersistentMessageExpiryMonitor.this.updateRates();
        }
    };

    public PersistentMessageExpiryMonitor(PersistentTopic topic, String subscriptionName, ManagedCursor cursor, PersistentSubscription subscription) {
        this.topic = topic;
        this.topicName = topic.getName();
        this.cursor = cursor;
        this.subName = subscriptionName;
        this.subscription = subscription;
        this.msgExpired = new Rate();
        this.totalMsgExpired = new LongAdder();
        this.autoSkipNonRecoverableData = this.cursor.getManagedLedger() != null && this.cursor.getManagedLedger().getConfig().isAutoSkipNonRecoverableData();
    }

    @Deprecated
    public PersistentMessageExpiryMonitor(String topicName, String subscriptionName, ManagedCursor cursor, PersistentSubscription subscription) {
        this.topicName = topicName;
        this.topic = subscription == null ? null : (PersistentTopic)subscription.getTopic();
        this.cursor = cursor;
        this.subName = subscriptionName;
        this.subscription = subscription;
        this.msgExpired = new Rate();
        this.totalMsgExpired = new LongAdder();
        this.autoSkipNonRecoverableData = this.cursor.getManagedLedger() != null && this.cursor.getManagedLedger().getConfig().isAutoSkipNonRecoverableData();
    }

    public boolean expireMessages(int messageTTLInSeconds) {
        if (expirationCheckInProgressUpdater.compareAndSet(this, 0, 1)) {
            log.info("[{}][{}] Starting message expiry check, ttl= {} seconds", new Object[]{this.topicName, this.subName, messageTTLInSeconds});
            this.cursor.asyncFindNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, entry -> {
                try {
                    long entryTimestamp = Commands.getEntryTimestamp(entry.getDataBuffer());
                    boolean bl = MessageImpl.isEntryExpired(messageTTLInSeconds, entryTimestamp);
                    return bl;
                }
                catch (Exception e) {
                    log.error("[{}][{}] Error deserializing message for expiry check", new Object[]{this.topicName, this.subName, e});
                }
                finally {
                    entry.release();
                }
                return false;
            }, this, null);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Ignore expire-message scheduled task, last check is still running", (Object)this.topicName, (Object)this.subName);
        }
        return false;
    }

    public boolean expireMessages(Position messagePosition) {
        PositionImpl topicLastPosition = (PositionImpl)this.topic.getLastPosition();
        if (topicLastPosition.compareTo((PositionImpl)messagePosition) < 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] Ignore expire-message scheduled task, given position {} is beyond current topic's last position {}", new Object[]{this.topicName, this.subName, messagePosition, topicLastPosition});
            }
            return false;
        }
        if (expirationCheckInProgressUpdater.compareAndSet(this, 0, 1)) {
            log.info("[{}][{}] Starting message expiry check, position= {} seconds", new Object[]{this.topicName, this.subName, messagePosition});
            this.cursor.asyncFindNewestMatching(ManagedCursor.FindPositionConstraint.SearchActiveEntries, entry -> {
                try {
                    boolean bl = ((PositionImpl)entry.getPosition()).compareTo((PositionImpl)messagePosition) <= 0;
                    return bl;
                }
                finally {
                    entry.release();
                }
            }, this, null);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Ignore expire-message scheduled task, last check is still running", (Object)this.topicName, (Object)this.subName);
        }
        return false;
    }

    public void updateRates() {
        this.msgExpired.calculateRate();
    }

    public double getMessageExpiryRate() {
        return this.msgExpired.getRate();
    }

    public long getTotalMessageExpired() {
        return this.totalMsgExpired.sum();
    }

    @Override
    public void findEntryComplete(Position position, Object ctx) {
        if (position != null) {
            log.info("[{}][{}] Expiring all messages until position {}", new Object[]{this.topicName, this.subName, position});
            Position prevMarkDeletePos = this.cursor.getMarkDeletedPosition();
            this.cursor.asyncMarkDelete(position, this.markDeleteCallback, this.cursor.getNumberOfEntriesInBacklog(false));
            if (!Objects.equals(this.cursor.getMarkDeletedPosition(), prevMarkDeletePos) && this.subscription != null) {
                this.subscription.updateLastMarkDeleteAdvancedTimestamp();
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("[{}][{}] No messages to expire", (Object)this.topicName, (Object)this.subName);
            }
            this.updateRates();
        }
        this.expirationCheckInProgress = 0;
    }

    @Override
    public void findEntryFailed(ManagedLedgerException exception, Optional<Position> failedReadPosition, Object ctx) {
        if (log.isDebugEnabled()) {
            log.debug("[{}][{}] Finding expired entry operation failed", new Object[]{this.topicName, this.subName, exception});
        }
        if (this.autoSkipNonRecoverableData && failedReadPosition.isPresent() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException) {
            log.warn("[{}][{}] read failed from ledger at position:{} : {}", new Object[]{this.topicName, this.subName, failedReadPosition, exception.getMessage()});
            if (exception instanceof ManagedLedgerException.LedgerNotExistException) {
                long failedLedgerId = failedReadPosition.get().getLedgerId();
                ManagedLedgerImpl ledger = (ManagedLedgerImpl)this.cursor.getManagedLedger();
                Position lastPositionInLedger = ledger.getOptionalLedgerInfo(failedLedgerId).map(ledgerInfo -> PositionImpl.get(failedLedgerId, ledgerInfo.getEntries() - 1L)).orElseGet(() -> {
                    Long nextExistingLedger = ledger.getNextValidLedger(((Position)failedReadPosition.get()).getLedgerId());
                    if (nextExistingLedger == null) {
                        log.info("[{}] [{}] Couldn't find next next valid ledger for expiry monitor when find entry failed {}", new Object[]{ledger.getName(), ledger.getName(), failedReadPosition});
                        return (PositionImpl)failedReadPosition.get();
                    }
                    return PositionImpl.get(nextExistingLedger, -1L);
                });
                log.info("[{}][{}] ledger not existed, will complete the last position of the non-existed ledger:{}", new Object[]{this.topicName, this.subName, lastPositionInLedger});
                this.findEntryComplete(lastPositionInLedger, ctx);
            } else {
                this.findEntryComplete(failedReadPosition.get(), ctx);
            }
            return;
        }
        this.expirationCheckInProgress = 0;
        this.updateRates();
    }
}

