/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.pulsar.broker.service.GracefulExecutorServicesTerminationHandler;

public class GracefulExecutorServicesShutdown {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(15L);
    private static final Double DEFAULT_TERMINATION_TIMEOUT_RATIO = 0.1;
    private final List<ExecutorService> executorServices = new ArrayList<ExecutorService>();
    private Duration timeout = DEFAULT_TIMEOUT;
    private Duration terminationTimeout;

    private GracefulExecutorServicesShutdown() {
    }

    public static GracefulExecutorServicesShutdown initiate() {
        return new GracefulExecutorServicesShutdown();
    }

    public GracefulExecutorServicesShutdown shutdown(ExecutorService ... executorServices) {
        for (ExecutorService executorService : executorServices) {
            if (executorService == null) continue;
            executorService.shutdown();
            this.executorServices.add(executorService);
        }
        return this;
    }

    public GracefulExecutorServicesShutdown timeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public GracefulExecutorServicesShutdown terminationTimeout(Duration terminationTimeout) {
        this.terminationTimeout = terminationTimeout;
        return this;
    }

    public CompletableFuture<Void> handle() {
        if (this.terminationTimeout == null) {
            this.terminationTimeout = Duration.ofNanos((long)((double)this.timeout.toNanos() * DEFAULT_TERMINATION_TIMEOUT_RATIO));
        }
        return new GracefulExecutorServicesTerminationHandler(this.timeout, this.terminationTimeout, this.executorServices).getFuture();
    }
}

