/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.resources;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.broker.resources.BaseResources;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesRackConfiguration;

public class BookieResources
extends BaseResources<BookiesRackConfiguration> {
    private static final String AVAILABLE_BOOKIES_ROOT = "/ledgers/available";

    public BookieResources(MetadataStore store, int operationTimeoutSec) {
        super(store, BookiesRackConfiguration.class, operationTimeoutSec);
    }

    public CompletableFuture<Optional<BookiesRackConfiguration>> get() {
        return this.getAsync("/bookies");
    }

    public CompletableFuture<Void> update(Function<Optional<BookiesRackConfiguration>, BookiesRackConfiguration> modifyFunction) {
        return this.getCache().readModifyUpdateOrCreate("/bookies", modifyFunction).thenApply(__ -> null);
    }

    public CompletableFuture<Set<String>> listAvailableBookiesAsync() {
        return this.getChildrenAsync(AVAILABLE_BOOKIES_ROOT).thenApply(list -> new HashSet(list));
    }
}

