/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwt;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.RequiredTypeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSubscription;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiRolesTokenAuthorizationProvider
extends PulsarAuthorizationProvider {
    private static final Logger log = LoggerFactory.getLogger(MultiRolesTokenAuthorizationProvider.class);
    static final String HTTP_HEADER_NAME = "Authorization";
    static final String HTTP_HEADER_VALUE_PREFIX = "Bearer ";
    static final String CONF_TOKEN_SETTING_PREFIX = "tokenSettingPrefix";
    static final String CONF_TOKEN_AUTH_CLAIM = "tokenAuthClaim";
    private final JwtParser parser = Jwts.parserBuilder().build();
    private String roleClaim = "sub";

    @Override
    public void initialize(ServiceConfiguration conf, PulsarResources pulsarResources) throws IOException {
        String confTokenAuthClaimSettingName;
        Object tokenAuthClaim;
        String prefix = (String)conf.getProperty(CONF_TOKEN_SETTING_PREFIX);
        if (null == prefix) {
            prefix = "";
        }
        if ((tokenAuthClaim = conf.getProperty(confTokenAuthClaimSettingName = prefix + CONF_TOKEN_AUTH_CLAIM)) != null && StringUtils.isNotBlank((String)tokenAuthClaim)) {
            this.roleClaim = (String)tokenAuthClaim;
        }
        super.initialize(conf, pulsarResources);
    }

    @Override
    public CompletableFuture<Boolean> isSuperUser(String role, AuthenticationDataSource authenticationData, ServiceConfiguration serviceConfiguration) {
        Set<String> superUserRoles = serviceConfiguration.getSuperUserRoles();
        if (superUserRoles.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        if (role != null && superUserRoles.contains(role)) {
            return CompletableFuture.completedFuture(true);
        }
        Set<String> roles = this.getRoles(role, authenticationData);
        if (roles.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.completedFuture(roles.stream().anyMatch(superUserRoles::contains));
    }

    @Override
    public CompletableFuture<Boolean> validateTenantAdminAccess(String tenantName, String role, AuthenticationDataSource authData) {
        return this.isSuperUser(role, authData, this.conf).thenCompose(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            Set<String> roles = this.getRoles(role, authData);
            if (roles.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            return ((CompletableFuture)this.pulsarResources.getTenantResources().getTenantAsync(tenantName).thenCompose(op -> {
                if (op.isPresent()) {
                    TenantInfo tenantInfo = (TenantInfo)op.get();
                    if (tenantInfo.getAdminRoles() == null || tenantInfo.getAdminRoles().isEmpty()) {
                        return CompletableFuture.completedFuture(false);
                    }
                    return CompletableFuture.completedFuture(roles.stream().anyMatch(n -> tenantInfo.getAdminRoles().contains(n)));
                }
                throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
            })).exceptionally(ex -> {
                Throwable cause = ex.getCause();
                if (cause instanceof MetadataStoreException.NotFoundException) {
                    log.warn("Failed to get tenant info data for non existing tenant {}", (Object)tenantName);
                    throw new RestException(Response.Status.NOT_FOUND, "Tenant does not exist");
                }
                log.error("Failed to get tenant {}", (Object)tenantName, (Object)cause);
                throw new RestException(cause);
            });
        });
    }

    private Set<String> getRoles(String role, AuthenticationDataSource authData) {
        if (authData == null || authData instanceof AuthenticationDataSubscription && ((AuthenticationDataSubscription)authData).getAuthData() == null) {
            return Collections.singleton(role);
        }
        String token = null;
        if (authData.hasDataFromCommand()) {
            token = authData.getCommandData();
            if (StringUtils.isBlank(token)) {
                return Collections.emptySet();
            }
        } else if (authData.hasDataFromHttp()) {
            String httpHeaderValue = authData.getHttpHeader(HTTP_HEADER_NAME);
            if (httpHeaderValue == null || !httpHeaderValue.startsWith(HTTP_HEADER_VALUE_PREFIX)) {
                return Collections.emptySet();
            }
            token = httpHeaderValue.substring(HTTP_HEADER_VALUE_PREFIX.length());
        }
        if (token == null) {
            return Collections.emptySet();
        }
        String[] splitToken = token.split("\\.");
        if (splitToken.length < 2) {
            log.warn("Unable to extract additional roles from JWT token");
            return Collections.emptySet();
        }
        String unsignedToken = splitToken[0] + "." + splitToken[1] + ".";
        Jwt jwt = this.parser.parseClaimsJwt(unsignedToken);
        try {
            String jwtRole = (String)((Claims)jwt.getBody()).get(this.roleClaim, String.class);
            if (jwtRole == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Do not have corresponding claim in jwt token. claim={}", (Object)this.roleClaim);
                }
                return Collections.emptySet();
            }
            return new HashSet<String>(Collections.singletonList(jwtRole));
        }
        catch (RequiredTypeException requiredTypeException) {
            try {
                List list = (List)((Claims)jwt.getBody()).get(this.roleClaim, List.class);
                if (list != null) {
                    return new HashSet<String>(list);
                }
            }
            catch (RequiredTypeException requiredTypeException1) {
                return Collections.emptySet();
            }
            return Collections.emptySet();
        }
    }

    public CompletableFuture<Boolean> authorize(String role, AuthenticationDataSource authenticationData, Function<String, CompletableFuture<Boolean>> authorizeFunc) {
        return this.isSuperUser(role, authenticationData, this.conf).thenCompose(superUser -> {
            if (superUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            Set<String> roles = this.getRoles(role, authenticationData);
            if (roles.isEmpty()) {
                return CompletableFuture.completedFuture(false);
            }
            ArrayList futures = new ArrayList(roles.size());
            roles.forEach(r -> futures.add((CompletableFuture)authorizeFunc.apply((String)r)));
            return FutureUtil.waitForAny(futures, ret -> (Boolean)ret).thenApply(v -> v.isPresent());
        });
    }

    @Override
    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(role, authenticationData, r -> super.canProduceAsync(topicName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        return this.authorize(role, authenticationData, r -> super.canConsumeAsync(topicName, (String)r, authenticationData, subscription));
    }

    @Override
    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(role, authenticationData, r -> super.canLookupAsync(topicName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(role, authenticationData, r -> super.allowFunctionOpsAsync(namespaceName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(role, authenticationData, r -> super.allowSourceOpsAsync(namespaceName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.authorize(role, authenticationData, r -> super.allowSinkOpsAsync(namespaceName, (String)r, authenticationData));
    }

    @Override
    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, String role, TenantOperation operation, AuthenticationDataSource authData) {
        return this.authorize(role, authData, r -> super.allowTenantOperationAsync(tenantName, (String)r, operation, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, String role, NamespaceOperation operation, AuthenticationDataSource authData) {
        return this.authorize(role, authData, r -> super.allowNamespaceOperationAsync(namespaceName, (String)r, operation, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        return this.authorize(role, authData, r -> super.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, (String)r, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, String role, TopicOperation operation, AuthenticationDataSource authData) {
        return this.authorize(role, authData, r -> super.allowTopicOperationAsync(topicName, (String)r, operation, authData));
    }

    @Override
    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, String role, PolicyName policyName, PolicyOperation policyOperation, AuthenticationDataSource authData) {
        return this.authorize(role, authData, r -> super.allowTopicPolicyOperationAsync(topicName, (String)r, policyName, policyOperation, authData));
    }
}

