/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.quorum;

import org.apache.pulsar.shade.org.apache.zookeeper.server.quorum.SyncThrottleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearnerSyncThrottler {
    private static final Logger LOG = LoggerFactory.getLogger(LearnerSyncThrottler.class);
    private final Object countSyncObject = new Object();
    private int syncInProgress;
    private volatile int maxConcurrentSyncs;
    private final SyncType syncType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LearnerSyncThrottler(int maxConcurrentSyncs, SyncType syncType) throws IllegalArgumentException {
        if (maxConcurrentSyncs <= 0) {
            String errorMsg = "maxConcurrentSyncs must be positive, was " + maxConcurrentSyncs;
            throw new IllegalArgumentException(errorMsg);
        }
        this.maxConcurrentSyncs = maxConcurrentSyncs;
        this.syncType = syncType;
        Object object = this.countSyncObject;
        synchronized (object) {
            this.syncInProgress = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beginSync(boolean essential) throws SyncThrottleException, InterruptedException {
        Object object = this.countSyncObject;
        synchronized (object) {
            if (essential || this.syncInProgress < this.maxConcurrentSyncs) {
                ++this.syncInProgress;
            } else {
                throw new SyncThrottleException(this.syncInProgress + 1, this.maxConcurrentSyncs, this.syncType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endSync() {
        int newCount;
        Object object = this.countSyncObject;
        synchronized (object) {
            --this.syncInProgress;
            newCount = this.syncInProgress;
            this.countSyncObject.notify();
        }
        if (newCount < 0) {
            String errorMsg = "endSync() called incorrectly; current sync count is " + newCount;
            LOG.error(errorMsg);
        }
    }

    public void setMaxConcurrentSyncs(int maxConcurrentSyncs) {
        this.maxConcurrentSyncs = maxConcurrentSyncs;
    }

    public int getSyncInProgress() {
        return this.syncInProgress;
    }

    public static enum SyncType {
        DIFF,
        SNAP;

    }
}

