/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.Bookie;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieServer;
import org.apache.pulsar.shade.org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.server.service.BookieService;
import org.apache.pulsar.shade.org.apache.bookkeeper.shims.zk.ZooKeeperServerShim;
import org.apache.pulsar.shade.org.apache.bookkeeper.shims.zk.ZooKeeperServerShimFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.IOUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.PortManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.pulsar.shade.org.apache.commons.io.FileUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.CreateMode;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.Op;
import org.apache.pulsar.shade.org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalBookKeeper {
    protected static final Logger LOG = LoggerFactory.getLogger(LocalBookKeeper.class);
    public static final int CONNECTION_TIMEOUT = 30000;
    int numberOfBookies;
    private static String zooKeeperDefaultHost = "127.0.0.1";
    private static int zooKeeperDefaultPort = 2181;
    private static int zkSessionTimeOut = 5000;
    private static Integer bookieDefaultInitialPort = 5000;
    private static String defaultLocalBookiesConfigDir = "/tmp/localbookies-config";
    File[] journalDirs;
    BookieServer[] bs;
    ServerConfiguration[] bsConfs;
    Integer initialPort = 5000;
    private ServerConfiguration baseConf;
    File localBookiesConfigDir;

    private static String newMetadataServiceUri(String zkServers, int port, String layout, String ledgerPath) {
        return "zk+" + layout + "://" + zkServers + ":" + port + ledgerPath;
    }

    public LocalBookKeeper() {
        this(3);
    }

    public LocalBookKeeper(int numberOfBookies) {
        this(numberOfBookies, 5000, new ServerConfiguration(), defaultLocalBookiesConfigDir);
    }

    public LocalBookKeeper(int numberOfBookies, int initialPort, ServerConfiguration baseConf, String localBookiesConfigDirName) {
        this.numberOfBookies = numberOfBookies;
        this.initialPort = initialPort;
        this.localBookiesConfigDir = new File(localBookiesConfigDirName);
        this.baseConf = baseConf;
        LOG.info("Running {} bookie(s) on zk ensemble = '{}:{}'.", new Object[]{this.numberOfBookies, zooKeeperDefaultHost, zooKeeperDefaultPort});
    }

    public static ZooKeeperServerShim runZookeeper(int maxCC, int zookeeperPort) throws IOException {
        File zkTmpDir = IOUtils.createTempDir("zookeeper", "localbookkeeper");
        return LocalBookKeeper.runZookeeper(maxCC, zookeeperPort, zkTmpDir);
    }

    public static ZooKeeperServerShim runZookeeper(int maxCC, int zookeeperPort, File zkDir) throws IOException {
        LOG.info("Starting ZK server");
        ZooKeeperServerShim server = ZooKeeperServerShimFactory.createServer(zkDir, zkDir, zookeeperPort, maxCC);
        server.start();
        boolean b = LocalBookKeeper.waitForServerUp(InetAddress.getLoopbackAddress().getHostAddress() + ":" + zookeeperPort, 30000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("ZooKeeper server up: {}", (Object)b);
        }
        return server;
    }

    private void initializeZookeeper(String zkHost, int zkPort) throws IOException {
        LOG.info("Instantiate ZK Client");
        try (ZooKeeperClient zkc = ZooKeeperClient.newBuilder().connectString(zkHost + ":" + zkPort).sessionTimeoutMs(zkSessionTimeOut).build();){
            String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(this.baseConf);
            ZkUtils.createFullPathOptimistic(zkc, zkLedgersRootPath, new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            ArrayList<Op> multiOps = Lists.newArrayListWithExpectedSize(2);
            multiOps.add(Op.create(zkLedgersRootPath + "/" + "available", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
            multiOps.add(Op.create(zkLedgersRootPath + "/" + "available" + "/" + "readonly", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT));
            zkc.multi(multiOps);
        }
        catch (KeeperException e) {
            LOG.error("Exception while creating znodes", (Throwable)e);
            throw new IOException("Error creating znodes : ", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Interrupted while creating znodes", (Throwable)e);
            throw new IOException("Error creating znodes : ", e);
        }
    }

    private static void cleanupDirectories(List<File> dirs) throws IOException {
        for (File dir : dirs) {
            FileUtils.deleteDirectory(dir);
        }
    }

    private List<File> runBookies(String dirSuffix) throws Exception {
        ArrayList<File> tempDirs = new ArrayList<File>();
        try {
            this.runBookies(tempDirs, dirSuffix);
            return tempDirs;
        }
        catch (Exception ioe) {
            LocalBookKeeper.cleanupDirectories(tempDirs);
            throw ioe;
        }
    }

    private void runBookies(List<File> tempDirs, String dirSuffix) throws Exception {
        LOG.info("Starting Bookie(s)");
        this.journalDirs = new File[this.numberOfBookies];
        this.bs = new BookieServer[this.numberOfBookies];
        this.bsConfs = new ServerConfiguration[this.numberOfBookies];
        if (this.localBookiesConfigDir.exists() && this.localBookiesConfigDir.isFile()) {
            throw new IOException("Unable to create LocalBookiesConfigDir, since there is a file at " + this.localBookiesConfigDir.getAbsolutePath());
        }
        if (!this.localBookiesConfigDir.exists() && !this.localBookiesConfigDir.mkdirs()) {
            throw new IOException("Unable to create LocalBookiesConfigDir - " + this.localBookiesConfigDir.getAbsolutePath());
        }
        for (int i = 0; i < this.numberOfBookies; ++i) {
            if (null == this.baseConf.getJournalDirNameWithoutDefault()) {
                this.journalDirs[i] = IOUtils.createTempDir("localbookkeeper" + Integer.toString(i), dirSuffix);
                tempDirs.add(this.journalDirs[i]);
            } else {
                this.journalDirs[i] = new File(this.baseConf.getJournalDirName(), "bookie" + Integer.toString(i));
            }
            if (this.journalDirs[i].exists()) {
                if (this.journalDirs[i].isDirectory()) {
                    FileUtils.deleteDirectory(this.journalDirs[i]);
                } else if (!this.journalDirs[i].delete()) {
                    throw new IOException("Couldn't cleanup bookie journal dir " + this.journalDirs[i]);
                }
            }
            if (!this.journalDirs[i].mkdirs()) {
                throw new IOException("Couldn't create bookie journal dir " + this.journalDirs[i]);
            }
            String[] ledgerDirs = this.baseConf.getLedgerDirWithoutDefault();
            if (null == ledgerDirs || 0 == ledgerDirs.length) {
                ledgerDirs = new String[]{this.journalDirs[i].getPath()};
            } else {
                for (int l = 0; l < ledgerDirs.length; ++l) {
                    File dir = new File(ledgerDirs[l], "bookie" + Integer.toString(i));
                    if (dir.exists()) {
                        if (dir.isDirectory()) {
                            FileUtils.deleteDirectory(dir);
                        } else if (!dir.delete()) {
                            throw new IOException("Couldn't cleanup bookie ledger dir " + dir);
                        }
                    }
                    if (!dir.mkdirs()) {
                        throw new IOException("Couldn't create bookie ledger dir " + dir);
                    }
                    ledgerDirs[l] = dir.getPath();
                }
            }
            this.bsConfs[i] = new ServerConfiguration((ServerConfiguration)this.baseConf.clone());
            PortManager.initPort(this.initialPort);
            if (0 == this.initialPort) {
                this.bsConfs[i].setBookiePort(0);
            } else {
                this.bsConfs[i].setBookiePort(PortManager.nextFreePort());
            }
            if (null == this.baseConf.getMetadataServiceUriUnchecked()) {
                this.bsConfs[i].setMetadataServiceUri(this.baseConf.getMetadataServiceUri());
            }
            this.bsConfs[i].setJournalDirName(this.journalDirs[i].getPath());
            this.bsConfs[i].setLedgerDirNames(ledgerDirs);
            String fileName = Bookie.getBookieId(this.bsConfs[i]).toString() + ".conf";
            this.serializeLocalBookieConfig(this.bsConfs[i], fileName);
            ComponentInfoPublisher componentInfoPublisher = new ComponentInfoPublisher();
            Supplier<BookieServiceInfo> bookieServiceInfoProvider = () -> LocalBookKeeper.buildBookieServiceInfo(componentInfoPublisher);
            BookieService bookieService = new BookieService(new BookieConfiguration(this.bsConfs[i]), NullStatsLogger.INSTANCE, bookieServiceInfoProvider);
            this.bs[i] = bookieService.getServer();
            bookieService.publishInfo(componentInfoPublisher);
            componentInfoPublisher.startupFinished();
            bookieService.start();
        }
        ServerConfiguration baseConfWithCorrectZKServers = new ServerConfiguration((ServerConfiguration)this.baseConf.clone());
        if (null == this.baseConf.getMetadataServiceUriUnchecked()) {
            baseConfWithCorrectZKServers.setMetadataServiceUri(this.baseConf.getMetadataServiceUri());
        }
        this.serializeLocalBookieConfig(baseConfWithCorrectZKServers, "baseconf.conf");
    }

    public static void startLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort) throws Exception {
        ServerConfiguration conf = new ServerConfiguration();
        LocalBookKeeper.startLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, initialBookiePort, true, "test", null, defaultLocalBookiesConfigDir);
    }

    public static void startLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort, ServerConfiguration conf) throws Exception {
        LocalBookKeeper.startLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, initialBookiePort, true, "test", null, defaultLocalBookiesConfigDir);
    }

    public static void startLocalBookies(String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort, String dirSuffix) throws Exception {
        ServerConfiguration conf = new ServerConfiguration();
        LocalBookKeeper.startLocalBookiesInternal(conf, zkHost, zkPort, numBookies, shouldStartZK, initialBookiePort, true, dirSuffix, null, defaultLocalBookiesConfigDir);
    }

    static void startLocalBookiesInternal(ServerConfiguration conf, String zkHost, int zkPort, int numBookies, boolean shouldStartZK, int initialBookiePort, boolean stopOnExit, String dirSuffix, String zkDataDir, String localBookiesConfigDirName) throws Exception {
        conf.setMetadataServiceUri(LocalBookKeeper.newMetadataServiceUri(zkHost, zkPort, conf.getLedgerManagerLayoutStringFromFactoryClass(), conf.getZkLedgersRootPath()));
        LocalBookKeeper lb = new LocalBookKeeper(numBookies, initialBookiePort, conf, localBookiesConfigDirName);
        ZooKeeperServerShim zks = null;
        File zkTmpDir = null;
        List<File> bkTmpDirs = null;
        try {
            try {
                if (shouldStartZK) {
                    File zkDataDirFile = null;
                    if (zkDataDir != null) {
                        zkDataDirFile = new File(zkDataDir);
                        if (zkDataDirFile.exists() && zkDataDirFile.isFile()) {
                            throw new IOException("Unable to create zkDataDir, since there is a file at " + zkDataDirFile.getAbsolutePath());
                        }
                        if (!zkDataDirFile.exists() && !zkDataDirFile.mkdirs()) {
                            throw new IOException("Unable to create zkDataDir - " + zkDataDirFile.getAbsolutePath());
                        }
                    }
                    zkTmpDir = IOUtils.createTempDir("zookeeper", dirSuffix, zkDataDirFile);
                    zkTmpDir.deleteOnExit();
                    zks = LocalBookKeeper.runZookeeper(1000, zkPort, zkTmpDir);
                }
                lb.initializeZookeeper(zkHost, zkPort);
                bkTmpDirs = lb.runBookies(dirSuffix);
                try {
                    while (true) {
                        Thread.sleep(5000L);
                    }
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    if (stopOnExit) {
                        lb.shutdownBookies();
                        if (null != zks) {
                            zks.stop();
                        }
                    }
                    throw ie;
                }
            }
            catch (Exception e) {
                LOG.error("Failed to run {} bookies : zk ensemble = '{}:{}'", new Object[]{numBookies, zkHost, zkPort, e});
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (stopOnExit) {
                if (null != bkTmpDirs) {
                    LocalBookKeeper.cleanupDirectories(bkTmpDirs);
                }
                if (null != zkTmpDir) {
                    FileUtils.deleteDirectory(zkTmpDir);
                }
            }
            throw throwable;
        }
    }

    private void serializeLocalBookieConfig(ServerConfiguration localBookieConfig, String fileName) throws IOException {
        File localBookieConfFile = new File(this.localBookiesConfigDir, fileName);
        if (localBookieConfFile.exists() && !localBookieConfFile.delete()) {
            throw new IOException("Unable to delete the existing LocalBookieConfigFile - " + localBookieConfFile.getAbsolutePath());
        }
        if (!localBookieConfFile.createNewFile()) {
            throw new IOException("Unable to create new File - " + localBookieConfFile.getAbsolutePath());
        }
        Iterator<String> keys = localBookieConfig.getKeys();
        try (PrintWriter writer = new PrintWriter(localBookieConfFile, "UTF-8");){
            while (keys.hasNext()) {
                String key = keys.next();
                String[] values = localBookieConfig.getStringArray(key);
                StringBuilder concatenatedValue = new StringBuilder(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    concatenatedValue.append(",").append(values[i]);
                }
                writer.println(key + "=" + concatenatedValue);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                LocalBookKeeper.usage();
                System.exit(-1);
            }
            int numBookies = 0;
            try {
                numBookies = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.error("Unrecognized number-of-bookies: {}", (Object)args[0]);
                LocalBookKeeper.usage();
                System.exit(-1);
            }
            ServerConfiguration conf = new ServerConfiguration();
            conf.setAllowLoopback(true);
            if (args.length >= 2) {
                String confFile = args[1];
                try {
                    conf.loadConf(new File(confFile).toURI().toURL());
                    LOG.info("Using configuration file {}", (Object)confFile);
                }
                catch (Exception e) {
                    LOG.warn("Error loading configuration file {}", (Object)confFile, (Object)e);
                }
            }
            String zkDataDir = null;
            if (args.length >= 3) {
                zkDataDir = args[2];
            }
            String localBookiesConfigDirName = defaultLocalBookiesConfigDir;
            if (args.length >= 4) {
                localBookiesConfigDirName = args[3];
            }
            LocalBookKeeper.startLocalBookiesInternal(conf, zooKeeperDefaultHost, zooKeeperDefaultPort, numBookies, true, bookieDefaultInitialPort, false, "test", zkDataDir, localBookiesConfigDirName);
        }
        catch (Exception e) {
            LOG.error("Exiting LocalBookKeeper because of exception in main method", (Throwable)e);
            System.exit(-1);
        }
    }

    private static void usage() {
        System.err.println("Usage: LocalBookKeeper number-of-bookies [path to bookie config] [path to create ZK data directory at] [path to LocalBookiesConfigDir]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        String[] split = hp.split(":");
        String host = split[0];
        int port = Integer.parseInt(split[1]);
        while (true) {
            try {
                Socket sock = new Socket(host, port);
                BufferedReader reader = null;
                try {
                    OutputStream outstream = sock.getOutputStream();
                    outstream.write("stat".getBytes(StandardCharsets.UTF_8));
                    outstream.flush();
                    reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    if (line != null && line.startsWith("Zookeeper version:")) {
                        LOG.info("Server UP");
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    sock.close();
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                LOG.info("server " + hp + " not up " + e);
            }
            if (System.currentTimeMillis() > start + timeout) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void shutdownBookies() {
        for (BookieServer bookieServer : this.bs) {
            bookieServer.shutdown();
        }
    }

    private static BookieServiceInfo buildBookieServiceInfo(ComponentInfoPublisher componentInfoPublisher) {
        List<BookieServiceInfo.Endpoint> endpoints = componentInfoPublisher.getEndpoints().values().stream().map(e -> new BookieServiceInfo.Endpoint(e.getId(), e.getPort(), e.getHost(), e.getProtocol(), e.getAuth(), e.getExtensions())).collect(Collectors.toList());
        return new BookieServiceInfo(componentInfoPublisher.getProperties(), endpoints);
    }
}

