/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.util;

import java.util.ArrayList;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.CompositeByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandlerContext;
import org.apache.pulsar.shade.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.pulsar.shade.io.netty.channel.ChannelPromise;
import org.apache.pulsar.shade.io.netty.util.AbstractReferenceCounted;
import org.apache.pulsar.shade.io.netty.util.Recycler;
import org.apache.pulsar.shade.io.netty.util.ReferenceCountUtil;
import org.apache.pulsar.shade.io.netty.util.ReferenceCounted;

public class ByteBufList
extends AbstractReferenceCounted {
    private final ArrayList<ByteBuf> buffers;
    private final Recycler.Handle<ByteBufList> recyclerHandle;
    private static final int INITIAL_LIST_SIZE = 4;
    private static final Recycler<ByteBufList> RECYCLER = new Recycler<ByteBufList>(){

        @Override
        protected ByteBufList newObject(Recycler.Handle<ByteBufList> handle) {
            return new ByteBufList(handle);
        }
    };
    public static final Encoder ENCODER = new Encoder();

    private ByteBufList(Recycler.Handle<ByteBufList> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
        this.buffers = new ArrayList(4);
    }

    public static ByteBufList get(ByteBuf b1, ByteBuf b2) {
        ByteBufList buf = ByteBufList.get();
        buf.add(b1);
        buf.add(b2);
        return buf;
    }

    public static ByteBufList get(ByteBuf b1) {
        ByteBufList buf = ByteBufList.get();
        buf.add(b1);
        return buf;
    }

    public static ByteBufList clone(ByteBufList other) {
        ByteBufList buf = ByteBufList.get();
        for (int i = 0; i < other.buffers.size(); ++i) {
            buf.add(other.buffers.get(i).retainedDuplicate());
        }
        return buf;
    }

    private static ByteBufList get() {
        ByteBufList buf = RECYCLER.get();
        buf.setRefCnt(1);
        return buf;
    }

    public void add(ByteBuf buf) {
        ByteBuf unwrapped = buf.unwrap() != null && buf.unwrap() instanceof CompositeByteBuf ? buf.unwrap() : buf;
        ReferenceCountUtil.retain(unwrapped);
        ReferenceCountUtil.release(buf);
        if (unwrapped instanceof CompositeByteBuf) {
            ((CompositeByteBuf)unwrapped).forEach(b -> {
                ReferenceCountUtil.retain(b);
                this.buffers.add((ByteBuf)b);
            });
            ReferenceCountUtil.release(unwrapped);
        } else {
            this.buffers.add(unwrapped);
        }
    }

    public void prepend(ByteBuf buf) {
        ByteBuf unwrapped = buf.unwrap() != null && buf.unwrap() instanceof CompositeByteBuf ? buf.unwrap() : buf;
        ReferenceCountUtil.retain(unwrapped);
        ReferenceCountUtil.release(buf);
        if (unwrapped instanceof CompositeByteBuf) {
            CompositeByteBuf composite = (CompositeByteBuf)unwrapped;
            for (int i = composite.numComponents() - 1; i >= 0; --i) {
                ByteBuf b = composite.component(i);
                ReferenceCountUtil.retain(b);
                this.buffers.add(0, b);
            }
            ReferenceCountUtil.release(unwrapped);
        } else {
            this.buffers.add(0, unwrapped);
        }
    }

    public int readableBytes() {
        int readableBytes = 0;
        for (int i = 0; i < this.buffers.size(); ++i) {
            readableBytes += this.buffers.get(i).readableBytes();
        }
        return readableBytes;
    }

    public ByteBuf getBuffer(int index) {
        return this.buffers.get(index);
    }

    public int size() {
        return this.buffers.size();
    }

    public int getBytes(byte[] dst) {
        int len;
        int copied = 0;
        for (int idx = 0; idx < this.buffers.size() && copied < dst.length; copied += len, ++idx) {
            ByteBuf b = this.buffers.get(idx);
            len = Math.min(b.readableBytes(), dst.length - copied);
            b.getBytes(b.readerIndex(), dst, copied, len);
        }
        return copied;
    }

    public byte[] toArray() {
        byte[] a = new byte[this.readableBytes()];
        this.getBytes(a);
        return a;
    }

    public boolean hasArray() {
        return this.buffers.size() == 1 && this.buffers.get(0).hasArray();
    }

    public byte[] array() {
        return this.buffers.get(0).array();
    }

    public int arrayOffset() {
        return this.buffers.get(0).arrayOffset();
    }

    @VisibleForTesting
    public static ByteBuf coalesce(ByteBufList list) {
        ByteBuf res = Unpooled.buffer(list.readableBytes());
        for (int i = 0; i < list.buffers.size(); ++i) {
            ByteBuf b = list.buffers.get(i);
            res.writeBytes(b, b.readerIndex(), b.readableBytes());
        }
        return res;
    }

    @Override
    public ByteBufList retain() {
        super.retain();
        return this;
    }

    @Override
    protected void deallocate() {
        for (int i = 0; i < this.buffers.size(); ++i) {
            ReferenceCountUtil.release(this.buffers.get(i));
        }
        this.buffers.clear();
        this.recyclerHandle.recycle(this);
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        for (int i = 0; i < this.buffers.size(); ++i) {
            this.buffers.get(i).touch(hint);
        }
        return this;
    }

    @ChannelHandler.Sharable
    public static class Encoder
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBufList) {
                ByteBufList b = (ByteBufList)msg;
                try {
                    int buffersCount = b.buffers.size();
                    for (int i = 0; i < buffersCount; ++i) {
                        ByteBuf bx = (ByteBuf)b.buffers.get(i);
                        ctx.write(bx.retainedDuplicate(), i == buffersCount - 1 ? promise : ctx.voidPromise());
                    }
                }
                finally {
                    ReferenceCountUtil.safeRelease(b);
                }
            } else {
                ctx.write(msg, promise);
            }
        }
    }
}

