/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.conf;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.annotations.Beta;
import org.apache.pulsar.shade.com.google.common.base.Strings;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.ConfigDef;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.ConfigException;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.ConfigKey;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.ConfigKeyGroup;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.Type;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.validators.ClassValidator;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.conf.validators.RangeValidator;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.discover.ZKRegistrationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.shade.org.apache.commons.configuration.ConfigurationException;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ServerConfiguration
extends AbstractConfiguration<ServerConfiguration> {
    private static final int SECOND = 1000;
    private static final ConfigKeyGroup GROUP_LEDGER_STORAGE = ConfigKeyGroup.builder("ledgerstorage").description("Ledger Storage related settings").order(10).build();
    protected static final String LEDGER_STORAGE_CLASS = "ledgerStorageClass";
    protected static final ConfigKey LEDGER_STORAGE_CLASS_KEY = ConfigKey.builder("ledgerStorageClass").type(Type.CLASS).description("Ledger storage implementation class").defaultValue(SortedLedgerStorage.class).optionValues(Lists.newArrayList(InterleavedLedgerStorage.class.getName(), SortedLedgerStorage.class.getName(), DbLedgerStorage.class.getName())).validator(ClassValidator.of(LedgerStorage.class)).group(GROUP_LEDGER_STORAGE).build();
    private static final ConfigKeyGroup GROUP_LEDGER_STORAGE_ENTRY_LOGGER = ConfigKeyGroup.builder("entrylogger").description("EntryLogger related settings").order(11).build();
    protected static final String ENTRY_LOG_SIZE_LIMIT = "logSizeLimit";
    protected static final ConfigKey ENTRY_LOG_SIZE_LIMIT_KEY = ConfigKey.builder("logSizeLimit").type(Type.LONG).description("Max file size of entry logger, in bytes").documentation("A new entry log file will be created when the old one reaches this file size limitation").defaultValue(0x40000000L).validator(RangeValidator.between(0, 0x40000000L)).group(GROUP_LEDGER_STORAGE_ENTRY_LOGGER).build();
    protected static final String ENTRY_LOG_FILE_PREALLOCATION_ENABLED = "entryLogFilePreallocationEnabled";
    protected static final String FORCE_ALLOW_COMPACTION = "forceAllowCompaction";
    protected static final String MINOR_COMPACTION_INTERVAL = "minorCompactionInterval";
    protected static final String MINOR_COMPACTION_THRESHOLD = "minorCompactionThreshold";
    protected static final String MINOR_COMPACTION_MAX_TIME_MILLIS = "minorCompactionMaxTimeMillis";
    protected static final String MAJOR_COMPACTION_INTERVAL = "majorCompactionInterval";
    protected static final String MAJOR_COMPACTION_THRESHOLD = "majorCompactionThreshold";
    protected static final String MAJOR_COMPACTION_MAX_TIME_MILLIS = "majorCompactionMaxTimeMillis";
    protected static final String IS_THROTTLE_BY_BYTES = "isThrottleByBytes";
    protected static final String COMPACTION_MAX_OUTSTANDING_REQUESTS = "compactionMaxOutstandingRequests";
    protected static final String COMPACTION_RATE = "compactionRate";
    protected static final String COMPACTION_RATE_BY_ENTRIES = "compactionRateByEntries";
    protected static final String COMPACTION_RATE_BY_BYTES = "compactionRateByBytes";
    protected static final String GC_WAIT_TIME = "gcWaitTime";
    protected static final String IS_FORCE_GC_ALLOW_WHEN_NO_SPACE = "isForceGCAllowWhenNoSpace";
    protected static final String GC_OVERREPLICATED_LEDGER_WAIT_TIME = "gcOverreplicatedLedgerWaitTime";
    protected static final String USE_TRANSACTIONAL_COMPACTION = "useTransactionalCompaction";
    protected static final String VERIFY_METADATA_ON_GC = "verifyMetadataOnGC";
    protected static final String LOCAL_SCRUB_PERIOD = "localScrubInterval";
    protected static final String LOCAL_SCRUB_RATE_LIMIT = "localScrubRateLimit";
    protected static final String FLUSH_INTERVAL = "flushInterval";
    protected static final String FLUSH_ENTRYLOG_INTERVAL_BYTES = "flushEntrylogBytes";
    protected static final String DEATH_WATCH_INTERVAL = "bookieDeathWatchInterval";
    protected static final String OPEN_FILE_LIMIT = "openFileLimit";
    protected static final String PAGE_LIMIT = "pageLimit";
    protected static final String PAGE_SIZE = "pageSize";
    protected static final String FILEINFO_CACHE_INITIAL_CAPACITY = "fileInfoCacheInitialCapacity";
    protected static final String FILEINFO_MAX_IDLE_TIME = "fileInfoMaxIdleTime";
    protected static final String FILEINFO_FORMAT_VERSION_TO_WRITE = "fileInfoFormatVersionToWrite";
    protected static final String MAX_JOURNAL_SIZE = "journalMaxSizeMB";
    protected static final String MAX_BACKUP_JOURNALS = "journalMaxBackups";
    protected static final String JOURNAL_SYNC_DATA = "journalSyncData";
    protected static final String JOURNAL_WRITE_DATA = "journalWriteData";
    protected static final String JOURNAL_ADAPTIVE_GROUP_WRITES = "journalAdaptiveGroupWrites";
    protected static final String JOURNAL_MAX_GROUP_WAIT_MSEC = "journalMaxGroupWaitMSec";
    protected static final String JOURNAL_BUFFERED_WRITES_THRESHOLD = "journalBufferedWritesThreshold";
    protected static final String JOURNAL_BUFFERED_ENTRIES_THRESHOLD = "journalBufferedEntriesThreshold";
    protected static final String JOURNAL_FLUSH_WHEN_QUEUE_EMPTY = "journalFlushWhenQueueEmpty";
    protected static final String JOURNAL_REMOVE_FROM_PAGE_CACHE = "journalRemoveFromPageCache";
    protected static final String JOURNAL_PRE_ALLOC_SIZE = "journalPreAllocSizeMB";
    protected static final String JOURNAL_WRITE_BUFFER_SIZE = "journalWriteBufferSizeKB";
    protected static final String JOURNAL_ALIGNMENT_SIZE = "journalAlignmentSize";
    protected static final String NUM_JOURNAL_CALLBACK_THREADS = "numJournalCallbackThreads";
    protected static final String JOURNAL_FORMAT_VERSION_TO_WRITE = "journalFormatVersionToWrite";
    protected static final String JOURNAL_QUEUE_SIZE = "journalQueueSize";
    protected static final String JOURNAL_MAX_MEMORY_SIZE_MB = "journalMaxMemorySizeMb";
    protected static final String JOURNAL_PAGECACHE_FLUSH_INTERVAL_MSEC = "journalPageCacheFlushIntervalMSec";
    protected static final String MAX_ADDS_IN_PROGRESS_LIMIT = "maxAddsInProgressLimit";
    protected static final String MAX_READS_IN_PROGRESS_LIMIT = "maxReadsInProgressLimit";
    protected static final String CLOSE_CHANNEL_ON_RESPONSE_TIMEOUT = "closeChannelOnResponseTimeout";
    protected static final String WAIT_TIMEOUT_ON_RESPONSE_BACKPRESSURE = "waitTimeoutOnResponseBackpressureMs";
    protected static final String BOOKIE_PORT = "bookiePort";
    protected static final String LISTENING_INTERFACE = "listeningInterface";
    protected static final String ALLOW_LOOPBACK = "allowLoopback";
    protected static final String ADVERTISED_ADDRESS = "advertisedAddress";
    protected static final String BOOKIE_ID = "bookieId";
    protected static final String ALLOW_EPHEMERAL_PORTS = "allowEphemeralPorts";
    protected static final String JOURNAL_DIR = "journalDirectory";
    protected static final String JOURNAL_DIRS = "journalDirectories";
    protected static final String LEDGER_DIRS = "ledgerDirectories";
    protected static final String INDEX_DIRS = "indexDirectories";
    protected static final String ALLOW_STORAGE_EXPANSION = "allowStorageExpansion";
    protected static final String SERVER_TCP_NODELAY = "serverTcpNoDelay";
    protected static final String SERVER_SOCK_KEEPALIVE = "serverSockKeepalive";
    protected static final String SERVER_SOCK_LINGER = "serverTcpLinger";
    protected static final String SERVER_WRITEBUFFER_LOW_WATER_MARK = "serverWriteBufferLowWaterMark";
    protected static final String SERVER_WRITEBUFFER_HIGH_WATER_MARK = "serverWriteBufferHighWaterMark";
    protected static final String SERVER_NUM_IO_THREADS = "serverNumIOThreads";
    protected static final String ZK_RETRY_BACKOFF_START_MS = "zkRetryBackoffStartMs";
    protected static final String ZK_RETRY_BACKOFF_MAX_MS = "zkRetryBackoffMaxMs";
    protected static final String OPEN_LEDGER_REREPLICATION_GRACE_PERIOD = "openLedgerRereplicationGracePeriod";
    protected static final String LOCK_RELEASE_OF_FAILED_LEDGER_GRACE_PERIOD = "lockReleaseOfFailedLedgerGracePeriod";
    protected static final String READ_ONLY_MODE_ENABLED = "readOnlyModeEnabled";
    protected static final String FORCE_READ_ONLY_BOOKIE = "forceReadOnlyBookie";
    protected static final String PERSIST_BOOKIE_STATUS_ENABLED = "persistBookieStatusEnabled";
    protected static final String DISK_USAGE_THRESHOLD = "diskUsageThreshold";
    protected static final String DISK_USAGE_WARN_THRESHOLD = "diskUsageWarnThreshold";
    protected static final String DISK_USAGE_LWM_THRESHOLD = "diskUsageLwmThreshold";
    protected static final String DISK_CHECK_INTERVAL = "diskCheckInterval";
    protected static final String AUDITOR_PERIODIC_CHECK_INTERVAL = "auditorPeriodicCheckInterval";
    protected static final String AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL = "auditorPeriodicBookieCheckInterval";
    protected static final String AUDITOR_PERIODIC_PLACEMENT_POLICY_CHECK_INTERVAL = "auditorPeriodicPlacementPolicyCheckInterval";
    protected static final String AUDITOR_LEDGER_VERIFICATION_PERCENTAGE = "auditorLedgerVerificationPercentage";
    protected static final String AUTO_RECOVERY_DAEMON_ENABLED = "autoRecoveryDaemonEnabled";
    protected static final String LOST_BOOKIE_RECOVERY_DELAY = "lostBookieRecoveryDelay";
    protected static final String RW_REREPLICATE_BACKOFF_MS = "rwRereplicateBackoffMs";
    protected static final String UNDERREPLICATED_LEDGER_RECOVERY_GRACE_PERIOD = "underreplicatedLedgerRecoveryGracePeriod";
    protected static final String AUDITOR_REPLICAS_CHECK_INTERVAL = "auditorReplicasCheckInterval";
    protected static final String AUDITOR_MAX_NUMBER_OF_CONCURRENT_OPEN_LEDGER_OPERATIONS = "auditorMaxNumberOfConcurrentOpenLedgerOperations";
    protected static final String AUDITOR_ACQUIRE_CONCURRENT_OPEN_LEDGER_OPERATIONS_TIMEOUT_MSEC = "auditorAcquireConcurrentOpenLedgerOperationsTimeOutMSec";
    protected static final String IN_FLIGHT_READ_ENTRY_NUM_IN_LEDGER_CHECKER = "inFlightReadEntryNumInLedgerChecker";
    protected static final String NUM_ADD_WORKER_THREADS = "numAddWorkerThreads";
    protected static final String NUM_READ_WORKER_THREADS = "numReadWorkerThreads";
    protected static final String MAX_PENDING_READ_REQUESTS_PER_THREAD = "maxPendingReadRequestsPerThread";
    protected static final String MAX_PENDING_ADD_REQUESTS_PER_THREAD = "maxPendingAddRequestsPerThread";
    protected static final String NUM_LONG_POLL_WORKER_THREADS = "numLongPollWorkerThreads";
    protected static final String NUM_HIGH_PRIORITY_WORKER_THREADS = "numHighPriorityWorkerThreads";
    protected static final String READ_WORKER_THREADS_THROTTLING_ENABLED = "readWorkerThreadsThrottlingEnabled";
    protected static final String REQUEST_TIMER_TICK_DURATION_MILLISEC = "requestTimerTickDurationMs";
    protected static final String REQUEST_TIMER_NO_OF_TICKS = "requestTimerNumTicks";
    protected static final String READ_BUFFER_SIZE = "readBufferSizeBytes";
    protected static final String WRITE_BUFFER_SIZE = "writeBufferSizeBytes";
    protected static final String USE_HOST_NAME_AS_BOOKIE_ID = "useHostNameAsBookieID";
    protected static final String USE_SHORT_HOST_NAME = "useShortHostName";
    protected static final String ENABLE_LOCAL_TRANSPORT = "enableLocalTransport";
    protected static final String DISABLE_SERVER_SOCKET_BIND = "disableServerSocketBind";
    protected static final String SORTED_LEDGER_STORAGE_ENABLED = "sortedLedgerStorageEnabled";
    protected static final String SKIP_LIST_SIZE_LIMIT = "skipListSizeLimit";
    protected static final String SKIP_LIST_CHUNK_SIZE_ENTRY = "skipListArenaChunkSize";
    protected static final String SKIP_LIST_MAX_ALLOC_ENTRY = "skipListArenaMaxAllocSize";
    protected static final String ENABLE_STATISTICS = "enableStatistics";
    protected static final String STATS_PROVIDER_CLASS = "statsProviderClass";
    protected static final String BYTEBUF_ALLOCATOR_SIZE_INITIAL = "byteBufAllocatorSizeInitial";
    protected static final String BYTEBUF_ALLOCATOR_SIZE_MIN = "byteBufAllocatorSizeMin";
    protected static final String BYTEBUF_ALLOCATOR_SIZE_MAX = "byteBufAllocatorSizeMax";
    protected static final String BOOKIE_AUTH_PROVIDER_FACTORY_CLASS = "bookieAuthProviderFactoryClass";
    protected static final String MIN_USABLESIZE_FOR_INDEXFILE_CREATION = "minUsableSizeForIndexFileCreation";
    protected static final String MIN_USABLESIZE_FOR_ENTRYLOG_CREATION = "minUsableSizeForEntryLogCreation";
    protected static final String MIN_USABLESIZE_FOR_HIGH_PRIORITY_WRITES = "minUsableSizeForHighPriorityWrites";
    protected static final String ALLOW_MULTIPLEDIRS_UNDER_SAME_DISKPARTITION = "allowMultipleDirsUnderSameDiskPartition";
    protected static final String HTTP_SERVER_ENABLED = "httpServerEnabled";
    protected static final String HTTP_SERVER_PORT = "httpServerPort";
    protected static final String EXTRA_SERVER_COMPONENTS = "extraServerComponents";
    protected static final String IGNORE_EXTRA_SERVER_COMPONENTS_STARTUP_FAILURES = "ignoreExtraServerComponentsStartupFailures";
    protected static final String REGISTRATION_MANAGER_CLASS = "registrationManagerClass";
    protected static final String ENABLE_TASK_EXECUTION_STATS = "enableTaskExecutionStats";
    protected static final String ENTRY_LOG_PER_LEDGER_ENABLED = "entryLogPerLedgerEnabled";
    protected static final String NUMBER_OF_MEMTABLE_FLUSH_THREADS = "numOfMemtableFlushThreads";
    protected static final String ENTRYLOGMAP_ACCESS_EXPIRYTIME_INSECONDS = "entrylogMapAccessExpiryTimeInSeconds";
    protected static final String MAXIMUM_NUMBER_OF_ACTIVE_ENTRYLOGS = "maximumNumberOfActiveEntryLogs";
    protected static final String ENTRY_LOG_PER_LEDGER_COUNTER_LIMITS_MULT_FACTOR = "entryLogPerLedgerCounterLimitsMultFactor";
    protected static final String LOCAL_CONSISTENCY_CHECK_ON_STARTUP = "localConsistencyCheckOnStartup";
    protected static final String AUTHORIZED_ROLES = "authorizedRoles";
    protected static final String ROCKSDB_DELETE_ENTRIES_BATCH_SIZE = "rocksDBDeleteEntriesBatchSize";

    public ServerConfiguration() {
    }

    public ServerConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public long getEntryLogSizeLimit() {
        return ENTRY_LOG_SIZE_LIMIT_KEY.getLong(this);
    }

    public ServerConfiguration setEntryLogSizeLimit(long logSizeLimit) {
        ENTRY_LOG_SIZE_LIMIT_KEY.set(this, logSizeLimit);
        return this;
    }

    public boolean isEntryLogFilePreAllocationEnabled() {
        return this.getBoolean(ENTRY_LOG_FILE_PREALLOCATION_ENABLED, true);
    }

    public ServerConfiguration setEntryLogFilePreAllocationEnabled(boolean enabled) {
        this.setProperty(ENTRY_LOG_FILE_PREALLOCATION_ENABLED, enabled);
        return this;
    }

    public long getGcWaitTime() {
        return this.getLong(GC_WAIT_TIME, 600000L);
    }

    public ServerConfiguration setGcWaitTime(long gcWaitTime) {
        this.setProperty(GC_WAIT_TIME, Long.toString(gcWaitTime));
        return this;
    }

    public long getGcOverreplicatedLedgerWaitTimeMillis() {
        return this.getLong(GC_OVERREPLICATED_LEDGER_WAIT_TIME, TimeUnit.DAYS.toMillis(1L));
    }

    public ServerConfiguration setGcOverreplicatedLedgerWaitTime(long gcWaitTime, TimeUnit unit) {
        this.setProperty(GC_OVERREPLICATED_LEDGER_WAIT_TIME, Long.toString(unit.toMillis(gcWaitTime)));
        return this;
    }

    public boolean getUseTransactionalCompaction() {
        return this.getBoolean(USE_TRANSACTIONAL_COMPACTION, false);
    }

    public ServerConfiguration setUseTransactionalCompaction(boolean useTransactionalCompaction) {
        this.setProperty(USE_TRANSACTIONAL_COMPACTION, useTransactionalCompaction);
        return this;
    }

    public boolean getVerifyMetadataOnGC() {
        return this.getBoolean(VERIFY_METADATA_ON_GC, false);
    }

    public ServerConfiguration setVerifyMetadataOnGc(boolean verifyMetadataOnGC) {
        this.setProperty(VERIFY_METADATA_ON_GC, verifyMetadataOnGC);
        return this;
    }

    public boolean isLocalScrubEnabled() {
        return this.getLocalScrubPeriod() > 0L;
    }

    public long getLocalScrubPeriod() {
        return this.getLong(LOCAL_SCRUB_PERIOD, 0L);
    }

    public void setLocalScrubPeriod(long period) {
        this.setProperty(LOCAL_SCRUB_PERIOD, period);
    }

    public double getLocalScrubRateLimit() {
        return this.getDouble(LOCAL_SCRUB_RATE_LIMIT, 60.0);
    }

    public void setLocalScrubRateLimit(double scrubRateLimit) {
        this.setProperty(LOCAL_SCRUB_RATE_LIMIT, scrubRateLimit);
    }

    public int getFlushInterval() {
        return this.getInt(FLUSH_INTERVAL, 10000);
    }

    public ServerConfiguration setFlushInterval(int flushInterval) {
        this.setProperty(FLUSH_INTERVAL, Integer.toString(flushInterval));
        return this;
    }

    public long getFlushIntervalInBytes() {
        return this.getLong(FLUSH_ENTRYLOG_INTERVAL_BYTES, 0L);
    }

    public ServerConfiguration setFlushIntervalInBytes(long flushInterval) {
        this.setProperty(FLUSH_ENTRYLOG_INTERVAL_BYTES, Long.toString(flushInterval));
        return this;
    }

    public int getDeathWatchInterval() {
        return this.getInt(DEATH_WATCH_INTERVAL, 1000);
    }

    public int getOpenFileLimit() {
        return this.getInt(OPEN_FILE_LIMIT, 20000);
    }

    public ServerConfiguration setOpenFileLimit(int fileLimit) {
        this.setProperty(OPEN_FILE_LIMIT, fileLimit);
        return this;
    }

    public int getPageLimit() {
        return this.getInt(PAGE_LIMIT, -1);
    }

    public ServerConfiguration setPageLimit(int pageLimit) {
        this.setProperty(PAGE_LIMIT, pageLimit);
        return this;
    }

    public int getPageSize() {
        return this.getInt(PAGE_SIZE, 8192);
    }

    public ServerConfiguration setPageSize(int pageSize) {
        this.setProperty(PAGE_SIZE, pageSize);
        return this;
    }

    public int getFileInfoCacheInitialCapacity() {
        return this.getInt(FILEINFO_CACHE_INITIAL_CAPACITY, Math.max(this.getOpenFileLimit() / 4, 64));
    }

    public ServerConfiguration setFileInfoCacheInitialCapacity(int initialCapacity) {
        this.setProperty(FILEINFO_CACHE_INITIAL_CAPACITY, initialCapacity);
        return this;
    }

    public long getFileInfoMaxIdleTime() {
        return this.getLong(FILEINFO_MAX_IDLE_TIME, 0L);
    }

    public ServerConfiguration setFileInfoMaxIdleTime(long idleTime) {
        this.setProperty(FILEINFO_MAX_IDLE_TIME, idleTime);
        return this;
    }

    public int getFileInfoFormatVersionToWrite() {
        return this.getInt(FILEINFO_FORMAT_VERSION_TO_WRITE, 1);
    }

    public ServerConfiguration setFileInfoFormatVersionToWrite(int version) {
        this.setProperty(FILEINFO_FORMAT_VERSION_TO_WRITE, version);
        return this;
    }

    public long getMaxJournalSizeMB() {
        return this.getLong(MAX_JOURNAL_SIZE, 2048L);
    }

    public ServerConfiguration setMaxJournalSizeMB(long maxJournalSize) {
        this.setProperty(MAX_JOURNAL_SIZE, Long.toString(maxJournalSize));
        return this;
    }

    public int getJournalPreAllocSizeMB() {
        return this.getInt(JOURNAL_PRE_ALLOC_SIZE, 16);
    }

    public int getJournalWriteBufferSizeKB() {
        return this.getInt(JOURNAL_WRITE_BUFFER_SIZE, 64);
    }

    public ServerConfiguration setJournalWriteBufferSizeKB(int bufferSizeKB) {
        this.setProperty(JOURNAL_WRITE_BUFFER_SIZE, bufferSizeKB);
        return this;
    }

    public int getMaxBackupJournals() {
        return this.getInt(MAX_BACKUP_JOURNALS, 5);
    }

    public ServerConfiguration setMaxBackupJournals(int maxBackupJournals) {
        this.setProperty(MAX_BACKUP_JOURNALS, Integer.toString(maxBackupJournals));
        return this;
    }

    public int getJournalAlignmentSize() {
        return this.getInt(JOURNAL_ALIGNMENT_SIZE, 512);
    }

    public ServerConfiguration setJournalAlignmentSize(int size) {
        this.setProperty(JOURNAL_ALIGNMENT_SIZE, size);
        return this;
    }

    public int getJournalFormatVersionToWrite() {
        return this.getInt(JOURNAL_FORMAT_VERSION_TO_WRITE, 6);
    }

    public ServerConfiguration setJournalFormatVersionToWrite(int version) {
        this.setProperty(JOURNAL_FORMAT_VERSION_TO_WRITE, version);
        return this;
    }

    public ServerConfiguration setJournalQueueSize(int journalQueueSize) {
        this.setProperty(JOURNAL_QUEUE_SIZE, journalQueueSize);
        return this;
    }

    public int getJournalQueueSize() {
        return this.getInt(JOURNAL_QUEUE_SIZE, 10000);
    }

    public ServerConfiguration setJournalMaxMemorySizeMb(long journalMaxMemorySizeMb) {
        this.setProperty(JOURNAL_MAX_MEMORY_SIZE_MB, journalMaxMemorySizeMb);
        return this;
    }

    public long getJournalMaxMemorySizeMb() {
        long defaultValue = (long)((double)PlatformDependent.maxDirectMemory() * 0.05 / 1024.0 / 1024.0);
        return this.getLong(JOURNAL_MAX_MEMORY_SIZE_MB, defaultValue);
    }

    public ServerConfiguration setJournalPageCacheFlushIntervalMSec(long journalPageCacheFlushIntervalMSec) {
        this.setProperty(JOURNAL_PAGECACHE_FLUSH_INTERVAL_MSEC, journalPageCacheFlushIntervalMSec);
        return this;
    }

    public long getJournalPageCacheFlushIntervalMSec() {
        return this.getLong(JOURNAL_PAGECACHE_FLUSH_INTERVAL_MSEC, 1000L);
    }

    public int getMaxAddsInProgressLimit() {
        return this.getInt(MAX_ADDS_IN_PROGRESS_LIMIT, 0);
    }

    public ServerConfiguration setMaxAddsInProgressLimit(int value) {
        this.setProperty(MAX_ADDS_IN_PROGRESS_LIMIT, value);
        return this;
    }

    public int getMaxReadsInProgressLimit() {
        return this.getInt(MAX_READS_IN_PROGRESS_LIMIT, 0);
    }

    public ServerConfiguration setMaxReadsInProgressLimit(int value) {
        this.setProperty(MAX_READS_IN_PROGRESS_LIMIT, value);
        return this;
    }

    public boolean getCloseChannelOnResponseTimeout() {
        return this.getBoolean(CLOSE_CHANNEL_ON_RESPONSE_TIMEOUT, false);
    }

    public ServerConfiguration setCloseChannelOnResponseTimeout(boolean value) {
        this.setProperty(CLOSE_CHANNEL_ON_RESPONSE_TIMEOUT, value);
        return this;
    }

    public long getWaitTimeoutOnResponseBackpressureMillis() {
        return this.getLong(WAIT_TIMEOUT_ON_RESPONSE_BACKPRESSURE, -1L);
    }

    public ServerConfiguration setWaitTimeoutOnResponseBackpressureMillis(long value) {
        this.setProperty(WAIT_TIMEOUT_ON_RESPONSE_BACKPRESSURE, value);
        return this;
    }

    public int getBookiePort() {
        return this.getInt(BOOKIE_PORT, 3181);
    }

    public ServerConfiguration setBookiePort(int port) {
        this.setProperty(BOOKIE_PORT, Integer.toString(port));
        return this;
    }

    public String getListeningInterface() {
        return this.getString(LISTENING_INTERFACE);
    }

    public ServerConfiguration setListeningInterface(String iface) {
        this.setProperty(LISTENING_INTERFACE, iface);
        return this;
    }

    public boolean getAllowLoopback() {
        return this.getBoolean(ALLOW_LOOPBACK, false);
    }

    public ServerConfiguration setAllowLoopback(boolean allow) {
        this.setProperty(ALLOW_LOOPBACK, allow);
        return this;
    }

    public String getBookieId() {
        return this.getString(BOOKIE_ID, null);
    }

    public ServerConfiguration setBookieId(String bookieId) {
        BookieId.parse(bookieId);
        this.setProperty(BOOKIE_ID, bookieId);
        return this;
    }

    public String getAdvertisedAddress() {
        return this.getString(ADVERTISED_ADDRESS, null);
    }

    public ServerConfiguration setAdvertisedAddress(String advertisedAddress) {
        this.setProperty(ADVERTISED_ADDRESS, advertisedAddress);
        return this;
    }

    public boolean getAllowEphemeralPorts() {
        return this.getBoolean(ALLOW_EPHEMERAL_PORTS, false);
    }

    public ServerConfiguration setAllowEphemeralPorts(boolean allow) {
        this.setProperty(ALLOW_EPHEMERAL_PORTS, allow);
        return this;
    }

    public boolean getAllowStorageExpansion() {
        return this.getBoolean(ALLOW_STORAGE_EXPANSION, false);
    }

    public ServerConfiguration setAllowStorageExpansion(boolean val) {
        this.setProperty(ALLOW_STORAGE_EXPANSION, val);
        return this;
    }

    public String[] getJournalDirNames() {
        String[] journalDirs = this.getStringArray(JOURNAL_DIRS);
        if (journalDirs == null || journalDirs.length == 0 || journalDirs.length == 1 && StringUtils.isEmpty(journalDirs[0])) {
            return new String[]{this.getJournalDirName()};
        }
        return journalDirs;
    }

    @Deprecated
    public String getJournalDirName() {
        return this.getString(JOURNAL_DIR, "/tmp/bk-txn");
    }

    public String getJournalDirNameWithoutDefault() {
        return this.getString(JOURNAL_DIR);
    }

    public ServerConfiguration setJournalDirName(String journalDir) {
        this.setProperty(JOURNAL_DIRS, new String[]{journalDir});
        return this;
    }

    public ServerConfiguration setJournalDirsName(String[] journalDirs) {
        this.setProperty(JOURNAL_DIRS, journalDirs);
        return this;
    }

    public File[] getJournalDirs() {
        String[] journalDirNames = this.getJournalDirNames();
        File[] journalDirs = new File[journalDirNames.length];
        for (int i = 0; i < journalDirNames.length; ++i) {
            journalDirs[i] = new File(journalDirNames[i]);
        }
        return journalDirs;
    }

    public String[] getLedgerDirWithoutDefault() {
        return this.getStringArray(LEDGER_DIRS);
    }

    public String[] getLedgerDirNames() {
        String[] ledgerDirs = this.getStringArray(LEDGER_DIRS);
        if (null == ledgerDirs || 0 == ledgerDirs.length) {
            return new String[]{"/tmp/bk-data"};
        }
        return ledgerDirs;
    }

    public ServerConfiguration setLedgerDirNames(String[] ledgerDirs) {
        if (null == ledgerDirs) {
            return this;
        }
        this.setProperty(LEDGER_DIRS, ledgerDirs);
        return this;
    }

    public File[] getLedgerDirs() {
        String[] ledgerDirNames = this.getLedgerDirNames();
        File[] ledgerDirs = new File[ledgerDirNames.length];
        for (int i = 0; i < ledgerDirNames.length; ++i) {
            ledgerDirs[i] = new File(ledgerDirNames[i]);
        }
        return ledgerDirs;
    }

    public String[] getIndexDirNames() {
        if (!this.containsKey(INDEX_DIRS)) {
            return null;
        }
        return this.getStringArray(INDEX_DIRS);
    }

    public ServerConfiguration setIndexDirName(String[] indexDirs) {
        this.setProperty(INDEX_DIRS, indexDirs);
        return this;
    }

    public File[] getIndexDirs() {
        String[] idxDirNames = this.getIndexDirNames();
        if (null == idxDirNames) {
            return null;
        }
        File[] idxDirs = new File[idxDirNames.length];
        for (int i = 0; i < idxDirNames.length; ++i) {
            idxDirs[i] = new File(idxDirNames[i]);
        }
        return idxDirs;
    }

    public boolean getServerTcpNoDelay() {
        return this.getBoolean(SERVER_TCP_NODELAY, true);
    }

    public ServerConfiguration setServerTcpNoDelay(boolean noDelay) {
        this.setProperty(SERVER_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public int getServerNumIOThreads() {
        return this.getInt(SERVER_NUM_IO_THREADS, 2 * Runtime.getRuntime().availableProcessors());
    }

    public ServerConfiguration setServerNumIOThreads(int numThreads) {
        this.setProperty(SERVER_NUM_IO_THREADS, Integer.toString(numThreads));
        return this;
    }

    public int getServerSockLinger() {
        return this.getInt(SERVER_SOCK_LINGER, 0);
    }

    public ServerConfiguration setServerSockLinger(int linger) {
        this.setProperty(SERVER_SOCK_LINGER, Integer.toString(linger));
        return this;
    }

    public boolean getServerSockKeepalive() {
        return this.getBoolean(SERVER_SOCK_KEEPALIVE, true);
    }

    public ServerConfiguration setServerSockKeepalive(boolean keepalive) {
        this.setProperty(SERVER_SOCK_KEEPALIVE, Boolean.toString(keepalive));
        return this;
    }

    public int getZkRetryBackoffStartMs() {
        return this.getInt(ZK_RETRY_BACKOFF_START_MS, this.getZkTimeout());
    }

    public ServerConfiguration setZkRetryBackoffStartMs(int retryMs) {
        this.setProperty(ZK_RETRY_BACKOFF_START_MS, retryMs);
        return this;
    }

    public int getZkRetryBackoffMaxMs() {
        return this.getInt(ZK_RETRY_BACKOFF_MAX_MS, this.getZkTimeout());
    }

    public ServerConfiguration setZkRetryBackoffMaxMs(int retryMs) {
        this.setProperty(ZK_RETRY_BACKOFF_MAX_MS, retryMs);
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.getBoolean(ENABLE_STATISTICS, true);
    }

    public ServerConfiguration setStatisticsEnabled(boolean enabled) {
        this.setProperty(ENABLE_STATISTICS, Boolean.toString(enabled));
        return this;
    }

    public ServerConfiguration setForceAllowCompaction(boolean enable) {
        this.setProperty(FORCE_ALLOW_COMPACTION, enable);
        return this;
    }

    public boolean isForceAllowCompaction() {
        return this.getBoolean(FORCE_ALLOW_COMPACTION, false);
    }

    public double getMinorCompactionThreshold() {
        return this.getDouble(MINOR_COMPACTION_THRESHOLD, 0.2f);
    }

    public ServerConfiguration setMinorCompactionThreshold(double threshold) {
        this.setProperty(MINOR_COMPACTION_THRESHOLD, threshold);
        return this;
    }

    public double getMajorCompactionThreshold() {
        return this.getDouble(MAJOR_COMPACTION_THRESHOLD, 0.8f);
    }

    public ServerConfiguration setMajorCompactionThreshold(double threshold) {
        this.setProperty(MAJOR_COMPACTION_THRESHOLD, threshold);
        return this;
    }

    public long getMajorCompactionMaxTimeMillis() {
        return this.getLong(MAJOR_COMPACTION_MAX_TIME_MILLIS, -1L);
    }

    public ServerConfiguration setMajorCompactionMaxTimeMillis(long majorCompactionMaxTimeMillis) {
        this.setProperty(MAJOR_COMPACTION_MAX_TIME_MILLIS, majorCompactionMaxTimeMillis);
        return this;
    }

    public long getMinorCompactionInterval() {
        return this.getLong(MINOR_COMPACTION_INTERVAL, 3600L);
    }

    public ServerConfiguration setMinorCompactionInterval(long interval) {
        this.setProperty(MINOR_COMPACTION_INTERVAL, interval);
        return this;
    }

    public long getMajorCompactionInterval() {
        return this.getLong(MAJOR_COMPACTION_INTERVAL, 86400L);
    }

    public ServerConfiguration setMajorCompactionInterval(long interval) {
        this.setProperty(MAJOR_COMPACTION_INTERVAL, interval);
        return this;
    }

    public long getMinorCompactionMaxTimeMillis() {
        return this.getLong(MINOR_COMPACTION_MAX_TIME_MILLIS, -1L);
    }

    public ServerConfiguration setMinorCompactionMaxTimeMillis(long minorCompactionMaxTimeMillis) {
        this.setProperty(MINOR_COMPACTION_MAX_TIME_MILLIS, minorCompactionMaxTimeMillis);
        return this;
    }

    public boolean getIsForceGCAllowWhenNoSpace() {
        return this.getBoolean(IS_FORCE_GC_ALLOW_WHEN_NO_SPACE, false);
    }

    public ServerConfiguration setIsForceGCAllowWhenNoSpace(boolean force) {
        this.setProperty(IS_FORCE_GC_ALLOW_WHEN_NO_SPACE, force);
        return this;
    }

    public void setOpenLedgerRereplicationGracePeriod(String waitTime) {
        this.setProperty(OPEN_LEDGER_REREPLICATION_GRACE_PERIOD, waitTime);
    }

    public long getOpenLedgerRereplicationGracePeriod() {
        return this.getLong(OPEN_LEDGER_REREPLICATION_GRACE_PERIOD, 30000L);
    }

    public void setLockReleaseOfFailedLedgerGracePeriod(String waitTime) {
        this.setProperty(LOCK_RELEASE_OF_FAILED_LEDGER_GRACE_PERIOD, waitTime);
    }

    public long getLockReleaseOfFailedLedgerGracePeriod() {
        return this.getLong(LOCK_RELEASE_OF_FAILED_LEDGER_GRACE_PERIOD, 300000L);
    }

    public int getReadBufferBytes() {
        return this.getInt(READ_BUFFER_SIZE, 512);
    }

    public ServerConfiguration setReadBufferBytes(int readBufferSize) {
        this.setProperty(READ_BUFFER_SIZE, readBufferSize);
        return this;
    }

    public ServerConfiguration setNumAddWorkerThreads(int numThreads) {
        this.setProperty(NUM_ADD_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumAddWorkerThreads() {
        return this.getInt(NUM_ADD_WORKER_THREADS, 1);
    }

    public ServerConfiguration setNumLongPollWorkerThreads(int numThreads) {
        this.setProperty(NUM_LONG_POLL_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumLongPollWorkerThreads() {
        return this.getInt(NUM_LONG_POLL_WORKER_THREADS, 0);
    }

    public ServerConfiguration setNumHighPriorityWorkerThreads(int numThreads) {
        this.setProperty(NUM_HIGH_PRIORITY_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumHighPriorityWorkerThreads() {
        return this.getInt(NUM_HIGH_PRIORITY_WORKER_THREADS, 8);
    }

    public ServerConfiguration setReadWorkerThreadsThrottlingEnabled(boolean throttle) {
        this.setProperty(READ_WORKER_THREADS_THROTTLING_ENABLED, throttle);
        return this;
    }

    public boolean isReadWorkerThreadsThrottlingEnabled() {
        return this.getBoolean(READ_WORKER_THREADS_THROTTLING_ENABLED, true);
    }

    public ServerConfiguration setNumReadWorkerThreads(int numThreads) {
        this.setProperty(NUM_READ_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumReadWorkerThreads() {
        return this.getInt(NUM_READ_WORKER_THREADS, 8);
    }

    public ServerConfiguration setRequestTimerTickDurationMs(int tickDuration) {
        this.setProperty(REQUEST_TIMER_TICK_DURATION_MILLISEC, tickDuration);
        return this;
    }

    public ServerConfiguration setMaxPendingReadRequestPerThread(int maxPendingReadRequestsPerThread) {
        this.setProperty(MAX_PENDING_READ_REQUESTS_PER_THREAD, maxPendingReadRequestsPerThread);
        return this;
    }

    public int getMaxPendingReadRequestPerThread() {
        return this.getInt(MAX_PENDING_READ_REQUESTS_PER_THREAD, 10000);
    }

    public ServerConfiguration setMaxPendingAddRequestPerThread(int maxPendingAddRequestsPerThread) {
        this.setProperty(MAX_PENDING_ADD_REQUESTS_PER_THREAD, maxPendingAddRequestsPerThread);
        return this;
    }

    public int getMaxPendingAddRequestPerThread() {
        return this.getInt(MAX_PENDING_ADD_REQUESTS_PER_THREAD, 10000);
    }

    public int getRequestTimerTickDurationMs() {
        return this.getInt(REQUEST_TIMER_TICK_DURATION_MILLISEC, 10);
    }

    public ServerConfiguration setRequestTimerNumTicks(int tickCount) {
        this.setProperty(REQUEST_TIMER_NO_OF_TICKS, tickCount);
        return this;
    }

    public int getRequestTimerNumTicks() {
        return this.getInt(REQUEST_TIMER_NO_OF_TICKS, 1024);
    }

    public int getWriteBufferBytes() {
        return this.getInt(WRITE_BUFFER_SIZE, 65536);
    }

    public ServerConfiguration setWriteBufferBytes(int writeBufferBytes) {
        this.setProperty(WRITE_BUFFER_SIZE, writeBufferBytes);
        return this;
    }

    public ServerConfiguration setNumJournalCallbackThreads(int numThreads) {
        this.setProperty(NUM_JOURNAL_CALLBACK_THREADS, numThreads);
        return this;
    }

    public int getNumJournalCallbackThreads() {
        return this.getInt(NUM_JOURNAL_CALLBACK_THREADS, 1);
    }

    public ServerConfiguration setSortedLedgerStorageEnabled(boolean enabled) {
        this.setProperty(SORTED_LEDGER_STORAGE_ENABLED, enabled);
        return this;
    }

    public boolean getSortedLedgerStorageEnabled() {
        return this.getBoolean(SORTED_LEDGER_STORAGE_ENABLED, true);
    }

    public long getSkipListSizeLimit() {
        return this.getLong(SKIP_LIST_SIZE_LIMIT, 0x4000000L);
    }

    public ServerConfiguration setSkipListSizeLimit(int size) {
        if (size > 0x3FFFFFFF) {
            throw new IllegalArgumentException("skiplist size over 1073741823");
        }
        this.setProperty(SKIP_LIST_SIZE_LIMIT, size);
        return this;
    }

    public int getSkipListArenaChunkSize() {
        return this.getInt(SKIP_LIST_CHUNK_SIZE_ENTRY, 0x400000);
    }

    public ServerConfiguration setSkipListArenaChunkSize(int size) {
        this.setProperty(SKIP_LIST_CHUNK_SIZE_ENTRY, size);
        return this;
    }

    public int getSkipListArenaMaxAllocSize() {
        return this.getInt(SKIP_LIST_MAX_ALLOC_ENTRY, 131072);
    }

    public ServerConfiguration setSkipListArenaMaxAllocSize(int size) {
        this.setProperty(SKIP_LIST_MAX_ALLOC_ENTRY, size);
        return this;
    }

    public boolean getJournalSyncData() {
        return this.getBoolean(JOURNAL_SYNC_DATA, true);
    }

    public boolean getJournalWriteData() {
        return this.getBoolean(JOURNAL_WRITE_DATA, true);
    }

    public ServerConfiguration setJournalWriteData(boolean journalWriteData) {
        this.setProperty(JOURNAL_WRITE_DATA, journalWriteData);
        return this;
    }

    public ServerConfiguration setJournalSyncData(boolean syncData) {
        this.setProperty(JOURNAL_SYNC_DATA, syncData);
        return this;
    }

    public boolean getJournalAdaptiveGroupWrites() {
        return this.getBoolean(JOURNAL_ADAPTIVE_GROUP_WRITES, true);
    }

    public ServerConfiguration setJournalAdaptiveGroupWrites(boolean enabled) {
        this.setProperty(JOURNAL_ADAPTIVE_GROUP_WRITES, enabled);
        return this;
    }

    public long getJournalMaxGroupWaitMSec() {
        return this.getLong(JOURNAL_MAX_GROUP_WAIT_MSEC, 2L);
    }

    public ServerConfiguration setJournalMaxGroupWaitMSec(long journalMaxGroupWaitMSec) {
        this.setProperty(JOURNAL_MAX_GROUP_WAIT_MSEC, journalMaxGroupWaitMSec);
        return this;
    }

    public long getJournalBufferedWritesThreshold() {
        return this.getLong(JOURNAL_BUFFERED_WRITES_THRESHOLD, 524288L);
    }

    public ServerConfiguration setJournalBufferedWritesThreshold(long maxBytes) {
        this.setProperty(JOURNAL_BUFFERED_WRITES_THRESHOLD, maxBytes);
        return this;
    }

    public long getJournalBufferedEntriesThreshold() {
        return this.getLong(JOURNAL_BUFFERED_ENTRIES_THRESHOLD, 0L);
    }

    public ServerConfiguration setJournalBufferedEntriesThreshold(int maxEntries) {
        this.setProperty(JOURNAL_BUFFERED_ENTRIES_THRESHOLD, maxEntries);
        return this;
    }

    public ServerConfiguration setJournalFlushWhenQueueEmpty(boolean enabled) {
        this.setProperty(JOURNAL_FLUSH_WHEN_QUEUE_EMPTY, enabled);
        return this;
    }

    public boolean getJournalFlushWhenQueueEmpty() {
        return this.getBoolean(JOURNAL_FLUSH_WHEN_QUEUE_EMPTY, false);
    }

    public ServerConfiguration setReadOnlyModeEnabled(boolean enabled) {
        this.setProperty(READ_ONLY_MODE_ENABLED, enabled);
        return this;
    }

    public boolean isReadOnlyModeEnabled() {
        return this.getBoolean(READ_ONLY_MODE_ENABLED, true);
    }

    public ServerConfiguration setDiskUsageWarnThreshold(float threshold) {
        this.setProperty(DISK_USAGE_WARN_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskUsageWarnThreshold() {
        return this.getFloat(DISK_USAGE_WARN_THRESHOLD, 0.9f);
    }

    public ServerConfiguration setPersistBookieStatusEnabled(boolean enabled) {
        this.setProperty(PERSIST_BOOKIE_STATUS_ENABLED, enabled);
        return this;
    }

    public boolean isPersistBookieStatusEnabled() {
        return this.getBoolean(PERSIST_BOOKIE_STATUS_ENABLED, false);
    }

    public ServerConfiguration setDiskUsageThreshold(float threshold) {
        this.setProperty(DISK_USAGE_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskUsageThreshold() {
        return this.getFloat(DISK_USAGE_THRESHOLD, 0.95f);
    }

    public ServerConfiguration setDiskLowWaterMarkUsageThreshold(float threshold) {
        this.setProperty(DISK_USAGE_LWM_THRESHOLD, Float.valueOf(threshold));
        return this;
    }

    public float getDiskLowWaterMarkUsageThreshold() {
        return this.getFloat(DISK_USAGE_LWM_THRESHOLD, this.getDiskUsageThreshold());
    }

    public ServerConfiguration setDiskCheckInterval(int interval) {
        this.setProperty(DISK_CHECK_INTERVAL, interval);
        return this;
    }

    public int getDiskCheckInterval() {
        return this.getInt(DISK_CHECK_INTERVAL, 10000);
    }

    public void setAuditorPeriodicCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_CHECK_INTERVAL, 604800L);
    }

    public void setAuditorPeriodicBookieCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicBookieCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_BOOKIE_CHECK_INTERVAL, 86400L);
    }

    public void setAuditorPeriodicPlacementPolicyCheckInterval(long interval) {
        this.setProperty(AUDITOR_PERIODIC_PLACEMENT_POLICY_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicPlacementPolicyCheckInterval() {
        return this.getLong(AUDITOR_PERIODIC_PLACEMENT_POLICY_CHECK_INTERVAL, 0L);
    }

    public void setUnderreplicatedLedgerRecoveryGracePeriod(long gracePeriod) {
        this.setProperty(UNDERREPLICATED_LEDGER_RECOVERY_GRACE_PERIOD, gracePeriod);
    }

    public long getUnderreplicatedLedgerRecoveryGracePeriod() {
        return this.getLong(UNDERREPLICATED_LEDGER_RECOVERY_GRACE_PERIOD, 0L);
    }

    public void setAuditorPeriodicReplicasCheckInterval(long interval) {
        this.setProperty(AUDITOR_REPLICAS_CHECK_INTERVAL, interval);
    }

    public long getAuditorPeriodicReplicasCheckInterval() {
        return this.getLong(AUDITOR_REPLICAS_CHECK_INTERVAL, 0L);
    }

    public int getAuditorMaxNumberOfConcurrentOpenLedgerOperations() {
        return this.getInt(AUDITOR_MAX_NUMBER_OF_CONCURRENT_OPEN_LEDGER_OPERATIONS, 500);
    }

    public void setAuditorMaxNumberOfConcurrentOpenLedgerOperations(int semaphore) {
        this.setProperty(AUDITOR_MAX_NUMBER_OF_CONCURRENT_OPEN_LEDGER_OPERATIONS, semaphore);
    }

    public int getAuditorAcquireConcurrentOpenLedgerOperationsTimeoutMSec() {
        return this.getInt(AUDITOR_ACQUIRE_CONCURRENT_OPEN_LEDGER_OPERATIONS_TIMEOUT_MSEC, 120000);
    }

    public void setAuditorAcquireConcurrentOpenLedgerOperationsTimeoutMSec(int timeoutMs) {
        this.setProperty(AUDITOR_ACQUIRE_CONCURRENT_OPEN_LEDGER_OPERATIONS_TIMEOUT_MSEC, timeoutMs);
    }

    public ServerConfiguration setAuditorLedgerVerificationPercentage(long auditorLedgerVerificationPercentage) {
        this.setProperty(AUDITOR_LEDGER_VERIFICATION_PERCENTAGE, auditorLedgerVerificationPercentage);
        return this;
    }

    public long getAuditorLedgerVerificationPercentage() {
        return this.getLong(AUDITOR_LEDGER_VERIFICATION_PERCENTAGE, 0L);
    }

    public ServerConfiguration setAutoRecoveryDaemonEnabled(boolean enabled) {
        this.setProperty(AUTO_RECOVERY_DAEMON_ENABLED, enabled);
        return this;
    }

    public boolean isAutoRecoveryDaemonEnabled() {
        return this.getBoolean(AUTO_RECOVERY_DAEMON_ENABLED, false);
    }

    public int getLostBookieRecoveryDelay() {
        return this.getInt(LOST_BOOKIE_RECOVERY_DELAY, 0);
    }

    public void setLostBookieRecoveryDelay(int interval) {
        this.setProperty(LOST_BOOKIE_RECOVERY_DELAY, interval);
    }

    public int getRwRereplicateBackoffMs() {
        return this.getInt(RW_REREPLICATE_BACKOFF_MS, 5000);
    }

    public void setRwRereplicateBackoffMs(int backoffMs) {
        this.setProperty(RW_REREPLICATE_BACKOFF_MS, backoffMs);
    }

    public ServerConfiguration setForceReadOnlyBookie(boolean enabled) {
        this.setProperty(FORCE_READ_ONLY_BOOKIE, enabled);
        return this;
    }

    public boolean isForceReadOnlyBookie() {
        return this.getBoolean(FORCE_READ_ONLY_BOOKIE, false);
    }

    public boolean getIsThrottleByBytes() {
        return this.getBoolean(IS_THROTTLE_BY_BYTES, false);
    }

    public ServerConfiguration setIsThrottleByBytes(boolean byBytes) {
        this.setProperty(IS_THROTTLE_BY_BYTES, byBytes);
        return this;
    }

    public int getCompactionMaxOutstandingRequests() {
        return this.getInt(COMPACTION_MAX_OUTSTANDING_REQUESTS, 100000);
    }

    public ServerConfiguration setCompactionMaxOutstandingRequests(int maxOutstandingRequests) {
        this.setProperty(COMPACTION_MAX_OUTSTANDING_REQUESTS, maxOutstandingRequests);
        return this;
    }

    @Deprecated
    public int getCompactionRate() {
        return this.getInt(COMPACTION_RATE, 1000);
    }

    public ServerConfiguration setCompactionRate(int rate) {
        this.setProperty(COMPACTION_RATE, rate);
        return this;
    }

    public int getCompactionRateByEntries() {
        return this.getInt(COMPACTION_RATE_BY_ENTRIES, this.getCompactionRate());
    }

    public ServerConfiguration setCompactionRateByEntries(int rate) {
        this.setProperty(COMPACTION_RATE_BY_ENTRIES, rate);
        return this;
    }

    public int getCompactionRateByBytes() {
        return this.getInt(COMPACTION_RATE_BY_BYTES, 1000000);
    }

    public ServerConfiguration setCompactionRateByBytes(int rate) {
        this.setProperty(COMPACTION_RATE_BY_BYTES, rate);
        return this;
    }

    @Beta
    public boolean getJournalRemovePagesFromCache() {
        return this.getBoolean(JOURNAL_REMOVE_FROM_PAGE_CACHE, true);
    }

    public ServerConfiguration setJournalRemovePagesFromCache(boolean enabled) {
        this.setProperty(JOURNAL_REMOVE_FROM_PAGE_CACHE, enabled);
        return this;
    }

    public String getLedgerStorageClass() {
        String ledgerStorageClass = LEDGER_STORAGE_CLASS_KEY.getString(this);
        if (ledgerStorageClass.equals(SortedLedgerStorage.class.getName()) && !this.getSortedLedgerStorageEnabled()) {
            ledgerStorageClass = InterleavedLedgerStorage.class.getName();
        }
        return ledgerStorageClass;
    }

    public ServerConfiguration setLedgerStorageClass(String ledgerStorageClass) {
        LEDGER_STORAGE_CLASS_KEY.set(this, ledgerStorageClass);
        return this;
    }

    public boolean getUseHostNameAsBookieID() {
        return this.getBoolean(USE_HOST_NAME_AS_BOOKIE_ID, false);
    }

    public ServerConfiguration setUseHostNameAsBookieID(boolean useHostName) {
        this.setProperty(USE_HOST_NAME_AS_BOOKIE_ID, useHostName);
        return this;
    }

    public boolean getUseShortHostName() {
        return this.getBoolean(USE_SHORT_HOST_NAME, false);
    }

    public ServerConfiguration setUseShortHostName(boolean useShortHostName) {
        this.setProperty(USE_SHORT_HOST_NAME, useShortHostName);
        return this;
    }

    public boolean isEnableLocalTransport() {
        return this.getBoolean(ENABLE_LOCAL_TRANSPORT, false);
    }

    public ServerConfiguration setEnableLocalTransport(boolean enableLocalTransport) {
        this.setProperty(ENABLE_LOCAL_TRANSPORT, enableLocalTransport);
        return this;
    }

    public boolean isDisableServerSocketBind() {
        return this.getBoolean(DISABLE_SERVER_SOCKET_BIND, false);
    }

    public ServerConfiguration setDisableServerSocketBind(boolean disableServerSocketBind) {
        this.setProperty(DISABLE_SERVER_SOCKET_BIND, disableServerSocketBind);
        return this;
    }

    public Class<? extends StatsProvider> getStatsProviderClass() throws ConfigurationException {
        return ReflectionUtils.getClass(this, STATS_PROVIDER_CLASS, NullStatsProvider.class, StatsProvider.class, DEFAULT_LOADER);
    }

    public ServerConfiguration setStatsProviderClass(Class<? extends StatsProvider> providerClass) {
        this.setProperty(STATS_PROVIDER_CLASS, providerClass.getName());
        return this;
    }

    public void validate() throws ConfigurationException {
        ConfigDef configDef = ConfigDef.of(ServerConfiguration.class);
        try {
            configDef.validate(this);
        }
        catch (ConfigException e) {
            throw new ConfigurationException(e.getMessage(), e.getCause());
        }
        if (this.getSkipListArenaChunkSize() < this.getSkipListArenaMaxAllocSize()) {
            throw new ConfigurationException("Arena max allocation size should be smaller than the chunk size.");
        }
        if (this.getJournalAlignmentSize() < 512 || this.getJournalAlignmentSize() % 512 != 0) {
            throw new ConfigurationException("Invalid journal alignment size : " + this.getJournalAlignmentSize());
        }
        if (this.getJournalAlignmentSize() > this.getJournalPreAllocSizeMB() * 1024 * 1024) {
            throw new ConfigurationException("Invalid preallocation size : " + this.getJournalPreAllocSizeMB() + " MB");
        }
        if (0 == this.getBookiePort() && !this.getAllowEphemeralPorts()) {
            throw new ConfigurationException("Invalid port specified, using ephemeral ports accidentally?");
        }
        if (this.isEntryLogPerLedgerEnabled() && this.getUseTransactionalCompaction()) {
            throw new ConfigurationException("When entryLogPerLedger is enabled , it is unnecessary to use transactional compaction");
        }
        if (this.getJournalFormatVersionToWrite() >= 6 ^ this.getFileInfoFormatVersionToWrite() >= 1) {
            throw new ConfigurationException("For persisiting explicitLac, journalFormatVersionToWrite should be >= 6and FileInfoFormatVersionToWrite should be >= 1");
        }
        if (this.getMinorCompactionInterval() * 1000L < this.getGcWaitTime()) {
            throw new ConfigurationException("minorCompactionInterval should be >= gcWaitTime.");
        }
        if (this.getMajorCompactionInterval() * 1000L < this.getGcWaitTime()) {
            throw new ConfigurationException("majorCompactionInterval should be >= gcWaitTime.");
        }
    }

    public int getRecvByteBufAllocatorSizeInitial() {
        return this.getInt(BYTEBUF_ALLOCATOR_SIZE_INITIAL, 65536);
    }

    public void setRecvByteBufAllocatorSizeInitial(int size) {
        this.setProperty(BYTEBUF_ALLOCATOR_SIZE_INITIAL, size);
    }

    public int getRecvByteBufAllocatorSizeMin() {
        return this.getInt(BYTEBUF_ALLOCATOR_SIZE_MIN, 65536);
    }

    public void setRecvByteBufAllocatorSizeMin(int size) {
        this.setProperty(BYTEBUF_ALLOCATOR_SIZE_MIN, size);
    }

    public int getRecvByteBufAllocatorSizeMax() {
        return this.getInt(BYTEBUF_ALLOCATOR_SIZE_MAX, 0x100000);
    }

    public void setRecvByteBufAllocatorSizeMax(int size) {
        this.setProperty(BYTEBUF_ALLOCATOR_SIZE_MAX, size);
    }

    public void setBookieAuthProviderFactoryClass(String factoryClass) {
        this.setProperty(BOOKIE_AUTH_PROVIDER_FACTORY_CLASS, factoryClass);
    }

    public String getBookieAuthProviderFactoryClass() {
        return this.getString(BOOKIE_AUTH_PROVIDER_FACTORY_CLASS, null);
    }

    @Override
    public ServerConfiguration setNettyMaxFrameSizeBytes(int maxSize) {
        super.setNettyMaxFrameSizeBytes(maxSize);
        return this;
    }

    public String getTLSTrustStoreType() {
        return this.getString("tlsTrustStoreType", "JKS");
    }

    public ServerConfiguration setTLSKeyStoreType(String arg) {
        this.setProperty("tlsKeyStoreType", arg);
        return this;
    }

    public String getTLSKeyStore() {
        return this.getString("tlsKeyStore", null);
    }

    public ServerConfiguration setTLSKeyStore(String arg) {
        this.setProperty("tlsKeyStore", arg);
        return this;
    }

    public String getTLSKeyStorePasswordPath() {
        return this.getString("tlsKeyStorePasswordPath", null);
    }

    public ServerConfiguration setTLSKeyStorePasswordPath(String arg) {
        this.setProperty("tlsKeyStorePasswordPath", arg);
        return this;
    }

    public String getTLSKeyStoreType() {
        return this.getString("tlsKeyStoreType", "JKS");
    }

    public ServerConfiguration setTLSTrustStoreType(String arg) {
        this.setProperty("tlsTrustStoreType", arg);
        return this;
    }

    public String getTLSTrustStore() {
        return this.getString("tlsTrustStore", null);
    }

    public ServerConfiguration setTLSTrustStore(String arg) {
        this.setProperty("tlsTrustStore", arg);
        return this;
    }

    public String getTLSTrustStorePasswordPath() {
        return this.getString("tlsTrustStorePasswordPath", null);
    }

    public ServerConfiguration setTLSTrustStorePasswordPath(String arg) {
        this.setProperty("tlsTrustStorePasswordPath", arg);
        return this;
    }

    public String getTLSCertificatePath() {
        return this.getString("tlsCertificatePath", null);
    }

    public ServerConfiguration setTLSCertificatePath(String arg) {
        this.setProperty("tlsCertificatePath", arg);
        return this;
    }

    public boolean getEnableTaskExecutionStats() {
        return this.getBoolean(ENABLE_TASK_EXECUTION_STATS, false);
    }

    public ServerConfiguration setEnableTaskExecutionStats(boolean enabled) {
        this.setProperty(ENABLE_TASK_EXECUTION_STATS, enabled);
        return this;
    }

    public long getMinUsableSizeForIndexFileCreation() {
        return this.getLong(MIN_USABLESIZE_FOR_INDEXFILE_CREATION, 0x6400000L);
    }

    public ServerConfiguration setMinUsableSizeForIndexFileCreation(long minUsableSizeForIndexFileCreation) {
        this.setProperty(MIN_USABLESIZE_FOR_INDEXFILE_CREATION, minUsableSizeForIndexFileCreation);
        return this;
    }

    public long getMinUsableSizeForEntryLogCreation() {
        return this.getLong(MIN_USABLESIZE_FOR_ENTRYLOG_CREATION, 1L * this.getEntryLogSizeLimit());
    }

    public ServerConfiguration setMinUsableSizeForEntryLogCreation(long minUsableSizeForEntryLogCreation) {
        this.setProperty(MIN_USABLESIZE_FOR_ENTRYLOG_CREATION, minUsableSizeForEntryLogCreation);
        return this;
    }

    public long getMinUsableSizeForHighPriorityWrites() {
        return this.getLong(MIN_USABLESIZE_FOR_HIGH_PRIORITY_WRITES, this.getMinUsableSizeForEntryLogCreation());
    }

    public ServerConfiguration setMinUsableSizeForHighPriorityWrites(long minUsableSizeForHighPriorityWrites) {
        this.setProperty(MIN_USABLESIZE_FOR_HIGH_PRIORITY_WRITES, minUsableSizeForHighPriorityWrites);
        return this;
    }

    public boolean isAllowMultipleDirsUnderSameDiskPartition() {
        return this.getBoolean(ALLOW_MULTIPLEDIRS_UNDER_SAME_DISKPARTITION, true);
    }

    public ServerConfiguration setAllowMultipleDirsUnderSameDiskPartition(boolean allow) {
        this.setProperty(ALLOW_MULTIPLEDIRS_UNDER_SAME_DISKPARTITION, allow);
        return this;
    }

    public boolean isHttpServerEnabled() {
        return this.getBoolean(HTTP_SERVER_ENABLED, false);
    }

    public ServerConfiguration setHttpServerEnabled(boolean enabled) {
        this.setProperty(HTTP_SERVER_ENABLED, enabled);
        return this;
    }

    public int getHttpServerPort() {
        return this.getInt(HTTP_SERVER_PORT, 8080);
    }

    public ServerConfiguration setHttpServerPort(int port) {
        this.setProperty(HTTP_SERVER_PORT, port);
        return this;
    }

    public String[] getExtraServerComponents() {
        String extraServerComponentsStr = this.getString(EXTRA_SERVER_COMPONENTS);
        if (Strings.isNullOrEmpty(extraServerComponentsStr)) {
            return null;
        }
        return this.getStringArray(EXTRA_SERVER_COMPONENTS);
    }

    public ServerConfiguration setExtraServerComponents(String[] componentClasses) {
        this.setProperty(EXTRA_SERVER_COMPONENTS, componentClasses);
        return this;
    }

    public boolean getIgnoreExtraServerComponentsStartupFailures() {
        return this.getBoolean(IGNORE_EXTRA_SERVER_COMPONENTS_STARTUP_FAILURES, false);
    }

    public ServerConfiguration setIgnoreExtraServerComponentsStartupFailures(boolean enabled) {
        this.setProperty(IGNORE_EXTRA_SERVER_COMPONENTS_STARTUP_FAILURES, enabled);
        return this;
    }

    public int getServerWriteBufferLowWaterMark() {
        return this.getInt(SERVER_WRITEBUFFER_LOW_WATER_MARK, 393216);
    }

    public ServerConfiguration setServerWriteBufferLowWaterMark(int waterMark) {
        this.setProperty(SERVER_WRITEBUFFER_LOW_WATER_MARK, waterMark);
        return this;
    }

    public int getServerWriteBufferHighWaterMark() {
        return this.getInt(SERVER_WRITEBUFFER_HIGH_WATER_MARK, 524288);
    }

    public ServerConfiguration setServerWriteBufferHighWaterMark(int waterMark) {
        this.setProperty(SERVER_WRITEBUFFER_HIGH_WATER_MARK, waterMark);
        return this;
    }

    @Deprecated
    public void setRegistrationManagerClass(Class<? extends RegistrationManager> regManagerClass) {
        this.setProperty(REGISTRATION_MANAGER_CLASS, regManagerClass);
    }

    @Deprecated
    public Class<? extends RegistrationManager> getRegistrationManagerClass() throws ConfigurationException {
        return ReflectionUtils.getClass(this, REGISTRATION_MANAGER_CLASS, ZKRegistrationManager.class, RegistrationManager.class, DEFAULT_LOADER);
    }

    @Override
    protected ServerConfiguration getThis() {
        return this;
    }

    public boolean isEntryLogPerLedgerEnabled() {
        return this.getBoolean(ENTRY_LOG_PER_LEDGER_ENABLED, false);
    }

    public ServerConfiguration setEntryLogPerLedgerEnabled(boolean entryLogPerLedgerEnabled) {
        this.setProperty(ENTRY_LOG_PER_LEDGER_ENABLED, Boolean.toString(entryLogPerLedgerEnabled));
        return this;
    }

    public int getNumOfMemtableFlushThreads() {
        return this.getInt(NUMBER_OF_MEMTABLE_FLUSH_THREADS, 8);
    }

    public ServerConfiguration setNumOfMemtableFlushThreads(int numOfMemtableFlushThreads) {
        this.setProperty(NUMBER_OF_MEMTABLE_FLUSH_THREADS, Integer.toString(numOfMemtableFlushThreads));
        return this;
    }

    public int getEntrylogMapAccessExpiryTimeInSeconds() {
        return this.getInt(ENTRYLOGMAP_ACCESS_EXPIRYTIME_INSECONDS, 300);
    }

    public ServerConfiguration setEntrylogMapAccessExpiryTimeInSeconds(int entrylogMapAccessExpiryTimeInSeconds) {
        this.setProperty(ENTRYLOGMAP_ACCESS_EXPIRYTIME_INSECONDS, Integer.toString(entrylogMapAccessExpiryTimeInSeconds));
        return this;
    }

    public int getMaximumNumberOfActiveEntryLogs() {
        return this.getInt(MAXIMUM_NUMBER_OF_ACTIVE_ENTRYLOGS, 500);
    }

    public ServerConfiguration setMaximumNumberOfActiveEntryLogs(int maximumNumberOfActiveEntryLogs) {
        this.setProperty(MAXIMUM_NUMBER_OF_ACTIVE_ENTRYLOGS, Integer.toString(maximumNumberOfActiveEntryLogs));
        return this;
    }

    public int getEntryLogPerLedgerCounterLimitsMultFactor() {
        return this.getInt(ENTRY_LOG_PER_LEDGER_COUNTER_LIMITS_MULT_FACTOR, 10);
    }

    public ServerConfiguration setEntryLogPerLedgerCounterLimitsMultFactor(int entryLogPerLedgerCounterLimitsMultFactor) {
        this.setProperty(ENTRY_LOG_PER_LEDGER_COUNTER_LIMITS_MULT_FACTOR, Integer.toString(entryLogPerLedgerCounterLimitsMultFactor));
        return this;
    }

    public boolean isLocalConsistencyCheckOnStartup() {
        return this.getBoolean(LOCAL_CONSISTENCY_CHECK_ON_STARTUP, false);
    }

    public String[] getAuthorizedRoles() {
        return this.getStringArray(AUTHORIZED_ROLES);
    }

    public ServerConfiguration setAuthorizedRoles(String roles) {
        this.setProperty(AUTHORIZED_ROLES, roles);
        return this;
    }

    public int getInFlightReadEntryNumInLedgerChecker() {
        return this.getInt(IN_FLIGHT_READ_ENTRY_NUM_IN_LEDGER_CHECKER, -1);
    }

    public int getRocksDBDeleteEntriesBatchSize() {
        return this.getInt(ROCKSDB_DELETE_ENTRIES_BATCH_SIZE, 100000);
    }

    public ServerConfiguration setRocksDBDeleteEntriesBatchSize(int rocksDBDeleteEntriesBatchSize) {
        this.setProperty(ROCKSDB_DELETE_ENTRIES_BATCH_SIZE, rocksDBDeleteEntriesBatchSize);
        return this;
    }
}

