/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.util;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ForwardingListeningExecutorService;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ListenableFuture;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ListenableScheduledFuture;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.pulsar.shade.com.google.common.util.concurrent.ListeningScheduledExecutorService;
import org.apache.pulsar.shade.com.google.common.util.concurrent.MoreExecutors;

public class BoundedScheduledExecutorService
extends ForwardingListeningExecutorService
implements ListeningScheduledExecutorService {
    private final BlockingQueue<Runnable> queue;
    private final ListeningScheduledExecutorService thread;
    private final int maxTasksInQueue;

    public BoundedScheduledExecutorService(ScheduledThreadPoolExecutor thread, int maxTasksInQueue) {
        this.queue = thread.getQueue();
        this.thread = MoreExecutors.listeningDecorator(thread);
        this.maxTasksInQueue = maxTasksInQueue;
    }

    @Override
    protected ListeningExecutorService delegate() {
        return this.thread;
    }

    @Override
    public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.checkQueue(1);
        return this.thread.schedule(command, delay, unit);
    }

    @Override
    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.checkQueue(1);
        return this.thread.schedule((Callable)callable, delay, unit);
    }

    @Override
    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.checkQueue(1);
        return this.thread.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.checkQueue(1);
        return this.thread.scheduleAtFixedRate(command, initialDelay, delay, unit);
    }

    @Override
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        this.checkQueue(1);
        return super.submit((Callable)task);
    }

    @Override
    public ListenableFuture<?> submit(Runnable task) {
        this.checkQueue(1);
        return super.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.checkQueue(tasks.size());
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkQueue(tasks.size());
        return super.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.checkQueue(tasks.size());
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.checkQueue(tasks.size());
        return super.invokeAny(tasks, timeout, unit);
    }

    @Override
    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        this.checkQueue(1);
        return super.submit(task, (Object)result);
    }

    @Override
    public void execute(Runnable command) {
        this.checkQueue(1);
        super.execute(command);
    }

    private void checkQueue(int numberOfTasks) {
        if (this.maxTasksInQueue > 0 && this.queue.size() + numberOfTasks > this.maxTasksInQueue) {
            throw new RejectedExecutionException("Queue at limit of " + this.maxTasksInQueue + " items");
        }
    }
}

