/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.io.prometheus.client.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.zip.GZIPOutputStream;
import org.apache.pulsar.shade.com.sun.net.httpserver.HttpExchange;
import org.apache.pulsar.shade.com.sun.net.httpserver.HttpHandler;
import org.apache.pulsar.shade.com.sun.net.httpserver.HttpServer;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.exporter.common.TextFormat;

public class HTTPServer {
    protected final HttpServer server = HttpServer.create();
    protected final ExecutorService executorService;

    protected static boolean shouldUseCompression(HttpExchange exchange) {
        List encodingHeaders = exchange.getRequestHeaders().get((Object)"Accept-Encoding");
        if (encodingHeaders == null) {
            return false;
        }
        for (String encodingHeader : encodingHeaders) {
            String[] encodings;
            for (String encoding : encodings = encodingHeader.split(",")) {
                if (!encoding.trim().toLowerCase().equals("gzip")) continue;
                return true;
            }
        }
        return false;
    }

    protected static Set<String> parseQuery(String query) throws IOException {
        HashSet<String> names = new HashSet<String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf("=");
                if (idx == -1 || !URLDecoder.decode(pair.substring(0, idx), "UTF-8").equals("name[]")) continue;
                names.add(URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        return names;
    }

    public HTTPServer(InetSocketAddress addr, CollectorRegistry registry, boolean daemon) throws IOException {
        this.server.bind(addr, 3);
        HTTPMetricHandler mHandler = new HTTPMetricHandler(registry);
        this.server.createContext("/", (HttpHandler)mHandler);
        this.server.createContext("/metrics", (HttpHandler)mHandler);
        this.executorService = Executors.newFixedThreadPool(5, DaemonThreadFactory.defaultThreadFactory(daemon));
        this.server.setExecutor((Executor)this.executorService);
        this.start(daemon);
    }

    public HTTPServer(InetSocketAddress addr, CollectorRegistry registry) throws IOException {
        this(addr, registry, false);
    }

    public HTTPServer(int port, boolean daemon) throws IOException {
        this(new InetSocketAddress(port), CollectorRegistry.defaultRegistry, daemon);
    }

    public HTTPServer(int port) throws IOException {
        this(port, false);
    }

    public HTTPServer(String host, int port, boolean daemon) throws IOException {
        this(new InetSocketAddress(host, port), CollectorRegistry.defaultRegistry, daemon);
    }

    public HTTPServer(String host, int port) throws IOException {
        this(new InetSocketAddress(host, port), CollectorRegistry.defaultRegistry, false);
    }

    private void start(boolean daemon) {
        if (daemon == Thread.currentThread().isDaemon()) {
            this.server.start();
        } else {
            FutureTask<Object> startTask = new FutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                    HTTPServer.this.server.start();
                }
            }, null);
            DaemonThreadFactory.defaultThreadFactory(daemon).newThread(startTask).start();
            try {
                startTask.get();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Unexpected exception on starting HTTPSever", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void stop() {
        this.server.stop(0);
        this.executorService.shutdown();
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory delegate;
        private final boolean daemon;

        DaemonThreadFactory(ThreadFactory delegate, boolean daemon) {
            this.delegate = delegate;
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.delegate.newThread(r);
            t.setDaemon(this.daemon);
            return t;
        }

        static ThreadFactory defaultThreadFactory(boolean daemon) {
            return new DaemonThreadFactory(Executors.defaultThreadFactory(), daemon);
        }
    }

    static class HTTPMetricHandler
    implements HttpHandler {
        private CollectorRegistry registry;
        private final LocalByteArray response = new LocalByteArray();

        HTTPMetricHandler(CollectorRegistry registry) {
            this.registry = registry;
        }

        public void handle(HttpExchange t) throws IOException {
            String query = t.getRequestURI().getRawQuery();
            ByteArrayOutputStream response = (ByteArrayOutputStream)this.response.get();
            response.reset();
            OutputStreamWriter osw = new OutputStreamWriter(response);
            TextFormat.write004(osw, this.registry.filteredMetricFamilySamples(HTTPServer.parseQuery(query)));
            osw.flush();
            osw.close();
            response.flush();
            response.close();
            t.getResponseHeaders().set("Content-Type", "text/plain; version=0.0.4; charset=utf-8");
            t.getResponseHeaders().set("Content-Length", String.valueOf(response.size()));
            if (HTTPServer.shouldUseCompression(t)) {
                t.getResponseHeaders().set("Content-Encoding", "gzip");
                t.sendResponseHeaders(200, 0L);
                GZIPOutputStream os = new GZIPOutputStream(t.getResponseBody());
                response.writeTo(os);
                os.finish();
            } else {
                t.sendResponseHeaders(200, (long)response.size());
                response.writeTo(t.getResponseBody());
            }
            t.close();
        }
    }

    private static class LocalByteArray
    extends ThreadLocal<ByteArrayOutputStream> {
        private LocalByteArray() {
        }

        @Override
        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(0x100000);
        }
    }
}

