/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.io.IOException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.shade.javax.servlet.Filter;
import org.apache.pulsar.shade.javax.servlet.FilterChain;
import org.apache.pulsar.shade.javax.servlet.FilterConfig;
import org.apache.pulsar.shade.javax.servlet.ServletException;
import org.apache.pulsar.shade.javax.servlet.ServletRequest;
import org.apache.pulsar.shade.javax.servlet.ServletResponse;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;

public class ProcessHandlerFilter
implements Filter {
    private final BrokerInterceptor interceptor;
    private final boolean interceptorEnabled;

    public ProcessHandlerFilter(PulsarService pulsar) {
        this.interceptor = pulsar.getBrokerInterceptor();
        this.interceptorEnabled = !pulsar.getConfig().getBrokerInterceptors().isEmpty();
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.interceptorEnabled && !StringUtils.containsIgnoreCase(request.getContentType(), "multipart/form-data") && !StringUtils.containsIgnoreCase(request.getContentType(), "application/octet-stream")) {
            this.interceptor.onFilter(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void init(FilterConfig arg) throws ServletException {
    }

    @Override
    public void destroy() {
    }
}

