/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.recover;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.TransactionMetadataStoreService;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.transaction.coordinator.TransactionRecoverTracker;
import org.apache.pulsar.transaction.coordinator.TransactionTimeoutTracker;
import org.apache.pulsar.transaction.coordinator.exceptions.CoordinatorException;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRecoverTrackerImpl
implements TransactionRecoverTracker {
    private static final Logger log = LoggerFactory.getLogger(TransactionRecoverTrackerImpl.class);
    private final long tcId;
    private final TransactionMetadataStoreService transactionMetadataStoreService;
    private final TransactionTimeoutTracker timeoutTracker;
    private final Map<Long, Long> openTransactions;
    private final Set<Long> committingTransactions;
    private final Set<Long> abortingTransactions;

    public TransactionRecoverTrackerImpl(TransactionMetadataStoreService transactionMetadataStoreService, TransactionTimeoutTracker timeoutTracker, long tcId) {
        this.tcId = tcId;
        this.transactionMetadataStoreService = transactionMetadataStoreService;
        this.openTransactions = new HashMap<Long, Long>();
        this.committingTransactions = new HashSet<Long>();
        this.abortingTransactions = new HashSet<Long>();
        this.timeoutTracker = timeoutTracker;
    }

    @Override
    public void updateTransactionStatus(long sequenceId, TxnStatus txnStatus) throws CoordinatorException.InvalidTxnStatusException {
        switch (txnStatus) {
            case COMMITTING: {
                this.openTransactions.remove(sequenceId);
                this.committingTransactions.add(sequenceId);
                break;
            }
            case ABORTING: {
                this.openTransactions.remove(sequenceId);
                this.abortingTransactions.add(sequenceId);
                break;
            }
            case ABORTED: {
                this.abortingTransactions.remove(sequenceId);
                break;
            }
            case COMMITTED: {
                this.committingTransactions.remove(sequenceId);
                break;
            }
            default: {
                throw new CoordinatorException.InvalidTxnStatusException("Transaction recover tracker`" + new TxnID(this.tcId, sequenceId) + "` load replay metadata operation from transaction log with unknown operation");
            }
        }
    }

    @Override
    public void handleOpenStatusTransaction(long sequenceId, long timeout) {
        this.openTransactions.put(sequenceId, timeout);
    }

    @Override
    public void appendOpenTransactionToTimeoutTracker() {
        this.openTransactions.forEach(this.timeoutTracker::replayAddTransaction);
    }

    @Override
    public void handleCommittingAndAbortingTransaction() {
        this.committingTransactions.forEach(k -> this.transactionMetadataStoreService.endTransaction(new TxnID(this.tcId, (long)k), 0, false));
        this.abortingTransactions.forEach(k -> this.transactionMetadataStoreService.endTransaction(new TxnID(this.tcId, (long)k), 1, false));
    }
}

