/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import java.lang.management.ManagementFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.shade.com.sun.management.OperatingSystemMXBean;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.Runnables;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

public class GenericBrokerHostUsageImpl
implements BrokerHostUsage {
    private static final int CPU_CHECK_MILLIS = 1000;
    private double totalCpuLimit;
    private double cpuUsageSum = 0.0;
    private int cpuUsageCount = 0;
    private OperatingSystemMXBean systemBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private SystemResourceUsage usage = new SystemResourceUsage();

    public GenericBrokerHostUsageImpl(PulsarService pulsar) {
        this(pulsar.getConfiguration().getLoadBalancerHostUsageCheckIntervalMinutes(), pulsar.getLoadManagerExecutor());
    }

    public GenericBrokerHostUsageImpl(int hostUsageCheckIntervalMin, ScheduledExecutorService executorService) {
        this.totalCpuLimit = this.getTotalCpuLimit();
        this.calculateBrokerHostUsage();
        executorService.scheduleWithFixedDelay(Runnables.catchingAndLoggingThrowables(this::checkCpuLoad), 1000L, 1000L, TimeUnit.MILLISECONDS);
        executorService.scheduleWithFixedDelay(Runnables.catchingAndLoggingThrowables(this::doCalculateBrokerHostUsage), hostUsageCheckIntervalMin, hostUsageCheckIntervalMin, TimeUnit.MINUTES);
    }

    @Override
    public SystemResourceUsage getBrokerHostUsage() {
        return this.usage;
    }

    private synchronized void checkCpuLoad() {
        this.cpuUsageSum += this.systemBean.getSystemCpuLoad();
        ++this.cpuUsageCount;
    }

    @Override
    public void calculateBrokerHostUsage() {
        this.checkCpuLoad();
        this.doCalculateBrokerHostUsage();
    }

    void doCalculateBrokerHostUsage() {
        SystemResourceUsage usage = new SystemResourceUsage();
        usage.setCpu(this.getCpuUsage());
        usage.setMemory(this.getMemUsage());
        this.usage = usage;
    }

    private double getTotalCpuLimit() {
        return 100 * Runtime.getRuntime().availableProcessors();
    }

    private synchronized double getTotalCpuUsage() {
        if (this.cpuUsageCount == 0) {
            return 0.0;
        }
        double cpuUsage = this.cpuUsageSum / (double)this.cpuUsageCount;
        this.cpuUsageSum = 0.0;
        this.cpuUsageCount = 0;
        return cpuUsage;
    }

    private ResourceUsage getCpuUsage() {
        return new ResourceUsage(this.getTotalCpuUsage() * this.totalCpuLimit, this.totalCpuLimit);
    }

    private ResourceUsage getMemUsage() {
        double total = (double)this.systemBean.getTotalPhysicalMemorySize() / 1048576.0;
        double free = (double)this.systemBean.getFreePhysicalMemorySize() / 1048576.0;
        return new ResourceUsage(total - free, total);
    }
}

