/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import java.util.List;
import org.apache.pulsar.broker.admin.impl.ResourceGroupsBase;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiParam;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.PUT;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.ResourceGroup;

@Path(value="/resourcegroups")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/resourcegroups", description="ResourceGroups admin apis", tags={"resourcegroups"})
public class ResourceGroups
extends ResourceGroupsBase {
    @GET
    @ApiOperation(value="Get the list of all the resourcegroups.", response=String.class, responseContainer="Set")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission")})
    public List<String> getResourceGroups() {
        return this.internalGetResourceGroups();
    }

    @GET
    @Path(value="/{resourcegroup}")
    @ApiOperation(value="Get the rate limiters specified for a resourcegroup.", response=ResourceGroup.class)
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="ResourceGroup doesn't exist")})
    public ResourceGroup getResourceGroup(@PathParam(value="resourcegroup") String resourcegroup) {
        return this.internalGetResourceGroup(resourcegroup);
    }

    @PUT
    @Path(value="/{resourcegroup}")
    @ApiOperation(value="Creates a new resourcegroup with the specified rate limiters")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="cluster doesn't exist")})
    public void createOrUpdateResourceGroup(@PathParam(value="resourcegroup") String name, @ApiParam(value="Rate limiters for the resourcegroup") ResourceGroup resourcegroup) {
        this.internalCreateOrUpdateResourceGroup(name, resourcegroup);
    }

    @DELETE
    @Path(value="/{resourcegroup}")
    @ApiOperation(value="Delete a resourcegroup.")
    @ApiResponses(value={@ApiResponse(code=403, message="Don't have admin permission"), @ApiResponse(code=404, message="ResourceGroup doesn't exist"), @ApiResponse(code=409, message="ResourceGroup is in use")})
    public void deleteResourceGroup(@PathParam(value="resourcegroup") String resourcegroup) {
        this.internalDeleteResourceGroup(resourcegroup);
    }
}

