/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.transaction.coordinator.proto;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.org.apache.pulsar.common.api.proto.Subscription;
import org.apache.pulsar.transaction.coordinator.proto.LightProtoCodec;
import org.apache.pulsar.transaction.coordinator.proto.TxnStatus;

public final class TransactionMetadataEntry {
    private TransactionMetadataOp metadataOp;
    private static final int _METADATA_OP_FIELD_NUMBER = 1;
    private static final int _METADATA_OP_TAG = 8;
    private static final int _METADATA_OP_TAG_SIZE = LightProtoCodec.computeVarIntSize(8);
    private static final int _METADATA_OP_MASK = 1;
    private long txnidLeastBits = 0L;
    private static final int _TXNID_LEAST_BITS_FIELD_NUMBER = 2;
    private static final int _TXNID_LEAST_BITS_TAG = 16;
    private static final int _TXNID_LEAST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(16);
    private static final int _TXNID_LEAST_BITS_MASK = 2;
    private long txnidMostBits = 0L;
    private static final int _TXNID_MOST_BITS_FIELD_NUMBER = 3;
    private static final int _TXNID_MOST_BITS_TAG = 24;
    private static final int _TXNID_MOST_BITS_TAG_SIZE = LightProtoCodec.computeVarIntSize(24);
    private static final int _TXNID_MOST_BITS_MASK = 4;
    private TxnStatus expectedStatus;
    private static final int _EXPECTED_STATUS_FIELD_NUMBER = 4;
    private static final int _EXPECTED_STATUS_TAG = 32;
    private static final int _EXPECTED_STATUS_TAG_SIZE = LightProtoCodec.computeVarIntSize(32);
    private static final int _EXPECTED_STATUS_MASK = 8;
    private TxnStatus newStatus;
    private static final int _NEW_STATUS_FIELD_NUMBER = 5;
    private static final int _NEW_STATUS_TAG = 40;
    private static final int _NEW_STATUS_TAG_SIZE = LightProtoCodec.computeVarIntSize(40);
    private static final int _NEW_STATUS_MASK = 16;
    private List<LightProtoCodec.StringHolder> partitions = null;
    private int _partitionsCount = 0;
    private static final int _PARTITIONS_FIELD_NUMBER = 6;
    private static final int _PARTITIONS_TAG = 50;
    private static final int _PARTITIONS_TAG_SIZE = LightProtoCodec.computeVarIntSize(50);
    private List<Subscription> subscriptions = null;
    private int _subscriptionsCount = 0;
    private static final int _SUBSCRIPTIONS_FIELD_NUMBER = 7;
    private static final int _SUBSCRIPTIONS_TAG = 58;
    private static final int _SUBSCRIPTIONS_TAG_SIZE = LightProtoCodec.computeVarIntSize(58);
    private long timeoutMs;
    private static final int _TIMEOUT_MS_FIELD_NUMBER = 8;
    private static final int _TIMEOUT_MS_TAG = 64;
    private static final int _TIMEOUT_MS_TAG_SIZE = LightProtoCodec.computeVarIntSize(64);
    private static final int _TIMEOUT_MS_MASK = 128;
    private long startTime;
    private static final int _START_TIME_FIELD_NUMBER = 9;
    private static final int _START_TIME_TAG = 72;
    private static final int _START_TIME_TAG_SIZE = LightProtoCodec.computeVarIntSize(72);
    private static final int _START_TIME_MASK = 256;
    private long lastModificationTime;
    private static final int _LAST_MODIFICATION_TIME_FIELD_NUMBER = 10;
    private static final int _LAST_MODIFICATION_TIME_TAG = 80;
    private static final int _LAST_MODIFICATION_TIME_TAG_SIZE = LightProtoCodec.computeVarIntSize(80);
    private static final int _LAST_MODIFICATION_TIME_MASK = 512;
    private long maxLocalTxnId;
    private static final int _MAX_LOCAL_TXN_ID_FIELD_NUMBER = 11;
    private static final int _MAX_LOCAL_TXN_ID_TAG = 88;
    private static final int _MAX_LOCAL_TXN_ID_TAG_SIZE = LightProtoCodec.computeVarIntSize(88);
    private static final int _MAX_LOCAL_TXN_ID_MASK = 1024;
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 0;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasMetadataOp() {
        return (this._bitField0 & 1) != 0;
    }

    public TransactionMetadataOp getMetadataOp() {
        if (!this.hasMetadataOp()) {
            throw new IllegalStateException("Field 'metadata_op' is not set");
        }
        return this.metadataOp;
    }

    public TransactionMetadataEntry setMetadataOp(TransactionMetadataOp metadataOp) {
        this.metadataOp = metadataOp;
        this._bitField0 |= 1;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearMetadataOp() {
        this._bitField0 &= 0xFFFFFFFE;
        return this;
    }

    public boolean hasTxnidLeastBits() {
        return (this._bitField0 & 2) != 0;
    }

    public long getTxnidLeastBits() {
        return this.txnidLeastBits;
    }

    public TransactionMetadataEntry setTxnidLeastBits(long txnidLeastBits) {
        this.txnidLeastBits = txnidLeastBits;
        this._bitField0 |= 2;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearTxnidLeastBits() {
        this._bitField0 &= 0xFFFFFFFD;
        this.txnidLeastBits = 0L;
        return this;
    }

    public boolean hasTxnidMostBits() {
        return (this._bitField0 & 4) != 0;
    }

    public long getTxnidMostBits() {
        return this.txnidMostBits;
    }

    public TransactionMetadataEntry setTxnidMostBits(long txnidMostBits) {
        this.txnidMostBits = txnidMostBits;
        this._bitField0 |= 4;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearTxnidMostBits() {
        this._bitField0 &= 0xFFFFFFFB;
        this.txnidMostBits = 0L;
        return this;
    }

    public boolean hasExpectedStatus() {
        return (this._bitField0 & 8) != 0;
    }

    public TxnStatus getExpectedStatus() {
        if (!this.hasExpectedStatus()) {
            throw new IllegalStateException("Field 'expected_status' is not set");
        }
        return this.expectedStatus;
    }

    public TransactionMetadataEntry setExpectedStatus(TxnStatus expectedStatus) {
        this.expectedStatus = expectedStatus;
        this._bitField0 |= 8;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearExpectedStatus() {
        this._bitField0 &= 0xFFFFFFF7;
        return this;
    }

    public boolean hasNewStatus() {
        return (this._bitField0 & 0x10) != 0;
    }

    public TxnStatus getNewStatus() {
        if (!this.hasNewStatus()) {
            throw new IllegalStateException("Field 'new_status' is not set");
        }
        return this.newStatus;
    }

    public TransactionMetadataEntry setNewStatus(TxnStatus newStatus) {
        this.newStatus = newStatus;
        this._bitField0 |= 0x10;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearNewStatus() {
        this._bitField0 &= 0xFFFFFFEF;
        return this;
    }

    public int getPartitionsCount() {
        return this._partitionsCount;
    }

    public String getPartitionAt(int idx) {
        if (idx < 0 || idx >= this._partitionsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._partitionsCount + ") for field 'partitions'");
        }
        LightProtoCodec.StringHolder _sh = this.partitions.get(idx);
        if (_sh.s == null) {
            _sh.s = LightProtoCodec.readString(this._parsedBuffer, _sh.idx, _sh.len);
        }
        return _sh.s;
    }

    public List<String> getPartitionsList() {
        if (this._partitionsCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> _l = new ArrayList<String>();
        for (int i = 0; i < this._partitionsCount; ++i) {
            _l.add(this.getPartitionAt(i));
        }
        return _l;
    }

    public void addPartition(String partition) {
        if (this.partitions == null) {
            this.partitions = new ArrayList<LightProtoCodec.StringHolder>();
        }
        LightProtoCodec.StringHolder _sh = this._newPartitionStringHolder();
        this._cachedSize = -1;
        _sh.s = partition;
        _sh.idx = -1;
        _sh.len = LightProtoCodec.computeStringUTF8Size(_sh.s);
    }

    public TransactionMetadataEntry addAllPartitions(Iterable<String> partitions) {
        for (String _s : partitions) {
            this.addPartition(_s);
        }
        return this;
    }

    private LightProtoCodec.StringHolder _newPartitionStringHolder() {
        LightProtoCodec.StringHolder _sh;
        if (this.partitions == null) {
            this.partitions = new ArrayList<LightProtoCodec.StringHolder>();
        }
        if (this.partitions.size() == this._partitionsCount) {
            _sh = new LightProtoCodec.StringHolder();
            this.partitions.add(_sh);
        } else {
            _sh = this.partitions.get(this._partitionsCount);
        }
        ++this._partitionsCount;
        return _sh;
    }

    public TransactionMetadataEntry clearPartitions() {
        for (int i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._partitionsCount = 0;
        return this;
    }

    public int getSubscriptionsCount() {
        return this._subscriptionsCount;
    }

    public Subscription getSubscriptionAt(int idx) {
        if (idx < 0 || idx >= this._subscriptionsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._subscriptionsCount + ") for field 'subscriptions'");
        }
        return this.subscriptions.get(idx);
    }

    public List<Subscription> getSubscriptionsList() {
        if (this._subscriptionsCount == 0) {
            return Collections.emptyList();
        }
        return this.subscriptions.subList(0, this._subscriptionsCount);
    }

    public Subscription addSubscription() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<Subscription>();
        }
        if (this.subscriptions.size() == this._subscriptionsCount) {
            this.subscriptions.add(new Subscription());
        }
        this._cachedSize = -1;
        return this.subscriptions.get(this._subscriptionsCount++);
    }

    public TransactionMetadataEntry addAllSubscriptions(Iterable<Subscription> subscriptions) {
        for (Subscription _o : subscriptions) {
            this.addSubscription().copyFrom(_o);
        }
        return this;
    }

    public TransactionMetadataEntry clearSubscriptions() {
        for (int i = 0; i < this._subscriptionsCount; ++i) {
            this.subscriptions.get(i).clear();
        }
        this._subscriptionsCount = 0;
        return this;
    }

    public boolean hasTimeoutMs() {
        return (this._bitField0 & 0x80) != 0;
    }

    public long getTimeoutMs() {
        if (!this.hasTimeoutMs()) {
            throw new IllegalStateException("Field 'timeout_ms' is not set");
        }
        return this.timeoutMs;
    }

    public TransactionMetadataEntry setTimeoutMs(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        this._bitField0 |= 0x80;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearTimeoutMs() {
        this._bitField0 &= 0xFFFFFF7F;
        return this;
    }

    public boolean hasStartTime() {
        return (this._bitField0 & 0x100) != 0;
    }

    public long getStartTime() {
        if (!this.hasStartTime()) {
            throw new IllegalStateException("Field 'start_time' is not set");
        }
        return this.startTime;
    }

    public TransactionMetadataEntry setStartTime(long startTime) {
        this.startTime = startTime;
        this._bitField0 |= 0x100;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearStartTime() {
        this._bitField0 &= 0xFFFFFEFF;
        return this;
    }

    public boolean hasLastModificationTime() {
        return (this._bitField0 & 0x200) != 0;
    }

    public long getLastModificationTime() {
        if (!this.hasLastModificationTime()) {
            throw new IllegalStateException("Field 'last_modification_time' is not set");
        }
        return this.lastModificationTime;
    }

    public TransactionMetadataEntry setLastModificationTime(long lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
        this._bitField0 |= 0x200;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearLastModificationTime() {
        this._bitField0 &= 0xFFFFFDFF;
        return this;
    }

    public boolean hasMaxLocalTxnId() {
        return (this._bitField0 & 0x400) != 0;
    }

    public long getMaxLocalTxnId() {
        if (!this.hasMaxLocalTxnId()) {
            throw new IllegalStateException("Field 'max_local_txn_id' is not set");
        }
        return this.maxLocalTxnId;
    }

    public TransactionMetadataEntry setMaxLocalTxnId(long maxLocalTxnId) {
        this.maxLocalTxnId = maxLocalTxnId;
        this._bitField0 |= 0x400;
        this._cachedSize = -1;
        return this;
    }

    public TransactionMetadataEntry clearMaxLocalTxnId() {
        this._bitField0 &= 0xFFFFFBFF;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        int i;
        int _writeIdx = _b.writerIndex();
        if (this.hasMetadataOp()) {
            LightProtoCodec.writeVarInt(_b, 8);
            LightProtoCodec.writeVarInt(_b, this.metadataOp.getValue());
        }
        if (this.hasTxnidLeastBits()) {
            LightProtoCodec.writeVarInt(_b, 16);
            LightProtoCodec.writeVarInt64(_b, this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            LightProtoCodec.writeVarInt(_b, 24);
            LightProtoCodec.writeVarInt64(_b, this.txnidMostBits);
        }
        if (this.hasExpectedStatus()) {
            LightProtoCodec.writeVarInt(_b, 32);
            LightProtoCodec.writeVarInt(_b, this.expectedStatus.getValue());
        }
        if (this.hasNewStatus()) {
            LightProtoCodec.writeVarInt(_b, 40);
            LightProtoCodec.writeVarInt(_b, this.newStatus.getValue());
        }
        for (i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            LightProtoCodec.writeVarInt(_b, 50);
            LightProtoCodec.writeVarInt(_b, _sh.len);
            if (_sh.idx == -1) {
                LightProtoCodec.writeString(_b, _sh.s, _sh.len);
                continue;
            }
            this._parsedBuffer.getBytes(_sh.idx, _b, _sh.len);
        }
        for (i = 0; i < this._subscriptionsCount; ++i) {
            Subscription _item = this.subscriptions.get(i);
            LightProtoCodec.writeVarInt(_b, 58);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        if (this.hasTimeoutMs()) {
            LightProtoCodec.writeVarInt(_b, 64);
            LightProtoCodec.writeVarInt64(_b, this.timeoutMs);
        }
        if (this.hasStartTime()) {
            LightProtoCodec.writeVarInt(_b, 72);
            LightProtoCodec.writeVarInt64(_b, this.startTime);
        }
        if (this.hasLastModificationTime()) {
            LightProtoCodec.writeVarInt(_b, 80);
            LightProtoCodec.writeVarInt64(_b, this.lastModificationTime);
        }
        if (this.hasMaxLocalTxnId()) {
            LightProtoCodec.writeVarInt(_b, 88);
            LightProtoCodec.writeVarInt64(_b, this.maxLocalTxnId);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        int i;
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        if (this.hasMetadataOp()) {
            _size += _METADATA_OP_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.metadataOp.getValue());
        }
        if (this.hasTxnidLeastBits()) {
            _size += _TXNID_LEAST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidLeastBits);
        }
        if (this.hasTxnidMostBits()) {
            _size += _TXNID_MOST_BITS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.txnidMostBits);
        }
        if (this.hasExpectedStatus()) {
            _size += _EXPECTED_STATUS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.expectedStatus.getValue());
        }
        if (this.hasNewStatus()) {
            _size += _NEW_STATUS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(this.newStatus.getValue());
        }
        for (i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            _size += _PARTITIONS_TAG_SIZE;
            _size += LightProtoCodec.computeVarIntSize(_sh.len) + _sh.len;
        }
        for (i = 0; i < this._subscriptionsCount; ++i) {
            Subscription _item = this.subscriptions.get(i);
            _size += _SUBSCRIPTIONS_TAG_SIZE;
            int MsgsizeSubscriptions = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeSubscriptions) + MsgsizeSubscriptions;
        }
        if (this.hasTimeoutMs()) {
            _size += _TIMEOUT_MS_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.timeoutMs);
        }
        if (this.hasStartTime()) {
            _size += _START_TIME_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.startTime);
        }
        if (this.hasLastModificationTime()) {
            _size += _LAST_MODIFICATION_TIME_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.lastModificationTime);
        }
        if (this.hasMaxLocalTxnId()) {
            _size += _MAX_LOCAL_TXN_ID_TAG_SIZE;
            _size += LightProtoCodec.computeVarInt64Size(this.maxLocalTxnId);
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block13: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 8: {
                    TransactionMetadataOp _metadataOp = TransactionMetadataOp.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_metadataOp == null) continue block13;
                    this._bitField0 |= 1;
                    this.metadataOp = _metadataOp;
                    continue block13;
                }
                case 16: {
                    this._bitField0 |= 2;
                    this.txnidLeastBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block13;
                }
                case 24: {
                    this._bitField0 |= 4;
                    this.txnidMostBits = LightProtoCodec.readVarInt64(_buffer);
                    continue block13;
                }
                case 32: {
                    TxnStatus _expectedStatus = TxnStatus.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_expectedStatus == null) continue block13;
                    this._bitField0 |= 8;
                    this.expectedStatus = _expectedStatus;
                    continue block13;
                }
                case 40: {
                    TxnStatus _newStatus = TxnStatus.valueOf(LightProtoCodec.readVarInt(_buffer));
                    if (_newStatus == null) continue block13;
                    this._bitField0 |= 0x10;
                    this.newStatus = _newStatus;
                    continue block13;
                }
                case 50: {
                    LightProtoCodec.StringHolder _partitionsSh = this._newPartitionStringHolder();
                    _partitionsSh.len = LightProtoCodec.readVarInt(_buffer);
                    _partitionsSh.idx = _buffer.readerIndex();
                    _buffer.skipBytes(_partitionsSh.len);
                    continue block13;
                }
                case 58: {
                    int _subscriptionsSize = LightProtoCodec.readVarInt(_buffer);
                    this.addSubscription().parseFrom(_buffer, _subscriptionsSize);
                    continue block13;
                }
                case 64: {
                    this._bitField0 |= 0x80;
                    this.timeoutMs = LightProtoCodec.readVarInt64(_buffer);
                    continue block13;
                }
                case 72: {
                    this._bitField0 |= 0x100;
                    this.startTime = LightProtoCodec.readVarInt64(_buffer);
                    continue block13;
                }
                case 80: {
                    this._bitField0 |= 0x200;
                    this.lastModificationTime = LightProtoCodec.readVarInt64(_buffer);
                    continue block13;
                }
                case 88: {
                    this._bitField0 |= 0x400;
                    this.maxLocalTxnId = LightProtoCodec.readVarInt64(_buffer);
                    continue block13;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this._parsedBuffer = _buffer;
    }

    public TransactionMetadataEntry clear() {
        int i;
        this.txnidLeastBits = 0L;
        this.txnidMostBits = 0L;
        for (i = 0; i < this._partitionsCount; ++i) {
            LightProtoCodec.StringHolder _sh = this.partitions.get(i);
            _sh.s = null;
            _sh.idx = -1;
            _sh.len = -1;
        }
        this._partitionsCount = 0;
        for (i = 0; i < this._subscriptionsCount; ++i) {
            this.subscriptions.get(i).clear();
        }
        this._subscriptionsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public TransactionMetadataEntry copyFrom(TransactionMetadataEntry _other) {
        int i;
        this._cachedSize = -1;
        if (_other.hasMetadataOp()) {
            this.setMetadataOp(_other.metadataOp);
        }
        if (_other.hasTxnidLeastBits()) {
            this.setTxnidLeastBits(_other.txnidLeastBits);
        }
        if (_other.hasTxnidMostBits()) {
            this.setTxnidMostBits(_other.txnidMostBits);
        }
        if (_other.hasExpectedStatus()) {
            this.setExpectedStatus(_other.expectedStatus);
        }
        if (_other.hasNewStatus()) {
            this.setNewStatus(_other.newStatus);
        }
        for (i = 0; i < _other.getPartitionsCount(); ++i) {
            this.addPartition(_other.getPartitionAt(i));
        }
        for (i = 0; i < _other.getSubscriptionsCount(); ++i) {
            this.addSubscription().copyFrom(_other.getSubscriptionAt(i));
        }
        if (_other.hasTimeoutMs()) {
            this.setTimeoutMs(_other.timeoutMs);
        }
        if (_other.hasStartTime()) {
            this.setStartTime(_other.startTime);
        }
        if (_other.hasLastModificationTime()) {
            this.setLastModificationTime(_other.lastModificationTime);
        }
        if (_other.hasMaxLocalTxnId()) {
            this.setMaxLocalTxnId(_other.maxLocalTxnId);
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }

    public static enum TransactionMetadataOp {
        NEW(0),
        ADD_PARTITION(1),
        ADD_SUBSCRIPTION(2),
        UPDATE(3);

        private final int value;
        public static final int NEW_VALUE = 0;
        public static final int ADD_PARTITION_VALUE = 1;
        public static final int ADD_SUBSCRIPTION_VALUE = 2;
        public static final int UPDATE_VALUE = 3;

        private TransactionMetadataOp(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TransactionMetadataOp valueOf(int n) {
            switch (n) {
                case 0: {
                    return NEW;
                }
                case 1: {
                    return ADD_PARTITION;
                }
                case 2: {
                    return ADD_SUBSCRIPTION;
                }
                case 3: {
                    return UPDATE;
                }
            }
            return null;
        }
    }
}

