/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.common;

import java.net.URI;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.LogicalConnection;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.SessionFactory;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.WebSocketSession;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.EventDriver;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.JettyAnnotatedEventDriver;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.events.JettyListenerEventDriver;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketSessionFactory
implements SessionFactory {
    private final WebSocketContainerScope containerScope;

    public WebSocketSessionFactory(WebSocketContainerScope containerScope) {
        this.containerScope = containerScope;
    }

    @Override
    public boolean supports(EventDriver websocket) {
        return websocket instanceof JettyAnnotatedEventDriver || websocket instanceof JettyListenerEventDriver;
    }

    @Override
    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new WebSocketSession(this.containerScope, requestURI, websocket, connection);
    }
}

