/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.AdvertisedListener;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.LoadManagerReport;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.shade.org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;

@JsonDeserialize(as=LocalBrokerData.class)
public class LocalBrokerData
implements LoadManagerReport {
    private final String webServiceUrl;
    private final String webServiceUrlTls;
    private final String pulsarServiceUrl;
    private final String pulsarServiceUrlTls;
    private boolean persistentTopicsEnabled = true;
    private boolean nonPersistentTopicsEnabled = true;
    private ResourceUsage cpu;
    private ResourceUsage memory;
    private ResourceUsage directMemory;
    private ResourceUsage bandwidthIn;
    private ResourceUsage bandwidthOut;
    private double msgThroughputIn;
    private double msgThroughputOut;
    private double msgRateIn;
    private double msgRateOut;
    private long lastUpdate;
    private Map<String, NamespaceBundleStats> lastStats;
    private int numTopics;
    private int numBundles;
    private int numConsumers;
    private int numProducers;
    private Set<String> bundles;
    private Set<String> lastBundleGains;
    private Set<String> lastBundleLosses;
    private String brokerVersionString;
    public static final String loadReportType = LocalBrokerData.class.getSimpleName();
    private Map<String, String> protocols;
    private Map<String, AdvertisedListener> advertisedListeners;

    public LocalBrokerData() {
        this(null, null, null, null);
    }

    public LocalBrokerData(String webServiceUrl, String webServiceUrlTls, String pulsarServiceUrl, String pulsarServiceUrlTls) {
        this(webServiceUrl, webServiceUrlTls, pulsarServiceUrl, pulsarServiceUrlTls, Collections.unmodifiableMap(Collections.emptyMap()));
    }

    public LocalBrokerData(String webServiceUrl, String webServiceUrlTls, String pulsarServiceUrl, String pulsarServiceUrlTls, Map<String, AdvertisedListener> advertisedListeners) {
        this.webServiceUrl = webServiceUrl;
        this.webServiceUrlTls = webServiceUrlTls;
        this.pulsarServiceUrl = pulsarServiceUrl;
        this.pulsarServiceUrlTls = pulsarServiceUrlTls;
        this.lastStats = new ConcurrentHashMap<String, NamespaceBundleStats>();
        this.lastUpdate = System.currentTimeMillis();
        this.cpu = new ResourceUsage();
        this.memory = new ResourceUsage();
        this.directMemory = new ResourceUsage();
        this.bandwidthIn = new ResourceUsage();
        this.bandwidthOut = new ResourceUsage();
        this.bundles = new HashSet<String>();
        this.lastBundleGains = new HashSet<String>();
        this.lastBundleLosses = new HashSet<String>();
        this.protocols = new HashMap<String, String>();
        this.advertisedListeners = Collections.unmodifiableMap(new HashMap<String, AdvertisedListener>(advertisedListeners));
    }

    public boolean equals(Object o) {
        if (o instanceof LocalBrokerData) {
            LocalBrokerData other = (LocalBrokerData)o;
            return Objects.equals(this.webServiceUrl, other.webServiceUrl) && Objects.equals(this.webServiceUrlTls, other.webServiceUrlTls) && Objects.equals(this.pulsarServiceUrl, other.pulsarServiceUrl) && Objects.equals(this.pulsarServiceUrlTls, other.pulsarServiceUrlTls);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.webServiceUrl, this.webServiceUrlTls, this.pulsarServiceUrl, this.pulsarServiceUrlTls);
    }

    public void update(SystemResourceUsage systemResourceUsage, Map<String, NamespaceBundleStats> bundleStats) {
        this.updateSystemResourceUsage(systemResourceUsage);
        this.updateBundleData(bundleStats);
        this.lastStats = bundleStats;
    }

    public void update(LocalBrokerData other) {
        this.updateSystemResourceUsage(other.cpu, other.memory, other.directMemory, other.bandwidthIn, other.bandwidthOut);
        this.updateBundleData(other.lastStats);
        this.lastStats = other.lastStats;
    }

    private void updateSystemResourceUsage(SystemResourceUsage systemResourceUsage) {
        this.updateSystemResourceUsage(systemResourceUsage.cpu, systemResourceUsage.memory, systemResourceUsage.directMemory, systemResourceUsage.bandwidthIn, systemResourceUsage.bandwidthOut);
    }

    private void updateSystemResourceUsage(ResourceUsage cpu, ResourceUsage memory, ResourceUsage directMemory, ResourceUsage bandwidthIn, ResourceUsage bandwidthOut) {
        this.cpu = cpu;
        this.memory = memory;
        this.directMemory = directMemory;
        this.bandwidthIn = bandwidthIn;
        this.bandwidthOut = bandwidthOut;
    }

    private void updateBundleData(Map<String, NamespaceBundleStats> bundleStats) {
        this.msgRateIn = 0.0;
        this.msgRateOut = 0.0;
        this.msgThroughputIn = 0.0;
        this.msgThroughputOut = 0.0;
        int totalNumTopics = 0;
        int totalNumBundles = 0;
        int totalNumConsumers = 0;
        int totalNumProducers = 0;
        Iterator<String> oldBundleIterator = this.bundles.iterator();
        while (oldBundleIterator.hasNext()) {
            String bundle = oldBundleIterator.next();
            if (bundleStats.containsKey(bundle)) continue;
            this.lastBundleLosses.add(bundle);
            oldBundleIterator.remove();
        }
        for (Map.Entry<String, NamespaceBundleStats> entry : bundleStats.entrySet()) {
            String bundle = entry.getKey();
            NamespaceBundleStats stats = entry.getValue();
            if (!this.bundles.contains(bundle)) {
                this.lastBundleGains.add(bundle);
                this.bundles.add(bundle);
            }
            this.msgThroughputIn += stats.msgThroughputIn;
            this.msgThroughputOut += stats.msgThroughputOut;
            this.msgRateIn += stats.msgRateIn;
            this.msgRateOut += stats.msgRateOut;
            totalNumTopics = (int)((long)totalNumTopics + stats.topics);
            ++totalNumBundles;
            totalNumConsumers += stats.consumerCount;
            totalNumProducers += stats.producerCount;
        }
        this.numTopics = totalNumTopics;
        this.numBundles = totalNumBundles;
        this.numConsumers = totalNumConsumers;
        this.numProducers = totalNumProducers;
    }

    public double getMaxResourceUsage() {
        return LocalBrokerData.max(this.cpu.percentUsage(), this.memory.percentUsage(), this.directMemory.percentUsage(), this.bandwidthIn.percentUsage(), this.bandwidthOut.percentUsage()) / 100.0f;
    }

    public String printResourceUsage() {
        return String.format(Locale.ENGLISH, "cpu: %.2f%%, memory: %.2f%%, directMemory: %.2f%%, bandwidthIn: %.2f%%, bandwidthOut: %.2f%%", Float.valueOf(this.cpu.percentUsage()), Float.valueOf(this.memory.percentUsage()), Float.valueOf(this.directMemory.percentUsage()), Float.valueOf(this.bandwidthIn.percentUsage()), Float.valueOf(this.bandwidthOut.percentUsage()));
    }

    public double getMaxResourceUsageWithWeight(double cpuWeight, double memoryWeight, double directMemoryWeight, double bandwidthInWeight, double bandwidthOutWeight) {
        return LocalBrokerData.max((double)this.cpu.percentUsage() * cpuWeight, (double)this.memory.percentUsage() * memoryWeight, (double)this.directMemory.percentUsage() * directMemoryWeight, (double)this.bandwidthIn.percentUsage() * bandwidthInWeight, (double)this.bandwidthOut.percentUsage() * bandwidthOutWeight) / 100.0;
    }

    private static double max(double ... args) {
        double max = Double.NEGATIVE_INFINITY;
        for (double d : args) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    private static float max(float ... args) {
        float max = Float.NEGATIVE_INFINITY;
        for (float d : args) {
            if (!(d > max)) continue;
            max = d;
        }
        return max;
    }

    public String getLoadReportType() {
        return loadReportType;
    }

    @Override
    public ResourceUsage getCpu() {
        return this.cpu;
    }

    public void setCpu(ResourceUsage cpu) {
        this.cpu = cpu;
    }

    @Override
    public ResourceUsage getMemory() {
        return this.memory;
    }

    public void setMemory(ResourceUsage memory) {
        this.memory = memory;
    }

    @Override
    public ResourceUsage getDirectMemory() {
        return this.directMemory;
    }

    public void setDirectMemory(ResourceUsage directMemory) {
        this.directMemory = directMemory;
    }

    @Override
    public ResourceUsage getBandwidthIn() {
        return this.bandwidthIn;
    }

    public void setBandwidthIn(ResourceUsage bandwidthIn) {
        this.bandwidthIn = bandwidthIn;
    }

    @Override
    public ResourceUsage getBandwidthOut() {
        return this.bandwidthOut;
    }

    public void setBandwidthOut(ResourceUsage bandwidthOut) {
        this.bandwidthOut = bandwidthOut;
    }

    public Set<String> getLastBundleGains() {
        return this.lastBundleGains;
    }

    public void cleanDeltas() {
        this.lastBundleGains.clear();
        this.lastBundleLosses.clear();
    }

    public void setLastBundleGains(Set<String> lastBundleGains) {
        this.lastBundleGains = lastBundleGains;
    }

    public Set<String> getLastBundleLosses() {
        return this.lastBundleLosses;
    }

    public void setLastBundleLosses(Set<String> lastBundleLosses) {
        this.lastBundleLosses = lastBundleLosses;
    }

    @Override
    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Set<String> getBundles() {
        return this.bundles;
    }

    public void setBundles(Set<String> bundles) {
        this.bundles = bundles;
    }

    public Map<String, NamespaceBundleStats> getLastStats() {
        return this.lastStats;
    }

    public void setLastStats(Map<String, NamespaceBundleStats> lastStats) {
        this.lastStats = lastStats;
    }

    @Override
    public int getNumTopics() {
        return this.numTopics;
    }

    public void setNumTopics(int numTopics) {
        this.numTopics = numTopics;
    }

    @Override
    public int getNumBundles() {
        return this.numBundles;
    }

    public void setNumBundles(int numBundles) {
        this.numBundles = numBundles;
    }

    @Override
    public int getNumConsumers() {
        return this.numConsumers;
    }

    public void setNumConsumers(int numConsumers) {
        this.numConsumers = numConsumers;
    }

    @Override
    public int getNumProducers() {
        return this.numProducers;
    }

    public void setNumProducers(int numProducers) {
        this.numProducers = numProducers;
    }

    @Override
    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    @Override
    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    @Override
    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    @Override
    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setBrokerVersionString(String brokerVersionString) {
        this.brokerVersionString = brokerVersionString;
    }

    @Override
    public String getBrokerVersionString() {
        return this.brokerVersionString;
    }

    @Override
    public String getWebServiceUrl() {
        return this.webServiceUrl;
    }

    @Override
    public String getWebServiceUrlTls() {
        return this.webServiceUrlTls;
    }

    @Override
    public String getPulsarServiceUrl() {
        return this.pulsarServiceUrl;
    }

    @Override
    public String getPulsarServiceUrlTls() {
        return this.pulsarServiceUrlTls;
    }

    @Override
    public boolean isPersistentTopicsEnabled() {
        return this.persistentTopicsEnabled;
    }

    public void setPersistentTopicsEnabled(boolean persistentTopicsEnabled) {
        this.persistentTopicsEnabled = persistentTopicsEnabled;
    }

    @Override
    public boolean isNonPersistentTopicsEnabled() {
        return this.nonPersistentTopicsEnabled;
    }

    public void setNonPersistentTopicsEnabled(boolean nonPersistentTopicsEnabled) {
        this.nonPersistentTopicsEnabled = nonPersistentTopicsEnabled;
    }

    @Override
    public Map<String, NamespaceBundleStats> getBundleStats() {
        return this.getLastStats();
    }

    public void setProtocols(Map<String, String> protocols) {
        this.protocols = protocols;
    }

    @Override
    public Map<String, String> getProtocols() {
        return this.protocols;
    }

    @Override
    public Optional<String> getProtocol(String protocol) {
        return Optional.ofNullable(this.protocols.get(protocol));
    }

    public Map<String, AdvertisedListener> getAdvertisedListeners() {
        return this.advertisedListeners;
    }

    public void setAdvertisedListeners(Map<String, AdvertisedListener> advertisedListeners) {
        this.advertisedListeners = advertisedListeners;
    }
}

