/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.io.IOException;
import java.util.List;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LayoutManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerAuditorManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LegacyHierarchicalLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.ZkLedgerAuditorManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.shade.org.apache.bookkeeper.replication.ReplicationException;
import org.apache.pulsar.shade.org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.KeeperException;
import org.apache.pulsar.shade.org.apache.zookeeper.data.ACL;

public class LegacyHierarchicalLedgerManagerFactory
extends AbstractZkLedgerManagerFactory {
    public static final String NAME = "legacyhierarchical";
    public static final int CUR_VERSION = 1;
    AbstractConfiguration conf;

    @Override
    public int getCurrentVersion() {
        return 1;
    }

    @Override
    public LedgerManagerFactory initialize(AbstractConfiguration conf, LayoutManager lm, int factoryVersion) throws IOException {
        Preconditions.checkArgument(lm instanceof ZkLayoutManager);
        ZkLayoutManager zkLayoutManager = (ZkLayoutManager)lm;
        if (1 != factoryVersion) {
            throw new IOException("Incompatible layout version found : " + factoryVersion);
        }
        this.conf = conf;
        this.zk = zkLayoutManager.getZk();
        return this;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        return new ZkLedgerIdGenerator(this.zk, ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf), "idgen", zkAcls);
    }

    @Override
    public LedgerAuditorManager newLedgerAuditorManager() {
        ServerConfiguration serverConfiguration = new ServerConfiguration(this.conf);
        return new ZkLedgerAuditorManager(this.zk, serverConfiguration, NullStatsLogger.INSTANCE);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new LegacyHierarchicalLedgerManager(this.conf, this.zk);
    }

    @Override
    public LedgerUnderreplicationManager newLedgerUnderreplicationManager() throws KeeperException, InterruptedException, ReplicationException.CompatibilityException {
        return new ZkLedgerUnderreplicationManager(this.conf, this.zk);
    }
}

