/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.meta;

import java.util.List;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.HierarchicalLedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LedgerManager;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LegacyHierarchicalLedgerManagerFactory;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.LongZkLedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.pulsar.shade.org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.shade.org.apache.zookeeper.data.ACL;

public class HierarchicalLedgerManagerFactory
extends LegacyHierarchicalLedgerManagerFactory {
    public static final String NAME = "hierarchical";

    @Override
    public LedgerIdGenerator newLedgerIdGenerator() {
        List<ACL> zkAcls = ZkUtils.getACLs(this.conf);
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath(this.conf);
        ZkLedgerIdGenerator subIdGenerator = new ZkLedgerIdGenerator(this.zk, zkLedgersRootPath, "idgen", zkAcls);
        return new LongZkLedgerIdGenerator(this.zk, zkLedgersRootPath, "idgen-long", subIdGenerator, zkAcls);
    }

    @Override
    public LedgerManager newLedgerManager() {
        return new HierarchicalLedgerManager(this.conf, this.zk);
    }
}

