/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.ProducerStats;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.shade.org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface Producer<T>
extends Closeable {
    public String getTopic();

    public String getProducerName();

    public MessageId send(T var1) throws PulsarClientException;

    public CompletableFuture<MessageId> sendAsync(T var1);

    public void flush() throws PulsarClientException;

    public CompletableFuture<Void> flushAsync();

    public TypedMessageBuilder<T> newMessage();

    public <V> TypedMessageBuilder<V> newMessage(Schema<V> var1);

    public TypedMessageBuilder<T> newMessage(Transaction var1);

    public long getLastSequenceId();

    public ProducerStats getStats();

    @Override
    public void close() throws PulsarClientException;

    public CompletableFuture<Void> closeAsync();

    public boolean isConnected();

    public long getLastDisconnectedTimestamp();

    public int getNumOfPartitions();
}

