/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.bookie.rackawareness;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.RackChangeNotifier;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.AbstractDNSToSwitchMapping;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieId;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieNode;
import org.apache.pulsar.shade.org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.pulsar.shade.org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.pulsar.shade.org.apache.commons.configuration.Configuration;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookieInfo;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieRackAffinityMapping
extends AbstractDNSToSwitchMapping
implements RackChangeNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(BookieRackAffinityMapping.class);
    public static final String BOOKIE_INFO_ROOT_PATH = "/bookies";
    public static final String METADATA_STORE_INSTANCE = "METADATA_STORE_INSTANCE";
    private MetadataCache<BookiesRackConfiguration> bookieMappingCache = null;
    private ITopologyAwareEnsemblePlacementPolicy<BookieNode> rackawarePolicy = null;
    private List<BookieId> bookieAddressListLastTime = new ArrayList<BookieId>();
    private volatile BookiesRackConfiguration racksWithHost = new BookiesRackConfiguration();
    private volatile Map<String, BookieInfo> bookieInfoMap = new HashMap<String, BookieInfo>();

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        Object storeProperty = conf.getProperty(METADATA_STORE_INSTANCE);
        if (storeProperty == null) {
            throw new RuntimeException("METADATA_STORE_INSTANCE configuration was not set in the BK client configuration");
        }
        if (!(storeProperty instanceof MetadataStore)) {
            throw new RuntimeException("METADATA_STORE_INSTANCE is not an instance of MetadataStore");
        }
        MetadataStore store = (MetadataStore)storeProperty;
        this.bookieMappingCache = store.getMetadataCache(BookiesRackConfiguration.class);
        this.bookieMappingCache.get(BOOKIE_INFO_ROOT_PATH).join();
        try {
            for (Map bookieMapping : (Collection)this.bookieMappingCache.get(BOOKIE_INFO_ROOT_PATH).get().map(Map::values).orElse(Collections.emptyList())) {
                for (String address : bookieMapping.keySet()) {
                    this.bookieAddressListLastTime.add(BookieId.parse(address));
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("BookieRackAffinityMapping init, bookieAddressListLastTime {}", this.bookieAddressListLastTime);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("METADATA_STORE_INSTANCE failed to init BookieId list");
        }
        store.registerListener(this::handleUpdates);
    }

    private void updateRacksWithHost(BookiesRackConfiguration racks) {
        BookiesRackConfiguration newRacksWithHost = new BookiesRackConfiguration();
        HashMap<String, BookieInfo> newBookieInfoMap = new HashMap<String, BookieInfo>();
        racks.forEach((group, bookies) -> bookies.forEach((addr, bi) -> {
            try {
                BookieId bookieId = BookieId.parse(addr);
                BookieAddressResolver addressResolver = this.getBookieAddressResolver();
                if (addressResolver == null) {
                    LOG.warn("Bookie address resolver not yet initialized, skipping resolution");
                } else {
                    BookieSocketAddress bsa = addressResolver.resolve(bookieId);
                    newRacksWithHost.updateBookie((String)group, bsa.toString(), (BookieInfo)bi);
                    String hostname = bsa.getSocketAddress().getHostName();
                    newBookieInfoMap.put(hostname, (BookieInfo)bi);
                    InetAddress address = bsa.getSocketAddress().getAddress();
                    if (null != address) {
                        String hostIp = address.getHostAddress();
                        if (null != hostIp) {
                            newBookieInfoMap.put(hostIp, (BookieInfo)bi);
                        }
                    } else {
                        LOG.info("Network address for {} is unresolvable yet.", addr);
                    }
                }
            }
            catch (BookieAddressResolver.BookieIdNotResolvedException e) {
                LOG.info("Network address for {} is unresolvable yet. error is {}", addr, (Object)e);
            }
        }));
        this.racksWithHost = newRacksWithHost;
        this.bookieInfoMap = newBookieInfoMap;
    }

    @Override
    public List<String> resolve(List<String> bookieAddressList) {
        ArrayList<String> racks = new ArrayList<String>(bookieAddressList.size());
        for (String bookieAddress : bookieAddressList) {
            racks.add(this.getRack(bookieAddress));
        }
        return racks;
    }

    private String getRack(String bookieAddress) {
        try {
            CompletableFuture<Optional<BookiesRackConfiguration>> future = this.bookieMappingCache.get(BOOKIE_INFO_ROOT_PATH);
            Optional<BookiesRackConfiguration> racks = future.isDone() && !future.isCompletedExceptionally() ? future.join() : Optional.empty();
            this.updateRacksWithHost(racks.orElseGet(BookiesRackConfiguration::new));
            if (!racks.isPresent()) {
                return null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        BookieInfo bi = this.bookieInfoMap.get(bookieAddress);
        if (bi == null) {
            Optional<BookieInfo> biOpt = this.racksWithHost.getBookie(bookieAddress);
            if (biOpt.isPresent()) {
                bi = biOpt.get();
            } else {
                this.updateRacksWithHost(this.racksWithHost);
                bi = this.bookieInfoMap.get(bookieAddress);
            }
        }
        if (bi != null && !StringUtils.isEmpty(bi.getRack()) && !bi.getRack().trim().equals("/")) {
            String rack = bi.getRack();
            if (!rack.startsWith("/")) {
                rack = "/" + rack;
            }
            return rack;
        }
        return null;
    }

    public String toString() {
        return "zk based bookie rack affinity mapping";
    }

    @Override
    public void reloadCachedMappings() {
    }

    private void handleUpdates(Notification n) {
        if (!n.getPath().equals(BOOKIE_INFO_ROOT_PATH)) {
            return;
        }
        if (this.rackawarePolicy != null) {
            this.bookieMappingCache.get(BOOKIE_INFO_ROOT_PATH).thenAccept(optVal -> {
                LOG.info("Bookie rack info updated to {}. Notifying rackaware policy.", optVal);
                ArrayList<BookieId> bookieAddressList = new ArrayList<BookieId>();
                for (Map bookieMapping : (Collection)optVal.map(Map::values).orElse(Collections.emptyList())) {
                    for (String addr : bookieMapping.keySet()) {
                        bookieAddressList.add(BookieId.parse(addr));
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bookies with rack update from {} to {}", this.bookieAddressListLastTime, bookieAddressList);
                }
                HashSet<BookieId> bookieIdSet = new HashSet<BookieId>(bookieAddressList);
                bookieIdSet.addAll(this.bookieAddressListLastTime);
                this.bookieAddressListLastTime = bookieAddressList;
                this.rackawarePolicy.onBookieRackChange(new ArrayList<BookieId>(bookieIdSet));
            });
        }
    }

    @Override
    public void registerRackChangeListener(ITopologyAwareEnsemblePlacementPolicy<BookieNode> rackawarePolicy) {
        this.rackawarePolicy = rackawarePolicy;
    }
}

