/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ExpiryQueue;
import org.apache.pulsar.shade.org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.pulsar.shade.org.apache.zookeeper.server.RateLogger;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerCnxn;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ServerMetrics;
import org.apache.pulsar.shade.org.apache.zookeeper.server.WorkerService;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.pulsar.shade.org.apache.zookeeper.server.ZooKeeperThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxnFactory
extends ServerCnxnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxnFactory.class);
    public static final String ZOOKEEPER_NIO_SESSIONLESS_CNXN_TIMEOUT = "zookeeper.nio.sessionlessCnxnTimeout";
    public static final String ZOOKEEPER_NIO_NUM_SELECTOR_THREADS = "zookeeper.nio.numSelectorThreads";
    public static final String ZOOKEEPER_NIO_NUM_WORKER_THREADS = "zookeeper.nio.numWorkerThreads";
    public static final String ZOOKEEPER_NIO_DIRECT_BUFFER_BYTES = "zookeeper.nio.directBufferBytes";
    public static final String ZOOKEEPER_NIO_SHUTDOWN_TIMEOUT = "zookeeper.nio.shutdownTimeout";
    ServerSocketChannel ss;
    private static final ThreadLocal<ByteBuffer> directBuffer;
    private final ConcurrentHashMap<InetAddress, Set<NIOServerCnxn>> ipMap = new ConcurrentHashMap();
    protected int maxClientCnxns = 60;
    int listenBacklog = -1;
    int sessionlessCnxnTimeout;
    private ExpiryQueue<NIOServerCnxn> cnxnExpiryQueue;
    protected WorkerService workerPool;
    private static int directBufferBytes;
    private int numSelectorThreads;
    private int numWorkerThreads;
    private long workerShutdownTimeoutMS;
    private volatile boolean stopped = true;
    private ConnectionExpirerThread expirerThread;
    private AcceptThread acceptThread;
    private final Set<SelectorThread> selectorThreads = new HashSet<SelectorThread>();

    public static ByteBuffer getDirectBuffer() {
        return directBufferBytes > 0 ? directBuffer.get() : null;
    }

    @Override
    public void configure(InetSocketAddress addr, int maxcc, int backlog, boolean secure) throws IOException {
        if (secure) {
            throw new UnsupportedOperationException("SSL isn't supported in NIOServerCnxn");
        }
        this.configureSaslLogin();
        this.maxClientCnxns = maxcc;
        this.initMaxCnxns();
        this.sessionlessCnxnTimeout = Integer.getInteger(ZOOKEEPER_NIO_SESSIONLESS_CNXN_TIMEOUT, 10000);
        this.cnxnExpiryQueue = new ExpiryQueue(this.sessionlessCnxnTimeout);
        this.expirerThread = new ConnectionExpirerThread();
        int numCores = Runtime.getRuntime().availableProcessors();
        this.numSelectorThreads = Integer.getInteger(ZOOKEEPER_NIO_NUM_SELECTOR_THREADS, Math.max((int)Math.sqrt((float)numCores / 2.0f), 1));
        if (this.numSelectorThreads < 1) {
            throw new IOException("numSelectorThreads must be at least 1");
        }
        this.numWorkerThreads = Integer.getInteger(ZOOKEEPER_NIO_NUM_WORKER_THREADS, 2 * numCores);
        this.workerShutdownTimeoutMS = Long.getLong(ZOOKEEPER_NIO_SHUTDOWN_TIMEOUT, 5000L);
        String logMsg = "Configuring NIO connection handler with " + this.sessionlessCnxnTimeout / 1000 + "s sessionless connection timeout, " + this.numSelectorThreads + " selector thread(s), " + (this.numWorkerThreads > 0 ? Integer.valueOf(this.numWorkerThreads) : "no") + " worker threads, and " + (directBufferBytes == 0 ? "gathered writes." : "" + directBufferBytes / 1024 + " kB direct buffers.");
        LOG.info(logMsg);
        for (int i = 0; i < this.numSelectorThreads; ++i) {
            this.selectorThreads.add(new SelectorThread(i));
        }
        this.listenBacklog = backlog;
        this.ss = ServerSocketChannel.open();
        this.ss.socket().setReuseAddress(true);
        LOG.info("binding to port {}", (Object)addr);
        if (this.listenBacklog == -1) {
            this.ss.socket().bind(addr);
        } else {
            this.ss.socket().bind(addr, this.listenBacklog);
        }
        this.ss.configureBlocking(false);
        this.acceptThread = new AcceptThread(this.ss, addr, this.selectorThreads);
    }

    private void tryClose(ServerSocketChannel s) {
        try {
            s.close();
        }
        catch (IOException sse) {
            LOG.error("Error while closing server socket.", (Throwable)sse);
        }
    }

    @Override
    public void reconfigure(InetSocketAddress addr) {
        ServerSocketChannel oldSS = this.ss;
        try {
            this.acceptThread.setReconfiguring();
            this.tryClose(oldSS);
            this.acceptThread.wakeupSelector();
            try {
                this.acceptThread.join();
            }
            catch (InterruptedException e) {
                LOG.error("Error joining old acceptThread when reconfiguring client port.", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.ss = ServerSocketChannel.open();
            this.ss.socket().setReuseAddress(true);
            LOG.info("binding to port {}", (Object)addr);
            this.ss.socket().bind(addr);
            this.ss.configureBlocking(false);
            this.acceptThread = new AcceptThread(this.ss, addr, this.selectorThreads);
            this.acceptThread.start();
        }
        catch (IOException e) {
            LOG.error("Error reconfiguring client port to {}", (Object)addr, (Object)e);
            this.tryClose(oldSS);
        }
    }

    @Override
    public int getMaxClientCnxnsPerHost() {
        return this.maxClientCnxns;
    }

    @Override
    public void setMaxClientCnxnsPerHost(int max) {
        this.maxClientCnxns = max;
    }

    @Override
    public int getSocketListenBacklog() {
        return this.listenBacklog;
    }

    @Override
    public void start() {
        this.stopped = false;
        if (this.workerPool == null) {
            this.workerPool = new WorkerService("NIOWorker", this.numWorkerThreads, false);
        }
        for (SelectorThread thread : this.selectorThreads) {
            if (thread.getState() != Thread.State.NEW) continue;
            thread.start();
        }
        if (this.acceptThread.getState() == Thread.State.NEW) {
            this.acceptThread.start();
        }
        if (this.expirerThread.getState() == Thread.State.NEW) {
            this.expirerThread.start();
        }
    }

    @Override
    public void startup(ZooKeeperServer zks, boolean startServer) throws IOException, InterruptedException {
        this.start();
        this.setZooKeeperServer(zks);
        if (startServer) {
            zks.startdata();
            zks.startup();
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.ss.socket().getLocalSocketAddress();
    }

    @Override
    public int getLocalPort() {
        return this.ss.socket().getLocalPort();
    }

    public boolean removeCnxn(NIOServerCnxn cnxn) {
        Set<NIOServerCnxn> set;
        if (!this.cnxns.remove(cnxn)) {
            return false;
        }
        this.cnxnExpiryQueue.remove(cnxn);
        this.removeCnxnFromSessionMap(cnxn);
        InetAddress addr = cnxn.getSocketAddress();
        if (addr != null && (set = this.ipMap.get(addr)) != null) {
            set.remove(cnxn);
        }
        this.unregisterConnection(cnxn);
        return true;
    }

    public void touchCnxn(NIOServerCnxn cnxn) {
        this.cnxnExpiryQueue.update(cnxn, cnxn.getSessionTimeout());
    }

    private void addCnxn(NIOServerCnxn cnxn) throws IOException {
        Set<NIOServerCnxn> existingSet;
        InetAddress addr = cnxn.getSocketAddress();
        if (addr == null) {
            throw new IOException("Socket of " + cnxn + " has been closed");
        }
        Set<NIOServerCnxn> set = this.ipMap.get(addr);
        if (set == null && (existingSet = this.ipMap.putIfAbsent(addr, set = Collections.newSetFromMap(new ConcurrentHashMap(2)))) != null) {
            set = existingSet;
        }
        set.add(cnxn);
        this.cnxns.add(cnxn);
        this.touchCnxn(cnxn);
    }

    protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk, SelectorThread selectorThread) throws IOException {
        return new NIOServerCnxn(this.zkServer, sock, sk, this, selectorThread);
    }

    private int getClientCnxnCount(InetAddress cl) {
        Set<NIOServerCnxn> s = this.ipMap.get(cl);
        if (s == null) {
            return 0;
        }
        return s.size();
    }

    @Override
    public void closeAll(ServerCnxn.DisconnectReason reason) {
        for (ServerCnxn cnxn : this.cnxns) {
            try {
                cnxn.close(reason);
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception closing cnxn session id 0x{}", (Object)Long.toHexString(cnxn.getSessionId()), (Object)e);
            }
        }
    }

    public void stop() {
        this.stopped = true;
        try {
            this.ss.close();
        }
        catch (IOException e) {
            LOG.warn("Error closing listen socket", (Throwable)e);
        }
        if (this.acceptThread != null) {
            if (this.acceptThread.isAlive()) {
                this.acceptThread.wakeupSelector();
            } else {
                this.acceptThread.closeSelector();
            }
        }
        if (this.expirerThread != null) {
            this.expirerThread.interrupt();
        }
        for (SelectorThread thread : this.selectorThreads) {
            if (thread.isAlive()) {
                thread.wakeupSelector();
                continue;
            }
            thread.closeSelector();
        }
        if (this.workerPool != null) {
            this.workerPool.stop();
        }
    }

    @Override
    public void shutdown() {
        try {
            this.stop();
            this.join();
            this.closeAll(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
            if (this.login != null) {
                this.login.shutdown();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Ignoring interrupted exception during shutdown", (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn("Ignoring unexpected exception during shutdown", (Throwable)e);
        }
        if (this.zkServer != null) {
            this.zkServer.shutdown();
        }
    }

    @Override
    public void join() throws InterruptedException {
        if (this.acceptThread != null) {
            this.acceptThread.join();
        }
        for (SelectorThread thread : this.selectorThreads) {
            thread.join();
        }
        if (this.workerPool != null) {
            this.workerPool.join(this.workerShutdownTimeoutMS);
        }
    }

    @Override
    public Iterable<ServerCnxn> getConnections() {
        return this.cnxns;
    }

    public void dumpConnections(PrintWriter pwriter) {
        pwriter.print("Connections ");
        this.cnxnExpiryQueue.dump(pwriter);
    }

    @Override
    public void resetAllConnectionStats() {
        for (ServerCnxn c : this.cnxns) {
            c.resetStats();
        }
    }

    @Override
    public Iterable<Map<String, Object>> getAllConnectionInfo(boolean brief) {
        HashSet<Map<String, Object>> info = new HashSet<Map<String, Object>>();
        for (ServerCnxn c : this.cnxns) {
            info.add(c.getConnectionInfo(brief));
        }
        return info;
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> LOG.error("Thread {} died", (Object)t, (Object)e));
        directBufferBytes = Integer.getInteger(ZOOKEEPER_NIO_DIRECT_BUFFER_BYTES, 65536);
        directBuffer = new ThreadLocal<ByteBuffer>(){

            @Override
            protected ByteBuffer initialValue() {
                return ByteBuffer.allocateDirect(directBufferBytes);
            }
        };
    }

    private class ConnectionExpirerThread
    extends ZooKeeperThread {
        ConnectionExpirerThread() {
            super("ConnnectionExpirer");
        }

        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped) {
                    long waitTime = NIOServerCnxnFactory.this.cnxnExpiryQueue.getWaitTime();
                    if (waitTime > 0L) {
                        Thread.sleep(waitTime);
                        continue;
                    }
                    for (NIOServerCnxn conn : NIOServerCnxnFactory.this.cnxnExpiryQueue.poll()) {
                        ServerMetrics.getMetrics().SESSIONLESS_CONNECTIONS_EXPIRED.add(1L);
                        conn.close(ServerCnxn.DisconnectReason.CONNECTION_EXPIRED);
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.info("ConnnectionExpirerThread interrupted");
            }
        }
    }

    private class IOWorkRequest
    extends WorkerService.WorkRequest {
        private final SelectorThread selectorThread;
        private final SelectionKey key;
        private final NIOServerCnxn cnxn;

        IOWorkRequest(SelectorThread selectorThread, SelectionKey key) {
            this.selectorThread = selectorThread;
            this.key = key;
            this.cnxn = (NIOServerCnxn)key.attachment();
        }

        @Override
        public void doWork() throws InterruptedException {
            if (!this.key.isValid()) {
                this.selectorThread.cleanupSelectionKey(this.key);
                return;
            }
            if (this.key.isReadable() || this.key.isWritable()) {
                this.cnxn.doIO(this.key);
                if (NIOServerCnxnFactory.this.stopped) {
                    this.cnxn.close(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
                    return;
                }
                if (!this.key.isValid()) {
                    this.selectorThread.cleanupSelectionKey(this.key);
                    return;
                }
                NIOServerCnxnFactory.this.touchCnxn(this.cnxn);
            }
            this.cnxn.enableSelectable();
            if (!this.selectorThread.addInterestOpsUpdateRequest(this.key)) {
                this.cnxn.close(ServerCnxn.DisconnectReason.CONNECTION_MODE_CHANGED);
            }
        }

        @Override
        public void cleanup() {
            this.cnxn.close(ServerCnxn.DisconnectReason.CLEAN_UP);
        }
    }

    public class SelectorThread
    extends AbstractSelectThread {
        private final int id;
        private final Queue<SocketChannel> acceptedQueue;
        private final Queue<SelectionKey> updateQueue;

        public SelectorThread(int id) throws IOException {
            super("NIOServerCxnFactory.SelectorThread-" + id);
            this.id = id;
            this.acceptedQueue = new LinkedBlockingQueue<SocketChannel>();
            this.updateQueue = new LinkedBlockingQueue<SelectionKey>();
        }

        public boolean addAcceptedConnection(SocketChannel accepted) {
            if (NIOServerCnxnFactory.this.stopped || !this.acceptedQueue.offer(accepted)) {
                return false;
            }
            this.wakeupSelector();
            return true;
        }

        public boolean addInterestOpsUpdateRequest(SelectionKey sk) {
            if (NIOServerCnxnFactory.this.stopped || !this.updateQueue.offer(sk)) {
                return false;
            }
            this.wakeupSelector();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SocketChannel accepted;
                while (!NIOServerCnxnFactory.this.stopped) {
                    try {
                        this.select();
                        this.processAcceptedConnections();
                        this.processInterestOpsUpdateRequests();
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Ignoring unexpected runtime exception", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.warn("Ignoring unexpected exception", (Throwable)e);
                    }
                }
                for (SelectionKey key : this.selector.keys()) {
                    NIOServerCnxn cnxn = (NIOServerCnxn)key.attachment();
                    if (cnxn.isSelectable()) {
                        cnxn.close(ServerCnxn.DisconnectReason.SERVER_SHUTDOWN);
                    }
                    this.cleanupSelectionKey(key);
                }
                while ((accepted = this.acceptedQueue.poll()) != null) {
                    this.fastCloseSock(accepted);
                }
                this.updateQueue.clear();
            }
            finally {
                this.closeSelector();
                NIOServerCnxnFactory.this.stop();
                LOG.info("selector thread exitted run method");
            }
        }

        private void select() {
            try {
                this.selector.select();
                Set<SelectionKey> selected = this.selector.selectedKeys();
                ArrayList<SelectionKey> selectedList = new ArrayList<SelectionKey>(selected);
                Collections.shuffle(selectedList);
                Iterator<SelectionKey> selectedKeys = selectedList.iterator();
                while (!NIOServerCnxnFactory.this.stopped && selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selected.remove(key);
                    if (!key.isValid()) {
                        this.cleanupSelectionKey(key);
                        continue;
                    }
                    if (key.isReadable() || key.isWritable()) {
                        this.handleIO(key);
                        continue;
                    }
                    LOG.warn("Unexpected ops in select {}", (Object)key.readyOps());
                }
            }
            catch (IOException e) {
                LOG.warn("Ignoring IOException while selecting", (Throwable)e);
            }
        }

        private void handleIO(SelectionKey key) {
            IOWorkRequest workRequest = new IOWorkRequest(this, key);
            NIOServerCnxn cnxn = (NIOServerCnxn)key.attachment();
            cnxn.disableSelectable();
            key.interestOps(0);
            NIOServerCnxnFactory.this.touchCnxn(cnxn);
            NIOServerCnxnFactory.this.workerPool.schedule(workRequest);
        }

        private void processAcceptedConnections() {
            SocketChannel accepted;
            while (!NIOServerCnxnFactory.this.stopped && (accepted = this.acceptedQueue.poll()) != null) {
                SelectionKey key = null;
                try {
                    key = accepted.register(this.selector, 1);
                    NIOServerCnxn cnxn = NIOServerCnxnFactory.this.createConnection(accepted, key, this);
                    key.attach(cnxn);
                    NIOServerCnxnFactory.this.addCnxn(cnxn);
                }
                catch (IOException e) {
                    this.cleanupSelectionKey(key);
                    this.fastCloseSock(accepted);
                }
            }
        }

        private void processInterestOpsUpdateRequests() {
            SelectionKey key;
            while (!NIOServerCnxnFactory.this.stopped && (key = this.updateQueue.poll()) != null) {
                NIOServerCnxn cnxn;
                if (!key.isValid()) {
                    this.cleanupSelectionKey(key);
                }
                if (!(cnxn = (NIOServerCnxn)key.attachment()).isSelectable()) continue;
                key.interestOps(cnxn.getInterestOps());
            }
        }
    }

    private class AcceptThread
    extends AbstractSelectThread {
        private final ServerSocketChannel acceptSocket;
        private final SelectionKey acceptKey;
        private final RateLogger acceptErrorLogger;
        private final Collection<SelectorThread> selectorThreads;
        private Iterator<SelectorThread> selectorIterator;
        private volatile boolean reconfiguring;

        public AcceptThread(ServerSocketChannel ss, InetSocketAddress addr, Set<SelectorThread> selectorThreads) throws IOException {
            super("NIOServerCxnFactory.AcceptThread:" + addr);
            this.acceptErrorLogger = new RateLogger(LOG);
            this.reconfiguring = false;
            this.acceptSocket = ss;
            this.acceptKey = this.acceptSocket.register(this.selector, 16);
            this.selectorThreads = Collections.unmodifiableList(new ArrayList<SelectorThread>(selectorThreads));
            this.selectorIterator = this.selectorThreads.iterator();
        }

        @Override
        public void run() {
            try {
                while (!NIOServerCnxnFactory.this.stopped && !this.acceptSocket.socket().isClosed()) {
                    try {
                        this.select();
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Ignoring unexpected runtime exception", (Throwable)e);
                    }
                    catch (Exception e) {
                        LOG.warn("Ignoring unexpected exception", (Throwable)e);
                    }
                }
            }
            finally {
                this.closeSelector();
                if (!this.reconfiguring) {
                    NIOServerCnxnFactory.this.stop();
                }
                LOG.info("accept thread exitted run method");
            }
        }

        public void setReconfiguring() {
            this.reconfiguring = true;
        }

        private void select() {
            try {
                this.selector.select();
                Iterator<SelectionKey> selectedKeys = this.selector.selectedKeys().iterator();
                while (!NIOServerCnxnFactory.this.stopped && selectedKeys.hasNext()) {
                    SelectionKey key = selectedKeys.next();
                    selectedKeys.remove();
                    if (!key.isValid()) continue;
                    if (key.isAcceptable()) {
                        if (this.doAccept()) continue;
                        this.pauseAccept(10L);
                        continue;
                    }
                    LOG.warn("Unexpected ops in accept select {}", (Object)key.readyOps());
                }
            }
            catch (IOException e) {
                LOG.warn("Ignoring IOException while selecting", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pauseAccept(long millisecs) {
            this.acceptKey.interestOps(0);
            try {
                this.selector.select(millisecs);
            }
            catch (IOException iOException) {
            }
            finally {
                this.acceptKey.interestOps(16);
            }
        }

        private boolean doAccept() {
            boolean accepted = false;
            SocketChannel sc = null;
            try {
                SelectorThread selectorThread;
                sc = this.acceptSocket.accept();
                accepted = true;
                if (NIOServerCnxnFactory.this.limitTotalNumberOfCnxns()) {
                    throw new IOException("Too many connections max allowed is " + NIOServerCnxnFactory.this.maxCnxns);
                }
                InetAddress ia = sc.socket().getInetAddress();
                int cnxncount = NIOServerCnxnFactory.this.getClientCnxnCount(ia);
                if (NIOServerCnxnFactory.this.maxClientCnxns > 0 && cnxncount >= NIOServerCnxnFactory.this.maxClientCnxns) {
                    throw new IOException("Too many connections from " + ia + " - max is " + NIOServerCnxnFactory.this.maxClientCnxns);
                }
                LOG.debug("Accepted socket connection from {}", (Object)sc.socket().getRemoteSocketAddress());
                sc.configureBlocking(false);
                if (!this.selectorIterator.hasNext()) {
                    this.selectorIterator = this.selectorThreads.iterator();
                }
                if (!(selectorThread = this.selectorIterator.next()).addAcceptedConnection(sc)) {
                    throw new IOException("Unable to add connection to selector queue" + (NIOServerCnxnFactory.this.stopped ? " (shutdown in progress)" : ""));
                }
                this.acceptErrorLogger.flush();
            }
            catch (IOException e) {
                ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
                this.acceptErrorLogger.rateLimitLog("Error accepting new connection: " + e.getMessage());
                this.fastCloseSock(sc);
            }
            return accepted;
        }
    }

    private abstract class AbstractSelectThread
    extends ZooKeeperThread {
        protected final Selector selector;

        public AbstractSelectThread(String name) throws IOException {
            super(name);
            this.setDaemon(true);
            this.selector = Selector.open();
        }

        public void wakeupSelector() {
            this.selector.wakeup();
        }

        protected void closeSelector() {
            try {
                this.selector.close();
            }
            catch (IOException e) {
                LOG.warn("ignored exception during selector close.", (Throwable)e);
            }
        }

        protected void cleanupSelectionKey(SelectionKey key) {
            if (key != null) {
                try {
                    key.cancel();
                }
                catch (Exception ex) {
                    LOG.debug("ignoring exception during selectionkey cancel", (Throwable)ex);
                }
            }
        }

        protected void fastCloseSock(SocketChannel sc) {
            if (sc != null) {
                try {
                    sc.socket().setSoLinger(true, 0);
                }
                catch (SocketException e) {
                    LOG.warn("Unable to set socket linger to 0, socket close may stall in CLOSE_WAIT", (Throwable)e);
                }
                NIOServerCnxn.closeSock(sc);
            }
        }
    }
}

