/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.bookie;

import java.io.Closeable;
import java.io.IOException;
import java.util.PrimitiveIterator;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.BookieException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.LedgerEntryPage;
import org.apache.pulsar.shade.org.apache.bookkeeper.common.util.Watcher;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.bookie.FormatUtil;

public interface LedgerCache
extends Closeable {
    public boolean setFenced(long var1) throws IOException;

    public boolean isFenced(long var1) throws IOException;

    public void setMasterKey(long var1, byte[] var3) throws IOException;

    public byte[] readMasterKey(long var1) throws IOException, BookieException;

    public boolean ledgerExists(long var1) throws IOException;

    public void putEntryOffset(long var1, long var3, long var5) throws IOException;

    public long getEntryOffset(long var1, long var3) throws IOException;

    public void flushLedger(boolean var1) throws IOException;

    public long getLastEntry(long var1) throws IOException;

    public Long getLastAddConfirmed(long var1) throws IOException;

    public long updateLastAddConfirmed(long var1, long var3) throws IOException;

    public boolean waitForLastAddConfirmedUpdate(long var1, long var3, Watcher<LastAddConfirmedUpdateNotification> var5) throws IOException;

    public void cancelWaitForLastAddConfirmedUpdate(long var1, Watcher<LastAddConfirmedUpdateNotification> var3) throws IOException;

    public void deleteLedger(long var1) throws IOException;

    public void setExplicitLac(long var1, ByteBuf var3) throws IOException;

    public ByteBuf getExplicitLac(long var1);

    public PageEntriesIterable listEntries(long var1) throws IOException;

    public PrimitiveIterator.OfLong getEntriesIterator(long var1) throws IOException;

    public LedgerIndexMetadata readLedgerIndexMetadata(long var1) throws IOException;

    public static class LedgerIndexMetadata {
        public final byte[] masterKey;
        public final long size;
        public final boolean fenced;

        LedgerIndexMetadata(byte[] masterKey, long size, boolean fenced) {
            this.masterKey = masterKey;
            this.size = size;
            this.fenced = fenced;
        }

        public String getMasterKeyHex() {
            if (null == this.masterKey) {
                return "NULL";
            }
            return FormatUtil.bytes2Hex(this.masterKey);
        }
    }

    public static interface PageEntriesIterable
    extends AutoCloseable,
    Iterable<PageEntries> {
    }

    public static interface PageEntries {
        public LedgerEntryPage getLEP() throws IOException;

        public long getFirstEntry();

        public long getLastEntry();
    }

    public static class NoIndexForLedgerException
    extends IOException {
        NoIndexForLedgerException(String reason, Exception cause) {
            super(reason, cause);
        }
    }
}

