/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils.functions;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.apache.pulsar.functions.api.Function;
import org.apache.pulsar.functions.utils.Exceptions;
import org.apache.pulsar.functions.utils.functions.Functions;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionUtils {
    private static final Logger log = LoggerFactory.getLogger(FunctionUtils.class);
    private static final String PULSAR_IO_SERVICE_NAME = "pulsar-io.yaml";

    public static String getFunctionClass(ClassLoader classLoader) throws IOException {
        NarClassLoader ncl = (NarClassLoader)classLoader;
        String configStr = ncl.getServiceDefinition(PULSAR_IO_SERVICE_NAME);
        FunctionDefinition conf = ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, FunctionDefinition.class);
        if (StringUtils.isEmpty(conf.getFunctionClass())) {
            throw new IOException(String.format("The '%s' functionctor does not provide a function implementation", conf.getName()));
        }
        try {
            Class<?> functionClass = ncl.loadClass(conf.getFunctionClass());
            if (!Function.class.isAssignableFrom(functionClass)) {
                throw new IOException("Class " + conf.getFunctionClass() + " does not implement interface " + Function.class.getName());
            }
        }
        catch (Throwable t) {
            Exceptions.rethrowIOException(t);
        }
        return conf.getFunctionClass();
    }

    public static FunctionDefinition getFunctionDefinition(String narPath) throws IOException {
        try (NarClassLoader ncl = NarClassLoaderBuilder.builder().narFile(new File(narPath)).build();){
            String configStr = ncl.getServiceDefinition(PULSAR_IO_SERVICE_NAME);
            FunctionDefinition functionDefinition = ObjectMapperFactory.getThreadLocalYaml().readValue(configStr, FunctionDefinition.class);
            return functionDefinition;
        }
    }

    public static Functions searchForFunctions(String functionsDirectory) throws IOException {
        return FunctionUtils.searchForFunctions(functionsDirectory, false);
    }

    public static Functions searchForFunctions(String functionsDirectory, boolean alwaysPopulatePath) throws IOException {
        Path path = Paths.get(functionsDirectory, new String[0]).toAbsolutePath();
        log.info("Searching for functions in {}", (Object)path);
        Functions functions = new Functions();
        if (!path.toFile().exists()) {
            log.warn("Functions archive directory not found");
            return functions;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.nar");){
            for (Path archive : stream) {
                try {
                    FunctionDefinition cntDef = FunctionUtils.getFunctionDefinition(archive.toString());
                    log.info("Found function {} from {}", (Object)cntDef, (Object)archive);
                    log.error(cntDef.getName());
                    log.error(cntDef.getFunctionClass());
                    if (alwaysPopulatePath || !StringUtils.isEmpty(cntDef.getFunctionClass())) {
                        functions.functions.put(cntDef.getName(), archive);
                    }
                    functions.functionsDefinitions.add(cntDef);
                }
                catch (Throwable t) {
                    log.warn("Failed to load function from {}", (Object)archive, (Object)t);
                }
            }
        }
        Collections.sort(functions.functionsDefinitions, (c1, c2) -> String.CASE_INSENSITIVE_ORDER.compare(c1.getName(), c2.getName()));
        return functions;
    }

    private FunctionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

