/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import org.apache.pulsar.broker.service.TransactionBufferSnapshotService;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.broker.systopic.TransactionBufferSystemTopicClient;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.shade.org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.shade.org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceEventsSystemTopicFactory {
    private final PulsarClient client;
    private static final Logger log = LoggerFactory.getLogger(NamespaceEventsSystemTopicFactory.class);

    public NamespaceEventsSystemTopicFactory(PulsarClient client) {
        this.client = client;
    }

    public TopicPoliciesSystemTopicClient createTopicPoliciesSystemTopicClient(NamespaceName namespaceName) {
        TopicName topicName = TopicName.get("persistent", namespaceName, "__change_events");
        log.info("Create topic policies system topic client {}", (Object)topicName.toString());
        return new TopicPoliciesSystemTopicClient(this.client, topicName);
    }

    public TransactionBufferSystemTopicClient createTransactionBufferSystemTopicClient(NamespaceName namespaceName, TransactionBufferSnapshotService transactionBufferSnapshotService) {
        TopicName topicName = TopicName.get("persistent", namespaceName, "__transaction_buffer_snapshot");
        log.info("Create transaction buffer snapshot client, topicName : {}", (Object)topicName.toString());
        return new TransactionBufferSystemTopicClient(this.client, topicName, transactionBufferSnapshotService);
    }

    public static TopicName getSystemTopicName(NamespaceName namespaceName, EventType eventType) {
        switch (eventType) {
            case TOPIC_POLICY: {
                return TopicName.get("persistent", namespaceName, "__change_events");
            }
            case TRANSACTION_BUFFER_SNAPSHOT: {
                return TopicName.get("persistent", namespaceName, "__transaction_buffer_snapshot");
            }
        }
        return null;
    }
}

