/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.resource.usage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.broker.service.resource.usage.LightProtoCodec;
import org.apache.pulsar.broker.service.resource.usage.ResourceUsage;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;

public final class ResourceUsageInfo {
    private String broker;
    private int _brokerBufferIdx = -1;
    private int _brokerBufferLen = -1;
    private static final int _BROKER_FIELD_NUMBER = 1;
    private static final int _BROKER_TAG = 10;
    private static final int _BROKER_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private static final int _BROKER_MASK = 1;
    private List<ResourceUsage> usageMaps = null;
    private int _usageMapsCount = 0;
    private static final int _USAGE_MAP_FIELD_NUMBER = 2;
    private static final int _USAGE_MAP_TAG = 18;
    private static final int _USAGE_MAP_TAG_SIZE = LightProtoCodec.computeVarIntSize(18);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 1;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public boolean hasBroker() {
        return (this._bitField0 & 1) != 0;
    }

    public String getBroker() {
        if (!this.hasBroker()) {
            throw new IllegalStateException("Field 'broker' is not set");
        }
        if (this.broker == null) {
            this.broker = LightProtoCodec.readString(this._parsedBuffer, this._brokerBufferIdx, this._brokerBufferLen);
        }
        return this.broker;
    }

    public ResourceUsageInfo setBroker(String broker) {
        this.broker = broker;
        this._bitField0 |= 1;
        this._brokerBufferIdx = -1;
        this._brokerBufferLen = LightProtoCodec.computeStringUTF8Size(broker);
        this._cachedSize = -1;
        return this;
    }

    public ResourceUsageInfo clearBroker() {
        this._bitField0 &= 0xFFFFFFFE;
        this.broker = null;
        this._brokerBufferIdx = -1;
        this._brokerBufferLen = -1;
        return this;
    }

    public int getUsageMapsCount() {
        return this._usageMapsCount;
    }

    public ResourceUsage getUsageMapAt(int idx) {
        if (idx < 0 || idx >= this._usageMapsCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._usageMapsCount + ") for field 'usageMap'");
        }
        return this.usageMaps.get(idx);
    }

    public List<ResourceUsage> getUsageMapsList() {
        if (this._usageMapsCount == 0) {
            return Collections.emptyList();
        }
        return this.usageMaps.subList(0, this._usageMapsCount);
    }

    public ResourceUsage addUsageMap() {
        if (this.usageMaps == null) {
            this.usageMaps = new ArrayList<ResourceUsage>();
        }
        if (this.usageMaps.size() == this._usageMapsCount) {
            this.usageMaps.add(new ResourceUsage());
        }
        this._cachedSize = -1;
        return this.usageMaps.get(this._usageMapsCount++);
    }

    public ResourceUsageInfo addAllUsageMaps(Iterable<ResourceUsage> usageMaps) {
        for (ResourceUsage _o : usageMaps) {
            this.addUsageMap().copyFrom(_o);
        }
        return this;
    }

    public ResourceUsageInfo clearUsageMap() {
        for (int i = 0; i < this._usageMapsCount; ++i) {
            this.usageMaps.get(i).clear();
        }
        this._usageMapsCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        this.checkRequiredFields();
        int _writeIdx = _b.writerIndex();
        LightProtoCodec.writeVarInt(_b, 10);
        LightProtoCodec.writeVarInt(_b, this._brokerBufferLen);
        if (this._brokerBufferIdx == -1) {
            LightProtoCodec.writeString(_b, this.broker, this._brokerBufferLen);
        } else {
            this._parsedBuffer.getBytes(this._brokerBufferIdx, _b, this._brokerBufferLen);
        }
        for (int i = 0; i < this._usageMapsCount; ++i) {
            ResourceUsage _item = this.usageMaps.get(i);
            LightProtoCodec.writeVarInt(_b, 18);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        _size += _BROKER_TAG_SIZE;
        _size += LightProtoCodec.computeVarIntSize(this._brokerBufferLen);
        _size += this._brokerBufferLen;
        for (int i = 0; i < this._usageMapsCount; ++i) {
            ResourceUsage _item = this.usageMaps.get(i);
            _size += _USAGE_MAP_TAG_SIZE;
            int MsgsizeUsageMap = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeUsageMap) + MsgsizeUsageMap;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block4: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    this._bitField0 |= 1;
                    this._brokerBufferLen = LightProtoCodec.readVarInt(_buffer);
                    this._brokerBufferIdx = _buffer.readerIndex();
                    _buffer.skipBytes(this._brokerBufferLen);
                    continue block4;
                }
                case 18: {
                    int _usageMapSize = LightProtoCodec.readVarInt(_buffer);
                    this.addUsageMap().parseFrom(_buffer, _usageMapSize);
                    continue block4;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this.checkRequiredFields();
        this._parsedBuffer = _buffer;
    }

    private void checkRequiredFields() {
        if ((this._bitField0 & 1) != 1) {
            throw new IllegalStateException("Some required fields are missing");
        }
    }

    public ResourceUsageInfo clear() {
        this.broker = null;
        this._brokerBufferIdx = -1;
        this._brokerBufferLen = -1;
        for (int i = 0; i < this._usageMapsCount; ++i) {
            this.usageMaps.get(i).clear();
        }
        this._usageMapsCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public ResourceUsageInfo copyFrom(ResourceUsageInfo _other) {
        this._cachedSize = -1;
        if (_other.hasBroker()) {
            this.setBroker(_other.getBroker());
        }
        for (int i = 0; i < _other.getUsageMapsCount(); ++i) {
            this.addUsageMap().copyFrom(_other.getUsageMapAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer(a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer(a);
        this.parseFrom(b, b.readableBytes());
    }
}

