/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v2;

import org.apache.pulsar.broker.admin.impl.SchemasResourceBase;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.io.swagger.annotations.Api;
import org.apache.pulsar.shade.io.swagger.annotations.ApiOperation;
import org.apache.pulsar.shade.io.swagger.annotations.ApiParam;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponse;
import org.apache.pulsar.shade.io.swagger.annotations.ApiResponses;
import org.apache.pulsar.shade.io.swagger.annotations.Example;
import org.apache.pulsar.shade.io.swagger.annotations.ExampleProperty;
import org.apache.pulsar.shade.javax.ws.rs.Consumes;
import org.apache.pulsar.shade.javax.ws.rs.DELETE;
import org.apache.pulsar.shade.javax.ws.rs.DefaultValue;
import org.apache.pulsar.shade.javax.ws.rs.Encoded;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.POST;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.PathParam;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.QueryParam;
import org.apache.pulsar.shade.javax.ws.rs.container.AsyncResponse;
import org.apache.pulsar.shade.javax.ws.rs.container.Suspended;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.IsCompatibilityResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.shade.org.apache.pulsar.common.protocol.schema.PostSchemaResponse;
import org.apache.pulsar.shade.org.apache.pulsar.common.schema.LongSchemaVersion;

@Path(value="/schemas")
@Api(value="/schemas", description="Schemas related admin APIs", tags={"schemas"})
public class SchemasResource
extends SchemasResourceBase {
    @VisibleForTesting
    public SchemasResource() {
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the schema of a topic", response=GetSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.getSchema(authoritative, response);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schema/{version}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the schema of a topic at a given version", response=GetSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @PathParam(value="version") @Encoded String version, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.getSchema(authoritative, version, response);
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{topic}/schemas")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the all schemas of a topic", response=GetAllVersionsSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist; or Schema is not found for this topic"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getAllSchemas(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.getAllSchemas(authoritative, response);
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the schema of a topic", response=DeleteSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void deleteSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.deleteSchema(authoritative, response);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/schema")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update the schema of a topic", response=PostSchemaResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=409, message="Incompatible schema"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=422, message="Invalid schema data"), @ApiResponse(code=500, message="Internal Server Error")})
    public void postSchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.postSchema(payload, authoritative, response);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/compatibility")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="test the schema compatibility", response=IsCompatibilityResponse.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=500, message="Internal Server Error")})
    public void testCompatibility(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.testCompatibility(payload, authoritative, response);
    }

    @POST
    @Path(value="/{tenant}/{namespace}/{topic}/version")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="get the version of the schema", response=LongSchemaVersion.class)
    @ApiResponses(value={@ApiResponse(code=307, message="Current broker doesn't serve the namespace of this topic"), @ApiResponse(code=401, message="Client is not authorized or Don't have admin permission"), @ApiResponse(code=403, message="Client is not authenticated"), @ApiResponse(code=404, message="Tenant or Namespace or Topic doesn't exist"), @ApiResponse(code=412, message="Failed to find the ownership for the topic"), @ApiResponse(code=422, message="Invalid schema data"), @ApiResponse(code=500, message="Internal Server Error")})
    public void getVersionBySchema(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="topic") String topic, @ApiParam(value="A JSON value presenting a schema playload. An example of the expected schema can be found down here.", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\"type\": \"STRING\", \"schema\": \"\", \"properties\": { \"key1\" : \"value1\" + } }")})) PostSchemaPayload payload, @QueryParam(value="authoritative") @DefaultValue(value="false") boolean authoritative, @Suspended AsyncResponse response) {
        this.validateTopicName(tenant, namespace, topic);
        this.getVersionBySchema(payload, authoritative, response);
    }
}

