/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.MetadataSessionExpiredPolicy;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Sets;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.apache.pulsar.shade.org.apache.bookkeeper.client.api.DigestType;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.Category;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.shade.org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.shade.org.apache.pulsar.common.policies.data.TopicType;

public class ServiceConfiguration
implements PulsarConfiguration {
    @Category
    private static final String CATEGORY_SERVER = "Server";
    @Category
    private static final String CATEGORY_PROTOCOLS = "Protocols";
    @Category
    private static final String CATEGORY_STORAGE_BK = "Storage (BookKeeper)";
    @Category
    private static final String CATEGORY_STORAGE_ML = "Storage (Managed Ledger)";
    @Category
    private static final String CATEGORY_STORAGE_OFFLOADING = "Storage (Ledger Offloading)";
    @Category
    private static final String CATEGORY_POLICIES = "Policies";
    @Category
    private static final String CATEGORY_WEBSOCKET = "WebSocket";
    @Category
    private static final String CATEGORY_SCHEMA = "Schema";
    @Category
    private static final String CATEGORY_METRICS = "Metrics";
    @Category
    private static final String CATEGORY_REPLICATION = "Replication";
    @Category
    private static final String CATEGORY_LOAD_BALANCER = "Load Balancer";
    @Category
    private static final String CATEGORY_FUNCTIONS = "Functions";
    @Category
    private static final String CATEGORY_TLS = "TLS";
    @Category
    private static final String CATEGORY_KEYSTORE_TLS = "KeyStoreTLS";
    @Category
    private static final String CATEGORY_AUTHENTICATION = "Authentication";
    @Category
    private static final String CATEGORY_AUTHORIZATION = "Authorization";
    @Category
    private static final String CATEGORY_TOKEN_AUTH = "Token Authentication Provider";
    @Category
    private static final String CATEGORY_SASL_AUTH = "SASL Authentication Provider";
    @Category
    private static final String CATEGORY_HTTP = "HTTP";
    @Category
    private static final String CATEGORY_TRANSACTION = "Transaction";
    @Category
    private static final String CATEGORY_PACKAGES_MANAGEMENT = "Packages Management";
    @Category
    private static final String CATEGORY_PLUGIN = "Broker Plugin";
    @FieldContext(category="Server", required=false, deprecated=true, doc="The Zookeeper quorum connection string (as a comma-separated list). Deprecated in favour of metadataStoreUrl")
    @Deprecated
    private String zookeeperServers;
    @FieldContext(category="Server", required=false, doc="The metadata store URL. \n Examples: \n  * zk:my-zk-1:2181,my-zk-2:2181,my-zk-3:2181\n  * my-zk-1:2181,my-zk-2:2181,my-zk-3:2181 (will default to ZooKeeper when the schema is not specified)\n  * zk:my-zk-1:2181,my-zk-2:2181,my-zk-3:2181/my-chroot-path (to add a ZK chroot path)\n")
    private String metadataStoreUrl;
    @FieldContext(category="Server", required=false, deprecated=true, doc="Global Zookeeper quorum connection string (as a comma-separated list). Deprecated in favor of using `configurationStoreServers`")
    @Deprecated
    private String globalZookeeperServers;
    @FieldContext(category="Server", required=false, deprecated=true, doc="Configuration store connection string (as a comma-separated list)")
    @Deprecated
    private String configurationStoreServers;
    @FieldContext(category="Server", required=false, doc="The metadata store URL for the configuration data. If empty, we fall back to use metadataStoreUrl")
    private String configurationMetadataStoreUrl;
    @FieldContext(category="Server", doc="The port for serving binary protobuf requests. If set, defines a server binding for bindAddress:brokerServicePort. The Default value is 6650.")
    private Optional<Integer> brokerServicePort = Optional.of(6650);
    @FieldContext(category="Server", doc="The port for serving TLS-secured binary protobuf requests. If set, defines a server binding for bindAddress:brokerServicePortTls.")
    private Optional<Integer> brokerServicePortTls = Optional.empty();
    @FieldContext(category="Server", doc="The port for serving http requests")
    private Optional<Integer> webServicePort = Optional.of(8080);
    @FieldContext(category="Server", doc="The port for serving https requests")
    private Optional<Integer> webServicePortTls = Optional.empty();
    @FieldContext(category="TLS", doc="Specify the tls protocols the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLSv1.3, TLSv1.2]")
    private Set<String> webServiceTlsProtocols = new TreeSet<String>();
    @FieldContext(category="TLS", doc="Specify the tls cipher the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> webServiceTlsCiphers = new TreeSet<String>();
    @FieldContext(category="Server", doc="Hostname or IP address the service binds on")
    private String bindAddress = "0.0.0.0";
    @FieldContext(category="Server", doc="Hostname or IP address the service advertises to the outside world. If not set, the value of `InetAddress.getLocalHost().getHostname()` is used.")
    private String advertisedAddress;
    @FieldContext(category="Server", doc="Used to specify multiple advertised listeners for the broker. The value must format as <listener_name>:pulsar://<host>:<port>,multiple listeners should separate with commas.Do not use this configuration with advertisedAddress and brokerServicePort.The Default value is absent means use advertisedAddress and brokerServicePort.")
    private String advertisedListeners;
    @FieldContext(category="Server", doc="Used to specify the internal listener name for the broker.The listener name must contain in the advertisedListeners.The Default value is absent, the broker uses the first listener as the internal listener.")
    private String internalListenerName;
    @FieldContext(category="Server", doc="Used to specify additional bind addresses for the broker. The value must format as <listener_name>:<scheme>://<host>:<port>, multiple bind addresses should be separated with commas. Associates each bind address with an advertised listener and protocol handler. Note that the brokerServicePort, brokerServicePortTls, webServicePort, and webServicePortTls properties define additional bindings.")
    private String bindAddresses;
    @FieldContext(category="Server", doc="Enable or disable the proxy protocol.")
    private boolean haProxyProtocolEnabled;
    @FieldContext(category="Server", doc="Number of threads to use for Netty Acceptor. Default is set to `1`")
    private int numAcceptorThreads = 1;
    @FieldContext(category="Server", doc="Number of threads to use for Netty IO. Default is set to `2 * Runtime.getRuntime().availableProcessors()`")
    private int numIOThreads = 2 * Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Server", doc="Number of threads to use for orderedExecutor. The ordered executor is used to operate with zookeeper, such as init zookeeper client, get namespace policies from zookeeper etc. It also used to split bundle. Default is 8")
    private int numOrderedExecutorThreads = 8;
    @FieldContext(category="Server", doc="Number of threads to use for HTTP requests processing Default is set to `2 * Runtime.getRuntime().availableProcessors()`")
    private int numHttpServerThreads = Math.max(8, 2 * Runtime.getRuntime().availableProcessors());
    @FieldContext(category="Server", doc="Number of threads to use for pulsar broker service. The executor in thread pool will do basic broker operation like load/unload bundle, update managedLedgerConfig, update topic/subscription/replicator message dispatch rate, do leader election etc. Default is set to 20 ")
    private int numExecutorThreadPoolSize = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Server", doc="Number of thread pool size to use for pulsar zookeeper callback service.The cache executor thread pool is used for restarting global zookeeper session. Default is 10")
    private int numCacheExecutorThreadPoolSize = 10;
    @FieldContext(category="Server", doc="Option to enable busy-wait settings. Default is false. WARNING: This option will enable spin-waiting on executors and IO threads in order to reduce latency during context switches. The spinning will consume 100% CPU even when the broker is not doing any work. It is recommended to reduce the number of IO threads and BK client threads to only have few CPU cores busy.")
    private boolean enableBusyWait = false;
    @FieldContext(category="Server", doc="Max concurrent web requests")
    private int maxConcurrentHttpRequests = 1024;
    @FieldContext(category="Server", doc="Whether to enable the delayed delivery for messages.")
    private boolean delayedDeliveryEnabled = true;
    @FieldContext(category="Server", doc="Class name of the factory that implements the delayed deliver tracker")
    private String delayedDeliveryTrackerFactoryClassName = "org.apache.pulsar.broker.delayed.InMemoryDelayedDeliveryTrackerFactory";
    @FieldContext(category="Server", doc="Control the tick time for when retrying on delayed delivery,  affecting the accuracy of the delivery time compared to the scheduled time. Default is 1 second.")
    private long delayedDeliveryTickTimeMillis = 1000L;
    @FieldContext(category="Server", doc="Whether to enable the acknowledge of batch local index")
    private boolean acknowledgmentAtBatchIndexLevelEnabled = false;
    @FieldContext(category="WebSocket", doc="Enable the WebSocket API service in broker")
    private boolean webSocketServiceEnabled = false;
    @FieldContext(category="WebSocket", doc="Flag indicates whether to run broker in standalone mode")
    private boolean isRunningStandalone = false;
    @FieldContext(category="Server", required=true, doc="Name of the cluster to which this broker belongs to")
    private String clusterName;
    @FieldContext(category="Server", dynamic=true, doc="The maximum number of tenants that each pulsar cluster can create.This configuration is not precise control, in a concurrent scenario, the threshold will be exceeded.")
    private int maxTenants = 0;
    @FieldContext(category="Server", dynamic=true, doc="Enable cluster's failure-domain which can distribute brokers into logical region")
    private boolean failureDomainsEnabled = false;
    @FieldContext(category="Server", doc="Metadata store session timeout in milliseconds.")
    private long metadataStoreSessionTimeoutMillis = 30000L;
    @FieldContext(category="Server", doc="Metadata store operation timeout in seconds.")
    private int metadataStoreOperationTimeoutSeconds = 30;
    @FieldContext(category="Server", doc="Metadata store cache expiry time in seconds.")
    private int metadataStoreCacheExpirySeconds = 300;
    @Deprecated
    @FieldContext(category="Server", deprecated=true, doc="ZooKeeper session timeout in milliseconds. @deprecated - Use metadataStoreSessionTimeoutMillis instead.")
    private long zooKeeperSessionTimeoutMillis = -1L;
    @Deprecated
    @FieldContext(category="Server", deprecated=true, doc="ZooKeeper operation timeout in seconds. @deprecated - Use metadataStoreOperationTimeoutSeconds instead.")
    private int zooKeeperOperationTimeoutSeconds = -1;
    @Deprecated
    @FieldContext(category="Server", deprecated=true, doc="ZooKeeper cache expiry time in seconds. @deprecated - Use metadataStoreCacheExpirySeconds instead.")
    private int zooKeeperCacheExpirySeconds = -1;
    @FieldContext(category="Server", dynamic=true, doc="Time to wait for broker graceful shutdown. After this time elapses, the process will be killed")
    private long brokerShutdownTimeoutMs = 60000L;
    @FieldContext(category="Server", dynamic=true, doc="Flag to skip broker shutdown when broker handles Out of memory error")
    private boolean skipBrokerShutdownOnOOM = false;
    @FieldContext(category="Server", doc="Amount of seconds to timeout when loading a topic. In situations with many geo-replicated clusters, this may need raised.")
    private long topicLoadTimeoutSeconds = 60L;
    @FieldContext(category="Server", doc="Whether we should enable metadata operations batching")
    private boolean metadataStoreBatchingEnabled = true;
    @FieldContext(category="Server", doc="Maximum delay to impose on batching grouping")
    private int metadataStoreBatchingMaxDelayMillis = 5;
    @FieldContext(category="Server", doc="Maximum number of operations to include in a singular batch")
    private int metadataStoreBatchingMaxOperations = 1000;
    @FieldContext(category="Server", doc="Maximum size of a batch")
    private int metadataStoreBatchingMaxSizeKb = 128;
    @FieldContext(category="Server", doc="Configuration file path for local metadata store. It's supported by RocksdbMetadataStore for now.")
    private String metadataStoreConfigPath = null;
    @FieldContext(category="Policies", doc="Enable backlog quota check. Enforces actions on topic when the quota is reached")
    private boolean backlogQuotaCheckEnabled = true;
    @FieldContext(category="Policies", doc="Whether to enable precise time based backlog quota check. Enabling precise time based backlog quota check will cause broker to read first entry in backlog of the slowest cursor on a ledger which will mostly result in reading entry from BookKeeper's disk which can have negative impact on overall performance. Disabling precise time based backlog quota check will just use the timestamp indicating when a ledger was closed, which is of coarser granularity.")
    private boolean preciseTimeBasedBacklogQuotaCheck = false;
    @FieldContext(category="Policies", doc="How often to check for topics that have reached the quota. It only takes effects when `backlogQuotaCheckEnabled` is true")
    private int backlogQuotaCheckIntervalInSeconds = 60;
    @Deprecated
    @FieldContext(category="Policies", doc="@deprecated - Use backlogQuotaDefaultLimitByte instead.\"")
    private double backlogQuotaDefaultLimitGB = -1.0;
    @FieldContext(category="Policies", doc="Default per-topic backlog quota limit by size, less than 0 means no limitation. default is -1. Increase it if you want to allow larger msg backlog")
    private long backlogQuotaDefaultLimitBytes = -1L;
    @FieldContext(category="Policies", doc="Default per-topic backlog quota limit by time in second, less than 0 means no limitation. default is -1. Increase it if you want to allow larger msg backlog")
    private int backlogQuotaDefaultLimitSecond = -1;
    @FieldContext(category="Policies", doc="Default backlog quota retention policy. Default is producer_request_hold\n\n'producer_request_hold' Policy which holds producer's send request until theresource becomes available (or holding times out)\n'producer_exception' Policy which throws javax.jms.ResourceAllocationException to the producer\n'consumer_backlog_eviction' Policy which evicts the oldest message from the slowest consumer's backlog")
    private BacklogQuota.RetentionPolicy backlogQuotaDefaultRetentionPolicy = BacklogQuota.RetentionPolicy.producer_request_hold;
    @FieldContext(category="Policies", doc="Default ttl for namespaces if ttl is not already configured at namespace policies. (disable default-ttl with value 0)")
    private int ttlDurationDefaultInSeconds = 0;
    @FieldContext(category="Policies", doc="Enable the deletion of inactive topics.\nIf only enable this option, will not clean the metadata of partitioned topic.")
    private boolean brokerDeleteInactiveTopicsEnabled = true;
    @FieldContext(category="Policies", doc="Metadata of inactive partitioned topic will not be automatically cleaned up by default.\nNote: If `allowAutoTopicCreation` and this option are enabled at the same time,\nit may appear that a partitioned topic has just been deleted but is automatically created as a non-partitioned topic.")
    private boolean brokerDeleteInactivePartitionedTopicMetadataEnabled = false;
    @FieldContext(category="Policies", doc="How often to check for inactive topics")
    private int brokerDeleteInactiveTopicsFrequencySeconds = 60;
    @FieldContext(category="Policies", doc="Set the inactive topic delete mode. Default is delete_when_no_subscriptions\n'delete_when_no_subscriptions' mode only delete the topic which has no subscriptions and no active producers\n'delete_when_subscriptions_caught_up' mode only delete the topic that all subscriptions has no backlogs(caught up) and no active producers/consumers")
    private InactiveTopicDeleteMode brokerDeleteInactiveTopicsMode = InactiveTopicDeleteMode.delete_when_no_subscriptions;
    @FieldContext(category="Policies", doc="Max duration of topic inactivity in seconds, default is not present\nIf not present, 'brokerDeleteInactiveTopicsFrequencySeconds' will be used\nTopics that are inactive for longer than this value will be deleted")
    private Integer brokerDeleteInactiveTopicsMaxInactiveDurationSeconds = null;
    @FieldContext(category="Policies", doc="Allow forced deletion of tenants. Default is false.")
    private boolean forceDeleteTenantAllowed = false;
    @FieldContext(category="Policies", doc="Allow forced deletion of namespaces. Default is false.")
    private boolean forceDeleteNamespaceAllowed = false;
    @FieldContext(category="Policies", doc="Max pending publish requests per connection to avoid keeping large number of pending requests in memory. Default: 1000")
    private int maxPendingPublishRequestsPerConnection = 1000;
    @FieldContext(category="Policies", doc="How frequently to proactively check and purge expired messages")
    private int messageExpiryCheckIntervalInMinutes = 5;
    @FieldContext(category="Policies", doc="How long to delay rewinding cursor and dispatching messages when active consumer is changed")
    private int activeConsumerFailoverDelayTimeMillis = 1000;
    @FieldContext(category="Policies", doc="How long to delete inactive subscriptions from last consuming. When it is 0, inactive subscriptions are not deleted automatically")
    private int subscriptionExpirationTimeMinutes = 0;
    @FieldContext(category="Policies", dynamic=true, doc="Enable subscription message redelivery tracker to send redelivery count to consumer (default is enabled)")
    private boolean subscriptionRedeliveryTrackerEnabled = true;
    @FieldContext(category="Policies", doc="How frequently to proactively check and purge expired subscription")
    private int subscriptionExpiryCheckIntervalInMinutes = 5;
    @FieldContext(category="Policies", dynamic=true, doc="Enable subscription types (default is all type enabled)")
    private Set<String> subscriptionTypesEnabled = Sets.newHashSet("Exclusive", "Shared", "Failover", "Key_Shared");
    @Deprecated
    @FieldContext(category="Policies", dynamic=true, doc="Enable Key_Shared subscription (default is enabled)")
    private boolean subscriptionKeySharedEnable = true;
    @FieldContext(category="Policies", doc="On KeyShared subscriptions, with default AUTO_SPLIT mode, use splitting ranges or consistent hashing to reassign keys to new consumers (default is consistent hashing)")
    private boolean subscriptionKeySharedUseConsistentHashing = true;
    @FieldContext(category="Policies", doc="On KeyShared subscriptions, number of points in the consistent-hashing ring. The higher the number, the more equal the assignment of keys to consumers")
    private int subscriptionKeySharedConsistentHashingReplicaPoints = 100;
    @FieldContext(category="Policies", doc="Set the default behavior for message deduplication in the broker.\n\nThis can be overridden per-namespace. If enabled, broker will reject messages that were already stored in the topic")
    private boolean brokerDeduplicationEnabled = false;
    @FieldContext(category="Policies", doc="Maximum number of producer information that it's going to be persisted for deduplication purposes")
    private int brokerDeduplicationMaxNumberOfProducers = 10000;
    @FieldContext(category="Policies", doc="How often is the thread pool scheduled to check whether a snapshot needs to be taken.(disable with value 0)")
    private int brokerDeduplicationSnapshotFrequencyInSeconds = 120;
    @FieldContext(category="Policies", doc="If this time interval is exceeded, a snapshot will be taken.It will run simultaneously with `brokerDeduplicationEntriesInterval`")
    private Integer brokerDeduplicationSnapshotIntervalSeconds = 120;
    @FieldContext(category="Policies", doc="Number of entries after which a dedup info snapshot is taken.\n\nA bigger interval will lead to less snapshots being taken though it would increase the topic recovery time, when the entries published after the snapshot need to be replayed")
    private int brokerDeduplicationEntriesInterval = 1000;
    @FieldContext(category="Policies", doc="Time of inactivity after which the broker will discard the deduplication information relative to a disconnected producer. Default is 6 hours.")
    private int brokerDeduplicationProducerInactivityTimeoutMinutes = 360;
    @FieldContext(category="Policies", doc="When a namespace is created without specifying the number of bundle, this value will be used as the default")
    private int defaultNumberOfNamespaceBundles = 4;
    @FieldContext(category="Policies", dynamic=true, doc="The maximum number of namespaces that each tenant can create.This configuration is not precise control, in a concurrent scenario, the threshold will be exceeded")
    private int maxNamespacesPerTenant = 0;
    @FieldContext(category="Policies", dynamic=true, doc="Max number of topics allowed to be created in the namespace. When the topics reach the max topics of the namespace, the broker should reject the new topic request(include topic auto-created by the producer or consumer) until the number of connected consumers decrease.  Using a value of 0, is disabling maxTopicsPerNamespace-limit check.")
    private int maxTopicsPerNamespace = 0;
    @FieldContext(category="Policies", doc="The maximum number of connections in the broker. If it exceeds, new connections are rejected.")
    private int brokerMaxConnections = 0;
    @FieldContext(category="Policies", doc="The maximum number of connections per IP. If it exceeds, new connections are rejected.")
    private int brokerMaxConnectionsPerIp = 0;
    @FieldContext(category="Policies", dynamic=true, doc="Allow schema to be auto updated at broker level. User can override this by 'is_allow_auto_update_schema' of namespace policy. This is enabled by default.")
    private boolean isAllowAutoUpdateSchemaEnabled = true;
    @FieldContext(category="Server", doc="Whether to enable the automatic shrink of pendingAcks map, the default is false, which means it is not enabled. When there are a large number of share or key share consumers in the cluster, it can be enabled to reduce the memory consumption caused by pendingAcks.")
    private boolean autoShrinkForConsumerPendingAcksMap = false;
    @FieldContext(category="Server", dynamic=true, doc="Enable check for minimum allowed client library version")
    private boolean clientLibraryVersionCheckEnabled = false;
    @FieldContext(category="Server", doc="Path for the file used to determine the rotation status for the broker when responding to service discovery health checks")
    private String statusFilePath;
    @FieldContext(category="Policies", doc="Max number of unacknowledged messages allowed to receive messages by a consumer on a shared subscription.\n\n Broker will stop sending messages to consumer once, this limit reaches until consumer starts acknowledging messages back and unack count reaches to `maxUnackedMessagesPerConsumer/2`. Using a value of 0, it is disabling  unackedMessage-limit check and consumer can receive messages without any restriction")
    private int maxUnackedMessagesPerConsumer = 50000;
    @FieldContext(category="Policies", doc="Max number of unacknowledged messages allowed per shared subscription. \n\n Broker will stop dispatching messages to all consumers of the subscription once this  limit reaches until consumer starts acknowledging messages back and unack count reaches to `limit/2`. Using a value of 0, is disabling unackedMessage-limit check and dispatcher can dispatch messages without any restriction")
    private int maxUnackedMessagesPerSubscription = 200000;
    @FieldContext(category="Policies", doc="Max number of unacknowledged messages allowed per broker. \n\n Once this limit reaches, broker will stop dispatching messages to all shared subscription  which has higher number of unack messages until subscriptions start acknowledging messages  back and unack count reaches to `limit/2`. Using a value of 0, is disabling unackedMessage-limit check and broker doesn't block dispatchers")
    private int maxUnackedMessagesPerBroker = 0;
    @FieldContext(category="Policies", doc="Once broker reaches maxUnackedMessagesPerBroker limit, it blocks subscriptions which has higher  unacked messages than this percentage limit and subscription will not receive any new messages  until that subscription acks back `limit/2` messages")
    private double maxUnackedMessagesPerSubscriptionOnBrokerBlocked = 0.16;
    @FieldContext(category="Policies", dynamic=true, doc="Broker periodically checks if subscription is stuck and unblock if flag is enabled. (Default is disabled)")
    private boolean unblockStuckSubscriptionEnabled = false;
    @FieldContext(category="Policies", dynamic=true, doc="Tick time to schedule task that checks topic publish rate limiting across all topics  Reducing to lower value can give more accuracy while throttling publish but it uses more CPU to perform frequent check. (Disable publish throttling with value 0)")
    private int topicPublisherThrottlingTickTimeMillis = 10;
    @FieldContext(category="Server", doc="Enable precise rate limit for topic publish")
    private boolean preciseTopicPublishRateLimiterEnable = false;
    @FieldContext(category="Server", dynamic=true, doc="Tick time to schedule task that checks broker publish rate limiting across all topics  Reducing to lower value can give more accuracy while throttling publish but it uses more CPU to perform frequent check. (Disable publish throttling with value 0)")
    private int brokerPublisherThrottlingTickTimeMillis = 50;
    @FieldContext(category="Server", dynamic=true, doc="Max Rate(in 1 seconds) of Message allowed to publish for a broker when broker publish rate limiting enabled. (Disable message rate limit with value 0)")
    private int brokerPublisherThrottlingMaxMessageRate = 0;
    @FieldContext(category="Server", dynamic=true, doc="Max Rate(in 1 seconds) of Byte allowed to publish for a broker when broker publish rate limiting enabled. (Disable byte rate limit with value 0)")
    private long brokerPublisherThrottlingMaxByteRate = 0L;
    @FieldContext(category="Server", dynamic=true, doc="Default messages per second dispatch throttling-limit for whole broker. Using a value of 0, is disabling default message-byte dispatch-throttling")
    private int dispatchThrottlingRateInMsg = 0;
    @FieldContext(category="Server", dynamic=true, doc="Default bytes per second dispatch throttling-limit for whole broker. Using a value of 0, is disabling default message-byte dispatch-throttling")
    private long dispatchThrottlingRateInByte = 0L;
    @FieldContext(category="Server", dynamic=true, doc="Max Rate(in 1 seconds) of Message allowed to publish for a topic when topic publish rate limiting enabled. (Disable byte rate limit with value 0)")
    private int maxPublishRatePerTopicInMessages = 0;
    @FieldContext(category="Server", dynamic=true, doc="Max Rate(in 1 seconds) of Byte allowed to publish for a topic when topic publish rate limiting enabled. (Disable byte rate limit with value 0)")
    private long maxPublishRatePerTopicInBytes = 0L;
    @FieldContext(category="Policies", dynamic=true, doc="Too many subscribe requests from a consumer can cause broker rewinding consumer cursors  and loading data from bookies, hence causing high network bandwidth usage When the positive value is set, broker will throttle the subscribe requests for one consumer. Otherwise, the throttling will be disabled. The default value of this setting is 0 - throttling is disabled.")
    private int subscribeThrottlingRatePerConsumer = 0;
    @FieldContext(minValue=1L, dynamic=true, category="Policies", doc="Rate period for {subscribeThrottlingRatePerConsumer}. Default is 30s.")
    private int subscribeRatePeriodPerConsumerInSecond = 30;
    @FieldContext(dynamic=true, category="Policies", doc="Default number of message dispatching throttling-limit for every topic. \n\nUsing a value of 0, is disabling default message dispatch-throttling")
    private int dispatchThrottlingRatePerTopicInMsg = 0;
    @FieldContext(dynamic=true, category="Policies", doc="Default number of message-bytes dispatching throttling-limit for every topic. \n\nUsing a value of 0, is disabling default message-byte dispatch-throttling")
    private long dispatchThrottlingRatePerTopicInByte = 0L;
    @FieldContext(dynamic=true, category="Policies", doc="Apply dispatch rate limiting on batch message instead individual messages with in batch message. (Default is disabled)")
    private boolean dispatchThrottlingOnBatchMessageEnabled = false;
    @FieldContext(dynamic=true, category="Policies", doc="Default number of message dispatching throttling-limit for a subscription. \n\nUsing a value of 0, is disabling default message dispatch-throttling.")
    private int dispatchThrottlingRatePerSubscriptionInMsg = 0;
    @FieldContext(dynamic=true, category="Policies", doc="Default number of message-bytes dispatching throttling-limit for a subscription. \n\nUsing a value of 0, is disabling default message-byte dispatch-throttling.")
    private long dispatchThrottlingRatePerSubscriptionInByte = 0L;
    @FieldContext(dynamic=true, category="Policies", doc="Default number of message dispatching throttling-limit for every replicator in replication. \n\nUsing a value of 0, is disabling replication message dispatch-throttling")
    private int dispatchThrottlingRatePerReplicatorInMsg = 0;
    @FieldContext(dynamic=true, category="Policies", doc="Default number of message-bytes dispatching throttling-limit for every replicator in replication. \n\nUsing a value of 0, is disabling replication message-byte dispatch-throttling")
    private long dispatchThrottlingRatePerReplicatorInByte = 0L;
    @FieldContext(dynamic=true, category="Policies", doc="Dispatch rate-limiting relative to publish rate. (Enabling flag will make broker to dynamically update dispatch-rate relatively to publish-rate: throttle-dispatch-rate = (publish-rate + configured dispatch-rate) ")
    private boolean dispatchThrottlingRateRelativeToPublishRate = false;
    @FieldContext(dynamic=true, category="Policies", doc="Default dispatch-throttling is disabled for consumers which already caught-up with published messages and don't have backlog. This enables dispatch-throttling for  non-backlog consumers as well.")
    private boolean dispatchThrottlingOnNonBacklogConsumerEnabled = true;
    @FieldContext(category="Policies", doc="Default policy for publishing usage reports to system topic is disabled.This enables publishing of usage reports")
    private String resourceUsageTransportClassName = "";
    @FieldContext(dynamic=true, category="Policies", doc="Default interval to publish usage reports if resourceUsagePublishToTopic is enabled.")
    private int resourceUsageTransportPublishIntervalInSecs = 60;
    @FieldContext(dynamic=true, category="Server", doc="Max number of entries to read from bookkeeper. By default it is 100 entries.")
    private int dispatcherMaxReadBatchSize = 100;
    @FieldContext(dynamic=true, category="Server", doc="Max size in bytes of entries to read from bookkeeper. By default it is 5MB.")
    private int dispatcherMaxReadSizeBytes = 0x500000;
    @FieldContext(dynamic=true, category="Server", doc="Min number of entries to read from bookkeeper. By default it is 1 entries.When there is an error occurred on reading entries from bookkeeper, the broker will backoff the batch size to this minimum number.")
    private int dispatcherMinReadBatchSize = 1;
    @FieldContext(dynamic=true, category="Server", doc="The read failure backoff initial time in milliseconds. By default it is 15s.")
    private int dispatcherReadFailureBackoffInitialTimeInMs = 15000;
    @FieldContext(dynamic=true, category="Server", doc="The read failure backoff max time in milliseconds. By default it is 60s.")
    private int dispatcherReadFailureBackoffMaxTimeInMs = 60000;
    @FieldContext(dynamic=true, category="Server", doc="The read failure backoff mandatory stop time in milliseconds. By default it is 0s.")
    private int dispatcherReadFailureBackoffMandatoryStopTimeInMs = 0;
    @FieldContext(dynamic=true, category="Server", doc="Max number of entries to dispatch for a shared subscription. By default it is 20 entries.")
    private int dispatcherMaxRoundRobinBatchSize = 20;
    @FieldContext(dynamic=true, category="Server", doc="Precise dispatcher flow control according to history message number of each entry")
    private boolean preciseDispatcherFlowControl = false;
    @FieldContext(dynamic=true, category="Server", doc=" Class name of pluggable entry filter that decides whether the entry needs to be filtered.You can use this class to decide which entries can be sent to consumers.Multiple names need to be separated by commas.")
    private List<String> entryFilterNames = new ArrayList<String>();
    @FieldContext(dynamic=true, category="Server", doc=" The directory for all the entry filter implementations.")
    private String entryFiltersDirectory = "";
    @FieldContext(category="Server", doc="Whether to use streaming read dispatcher. Currently is in preview and can be changed in subsequent release.")
    private boolean streamingDispatch = false;
    @FieldContext(dynamic=true, category="Server", doc="Max number of concurrent lookup request broker allows to throttle heavy incoming lookup traffic")
    private int maxConcurrentLookupRequest = 50000;
    @FieldContext(dynamic=true, category="Server", doc="Max number of concurrent topic loading request broker allows to control number of zk-operations")
    private int maxConcurrentTopicLoadRequest = 5000;
    @FieldContext(category="Server", doc="Max concurrent non-persistent message can be processed per connection")
    private int maxConcurrentNonPersistentMessagePerConnection = 1000;
    @FieldContext(category="Server", doc="Number of worker threads to serve non-persistent topic")
    private int numWorkerThreadsForNonPersistentTopic = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Server", doc="Enable broker to load persistent topics")
    private boolean enablePersistentTopics = true;
    @FieldContext(category="Server", doc="Enable broker to load non-persistent topics")
    private boolean enableNonPersistentTopics = true;
    @FieldContext(category="Server", doc="Enable to run bookie along with broker")
    private boolean enableRunBookieTogether = false;
    @FieldContext(category="Server", doc="Enable to run bookie autorecovery along with broker")
    private boolean enableRunBookieAutoRecoveryTogether = false;
    @FieldContext(category="Server", doc="Max number of producers allowed to connect to topic. \n\nOnce this limit reaches, Broker will reject new producers until the number of connected producers decrease. Using a value of 0, is disabling maxProducersPerTopic-limit check.")
    private int maxProducersPerTopic = 0;
    @FieldContext(category="Server", doc="Max number of producers with the same IP address allowed to connect to topic. \n\nOnce this limit reaches, Broker will reject new producers until the number of connected producers with the same IP address decrease. Using a value of 0, is disabling maxSameAddressProducersPerTopic-limit check.")
    private int maxSameAddressProducersPerTopic = 0;
    @FieldContext(category="Server", doc="Enforce producer to publish encrypted messages.(default disable).")
    private boolean encryptionRequireOnProducer = false;
    @FieldContext(category="Server", doc="Max number of consumers allowed to connect to topic. \n\nOnce this limit reaches, Broker will reject new consumers until the number of connected consumers decrease. Using a value of 0, is disabling maxConsumersPerTopic-limit check.")
    private int maxConsumersPerTopic = 0;
    @FieldContext(category="Server", doc="Max number of consumers with the same IP address allowed to connect to topic. \n\nOnce this limit reaches, Broker will reject new consumers until the number of connected consumers with the same IP address decrease. Using a value of 0, is disabling maxSameAddressConsumersPerTopic-limit check.")
    private int maxSameAddressConsumersPerTopic = 0;
    @FieldContext(category="Server", doc="Max number of subscriptions allowed to subscribe to topic. \n\nOnce this limit reaches,  broker will reject new subscription until the number of subscribed subscriptions decrease.\n Using a value of 0, is disabling maxSubscriptionsPerTopic limit check.")
    private int maxSubscriptionsPerTopic = 0;
    @FieldContext(category="Server", doc="Max number of consumers allowed to connect to subscription. \n\nOnce this limit reaches, Broker will reject new consumers until the number of connected consumers decrease. Using a value of 0, is disabling maxConsumersPerSubscription-limit check.")
    private int maxConsumersPerSubscription = 0;
    @FieldContext(category="Server", doc="Max size of messages.", maxValue=0x7FFFD7FFL)
    private int maxMessageSize = 0x500000;
    @FieldContext(category="Server", doc="Enable tracking of replicated subscriptions state across clusters.")
    private boolean enableReplicatedSubscriptions = true;
    @FieldContext(category="Server", doc="Frequency of snapshots for replicated subscriptions tracking.")
    private int replicatedSubscriptionsSnapshotFrequencyMillis = 1000;
    @FieldContext(category="Server", doc="Timeout for building a consistent snapshot for tracking replicated subscriptions state. ")
    private int replicatedSubscriptionsSnapshotTimeoutSeconds = 30;
    @FieldContext(category="Server", doc="Max number of snapshot to be cached per subscription.")
    private int replicatedSubscriptionsSnapshotMaxCachedPerSubscription = 10;
    @FieldContext(category="Server", dynamic=true, doc="Max memory size for broker handling messages sending from producers.\n\n If the processing message size exceed this value, broker will stop read data from the connection. The processing messages means messages are sends to broker but broker have not send response to client, usually waiting to write to bookies.\n\n It's shared across all the topics running in the same broker.\n\n Use -1 to disable the memory limitation. Default is 1/2 of direct memory.\n\n")
    private int maxMessagePublishBufferSizeInMB = Math.max(64, (int)(PlatformDependent.maxDirectMemory() / 2L / 0x100000L));
    @FieldContext(category="Server", doc="Interval between checks to see if message publish buffer size is exceed the max message publish buffer size")
    private int messagePublishBufferCheckIntervalInMillis = 100;
    @FieldContext(category="Server", doc="Whether to recover cursors lazily when trying to recover a managed ledger backing a persistent topic. It can improve write availability of topics.\nThe caveat is now when recovered ledger is ready to write we're not sure if all old consumers last mark delete position can be recovered or not.")
    private boolean lazyCursorRecovery = false;
    @FieldContext(category="Server", doc="Check between intervals to see if consumed ledgers need to be trimmed")
    private int retentionCheckIntervalInSeconds = 120;
    @FieldContext(category="Server", doc="The number of partitions per partitioned topic.\nIf try to create or update partitioned topics by exceeded number of partitions, then fail.")
    private int maxNumPartitionsPerPartitionedTopic = 0;
    @FieldContext(category="Server", doc="The directory to locate broker interceptors")
    private String brokerInterceptorsDirectory = "./interceptors";
    @FieldContext(category="Server", doc="List of broker interceptor to load, which is a list of broker interceptor names")
    private Set<String> brokerInterceptors = new TreeSet<String>();
    @FieldContext(category="Server", doc="Enable or disable the broker interceptor, which is only used for testing for now")
    private boolean disableBrokerInterceptors = true;
    @FieldContext(category="Server", doc="List of interceptors for payload processing.")
    private Set<String> brokerEntryPayloadProcessors = new LinkedHashSet<String>();
    @FieldContext(doc="There are two policies to apply when broker metadata session expires: session expired happens, \"shutdown\" or \"reconnect\". \n\n With \"shutdown\", the broker will be restarted.\n\n With \"reconnect\", the broker will keep serving the topics, while attempting to recreate a new session.")
    private MetadataSessionExpiredPolicy zookeeperSessionExpiredPolicy = MetadataSessionExpiredPolicy.reconnect;
    @FieldContext(category="Server", doc="If a topic remains fenced for this number of seconds, it will be closed forcefully.\n If it is set to 0 or a negative number, the fenced topic will not be closed.")
    private int topicFencingTimeoutSeconds = 0;
    @FieldContext(category="Protocols", doc="The directory to locate messaging protocol handlers")
    private String protocolHandlerDirectory = "./protocols";
    @FieldContext(category="Protocols", doc="Use a separate ThreadPool for each Protocol Handler")
    private boolean useSeparateThreadPoolForProtocolHandlers = true;
    @FieldContext(category="Protocols", doc="List of messaging protocols to load, which is a list of protocol names")
    private Set<String> messagingProtocols = new TreeSet<String>();
    @FieldContext(category="Server", doc="Enable or disable system topic.")
    private boolean systemTopicEnabled = false;
    @FieldContext(category="Schema", doc="The schema compatibility strategy to use for system topics")
    private SchemaCompatibilityStrategy systemTopicSchemaCompatibilityStrategy = SchemaCompatibilityStrategy.ALWAYS_COMPATIBLE;
    @FieldContext(category="Server", doc="Enable or disable topic level policies, topic level policies depends on the system topic, please enable the system topic first.")
    private boolean topicLevelPoliciesEnabled = false;
    @FieldContext(category="Server", doc="List of interceptors for entry metadata.")
    private Set<String> brokerEntryMetadataInterceptors = new HashSet<String>();
    @FieldContext(category="Server", doc="Enable or disable exposing broker entry metadata to client.")
    private boolean exposingBrokerEntryMetadataToClientEnabled = false;
    @FieldContext(category="Server", doc="Enable namespaceIsolation policy update take effect ontime or not, if set to ture, then the related namespaces will be unloaded after reset policy to make it take effect.")
    private boolean enableNamespaceIsolationUpdateOnTime = false;
    @FieldContext(category="TLS", doc="Enable TLS")
    @Deprecated
    private boolean tlsEnabled = false;
    @FieldContext(category="TLS", doc="Tls cert refresh duration in seconds (set 0 to check on every new connection)")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @FieldContext(category="TLS", doc="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @FieldContext(category="TLS", doc="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @FieldContext(category="TLS", doc="Path for the trusted TLS certificate file")
    private String tlsTrustCertsFilePath = "";
    @FieldContext(category="TLS", doc="Accept untrusted TLS certificate from client")
    private boolean tlsAllowInsecureConnection = false;
    @FieldContext(category="TLS", doc="Specify the tls protocols the broker will use to negotiate during TLS Handshake.\n\nExample:- [TLSv1.3, TLSv1.2]")
    private Set<String> tlsProtocols = new TreeSet<String>();
    @FieldContext(category="TLS", doc="Specify the tls cipher the broker will use to negotiate during TLS Handshake.\n\nExample:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> tlsCiphers = new TreeSet<String>();
    @FieldContext(category="TLS", doc="Specify whether Client certificates are required for TLS Reject.\nthe Connection if the Client Certificate is not trusted")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @FieldContext(category="Authentication", doc="Enable authentication")
    private boolean authenticationEnabled = false;
    @FieldContext(category="Authentication", doc="Authentication provider name list, which is a list of class names")
    private Set<String> authenticationProviders = new TreeSet<String>();
    @FieldContext(category="Authentication", doc="Interval of time for checking for expired authentication credentials")
    private int authenticationRefreshCheckSeconds = 60;
    @FieldContext(category="Authorization", doc="Enforce authorization")
    private boolean authorizationEnabled = false;
    @FieldContext(category="Authorization", doc="Authorization provider fully qualified class-name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @FieldContext(category="Authorization", dynamic=true, doc="Role names that are treated as `super-user`, meaning they will be able to do all admin operations and publish/consume from all topics")
    private Set<String> superUserRoles = new TreeSet<String>();
    @FieldContext(category="Authorization", doc="Role names that are treated as `proxy roles`. \n\nIf the broker sees a request with role as proxyRoles - it will demand to see the original client role or certificate.")
    private Set<String> proxyRoles = new TreeSet<String>();
    @FieldContext(category="Authorization", doc="If this flag is set then the broker authenticates the original Auth data else it just accepts the originalPrincipal and authorizes it (if required)")
    private boolean authenticateOriginalAuthData = false;
    @FieldContext(category="Authorization", doc="Allow wildcard matching in authorization\n\n(wildcard matching only applicable if wildcard-char: * presents at first or last position eg: *.pulsar.service, pulsar.service.*)")
    private boolean authorizationAllowWildcardsMatching = false;
    @FieldContext(category="Authentication", dynamic=true, doc="Authentication settings of the broker itself. \n\nUsed when the broker connects to other brokers, either in same or other clusters. Default uses plugin which disables authentication")
    private String brokerClientAuthenticationPlugin = "org.apache.pulsar.client.impl.auth.AuthenticationDisabled";
    @FieldContext(category="Authentication", dynamic=true, doc="Authentication parameters of the authentication plugin the broker is using to connect to other brokers")
    private String brokerClientAuthenticationParameters = "";
    @FieldContext(category="Authentication", doc="Path for the trusted TLS certificate file for outgoing connection to a server (broker)")
    private String brokerClientTrustCertsFilePath = "";
    @FieldContext(category="Authorization", doc="When this parameter is not empty, unauthenticated users perform as anonymousUserRole")
    private String anonymousUserRole = null;
    @FieldContext(category="HTTP", doc="If >0, it will reject all HTTP requests with bodies larged than the configured limit")
    private long httpMaxRequestSize = -1L;
    @FieldContext(category="HTTP", doc="If true, the broker will reject all HTTP requests using the TRACE and TRACK verbs.\n This setting may be necessary if the broker is deployed into an environment that uses http port\n scanning and flags web servers allowing the TRACE method as insecure.")
    private boolean disableHttpDebugMethods = false;
    @FieldContext(category="HTTP", doc="Enable the enforcement of limits on the incoming HTTP requests")
    private boolean httpRequestsLimitEnabled = false;
    @FieldContext(category="HTTP", doc="Max HTTP requests per seconds allowed. The excess of requests will be rejected with HTTP code 429 (Too many requests)")
    private double httpRequestsMaxPerSecond = 100.0;
    @FieldContext(category="SASL Authentication Provider", doc="This is a regexp, which limits the range of possible ids which can connect to the Broker using SASL.\n Default value is: \".*pulsar.*\", so only clients whose id contains 'pulsar' are allowed to connect.")
    private String saslJaasClientAllowedIds = ".*pulsar.*";
    @FieldContext(category="SASL Authentication Provider", doc="Service Principal, for login context name. Default value is \"PulsarBroker\".")
    private String saslJaasServerSectionName = "PulsarBroker";
    @FieldContext(category="SASL Authentication Provider", doc="kerberos kinit command.")
    private String kinitCommand = "/usr/bin/kinit";
    @FieldContext(category="Storage (BookKeeper)", doc="Metadata service uri that bookkeeper is used for loading corresponding metadata driver and resolving its metadata service location")
    private String bookkeeperMetadataServiceUri;
    @FieldContext(category="Storage (BookKeeper)", doc="Authentication plugin to use when connecting to bookies")
    private String bookkeeperClientAuthenticationPlugin;
    @FieldContext(category="Storage (BookKeeper)", doc="BookKeeper auth plugin implementation specifics parameters name and values")
    private String bookkeeperClientAuthenticationParametersName;
    @FieldContext(category="Storage (BookKeeper)", doc="Parameters for bookkeeper auth plugin")
    private String bookkeeperClientAuthenticationParameters;
    @FieldContext(category="Storage (BookKeeper)", doc="Timeout for BK add / read operations")
    private long bookkeeperClientTimeoutInSeconds = 30L;
    @FieldContext(category="Storage (BookKeeper)", doc="Speculative reads are initiated if a read request doesn't complete within a certain time Using a value of 0, is disabling the speculative reads")
    private int bookkeeperClientSpeculativeReadTimeoutInMillis = 0;
    @FieldContext(category="Storage (BookKeeper)", doc="Number of channels per bookie")
    private int bookkeeperNumberOfChannelsPerBookie = 16;
    @FieldContext(dynamic=true, category="Storage (BookKeeper)", doc="Use older Bookkeeper wire protocol with bookie")
    private boolean bookkeeperUseV2WireProtocol = true;
    @FieldContext(category="Storage (BookKeeper)", doc="Enable bookies health check. \n\n Bookies that have more than the configured number of failure within the interval will be quarantined for some time. During this period, new ledgers won't be created on these bookies")
    private boolean bookkeeperClientHealthCheckEnabled = true;
    @FieldContext(category="Storage (BookKeeper)", doc="Bookies health check interval in seconds")
    private long bookkeeperClientHealthCheckIntervalSeconds = 60L;
    @FieldContext(category="Storage (BookKeeper)", doc="Bookies health check error threshold per check interval")
    private long bookkeeperClientHealthCheckErrorThresholdPerInterval = 5L;
    @FieldContext(category="Storage (BookKeeper)", doc="Bookie health check quarantined time in seconds")
    private long bookkeeperClientHealthCheckQuarantineTimeInSeconds = 1800L;
    @FieldContext(category="Storage (BookKeeper)", doc="bookie quarantine ratio to avoid all clients quarantine the high pressure bookie servers at the same time")
    private double bookkeeperClientQuarantineRatio = 1.0;
    @FieldContext(category="Storage (BookKeeper)", doc="Enable rack-aware bookie selection policy. \n\nBK will chose bookies from different racks when forming a new bookie ensemble")
    private boolean bookkeeperClientRackawarePolicyEnabled = true;
    @FieldContext(category="Storage (BookKeeper)", doc="Enable region-aware bookie selection policy. \n\nBK will chose bookies from different regions and racks when forming a new bookie ensemble")
    private boolean bookkeeperClientRegionawarePolicyEnabled = false;
    @FieldContext(category="Storage (BookKeeper)", doc="Minimum number of racks per write quorum. \n\nBK rack-aware bookie selection policy will try to get bookies from at least 'bookkeeperClientMinNumRacksPerWriteQuorum' racks for a write quorum.")
    private int bookkeeperClientMinNumRacksPerWriteQuorum = 2;
    @FieldContext(category="Storage (BookKeeper)", doc="Enforces rack-aware bookie selection policy to pick bookies from 'bookkeeperClientMinNumRacksPerWriteQuorum' racks for  a writeQuorum. \n\nIf BK can't find bookie then it would throw BKNotEnoughBookiesException instead of picking random one.")
    private boolean bookkeeperClientEnforceMinNumRacksPerWriteQuorum = false;
    @FieldContext(category="Storage (BookKeeper)", doc="Enable/disable reordering read sequence on reading entries")
    private boolean bookkeeperClientReorderReadSequenceEnabled = false;
    @FieldContext(category="Storage (BookKeeper)", required=false, doc="Enable bookie isolation by specifying a list of bookie groups to choose from. \n\nAny bookie outside the specified groups will not be used by the broker")
    private String bookkeeperClientIsolationGroups;
    @FieldContext(category="Storage (BookKeeper)", required=false, doc="Enable bookie secondary-isolation group if bookkeeperClientIsolationGroups doesn't have enough bookie available.")
    private String bookkeeperClientSecondaryIsolationGroups;
    @FieldContext(category="Storage (BookKeeper)", doc="Set the interval to periodically check bookie info")
    private int bookkeeperClientGetBookieInfoIntervalSeconds = 86400;
    @FieldContext(category="Storage (BookKeeper)", doc="Set the interval to retry a failed bookie info lookup")
    private int bookkeeperClientGetBookieInfoRetryIntervalSeconds = 60;
    @FieldContext(category="Storage (BookKeeper)", doc="Enable/disable having read operations for a ledger to be sticky to a single bookie.\nIf this flag is enabled, the client will use one single bookie (by preference) to read all entries for a ledger.")
    private boolean bookkeeperEnableStickyReads = true;
    @FieldContext(category="Storage (BookKeeper)", doc="Set the client security provider factory class name. Default: org.apache.bookkeeper.tls.TLSContextFactory")
    private String bookkeeperTLSProviderFactoryClass = "org.apache.pulsar.shade.org.apache.bookkeeper.tls.TLSContextFactory";
    @FieldContext(category="Storage (BookKeeper)", doc="Enable tls authentication with bookie")
    private boolean bookkeeperTLSClientAuthentication = false;
    @FieldContext(category="Storage (BookKeeper)", doc="Supported type: PEM, JKS, PKCS12. Default value: PEM")
    private String bookkeeperTLSKeyFileType = "PEM";
    @FieldContext(category="Storage (BookKeeper)", doc="Supported type: PEM, JKS, PKCS12. Default value: PEM")
    private String bookkeeperTLSTrustCertTypes = "PEM";
    @FieldContext(category="Storage (BookKeeper)", doc="Path to file containing keystore password, if the client keystore is password protected.")
    private String bookkeeperTLSKeyStorePasswordPath;
    @FieldContext(category="Storage (BookKeeper)", doc="Path to file containing truststore password, if the client truststore is password protected.")
    private String bookkeeperTLSTrustStorePasswordPath;
    @FieldContext(category="Storage (BookKeeper)", doc="Path for the TLS private key file")
    private String bookkeeperTLSKeyFilePath;
    @FieldContext(category="Storage (BookKeeper)", doc="Path for the TLS certificate file")
    private String bookkeeperTLSCertificateFilePath;
    @FieldContext(category="Storage (BookKeeper)", doc="Path for the trusted TLS certificate file")
    private String bookkeeperTLSTrustCertsFilePath;
    @FieldContext(category="Storage (BookKeeper)", doc="Tls cert refresh duration at bookKeeper-client in seconds (0 to disable check)")
    private int bookkeeperTlsCertFilesRefreshDurationSeconds = 300;
    @FieldContext(category="Storage (BookKeeper)", doc="Enable/disable disk weight based placement. Default is false")
    private boolean bookkeeperDiskWeightBasedPlacementEnabled = false;
    @FieldContext(category="Storage (BookKeeper)", doc="Set the interval to check the need for sending an explicit LAC")
    private int bookkeeperExplicitLacIntervalInMills = 0;
    @FieldContext(category="Storage (BookKeeper)", doc="whether expose managed ledger client stats to prometheus")
    private boolean bookkeeperClientExposeStatsToPrometheus = false;
    @FieldContext(category="Storage (BookKeeper)", doc="Throttle value for bookkeeper client")
    private int bookkeeperClientThrottleValue = 0;
    @FieldContext(category="Storage (BookKeeper)", doc="Number of BookKeeper client worker threads. Default is Runtime.getRuntime().availableProcessors()")
    private int bookkeeperClientNumWorkerThreads = Runtime.getRuntime().availableProcessors();
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="Number of bookies to use when creating a ledger")
    private int managedLedgerDefaultEnsembleSize = 2;
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="Number of copies to store for each message")
    private int managedLedgerDefaultWriteQuorum = 2;
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="Number of guaranteed copies (acks to wait before write is complete)")
    private int managedLedgerDefaultAckQuorum = 2;
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="How frequently to flush the cursor positions that were accumulated due to rate limiting. (seconds). Default is 60 seconds")
    private int managedLedgerCursorPositionFlushSeconds = 60;
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="How frequently to refresh the stats. (seconds). Default is 60 seconds")
    private int managedLedgerStatsPeriodSeconds = 60;
    @FieldContext(category="Storage (Managed Ledger)", doc="Default type of checksum to use when writing to BookKeeper. \n\nDefault is `CRC32C`. Other possible options are `CRC32`, `MAC` or `DUMMY` (no checksum).")
    private DigestType managedLedgerDigestType = DigestType.CRC32C;
    @FieldContext(category="Storage (Managed Ledger)", doc="Default  password to use when writing to BookKeeper. \n\nDefault is ``.")
    private String managedLedgerPassword = "";
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="Max number of bookies to use when creating a ledger")
    private int managedLedgerMaxEnsembleSize = 5;
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="Max number of copies to store for each message")
    private int managedLedgerMaxWriteQuorum = 5;
    @FieldContext(minValue=1L, category="Storage (Managed Ledger)", doc="Max number of guaranteed copies (acks to wait before write is complete)")
    private int managedLedgerMaxAckQuorum = 5;
    @FieldContext(category="Storage (Managed Ledger)", doc="Amount of memory to use for caching data payload in managed ledger. \n\nThis memory is allocated from JVM direct memory and it's shared across all the topics running in the same broker. By default, uses 1/5th of available direct memory")
    private int managedLedgerCacheSizeMB = Math.max(64, (int)(PlatformDependent.maxDirectMemory() / 5L / 0x100000L));
    @FieldContext(category="Storage (Managed Ledger)", doc="Whether we should make a copy of the entry payloads when inserting in cache")
    private boolean managedLedgerCacheCopyEntries = false;
    @FieldContext(category="Storage (Managed Ledger)", doc="Threshold to which bring down the cache level when eviction is triggered")
    private double managedLedgerCacheEvictionWatermark = 0.9;
    @FieldContext(category="Storage (Managed Ledger)", doc="Configure the cache eviction frequency for the managed ledger cache. Default is 100/s")
    private double managedLedgerCacheEvictionFrequency = 100.0;
    @FieldContext(category="Storage (Managed Ledger)", doc="All entries that have stayed in cache for more than the configured time, will be evicted")
    private long managedLedgerCacheEvictionTimeThresholdMillis = 1000L;
    @FieldContext(category="Storage (Managed Ledger)", doc="Configure the threshold (in number of entries) from where a cursor should be considered 'backlogged' and thus should be set as inactive.")
    private long managedLedgerCursorBackloggedThreshold = 1000L;
    @FieldContext(category="Storage (Managed Ledger)", doc="Rate limit the amount of writes per second generated by consumer acking the messages")
    private double managedLedgerDefaultMarkDeleteRateLimit = 1.0;
    @FieldContext(category="Storage (Managed Ledger)", doc="Allow automated creation of topics if set to true (default value).")
    private boolean allowAutoTopicCreation = true;
    @FieldContext(category="Storage (Managed Ledger)", doc="The type of topic that is allowed to be automatically created.(partitioned/non-partitioned)")
    private String allowAutoTopicCreationType = "non-partitioned";
    @FieldContext(category="Storage (Managed Ledger)", doc="Allow automated creation of subscriptions if set to true (default value).")
    private boolean allowAutoSubscriptionCreation = true;
    @FieldContext(category="Storage (Managed Ledger)", doc="The number of partitioned topics that is allowed to be automatically createdif allowAutoTopicCreationType is partitioned.")
    private int defaultNumPartitions = 1;
    @FieldContext(category="Storage (Managed Ledger)", doc="The class of the managed ledger storage")
    private String managedLedgerStorageClassName = "org.apache.pulsar.broker.ManagedLedgerClientFactory";
    @FieldContext(category="Storage (Managed Ledger)", doc="Number of threads to be used for managed ledger tasks dispatching")
    private int managedLedgerNumWorkerThreads = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Storage (Managed Ledger)", doc="Number of threads to be used for managed ledger scheduled tasks")
    private int managedLedgerNumSchedulerThreads = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Storage (Managed Ledger)", doc="Max number of entries to append to a ledger before triggering a rollover.\n\nA ledger rollover is triggered after the min rollover time has passed and one of the following conditions is true: the max rollover time has been reached, the max entries have been written to the ledger, or the max ledger size has been written to the ledger")
    private int managedLedgerMaxEntriesPerLedger = 50000;
    @FieldContext(category="Storage (Managed Ledger)", doc="Minimum time between ledger rollover for a topic")
    private int managedLedgerMinLedgerRolloverTimeMinutes = 10;
    @FieldContext(category="Storage (Managed Ledger)", doc="Maximum time before forcing a ledger rollover for a topic")
    private int managedLedgerMaxLedgerRolloverTimeMinutes = 240;
    @FieldContext(category="Storage (Managed Ledger)", doc="Maximum ledger size before triggering a rollover for a topic (MB)")
    private int managedLedgerMaxSizePerLedgerMbytes = 2048;
    @FieldContext(category="Storage (Ledger Offloading)", doc="Delay between a ledger being successfully offloaded to long term storage, and the ledger being deleted from bookkeeper")
    private long managedLedgerOffloadDeletionLagMs = TimeUnit.HOURS.toMillis(4L);
    @FieldContext(category="Storage (Ledger Offloading)", doc="The number of bytes before triggering automatic offload to long term storage")
    private long managedLedgerOffloadAutoTriggerSizeThresholdBytes = -1L;
    @FieldContext(category="Storage (Managed Ledger)", doc="Max number of entries to append to a cursor ledger")
    private int managedLedgerCursorMaxEntriesPerLedger = 50000;
    @FieldContext(category="Storage (Managed Ledger)", doc="Max time before triggering a rollover on a cursor ledger")
    private int managedLedgerCursorRolloverTimeInSeconds = 14400;
    @FieldContext(category="Storage (Managed Ledger)", doc="Max number of `acknowledgment holes` that are going to be persistently stored.\n\nWhen acknowledging out of order, a consumer will leave holes that are supposed to be quickly filled by acking all the messages. The information of which messages are acknowledged is persisted by compressing in `ranges` of messages that were acknowledged. After the max number of ranges is reached, the information will only be tracked in memory and messages will be redelivered in case of crashes.")
    private int managedLedgerMaxUnackedRangesToPersist = 10000;
    @FieldContext(category="Storage (Managed Ledger)", doc="Max number of `acknowledgment holes` that can be stored in Zookeeper.\n\nIf number of unack message range is higher than this limit then broker will persist unacked ranges into bookkeeper to avoid additional data overhead into zookeeper.")
    private int managedLedgerMaxUnackedRangesToPersistInZooKeeper = 1000;
    @FieldContext(category="Storage (Ledger Offloading)", doc="Use Open Range-Set to cache unacked messages (it is memory efficient but it can take more cpu)")
    private boolean managedLedgerUnackedRangesOpenCacheSetEnabled = true;
    @FieldContext(dynamic=true, category="Storage (Managed Ledger)", doc="Skip reading non-recoverable/unreadable data-ledger under managed-ledger's list.\n\n It helps when data-ledgers gets corrupted at bookkeeper and managed-cursor is stuck at that ledger.")
    private boolean autoSkipNonRecoverableData = false;
    @FieldContext(category="Storage (Managed Ledger)", doc="operation timeout while updating managed-ledger metadata.")
    private long managedLedgerMetadataOperationsTimeoutSeconds = 60L;
    @FieldContext(category="Storage (Managed Ledger)", doc="Read entries timeout when broker tries to read messages from bookkeeper (0 to disable it)")
    private long managedLedgerReadEntryTimeoutSeconds = 0L;
    @FieldContext(category="Storage (Managed Ledger)", doc="Add entry timeout when broker tries to publish message to bookkeeper.(0 to disable it)")
    private long managedLedgerAddEntryTimeoutSeconds = 0L;
    @FieldContext(category="Storage (Managed Ledger)", doc="Managed ledger prometheus stats latency rollover seconds")
    private int managedLedgerPrometheusStatsLatencyRolloverSeconds = 60;
    @FieldContext(dynamic=true, category="Storage (Managed Ledger)", doc="Whether trace managed ledger task execution time")
    private boolean managedLedgerTraceTaskExecution = true;
    @FieldContext(category="Storage (Managed Ledger)", doc="New entries check delay for the cursor under the managed ledger. \nIf no new messages in the topic, the cursor will try to check again after the delay time. \nFor consumption latency sensitive scenario, can set to a smaller value or set to 0.\nOf course, this may degrade consumption throughput. Default is 10ms.")
    private int managedLedgerNewEntriesCheckDelayInMillis = 10;
    @FieldContext(category="Storage (Managed Ledger)", doc="Read priority when ledgers exists in both bookkeeper and the second layer storage.")
    private String managedLedgerDataReadPriority = OffloadedReadPriority.TIERED_STORAGE_FIRST.getValue();
    @FieldContext(category="Storage (Managed Ledger)", doc="ManagedLedgerInfo compression type, option values (NONE, LZ4, ZLIB, ZSTD, SNAPPY). \nIf value is invalid or NONE, then save the ManagedLedgerInfo bytes data directly.")
    private String managedLedgerInfoCompressionType = "NONE";
    @FieldContext(category="Load Balancer", doc="Enable load balancer")
    private boolean loadBalancerEnabled = true;
    @Deprecated
    @FieldContext(category="Load Balancer", deprecated=true, doc="load placement strategy[weightedRandomSelection/leastLoadedServer] (only used by SimpleLoadManagerImpl)")
    private String loadBalancerPlacementStrategy = "leastLoadedServer";
    @FieldContext(category="Load Balancer", dynamic=true, doc="load balance load shedding strategy (It requires broker restart if value is changed using dynamic config). Default is ThresholdShedder since 2.10.0")
    private String loadBalancerLoadSheddingStrategy = "org.apache.pulsar.broker.loadbalance.impl.ThresholdShedder";
    @FieldContext(dynamic=true, category="Load Balancer", doc="Percentage of change to trigger load report update")
    private int loadBalancerReportUpdateThresholdPercentage = 10;
    @FieldContext(dynamic=true, category="Load Balancer", doc="maximum interval to update load report")
    private int loadBalancerReportUpdateMaxIntervalMinutes = 15;
    @FieldContext(category="Load Balancer", dynamic=true, doc="Frequency of report to collect, in minutes")
    private int loadBalancerHostUsageCheckIntervalMinutes = 1;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Enable/disable automatic bundle unloading for load-shedding")
    private boolean loadBalancerSheddingEnabled = true;
    @FieldContext(category="Load Balancer", dynamic=true, doc="Load shedding interval. \n\nBroker periodically checks whether some traffic should be offload from some over-loaded broker to other under-loaded brokers")
    private int loadBalancerSheddingIntervalMinutes = 1;
    @FieldContext(category="Load Balancer", dynamic=true, doc="Prevent the same topics to be shed and moved to other broker more than once within this timeframe")
    private long loadBalancerSheddingGracePeriodMinutes = 30L;
    @FieldContext(category="Load Balancer", deprecated=true, doc="Usage threshold to determine a broker as under-loaded (only used by SimpleLoadManagerImpl)")
    @Deprecated
    private int loadBalancerBrokerUnderloadedThresholdPercentage = 50;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Usage threshold to allocate max number of topics to broker")
    private int loadBalancerBrokerMaxTopics = 50000;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Usage threshold to determine a broker as over-loaded")
    private int loadBalancerBrokerOverloadedThresholdPercentage = 85;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Usage threshold to determine a broker whether to start threshold shedder")
    private int loadBalancerBrokerThresholdShedderPercentage = 10;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Message-rate percentage threshold between highest and least loaded brokers for uniform load shedding. (eg: broker1 with 50K msgRate and broker2 with 30K msgRate will have 66% msgRate difference and load balancer can unload bundles from broker-1 to broker-2)")
    private double loadBalancerMsgRateDifferenceShedderThreshold = 50.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Message-throughput threshold between highest and least loaded brokers for uniform load shedding. (eg: broker1 with 450MB msgRate and broker2 with 100MB msgRate will have 4.5 times msgThroughout difference and load balancer can unload bundles from broker-1 to broker-2)")
    private double loadBalancerMsgThroughputMultiplierDifferenceShedderThreshold = 4.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Resource history Usage Percentage When adding new resource usage info")
    private double loadBalancerHistoryResourcePercentage = 0.9;
    @FieldContext(dynamic=true, category="Load Balancer", doc="BandwithIn Resource Usage Weight")
    private double loadBalancerBandwithInResourceWeight = 1.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="BandwithOut Resource Usage Weight")
    private double loadBalancerBandwithOutResourceWeight = 1.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="CPU Resource Usage Weight")
    private double loadBalancerCPUResourceWeight = 1.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Memory Resource Usage Weight")
    private double loadBalancerMemoryResourceWeight = 1.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Direct Memory Resource Usage Weight")
    private double loadBalancerDirectMemoryResourceWeight = 1.0;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Bundle unload minimum throughput threshold (MB)")
    private double loadBalancerBundleUnloadMinThroughputThreshold = 10.0;
    @FieldContext(category="Load Balancer", doc="Interval to flush dynamic resource quota to ZooKeeper")
    private int loadBalancerResourceQuotaUpdateIntervalMinutes = 15;
    @Deprecated
    @FieldContext(category="Load Balancer", deprecated=true, doc="Usage threshold to determine a broker is having just right level of load (only used by SimpleLoadManagerImpl)")
    private int loadBalancerBrokerComfortLoadLevelPercentage = 65;
    @FieldContext(dynamic=true, category="Load Balancer", doc="enable/disable automatic namespace bundle split")
    private boolean loadBalancerAutoBundleSplitEnabled = true;
    @FieldContext(dynamic=true, category="Load Balancer", doc="enable/disable automatic unloading of split bundles")
    private boolean loadBalancerAutoUnloadSplitBundlesEnabled = true;
    @FieldContext(category="Load Balancer", dynamic=true, doc="maximum topics in a bundle, otherwise bundle split will be triggered")
    private int loadBalancerNamespaceBundleMaxTopics = 1000;
    @FieldContext(category="Load Balancer", dynamic=true, doc="maximum sessions (producers + consumers) in a bundle, otherwise bundle split will be triggered(disable threshold check with value -1)")
    private int loadBalancerNamespaceBundleMaxSessions = 1000;
    @FieldContext(category="Load Balancer", dynamic=true, doc="maximum msgRate (in + out) in a bundle, otherwise bundle split will be triggered")
    private int loadBalancerNamespaceBundleMaxMsgRate = 30000;
    @FieldContext(category="Load Balancer", dynamic=true, doc="maximum bandwidth (in + out) in a bundle, otherwise bundle split will be triggered")
    private int loadBalancerNamespaceBundleMaxBandwidthMbytes = 100;
    @FieldContext(category="Load Balancer", dynamic=true, doc="maximum number of bundles in a namespace")
    private int loadBalancerNamespaceMaximumBundles = 128;
    @FieldContext(dynamic=true, category="Load Balancer", doc="Name of load manager to use")
    private String loadManagerClassName = "org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl";
    @FieldContext(dynamic=true, category="Load Balancer", doc="Supported algorithms name for namespace bundle split")
    private List<String> supportedNamespaceBundleSplitAlgorithms = Lists.newArrayList("range_equally_divide", "topic_count_equally_divide", "specified_positions_divide");
    @FieldContext(dynamic=true, category="Load Balancer", doc="Default algorithm name for namespace bundle split")
    private String defaultNamespaceBundleSplitAlgorithm = "range_equally_divide";
    @FieldContext(category="Load Balancer", doc="Option to override the auto-detected network interfaces max speed")
    private Optional<Double> loadBalancerOverrideBrokerNicSpeedGbps = Optional.empty();
    @FieldContext(category="Load Balancer", dynamic=true, doc="Time to wait for the unloading of a namespace bundle")
    private long namespaceBundleUnloadingTimeoutMs = 60000L;
    @FieldContext(category="Replication", doc="Enable replication metrics")
    private boolean replicationMetricsEnabled = true;
    @FieldContext(category="Replication", doc="Max number of connections to open for each broker in a remote cluster.\n\nMore connections host-to-host lead to better throughput over high-latency links")
    private int replicationConnectionsPerBroker = 16;
    @FieldContext(required=false, category="Replication", doc="replicator prefix used for replicator producer name and cursor name")
    private String replicatorPrefix = "pulsar.repl";
    @FieldContext(category="Replication", dynamic=true, doc="Replicator producer queue size. When dynamically modified, it only takes effect for the newly added replicators")
    private int replicationProducerQueueSize = 1000;
    @FieldContext(category="Replication", doc="Duration to check replication policy to avoid replicator inconsistency due to missing ZooKeeper watch (disable with value 0)")
    private int replicationPolicyCheckDurationSeconds = 600;
    @Deprecated
    @FieldContext(category="Replication", deprecated=true, doc="@deprecated - Use brokerClientTlsEnabled instead.")
    private boolean replicationTlsEnabled = false;
    @FieldContext(category="Replication", dynamic=true, doc="Enable TLS when talking with other brokers in the same cluster (admin operation) or different clusters (replication)")
    private boolean brokerClientTlsEnabled = false;
    @FieldContext(category="Policies", doc="Default message retention time")
    private int defaultRetentionTimeInMinutes = 0;
    @FieldContext(category="Policies", doc="Default retention size")
    private int defaultRetentionSizeInMB = 0;
    @FieldContext(category="Server", doc="How often to check pulsar connection is still alive")
    private int keepAliveIntervalSeconds = 30;
    @Deprecated
    @FieldContext(category="Policies", deprecated=true, doc="How often broker checks for inactive topics to be deleted (topics with no subscriptions and no one connected) Deprecated in favor of using `brokerDeleteInactiveTopicsFrequencySeconds`")
    private int brokerServicePurgeInactiveFrequencyInSeconds = 60;
    @FieldContext(category="Server", doc="A comma-separated list of namespaces to bootstrap")
    private List<String> bootstrapNamespaces = new ArrayList<String>();
    @JsonIgnore
    private Properties properties = new Properties();
    @FieldContext(dynamic=true, category="Server", doc="If true, (and ModularLoadManagerImpl is being used), the load manager will attempt to use only brokers running the latest software version (to minimize impact to bundles)")
    private boolean preferLaterVersions = false;
    @FieldContext(category="Server", doc="Interval between checks to see if topics with compaction policies need to be compacted")
    private int brokerServiceCompactionMonitorIntervalInSeconds = 60;
    @FieldContext(category="Server", doc="The estimated backlog size is greater than this threshold, compression will be triggered.\nUsing a value of 0, is disabling compression check.")
    private long brokerServiceCompactionThresholdInBytes = 0L;
    @FieldContext(category="Server", doc="Timeout for the compaction phase one loop, If the execution time of the compaction phase one loop exceeds this time, the compaction will not proceed.")
    private long brokerServiceCompactionPhaseOneLoopTimeInSeconds = 30L;
    @FieldContext(category="Schema", doc="Enforce schema validation on following cases:\n\n - if a producer without a schema attempts to produce to a topic with schema, the producer will be\n   failed to connect. PLEASE be carefully on using this, since non-java clients don't support schema.\n   if you enable this setting, it will cause non-java clients failed to produce.")
    private boolean isSchemaValidationEnforced = false;
    @FieldContext(category="Schema", doc="The schema storage implementation used by this broker")
    private String schemaRegistryStorageClassName = "org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorageFactory";
    @FieldContext(category="Schema", doc="The list compatibility checkers to be used in schema registry")
    private Set<String> schemaRegistryCompatibilityCheckers = Sets.newHashSet("org.apache.pulsar.broker.service.schema.JsonSchemaCompatibilityCheck", "org.apache.pulsar.broker.service.schema.AvroSchemaCompatibilityCheck", "org.apache.pulsar.broker.service.schema.ProtobufNativeSchemaCompatibilityCheck");
    @FieldContext(category="Schema", doc="The schema compatibility strategy in broker level")
    private SchemaCompatibilityStrategy schemaCompatibilityStrategy = SchemaCompatibilityStrategy.FULL;
    @FieldContext(category="WebSocket", doc="Number of IO threads in Pulsar Client used in WebSocket proxy")
    private int webSocketNumIoThreads = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="WebSocket", doc="Number of connections per Broker in Pulsar Client used in WebSocket proxy")
    private int webSocketConnectionsPerBroker = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="WebSocket", doc="Time in milliseconds that idle WebSocket session times out")
    private int webSocketSessionIdleTimeoutMillis = 300000;
    @FieldContext(category="WebSocket", doc="The maximum size of a text message during parsing in WebSocket proxy.")
    private int webSocketMaxTextFrameSize = 0x100000;
    @FieldContext(category="Metrics", doc="If true, export topic level metrics otherwise namespace level")
    private boolean exposeTopicLevelMetricsInPrometheus = true;
    @FieldContext(category="Metrics", doc="If true, export consumer level metrics otherwise namespace level")
    private boolean exposeConsumerLevelMetricsInPrometheus = false;
    @FieldContext(category="Metrics", doc="If true, export producer level metrics otherwise namespace level")
    private boolean exposeProducerLevelMetricsInPrometheus = false;
    @FieldContext(category="Metrics", doc="If true, export managed ledger metrics (aggregated by namespace)")
    private boolean exposeManagedLedgerMetricsInPrometheus = true;
    @FieldContext(category="Metrics", doc="If true, export managed cursor metrics")
    private boolean exposeManagedCursorMetricsInPrometheus = false;
    @FieldContext(category="Metrics", doc="Classname of Pluggable JVM GC metrics logger that can log GC specific metrics")
    private String jvmGCMetricsLoggerClassName;
    @FieldContext(category="Metrics", doc="Enable expose the precise backlog stats.\n Set false to use published counter and consumed counter to calculate,\n this would be more efficient but may be inaccurate. Default is false.")
    private boolean exposePreciseBacklogInPrometheus = false;
    @FieldContext(category="Metrics", doc="Time in milliseconds that metrics endpoint would time out. Default is 30s.\n Increase it if there are a lot of topics to expose topic-level metrics.\n Set it to 0 to disable timeout.")
    private long metricsServletTimeoutMs = 30000L;
    @FieldContext(category="Metrics", doc="Enable expose the backlog size for each subscription when generating stats.\n Locking is used for fetching the status so default to false.")
    private boolean exposeSubscriptionBacklogSizeInPrometheus = false;
    @FieldContext(category="Metrics", doc="Enable splitting topic and partition label in Prometheus.\n If enabled, a topic name will split into 2 parts, one is topic name without partition index,\n another one is partition index, e.g. (topic=xxx, partition=0).\n If the topic is a non-partitioned topic, -1 will be used for the partition index.\n If disabled, one label to represent the topic and partition, e.g. (topic=xxx-partition-0)\n Default is false.")
    private boolean splitTopicAndPartitionLabelInPrometheus = false;
    @FieldContext(category="Metrics", doc="Enable expose the broker bundles metrics.")
    private boolean exposeBundlesMetricsInPrometheus = false;
    @FieldContext(category="Functions", doc="Flag indicates enabling or disabling function worker on brokers")
    private boolean functionsWorkerEnabled = false;
    @FieldContext(category="Functions", doc="The nar package for the function worker service")
    private String functionsWorkerServiceNarPackage = "";
    @FieldContext(category="Metrics", doc="If true, export publisher stats when returning topics stats from the admin rest api")
    private boolean exposePublisherStats = true;
    @FieldContext(category="Metrics", doc="Stats update frequency in seconds")
    private int statsUpdateFrequencyInSecs = 60;
    @FieldContext(category="Metrics", doc="Stats update initial delay in seconds")
    private int statsUpdateInitialDelayInSecs = 60;
    @FieldContext(category="Metrics", doc="If true, aggregate publisher stats of PartitionedTopicStats by producerName")
    private boolean aggregatePublisherStatsByProducerName = false;
    @FieldContext(category="Storage (Ledger Offloading)", doc="The directory to locate offloaders")
    private String offloadersDirectory = "./offloaders";
    @FieldContext(category="Storage (Ledger Offloading)", doc="Driver to use to offload old data to long term storage")
    private String managedLedgerOffloadDriver = null;
    @FieldContext(category="Storage (Ledger Offloading)", doc="Maximum number of thread pool threads for ledger offloading")
    private int managedLedgerOffloadMaxThreads = 2;
    @FieldContext(category="Storage (Ledger Offloading)", doc="The directory where nar Extraction of offloaders happens")
    private String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
    @FieldContext(category="Storage (Ledger Offloading)", doc="Maximum prefetch rounds for ledger reading for offloading")
    private int managedLedgerOffloadPrefetchRounds = 1;
    @FieldContext(dynamic=true, category="Storage (Managed Ledger)", doc="Time to rollover ledger for inactive topic (duration without any publish on that topic). Disable rollover with value 0 (Default value 0)")
    private int managedLedgerInactiveLedgerRolloverTimeSeconds = 0;
    @FieldContext(category="Transaction", doc="Enable transaction coordinator in broker")
    private boolean transactionCoordinatorEnabled = false;
    @FieldContext(category="Transaction", doc="Class name for transaction metadata store provider")
    private String transactionMetadataStoreProviderClassName = "org.apache.pulsar.transaction.coordinator.impl.MLTransactionMetadataStoreProvider";
    @FieldContext(category="Transaction", doc="Class name for transaction buffer provider")
    private String transactionBufferProviderClassName = "org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferProvider";
    @FieldContext(category="Transaction", doc="Class name for transaction pending ack store provider")
    private String transactionPendingAckStoreProviderClassName = "org.apache.pulsar.broker.transaction.pendingack.impl.MLPendingAckStoreProvider";
    @FieldContext(category="Transaction", doc="Number of threads to use for pulsar transaction replay PendingAckStore or TransactionBuffer.Default is 5")
    private int numTransactionReplayThreadPoolSize = Runtime.getRuntime().availableProcessors();
    @FieldContext(category="Transaction", doc="Transaction buffer take snapshot transaction count")
    private int transactionBufferSnapshotMaxTransactionCount = 1000;
    @FieldContext(category="Transaction", doc="Transaction buffer take snapshot min interval time")
    private int transactionBufferSnapshotMinTimeInMillis = 5000;
    @FieldContext(category="KeyStoreTLS", doc="Enable TLS with KeyStore type configuration in broker")
    private boolean tlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="TLS Provider for KeyStore type")
    private String tlsProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore type configuration in broker: JKS, PKCS12")
    private String tlsKeyStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore path in broker")
    private String tlsKeyStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS KeyStore password for broker")
    private String tlsKeyStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration in broker: JKS, PKCS12")
    private String tlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path in broker")
    private String tlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for broker, null means empty password.")
    private String tlsTrustStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="Whether internal client use KeyStore type to authenticate with other Pulsar brokers")
    private boolean brokerClientTlsEnabledWithKeyStore = false;
    @FieldContext(category="KeyStoreTLS", doc="The TLS Provider used by internal client to authenticate with other Pulsar brokers")
    private String brokerClientSslProvider = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore type configuration for internal client: JKS, PKCS12  used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStoreType = "JKS";
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore path for internal client,  used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStore = null;
    @FieldContext(category="KeyStoreTLS", doc="TLS TrustStore password for internal client,  used by the internal client to authenticate with Pulsar brokers")
    private String brokerClientTlsTrustStorePassword = null;
    @FieldContext(category="KeyStoreTLS", doc="Specify the tls cipher the internal client will use to negotiate during TLS Handshake (a comma-separated list of ciphers).\n\nExamples:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256].\n used by the internal client to authenticate with Pulsar brokers")
    private Set<String> brokerClientTlsCiphers = new TreeSet<String>();
    @FieldContext(category="KeyStoreTLS", doc="Specify the tls protocols the broker will use to negotiate during TLS handshake (a comma-separated list of protocol names).\n\nExamples:- [TLSv1.3, TLSv1.2] \n used by the internal client to authenticate with Pulsar brokers")
    private Set<String> brokerClientTlsProtocols = new TreeSet<String>();
    @FieldContext(category="Packages Management", doc="Enable the packages management service or not")
    private boolean enablePackagesManagement = false;
    @FieldContext(category="Packages Management", doc="The packages management service storage service provider")
    private String packagesManagementStorageProvider = "org.apache.pulsar.packages.management.storage.bookkeeper.BookKeeperPackagesStorageProvider";
    @FieldContext(category="Packages Management", doc="When the packages storage provider is bookkeeper, you can use this configuration to\ncontrol the number of replicas for storing the package")
    private int packagesReplicas = 1;
    @FieldContext(category="Packages Management", doc="The bookkeeper ledger root path")
    private String packagesManagementLedgerRootPath = "/ledgers";
    @FieldContext(category="Broker Plugin", doc="The directory to locate broker additional servlet")
    private String additionalServletDirectory = "./brokerAdditionalServlet";
    @FieldContext(category="Broker Plugin", doc="List of broker additional servlet to load, which is a list of broker additional servlet names")
    private Set<String> additionalServlets = new TreeSet<String>();

    public String getMetadataStoreUrl() {
        if (StringUtils.isNotBlank(this.metadataStoreUrl)) {
            return this.metadataStoreUrl;
        }
        return this.zookeeperServers;
    }

    public String getConfigurationMetadataStoreUrl() {
        if (StringUtils.isNotBlank(this.configurationMetadataStoreUrl)) {
            return this.configurationMetadataStoreUrl;
        }
        if (StringUtils.isNotBlank(this.configurationStoreServers)) {
            return this.configurationStoreServers;
        }
        if (StringUtils.isNotBlank(this.globalZookeeperServers)) {
            return this.globalZookeeperServers;
        }
        return this.getMetadataStoreUrl();
    }

    public boolean isConfigurationStoreSeparated() {
        return !Objects.equals(this.getConfigurationMetadataStoreUrl(), this.getMetadataStoreUrl());
    }

    public boolean isBookkeeperMetadataStoreSeparated() {
        return StringUtils.isNotBlank(this.bookkeeperMetadataServiceUri);
    }

    public String getBookkeeperMetadataStoreUrl() {
        if (this.isBookkeeperMetadataStoreSeparated()) {
            return this.bookkeeperMetadataServiceUri;
        }
        String suffix = StringUtils.isNotBlank(this.metadataStoreUrl) ? this.metadataStoreUrl : "zk:" + this.zookeeperServers;
        return "metadata-store:" + suffix + "/ledgers";
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public boolean isDefaultTopicTypePartitioned() {
        return TopicType.PARTITIONED.toString().equals(this.allowAutoTopicCreationType);
    }

    public int getBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds() {
        if (this.brokerDeleteInactiveTopicsMaxInactiveDurationSeconds == null) {
            return this.brokerDeleteInactiveTopicsFrequencySeconds;
        }
        return this.brokerDeleteInactiveTopicsMaxInactiveDurationSeconds;
    }

    public SchemaCompatibilityStrategy getSchemaCompatibilityStrategy() {
        if (SchemaCompatibilityStrategy.isUndefined(this.schemaCompatibilityStrategy)) {
            return SchemaCompatibilityStrategy.FULL;
        }
        return this.schemaCompatibilityStrategy;
    }

    public long getMetadataStoreSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis > 0L ? this.zooKeeperSessionTimeoutMillis : this.metadataStoreSessionTimeoutMillis;
    }

    public int getMetadataStoreOperationTimeoutSeconds() {
        return this.zooKeeperOperationTimeoutSeconds > 0 ? this.zooKeeperOperationTimeoutSeconds : this.metadataStoreOperationTimeoutSeconds;
    }

    public int getMetadataStoreCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds > 0 ? this.zooKeeperCacheExpirySeconds : this.metadataStoreCacheExpirySeconds;
    }

    public Optional<Integer> getBrokerServicePort() {
        return this.brokerServicePort;
    }

    public Optional<Integer> getBrokerServicePortTls() {
        return this.brokerServicePortTls;
    }

    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    public Set<String> getWebServiceTlsProtocols() {
        return this.webServiceTlsProtocols;
    }

    public Set<String> getWebServiceTlsCiphers() {
        return this.webServiceTlsCiphers;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public String getAdvertisedAddress() {
        return this.advertisedAddress;
    }

    public String getAdvertisedListeners() {
        return this.advertisedListeners;
    }

    public String getInternalListenerName() {
        return this.internalListenerName;
    }

    public String getBindAddresses() {
        return this.bindAddresses;
    }

    public boolean isHaProxyProtocolEnabled() {
        return this.haProxyProtocolEnabled;
    }

    public int getNumAcceptorThreads() {
        return this.numAcceptorThreads;
    }

    public int getNumIOThreads() {
        return this.numIOThreads;
    }

    public int getNumOrderedExecutorThreads() {
        return this.numOrderedExecutorThreads;
    }

    public int getNumHttpServerThreads() {
        return this.numHttpServerThreads;
    }

    public int getNumExecutorThreadPoolSize() {
        return this.numExecutorThreadPoolSize;
    }

    public int getNumCacheExecutorThreadPoolSize() {
        return this.numCacheExecutorThreadPoolSize;
    }

    public boolean isEnableBusyWait() {
        return this.enableBusyWait;
    }

    public int getMaxConcurrentHttpRequests() {
        return this.maxConcurrentHttpRequests;
    }

    public boolean isDelayedDeliveryEnabled() {
        return this.delayedDeliveryEnabled;
    }

    public String getDelayedDeliveryTrackerFactoryClassName() {
        return this.delayedDeliveryTrackerFactoryClassName;
    }

    public long getDelayedDeliveryTickTimeMillis() {
        return this.delayedDeliveryTickTimeMillis;
    }

    public boolean isAcknowledgmentAtBatchIndexLevelEnabled() {
        return this.acknowledgmentAtBatchIndexLevelEnabled;
    }

    public boolean isWebSocketServiceEnabled() {
        return this.webSocketServiceEnabled;
    }

    public boolean isRunningStandalone() {
        return this.isRunningStandalone;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getMaxTenants() {
        return this.maxTenants;
    }

    public boolean isFailureDomainsEnabled() {
        return this.failureDomainsEnabled;
    }

    @Deprecated
    public long getZooKeeperSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis;
    }

    @Deprecated
    public int getZooKeeperOperationTimeoutSeconds() {
        return this.zooKeeperOperationTimeoutSeconds;
    }

    @Deprecated
    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    public long getBrokerShutdownTimeoutMs() {
        return this.brokerShutdownTimeoutMs;
    }

    public boolean isSkipBrokerShutdownOnOOM() {
        return this.skipBrokerShutdownOnOOM;
    }

    public long getTopicLoadTimeoutSeconds() {
        return this.topicLoadTimeoutSeconds;
    }

    public boolean isMetadataStoreBatchingEnabled() {
        return this.metadataStoreBatchingEnabled;
    }

    public int getMetadataStoreBatchingMaxDelayMillis() {
        return this.metadataStoreBatchingMaxDelayMillis;
    }

    public int getMetadataStoreBatchingMaxOperations() {
        return this.metadataStoreBatchingMaxOperations;
    }

    public int getMetadataStoreBatchingMaxSizeKb() {
        return this.metadataStoreBatchingMaxSizeKb;
    }

    public String getMetadataStoreConfigPath() {
        return this.metadataStoreConfigPath;
    }

    public boolean isBacklogQuotaCheckEnabled() {
        return this.backlogQuotaCheckEnabled;
    }

    public boolean isPreciseTimeBasedBacklogQuotaCheck() {
        return this.preciseTimeBasedBacklogQuotaCheck;
    }

    public int getBacklogQuotaCheckIntervalInSeconds() {
        return this.backlogQuotaCheckIntervalInSeconds;
    }

    @Deprecated
    public double getBacklogQuotaDefaultLimitGB() {
        return this.backlogQuotaDefaultLimitGB;
    }

    public long getBacklogQuotaDefaultLimitBytes() {
        return this.backlogQuotaDefaultLimitBytes;
    }

    public int getBacklogQuotaDefaultLimitSecond() {
        return this.backlogQuotaDefaultLimitSecond;
    }

    public BacklogQuota.RetentionPolicy getBacklogQuotaDefaultRetentionPolicy() {
        return this.backlogQuotaDefaultRetentionPolicy;
    }

    public int getTtlDurationDefaultInSeconds() {
        return this.ttlDurationDefaultInSeconds;
    }

    public boolean isBrokerDeleteInactiveTopicsEnabled() {
        return this.brokerDeleteInactiveTopicsEnabled;
    }

    public boolean isBrokerDeleteInactivePartitionedTopicMetadataEnabled() {
        return this.brokerDeleteInactivePartitionedTopicMetadataEnabled;
    }

    public int getBrokerDeleteInactiveTopicsFrequencySeconds() {
        return this.brokerDeleteInactiveTopicsFrequencySeconds;
    }

    public InactiveTopicDeleteMode getBrokerDeleteInactiveTopicsMode() {
        return this.brokerDeleteInactiveTopicsMode;
    }

    public boolean isForceDeleteTenantAllowed() {
        return this.forceDeleteTenantAllowed;
    }

    public boolean isForceDeleteNamespaceAllowed() {
        return this.forceDeleteNamespaceAllowed;
    }

    public int getMaxPendingPublishRequestsPerConnection() {
        return this.maxPendingPublishRequestsPerConnection;
    }

    public int getMessageExpiryCheckIntervalInMinutes() {
        return this.messageExpiryCheckIntervalInMinutes;
    }

    public int getActiveConsumerFailoverDelayTimeMillis() {
        return this.activeConsumerFailoverDelayTimeMillis;
    }

    public int getSubscriptionExpirationTimeMinutes() {
        return this.subscriptionExpirationTimeMinutes;
    }

    public boolean isSubscriptionRedeliveryTrackerEnabled() {
        return this.subscriptionRedeliveryTrackerEnabled;
    }

    public int getSubscriptionExpiryCheckIntervalInMinutes() {
        return this.subscriptionExpiryCheckIntervalInMinutes;
    }

    public Set<String> getSubscriptionTypesEnabled() {
        return this.subscriptionTypesEnabled;
    }

    @Deprecated
    public boolean isSubscriptionKeySharedEnable() {
        return this.subscriptionKeySharedEnable;
    }

    public boolean isSubscriptionKeySharedUseConsistentHashing() {
        return this.subscriptionKeySharedUseConsistentHashing;
    }

    public int getSubscriptionKeySharedConsistentHashingReplicaPoints() {
        return this.subscriptionKeySharedConsistentHashingReplicaPoints;
    }

    public boolean isBrokerDeduplicationEnabled() {
        return this.brokerDeduplicationEnabled;
    }

    public int getBrokerDeduplicationMaxNumberOfProducers() {
        return this.brokerDeduplicationMaxNumberOfProducers;
    }

    public int getBrokerDeduplicationSnapshotFrequencyInSeconds() {
        return this.brokerDeduplicationSnapshotFrequencyInSeconds;
    }

    public Integer getBrokerDeduplicationSnapshotIntervalSeconds() {
        return this.brokerDeduplicationSnapshotIntervalSeconds;
    }

    public int getBrokerDeduplicationEntriesInterval() {
        return this.brokerDeduplicationEntriesInterval;
    }

    public int getBrokerDeduplicationProducerInactivityTimeoutMinutes() {
        return this.brokerDeduplicationProducerInactivityTimeoutMinutes;
    }

    public int getDefaultNumberOfNamespaceBundles() {
        return this.defaultNumberOfNamespaceBundles;
    }

    public int getMaxNamespacesPerTenant() {
        return this.maxNamespacesPerTenant;
    }

    public int getMaxTopicsPerNamespace() {
        return this.maxTopicsPerNamespace;
    }

    public int getBrokerMaxConnections() {
        return this.brokerMaxConnections;
    }

    public int getBrokerMaxConnectionsPerIp() {
        return this.brokerMaxConnectionsPerIp;
    }

    public boolean isAllowAutoUpdateSchemaEnabled() {
        return this.isAllowAutoUpdateSchemaEnabled;
    }

    public boolean isAutoShrinkForConsumerPendingAcksMap() {
        return this.autoShrinkForConsumerPendingAcksMap;
    }

    public boolean isClientLibraryVersionCheckEnabled() {
        return this.clientLibraryVersionCheckEnabled;
    }

    public String getStatusFilePath() {
        return this.statusFilePath;
    }

    public int getMaxUnackedMessagesPerConsumer() {
        return this.maxUnackedMessagesPerConsumer;
    }

    public int getMaxUnackedMessagesPerSubscription() {
        return this.maxUnackedMessagesPerSubscription;
    }

    public int getMaxUnackedMessagesPerBroker() {
        return this.maxUnackedMessagesPerBroker;
    }

    public double getMaxUnackedMessagesPerSubscriptionOnBrokerBlocked() {
        return this.maxUnackedMessagesPerSubscriptionOnBrokerBlocked;
    }

    public boolean isUnblockStuckSubscriptionEnabled() {
        return this.unblockStuckSubscriptionEnabled;
    }

    public int getTopicPublisherThrottlingTickTimeMillis() {
        return this.topicPublisherThrottlingTickTimeMillis;
    }

    public boolean isPreciseTopicPublishRateLimiterEnable() {
        return this.preciseTopicPublishRateLimiterEnable;
    }

    public int getBrokerPublisherThrottlingTickTimeMillis() {
        return this.brokerPublisherThrottlingTickTimeMillis;
    }

    public int getBrokerPublisherThrottlingMaxMessageRate() {
        return this.brokerPublisherThrottlingMaxMessageRate;
    }

    public long getBrokerPublisherThrottlingMaxByteRate() {
        return this.brokerPublisherThrottlingMaxByteRate;
    }

    public int getDispatchThrottlingRateInMsg() {
        return this.dispatchThrottlingRateInMsg;
    }

    public long getDispatchThrottlingRateInByte() {
        return this.dispatchThrottlingRateInByte;
    }

    public int getMaxPublishRatePerTopicInMessages() {
        return this.maxPublishRatePerTopicInMessages;
    }

    public long getMaxPublishRatePerTopicInBytes() {
        return this.maxPublishRatePerTopicInBytes;
    }

    public int getSubscribeThrottlingRatePerConsumer() {
        return this.subscribeThrottlingRatePerConsumer;
    }

    public int getSubscribeRatePeriodPerConsumerInSecond() {
        return this.subscribeRatePeriodPerConsumerInSecond;
    }

    public int getDispatchThrottlingRatePerTopicInMsg() {
        return this.dispatchThrottlingRatePerTopicInMsg;
    }

    public long getDispatchThrottlingRatePerTopicInByte() {
        return this.dispatchThrottlingRatePerTopicInByte;
    }

    public boolean isDispatchThrottlingOnBatchMessageEnabled() {
        return this.dispatchThrottlingOnBatchMessageEnabled;
    }

    public int getDispatchThrottlingRatePerSubscriptionInMsg() {
        return this.dispatchThrottlingRatePerSubscriptionInMsg;
    }

    public long getDispatchThrottlingRatePerSubscriptionInByte() {
        return this.dispatchThrottlingRatePerSubscriptionInByte;
    }

    public int getDispatchThrottlingRatePerReplicatorInMsg() {
        return this.dispatchThrottlingRatePerReplicatorInMsg;
    }

    public long getDispatchThrottlingRatePerReplicatorInByte() {
        return this.dispatchThrottlingRatePerReplicatorInByte;
    }

    public boolean isDispatchThrottlingRateRelativeToPublishRate() {
        return this.dispatchThrottlingRateRelativeToPublishRate;
    }

    public boolean isDispatchThrottlingOnNonBacklogConsumerEnabled() {
        return this.dispatchThrottlingOnNonBacklogConsumerEnabled;
    }

    public String getResourceUsageTransportClassName() {
        return this.resourceUsageTransportClassName;
    }

    public int getResourceUsageTransportPublishIntervalInSecs() {
        return this.resourceUsageTransportPublishIntervalInSecs;
    }

    public int getDispatcherMaxReadBatchSize() {
        return this.dispatcherMaxReadBatchSize;
    }

    public int getDispatcherMaxReadSizeBytes() {
        return this.dispatcherMaxReadSizeBytes;
    }

    public int getDispatcherMinReadBatchSize() {
        return this.dispatcherMinReadBatchSize;
    }

    public int getDispatcherReadFailureBackoffInitialTimeInMs() {
        return this.dispatcherReadFailureBackoffInitialTimeInMs;
    }

    public int getDispatcherReadFailureBackoffMaxTimeInMs() {
        return this.dispatcherReadFailureBackoffMaxTimeInMs;
    }

    public int getDispatcherReadFailureBackoffMandatoryStopTimeInMs() {
        return this.dispatcherReadFailureBackoffMandatoryStopTimeInMs;
    }

    public int getDispatcherMaxRoundRobinBatchSize() {
        return this.dispatcherMaxRoundRobinBatchSize;
    }

    public boolean isPreciseDispatcherFlowControl() {
        return this.preciseDispatcherFlowControl;
    }

    public List<String> getEntryFilterNames() {
        return this.entryFilterNames;
    }

    public String getEntryFiltersDirectory() {
        return this.entryFiltersDirectory;
    }

    public boolean isStreamingDispatch() {
        return this.streamingDispatch;
    }

    public int getMaxConcurrentLookupRequest() {
        return this.maxConcurrentLookupRequest;
    }

    public int getMaxConcurrentTopicLoadRequest() {
        return this.maxConcurrentTopicLoadRequest;
    }

    public int getMaxConcurrentNonPersistentMessagePerConnection() {
        return this.maxConcurrentNonPersistentMessagePerConnection;
    }

    public int getNumWorkerThreadsForNonPersistentTopic() {
        return this.numWorkerThreadsForNonPersistentTopic;
    }

    public boolean isEnablePersistentTopics() {
        return this.enablePersistentTopics;
    }

    public boolean isEnableNonPersistentTopics() {
        return this.enableNonPersistentTopics;
    }

    public boolean isEnableRunBookieTogether() {
        return this.enableRunBookieTogether;
    }

    public boolean isEnableRunBookieAutoRecoveryTogether() {
        return this.enableRunBookieAutoRecoveryTogether;
    }

    public int getMaxProducersPerTopic() {
        return this.maxProducersPerTopic;
    }

    public int getMaxSameAddressProducersPerTopic() {
        return this.maxSameAddressProducersPerTopic;
    }

    public boolean isEncryptionRequireOnProducer() {
        return this.encryptionRequireOnProducer;
    }

    public int getMaxConsumersPerTopic() {
        return this.maxConsumersPerTopic;
    }

    public int getMaxSameAddressConsumersPerTopic() {
        return this.maxSameAddressConsumersPerTopic;
    }

    public int getMaxSubscriptionsPerTopic() {
        return this.maxSubscriptionsPerTopic;
    }

    public int getMaxConsumersPerSubscription() {
        return this.maxConsumersPerSubscription;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean isEnableReplicatedSubscriptions() {
        return this.enableReplicatedSubscriptions;
    }

    public int getReplicatedSubscriptionsSnapshotFrequencyMillis() {
        return this.replicatedSubscriptionsSnapshotFrequencyMillis;
    }

    public int getReplicatedSubscriptionsSnapshotTimeoutSeconds() {
        return this.replicatedSubscriptionsSnapshotTimeoutSeconds;
    }

    public int getReplicatedSubscriptionsSnapshotMaxCachedPerSubscription() {
        return this.replicatedSubscriptionsSnapshotMaxCachedPerSubscription;
    }

    public int getMaxMessagePublishBufferSizeInMB() {
        return this.maxMessagePublishBufferSizeInMB;
    }

    public int getMessagePublishBufferCheckIntervalInMillis() {
        return this.messagePublishBufferCheckIntervalInMillis;
    }

    public boolean isLazyCursorRecovery() {
        return this.lazyCursorRecovery;
    }

    public int getRetentionCheckIntervalInSeconds() {
        return this.retentionCheckIntervalInSeconds;
    }

    public int getMaxNumPartitionsPerPartitionedTopic() {
        return this.maxNumPartitionsPerPartitionedTopic;
    }

    public String getBrokerInterceptorsDirectory() {
        return this.brokerInterceptorsDirectory;
    }

    public Set<String> getBrokerInterceptors() {
        return this.brokerInterceptors;
    }

    public boolean isDisableBrokerInterceptors() {
        return this.disableBrokerInterceptors;
    }

    public Set<String> getBrokerEntryPayloadProcessors() {
        return this.brokerEntryPayloadProcessors;
    }

    public MetadataSessionExpiredPolicy getZookeeperSessionExpiredPolicy() {
        return this.zookeeperSessionExpiredPolicy;
    }

    public int getTopicFencingTimeoutSeconds() {
        return this.topicFencingTimeoutSeconds;
    }

    public String getProtocolHandlerDirectory() {
        return this.protocolHandlerDirectory;
    }

    public boolean isUseSeparateThreadPoolForProtocolHandlers() {
        return this.useSeparateThreadPoolForProtocolHandlers;
    }

    public Set<String> getMessagingProtocols() {
        return this.messagingProtocols;
    }

    public boolean isSystemTopicEnabled() {
        return this.systemTopicEnabled;
    }

    public SchemaCompatibilityStrategy getSystemTopicSchemaCompatibilityStrategy() {
        return this.systemTopicSchemaCompatibilityStrategy;
    }

    public boolean isTopicLevelPoliciesEnabled() {
        return this.topicLevelPoliciesEnabled;
    }

    public Set<String> getBrokerEntryMetadataInterceptors() {
        return this.brokerEntryMetadataInterceptors;
    }

    public boolean isExposingBrokerEntryMetadataToClientEnabled() {
        return this.exposingBrokerEntryMetadataToClientEnabled;
    }

    public boolean isEnableNamespaceIsolationUpdateOnTime() {
        return this.enableNamespaceIsolationUpdateOnTime;
    }

    @Deprecated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    public int getAuthenticationRefreshCheckSeconds() {
        return this.authenticationRefreshCheckSeconds;
    }

    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    public Set<String> getProxyRoles() {
        return this.proxyRoles;
    }

    public boolean isAuthenticateOriginalAuthData() {
        return this.authenticateOriginalAuthData;
    }

    public boolean isAuthorizationAllowWildcardsMatching() {
        return this.authorizationAllowWildcardsMatching;
    }

    public String getBrokerClientAuthenticationPlugin() {
        return this.brokerClientAuthenticationPlugin;
    }

    public String getBrokerClientAuthenticationParameters() {
        return this.brokerClientAuthenticationParameters;
    }

    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    public String getAnonymousUserRole() {
        return this.anonymousUserRole;
    }

    public long getHttpMaxRequestSize() {
        return this.httpMaxRequestSize;
    }

    public boolean isDisableHttpDebugMethods() {
        return this.disableHttpDebugMethods;
    }

    public boolean isHttpRequestsLimitEnabled() {
        return this.httpRequestsLimitEnabled;
    }

    public double getHttpRequestsMaxPerSecond() {
        return this.httpRequestsMaxPerSecond;
    }

    public String getSaslJaasClientAllowedIds() {
        return this.saslJaasClientAllowedIds;
    }

    public String getSaslJaasServerSectionName() {
        return this.saslJaasServerSectionName;
    }

    public String getKinitCommand() {
        return this.kinitCommand;
    }

    public String getBookkeeperClientAuthenticationPlugin() {
        return this.bookkeeperClientAuthenticationPlugin;
    }

    public String getBookkeeperClientAuthenticationParametersName() {
        return this.bookkeeperClientAuthenticationParametersName;
    }

    public String getBookkeeperClientAuthenticationParameters() {
        return this.bookkeeperClientAuthenticationParameters;
    }

    public long getBookkeeperClientTimeoutInSeconds() {
        return this.bookkeeperClientTimeoutInSeconds;
    }

    public int getBookkeeperClientSpeculativeReadTimeoutInMillis() {
        return this.bookkeeperClientSpeculativeReadTimeoutInMillis;
    }

    public int getBookkeeperNumberOfChannelsPerBookie() {
        return this.bookkeeperNumberOfChannelsPerBookie;
    }

    public boolean isBookkeeperUseV2WireProtocol() {
        return this.bookkeeperUseV2WireProtocol;
    }

    public boolean isBookkeeperClientHealthCheckEnabled() {
        return this.bookkeeperClientHealthCheckEnabled;
    }

    public long getBookkeeperClientHealthCheckIntervalSeconds() {
        return this.bookkeeperClientHealthCheckIntervalSeconds;
    }

    public long getBookkeeperClientHealthCheckErrorThresholdPerInterval() {
        return this.bookkeeperClientHealthCheckErrorThresholdPerInterval;
    }

    public long getBookkeeperClientHealthCheckQuarantineTimeInSeconds() {
        return this.bookkeeperClientHealthCheckQuarantineTimeInSeconds;
    }

    public double getBookkeeperClientQuarantineRatio() {
        return this.bookkeeperClientQuarantineRatio;
    }

    public boolean isBookkeeperClientRackawarePolicyEnabled() {
        return this.bookkeeperClientRackawarePolicyEnabled;
    }

    public boolean isBookkeeperClientRegionawarePolicyEnabled() {
        return this.bookkeeperClientRegionawarePolicyEnabled;
    }

    public int getBookkeeperClientMinNumRacksPerWriteQuorum() {
        return this.bookkeeperClientMinNumRacksPerWriteQuorum;
    }

    public boolean isBookkeeperClientEnforceMinNumRacksPerWriteQuorum() {
        return this.bookkeeperClientEnforceMinNumRacksPerWriteQuorum;
    }

    public boolean isBookkeeperClientReorderReadSequenceEnabled() {
        return this.bookkeeperClientReorderReadSequenceEnabled;
    }

    public String getBookkeeperClientIsolationGroups() {
        return this.bookkeeperClientIsolationGroups;
    }

    public String getBookkeeperClientSecondaryIsolationGroups() {
        return this.bookkeeperClientSecondaryIsolationGroups;
    }

    public int getBookkeeperClientGetBookieInfoIntervalSeconds() {
        return this.bookkeeperClientGetBookieInfoIntervalSeconds;
    }

    public int getBookkeeperClientGetBookieInfoRetryIntervalSeconds() {
        return this.bookkeeperClientGetBookieInfoRetryIntervalSeconds;
    }

    public boolean isBookkeeperEnableStickyReads() {
        return this.bookkeeperEnableStickyReads;
    }

    public String getBookkeeperTLSProviderFactoryClass() {
        return this.bookkeeperTLSProviderFactoryClass;
    }

    public boolean isBookkeeperTLSClientAuthentication() {
        return this.bookkeeperTLSClientAuthentication;
    }

    public String getBookkeeperTLSKeyFileType() {
        return this.bookkeeperTLSKeyFileType;
    }

    public String getBookkeeperTLSTrustCertTypes() {
        return this.bookkeeperTLSTrustCertTypes;
    }

    public String getBookkeeperTLSKeyStorePasswordPath() {
        return this.bookkeeperTLSKeyStorePasswordPath;
    }

    public String getBookkeeperTLSTrustStorePasswordPath() {
        return this.bookkeeperTLSTrustStorePasswordPath;
    }

    public String getBookkeeperTLSKeyFilePath() {
        return this.bookkeeperTLSKeyFilePath;
    }

    public String getBookkeeperTLSCertificateFilePath() {
        return this.bookkeeperTLSCertificateFilePath;
    }

    public String getBookkeeperTLSTrustCertsFilePath() {
        return this.bookkeeperTLSTrustCertsFilePath;
    }

    public int getBookkeeperTlsCertFilesRefreshDurationSeconds() {
        return this.bookkeeperTlsCertFilesRefreshDurationSeconds;
    }

    public boolean isBookkeeperDiskWeightBasedPlacementEnabled() {
        return this.bookkeeperDiskWeightBasedPlacementEnabled;
    }

    public int getBookkeeperExplicitLacIntervalInMills() {
        return this.bookkeeperExplicitLacIntervalInMills;
    }

    public boolean isBookkeeperClientExposeStatsToPrometheus() {
        return this.bookkeeperClientExposeStatsToPrometheus;
    }

    public int getBookkeeperClientThrottleValue() {
        return this.bookkeeperClientThrottleValue;
    }

    public int getBookkeeperClientNumWorkerThreads() {
        return this.bookkeeperClientNumWorkerThreads;
    }

    public int getManagedLedgerDefaultEnsembleSize() {
        return this.managedLedgerDefaultEnsembleSize;
    }

    public int getManagedLedgerDefaultWriteQuorum() {
        return this.managedLedgerDefaultWriteQuorum;
    }

    public int getManagedLedgerDefaultAckQuorum() {
        return this.managedLedgerDefaultAckQuorum;
    }

    public int getManagedLedgerCursorPositionFlushSeconds() {
        return this.managedLedgerCursorPositionFlushSeconds;
    }

    public int getManagedLedgerStatsPeriodSeconds() {
        return this.managedLedgerStatsPeriodSeconds;
    }

    public DigestType getManagedLedgerDigestType() {
        return this.managedLedgerDigestType;
    }

    public String getManagedLedgerPassword() {
        return this.managedLedgerPassword;
    }

    public int getManagedLedgerMaxEnsembleSize() {
        return this.managedLedgerMaxEnsembleSize;
    }

    public int getManagedLedgerMaxWriteQuorum() {
        return this.managedLedgerMaxWriteQuorum;
    }

    public int getManagedLedgerMaxAckQuorum() {
        return this.managedLedgerMaxAckQuorum;
    }

    public int getManagedLedgerCacheSizeMB() {
        return this.managedLedgerCacheSizeMB;
    }

    public boolean isManagedLedgerCacheCopyEntries() {
        return this.managedLedgerCacheCopyEntries;
    }

    public double getManagedLedgerCacheEvictionWatermark() {
        return this.managedLedgerCacheEvictionWatermark;
    }

    public double getManagedLedgerCacheEvictionFrequency() {
        return this.managedLedgerCacheEvictionFrequency;
    }

    public long getManagedLedgerCacheEvictionTimeThresholdMillis() {
        return this.managedLedgerCacheEvictionTimeThresholdMillis;
    }

    public long getManagedLedgerCursorBackloggedThreshold() {
        return this.managedLedgerCursorBackloggedThreshold;
    }

    public double getManagedLedgerDefaultMarkDeleteRateLimit() {
        return this.managedLedgerDefaultMarkDeleteRateLimit;
    }

    public boolean isAllowAutoTopicCreation() {
        return this.allowAutoTopicCreation;
    }

    public String getAllowAutoTopicCreationType() {
        return this.allowAutoTopicCreationType;
    }

    public boolean isAllowAutoSubscriptionCreation() {
        return this.allowAutoSubscriptionCreation;
    }

    public int getDefaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    public String getManagedLedgerStorageClassName() {
        return this.managedLedgerStorageClassName;
    }

    public int getManagedLedgerNumWorkerThreads() {
        return this.managedLedgerNumWorkerThreads;
    }

    public int getManagedLedgerNumSchedulerThreads() {
        return this.managedLedgerNumSchedulerThreads;
    }

    public int getManagedLedgerMaxEntriesPerLedger() {
        return this.managedLedgerMaxEntriesPerLedger;
    }

    public int getManagedLedgerMinLedgerRolloverTimeMinutes() {
        return this.managedLedgerMinLedgerRolloverTimeMinutes;
    }

    public int getManagedLedgerMaxLedgerRolloverTimeMinutes() {
        return this.managedLedgerMaxLedgerRolloverTimeMinutes;
    }

    public int getManagedLedgerMaxSizePerLedgerMbytes() {
        return this.managedLedgerMaxSizePerLedgerMbytes;
    }

    public long getManagedLedgerOffloadDeletionLagMs() {
        return this.managedLedgerOffloadDeletionLagMs;
    }

    public long getManagedLedgerOffloadAutoTriggerSizeThresholdBytes() {
        return this.managedLedgerOffloadAutoTriggerSizeThresholdBytes;
    }

    public int getManagedLedgerCursorMaxEntriesPerLedger() {
        return this.managedLedgerCursorMaxEntriesPerLedger;
    }

    public int getManagedLedgerCursorRolloverTimeInSeconds() {
        return this.managedLedgerCursorRolloverTimeInSeconds;
    }

    public int getManagedLedgerMaxUnackedRangesToPersist() {
        return this.managedLedgerMaxUnackedRangesToPersist;
    }

    public int getManagedLedgerMaxUnackedRangesToPersistInZooKeeper() {
        return this.managedLedgerMaxUnackedRangesToPersistInZooKeeper;
    }

    public boolean isManagedLedgerUnackedRangesOpenCacheSetEnabled() {
        return this.managedLedgerUnackedRangesOpenCacheSetEnabled;
    }

    public boolean isAutoSkipNonRecoverableData() {
        return this.autoSkipNonRecoverableData;
    }

    public long getManagedLedgerMetadataOperationsTimeoutSeconds() {
        return this.managedLedgerMetadataOperationsTimeoutSeconds;
    }

    public long getManagedLedgerReadEntryTimeoutSeconds() {
        return this.managedLedgerReadEntryTimeoutSeconds;
    }

    public long getManagedLedgerAddEntryTimeoutSeconds() {
        return this.managedLedgerAddEntryTimeoutSeconds;
    }

    public int getManagedLedgerPrometheusStatsLatencyRolloverSeconds() {
        return this.managedLedgerPrometheusStatsLatencyRolloverSeconds;
    }

    public boolean isManagedLedgerTraceTaskExecution() {
        return this.managedLedgerTraceTaskExecution;
    }

    public int getManagedLedgerNewEntriesCheckDelayInMillis() {
        return this.managedLedgerNewEntriesCheckDelayInMillis;
    }

    public String getManagedLedgerDataReadPriority() {
        return this.managedLedgerDataReadPriority;
    }

    public String getManagedLedgerInfoCompressionType() {
        return this.managedLedgerInfoCompressionType;
    }

    public boolean isLoadBalancerEnabled() {
        return this.loadBalancerEnabled;
    }

    @Deprecated
    public String getLoadBalancerPlacementStrategy() {
        return this.loadBalancerPlacementStrategy;
    }

    public String getLoadBalancerLoadSheddingStrategy() {
        return this.loadBalancerLoadSheddingStrategy;
    }

    public int getLoadBalancerReportUpdateThresholdPercentage() {
        return this.loadBalancerReportUpdateThresholdPercentage;
    }

    public int getLoadBalancerReportUpdateMaxIntervalMinutes() {
        return this.loadBalancerReportUpdateMaxIntervalMinutes;
    }

    public int getLoadBalancerHostUsageCheckIntervalMinutes() {
        return this.loadBalancerHostUsageCheckIntervalMinutes;
    }

    public boolean isLoadBalancerSheddingEnabled() {
        return this.loadBalancerSheddingEnabled;
    }

    public int getLoadBalancerSheddingIntervalMinutes() {
        return this.loadBalancerSheddingIntervalMinutes;
    }

    public long getLoadBalancerSheddingGracePeriodMinutes() {
        return this.loadBalancerSheddingGracePeriodMinutes;
    }

    @Deprecated
    public int getLoadBalancerBrokerUnderloadedThresholdPercentage() {
        return this.loadBalancerBrokerUnderloadedThresholdPercentage;
    }

    public int getLoadBalancerBrokerMaxTopics() {
        return this.loadBalancerBrokerMaxTopics;
    }

    public int getLoadBalancerBrokerOverloadedThresholdPercentage() {
        return this.loadBalancerBrokerOverloadedThresholdPercentage;
    }

    public int getLoadBalancerBrokerThresholdShedderPercentage() {
        return this.loadBalancerBrokerThresholdShedderPercentage;
    }

    public double getLoadBalancerMsgRateDifferenceShedderThreshold() {
        return this.loadBalancerMsgRateDifferenceShedderThreshold;
    }

    public double getLoadBalancerMsgThroughputMultiplierDifferenceShedderThreshold() {
        return this.loadBalancerMsgThroughputMultiplierDifferenceShedderThreshold;
    }

    public double getLoadBalancerHistoryResourcePercentage() {
        return this.loadBalancerHistoryResourcePercentage;
    }

    public double getLoadBalancerBandwithInResourceWeight() {
        return this.loadBalancerBandwithInResourceWeight;
    }

    public double getLoadBalancerBandwithOutResourceWeight() {
        return this.loadBalancerBandwithOutResourceWeight;
    }

    public double getLoadBalancerCPUResourceWeight() {
        return this.loadBalancerCPUResourceWeight;
    }

    public double getLoadBalancerMemoryResourceWeight() {
        return this.loadBalancerMemoryResourceWeight;
    }

    public double getLoadBalancerDirectMemoryResourceWeight() {
        return this.loadBalancerDirectMemoryResourceWeight;
    }

    public double getLoadBalancerBundleUnloadMinThroughputThreshold() {
        return this.loadBalancerBundleUnloadMinThroughputThreshold;
    }

    public int getLoadBalancerResourceQuotaUpdateIntervalMinutes() {
        return this.loadBalancerResourceQuotaUpdateIntervalMinutes;
    }

    @Deprecated
    public int getLoadBalancerBrokerComfortLoadLevelPercentage() {
        return this.loadBalancerBrokerComfortLoadLevelPercentage;
    }

    public boolean isLoadBalancerAutoBundleSplitEnabled() {
        return this.loadBalancerAutoBundleSplitEnabled;
    }

    public boolean isLoadBalancerAutoUnloadSplitBundlesEnabled() {
        return this.loadBalancerAutoUnloadSplitBundlesEnabled;
    }

    public int getLoadBalancerNamespaceBundleMaxTopics() {
        return this.loadBalancerNamespaceBundleMaxTopics;
    }

    public int getLoadBalancerNamespaceBundleMaxSessions() {
        return this.loadBalancerNamespaceBundleMaxSessions;
    }

    public int getLoadBalancerNamespaceBundleMaxMsgRate() {
        return this.loadBalancerNamespaceBundleMaxMsgRate;
    }

    public int getLoadBalancerNamespaceBundleMaxBandwidthMbytes() {
        return this.loadBalancerNamespaceBundleMaxBandwidthMbytes;
    }

    public int getLoadBalancerNamespaceMaximumBundles() {
        return this.loadBalancerNamespaceMaximumBundles;
    }

    public String getLoadManagerClassName() {
        return this.loadManagerClassName;
    }

    public List<String> getSupportedNamespaceBundleSplitAlgorithms() {
        return this.supportedNamespaceBundleSplitAlgorithms;
    }

    public String getDefaultNamespaceBundleSplitAlgorithm() {
        return this.defaultNamespaceBundleSplitAlgorithm;
    }

    public Optional<Double> getLoadBalancerOverrideBrokerNicSpeedGbps() {
        return this.loadBalancerOverrideBrokerNicSpeedGbps;
    }

    public long getNamespaceBundleUnloadingTimeoutMs() {
        return this.namespaceBundleUnloadingTimeoutMs;
    }

    public boolean isReplicationMetricsEnabled() {
        return this.replicationMetricsEnabled;
    }

    public int getReplicationConnectionsPerBroker() {
        return this.replicationConnectionsPerBroker;
    }

    public String getReplicatorPrefix() {
        return this.replicatorPrefix;
    }

    public int getReplicationProducerQueueSize() {
        return this.replicationProducerQueueSize;
    }

    public int getReplicationPolicyCheckDurationSeconds() {
        return this.replicationPolicyCheckDurationSeconds;
    }

    @Deprecated
    public boolean isReplicationTlsEnabled() {
        return this.replicationTlsEnabled;
    }

    public boolean isBrokerClientTlsEnabled() {
        return this.brokerClientTlsEnabled;
    }

    public int getDefaultRetentionTimeInMinutes() {
        return this.defaultRetentionTimeInMinutes;
    }

    public int getDefaultRetentionSizeInMB() {
        return this.defaultRetentionSizeInMB;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    @Deprecated
    public int getBrokerServicePurgeInactiveFrequencyInSeconds() {
        return this.brokerServicePurgeInactiveFrequencyInSeconds;
    }

    public List<String> getBootstrapNamespaces() {
        return this.bootstrapNamespaces;
    }

    public boolean isPreferLaterVersions() {
        return this.preferLaterVersions;
    }

    public int getBrokerServiceCompactionMonitorIntervalInSeconds() {
        return this.brokerServiceCompactionMonitorIntervalInSeconds;
    }

    public long getBrokerServiceCompactionThresholdInBytes() {
        return this.brokerServiceCompactionThresholdInBytes;
    }

    public long getBrokerServiceCompactionPhaseOneLoopTimeInSeconds() {
        return this.brokerServiceCompactionPhaseOneLoopTimeInSeconds;
    }

    public boolean isSchemaValidationEnforced() {
        return this.isSchemaValidationEnforced;
    }

    public String getSchemaRegistryStorageClassName() {
        return this.schemaRegistryStorageClassName;
    }

    public Set<String> getSchemaRegistryCompatibilityCheckers() {
        return this.schemaRegistryCompatibilityCheckers;
    }

    public int getWebSocketNumIoThreads() {
        return this.webSocketNumIoThreads;
    }

    public int getWebSocketConnectionsPerBroker() {
        return this.webSocketConnectionsPerBroker;
    }

    public int getWebSocketSessionIdleTimeoutMillis() {
        return this.webSocketSessionIdleTimeoutMillis;
    }

    public int getWebSocketMaxTextFrameSize() {
        return this.webSocketMaxTextFrameSize;
    }

    public boolean isExposeTopicLevelMetricsInPrometheus() {
        return this.exposeTopicLevelMetricsInPrometheus;
    }

    public boolean isExposeConsumerLevelMetricsInPrometheus() {
        return this.exposeConsumerLevelMetricsInPrometheus;
    }

    public boolean isExposeProducerLevelMetricsInPrometheus() {
        return this.exposeProducerLevelMetricsInPrometheus;
    }

    public boolean isExposeManagedLedgerMetricsInPrometheus() {
        return this.exposeManagedLedgerMetricsInPrometheus;
    }

    public boolean isExposeManagedCursorMetricsInPrometheus() {
        return this.exposeManagedCursorMetricsInPrometheus;
    }

    public String getJvmGCMetricsLoggerClassName() {
        return this.jvmGCMetricsLoggerClassName;
    }

    public boolean isExposePreciseBacklogInPrometheus() {
        return this.exposePreciseBacklogInPrometheus;
    }

    public long getMetricsServletTimeoutMs() {
        return this.metricsServletTimeoutMs;
    }

    public boolean isExposeSubscriptionBacklogSizeInPrometheus() {
        return this.exposeSubscriptionBacklogSizeInPrometheus;
    }

    public boolean isSplitTopicAndPartitionLabelInPrometheus() {
        return this.splitTopicAndPartitionLabelInPrometheus;
    }

    public boolean isExposeBundlesMetricsInPrometheus() {
        return this.exposeBundlesMetricsInPrometheus;
    }

    public boolean isFunctionsWorkerEnabled() {
        return this.functionsWorkerEnabled;
    }

    public String getFunctionsWorkerServiceNarPackage() {
        return this.functionsWorkerServiceNarPackage;
    }

    public boolean isExposePublisherStats() {
        return this.exposePublisherStats;
    }

    public int getStatsUpdateFrequencyInSecs() {
        return this.statsUpdateFrequencyInSecs;
    }

    public int getStatsUpdateInitialDelayInSecs() {
        return this.statsUpdateInitialDelayInSecs;
    }

    public boolean isAggregatePublisherStatsByProducerName() {
        return this.aggregatePublisherStatsByProducerName;
    }

    public String getOffloadersDirectory() {
        return this.offloadersDirectory;
    }

    public String getManagedLedgerOffloadDriver() {
        return this.managedLedgerOffloadDriver;
    }

    public int getManagedLedgerOffloadMaxThreads() {
        return this.managedLedgerOffloadMaxThreads;
    }

    public String getNarExtractionDirectory() {
        return this.narExtractionDirectory;
    }

    public int getManagedLedgerOffloadPrefetchRounds() {
        return this.managedLedgerOffloadPrefetchRounds;
    }

    public int getManagedLedgerInactiveLedgerRolloverTimeSeconds() {
        return this.managedLedgerInactiveLedgerRolloverTimeSeconds;
    }

    public boolean isTransactionCoordinatorEnabled() {
        return this.transactionCoordinatorEnabled;
    }

    public String getTransactionMetadataStoreProviderClassName() {
        return this.transactionMetadataStoreProviderClassName;
    }

    public String getTransactionBufferProviderClassName() {
        return this.transactionBufferProviderClassName;
    }

    public String getTransactionPendingAckStoreProviderClassName() {
        return this.transactionPendingAckStoreProviderClassName;
    }

    public int getNumTransactionReplayThreadPoolSize() {
        return this.numTransactionReplayThreadPoolSize;
    }

    public int getTransactionBufferSnapshotMaxTransactionCount() {
        return this.transactionBufferSnapshotMaxTransactionCount;
    }

    public int getTransactionBufferSnapshotMinTimeInMillis() {
        return this.transactionBufferSnapshotMinTimeInMillis;
    }

    public boolean isTlsEnabledWithKeyStore() {
        return this.tlsEnabledWithKeyStore;
    }

    public String getTlsProvider() {
        return this.tlsProvider;
    }

    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    public String getTlsKeyStore() {
        return this.tlsKeyStore;
    }

    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public boolean isBrokerClientTlsEnabledWithKeyStore() {
        return this.brokerClientTlsEnabledWithKeyStore;
    }

    public String getBrokerClientSslProvider() {
        return this.brokerClientSslProvider;
    }

    public String getBrokerClientTlsTrustStoreType() {
        return this.brokerClientTlsTrustStoreType;
    }

    public String getBrokerClientTlsTrustStore() {
        return this.brokerClientTlsTrustStore;
    }

    public String getBrokerClientTlsTrustStorePassword() {
        return this.brokerClientTlsTrustStorePassword;
    }

    public Set<String> getBrokerClientTlsCiphers() {
        return this.brokerClientTlsCiphers;
    }

    public Set<String> getBrokerClientTlsProtocols() {
        return this.brokerClientTlsProtocols;
    }

    public boolean isEnablePackagesManagement() {
        return this.enablePackagesManagement;
    }

    public String getPackagesManagementStorageProvider() {
        return this.packagesManagementStorageProvider;
    }

    public int getPackagesReplicas() {
        return this.packagesReplicas;
    }

    public String getPackagesManagementLedgerRootPath() {
        return this.packagesManagementLedgerRootPath;
    }

    public String getAdditionalServletDirectory() {
        return this.additionalServletDirectory;
    }

    public Set<String> getAdditionalServlets() {
        return this.additionalServlets;
    }

    @Deprecated
    public void setZookeeperServers(String zookeeperServers) {
        this.zookeeperServers = zookeeperServers;
    }

    public void setMetadataStoreUrl(String metadataStoreUrl) {
        this.metadataStoreUrl = metadataStoreUrl;
    }

    @Deprecated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    @Deprecated
    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    public void setConfigurationMetadataStoreUrl(String configurationMetadataStoreUrl) {
        this.configurationMetadataStoreUrl = configurationMetadataStoreUrl;
    }

    public void setBrokerServicePort(Optional<Integer> brokerServicePort) {
        this.brokerServicePort = brokerServicePort;
    }

    public void setBrokerServicePortTls(Optional<Integer> brokerServicePortTls) {
        this.brokerServicePortTls = brokerServicePortTls;
    }

    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    public void setWebServiceTlsProtocols(Set<String> webServiceTlsProtocols) {
        this.webServiceTlsProtocols = webServiceTlsProtocols;
    }

    public void setWebServiceTlsCiphers(Set<String> webServiceTlsCiphers) {
        this.webServiceTlsCiphers = webServiceTlsCiphers;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setAdvertisedAddress(String advertisedAddress) {
        this.advertisedAddress = advertisedAddress;
    }

    public void setAdvertisedListeners(String advertisedListeners) {
        this.advertisedListeners = advertisedListeners;
    }

    public void setInternalListenerName(String internalListenerName) {
        this.internalListenerName = internalListenerName;
    }

    public void setBindAddresses(String bindAddresses) {
        this.bindAddresses = bindAddresses;
    }

    public void setHaProxyProtocolEnabled(boolean haProxyProtocolEnabled) {
        this.haProxyProtocolEnabled = haProxyProtocolEnabled;
    }

    public void setNumAcceptorThreads(int numAcceptorThreads) {
        this.numAcceptorThreads = numAcceptorThreads;
    }

    public void setNumIOThreads(int numIOThreads) {
        this.numIOThreads = numIOThreads;
    }

    public void setNumOrderedExecutorThreads(int numOrderedExecutorThreads) {
        this.numOrderedExecutorThreads = numOrderedExecutorThreads;
    }

    public void setNumHttpServerThreads(int numHttpServerThreads) {
        this.numHttpServerThreads = numHttpServerThreads;
    }

    public void setNumExecutorThreadPoolSize(int numExecutorThreadPoolSize) {
        this.numExecutorThreadPoolSize = numExecutorThreadPoolSize;
    }

    public void setNumCacheExecutorThreadPoolSize(int numCacheExecutorThreadPoolSize) {
        this.numCacheExecutorThreadPoolSize = numCacheExecutorThreadPoolSize;
    }

    public void setEnableBusyWait(boolean enableBusyWait) {
        this.enableBusyWait = enableBusyWait;
    }

    public void setMaxConcurrentHttpRequests(int maxConcurrentHttpRequests) {
        this.maxConcurrentHttpRequests = maxConcurrentHttpRequests;
    }

    public void setDelayedDeliveryEnabled(boolean delayedDeliveryEnabled) {
        this.delayedDeliveryEnabled = delayedDeliveryEnabled;
    }

    public void setDelayedDeliveryTrackerFactoryClassName(String delayedDeliveryTrackerFactoryClassName) {
        this.delayedDeliveryTrackerFactoryClassName = delayedDeliveryTrackerFactoryClassName;
    }

    public void setDelayedDeliveryTickTimeMillis(long delayedDeliveryTickTimeMillis) {
        this.delayedDeliveryTickTimeMillis = delayedDeliveryTickTimeMillis;
    }

    public void setAcknowledgmentAtBatchIndexLevelEnabled(boolean acknowledgmentAtBatchIndexLevelEnabled) {
        this.acknowledgmentAtBatchIndexLevelEnabled = acknowledgmentAtBatchIndexLevelEnabled;
    }

    public void setWebSocketServiceEnabled(boolean webSocketServiceEnabled) {
        this.webSocketServiceEnabled = webSocketServiceEnabled;
    }

    public void setRunningStandalone(boolean isRunningStandalone) {
        this.isRunningStandalone = isRunningStandalone;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setMaxTenants(int maxTenants) {
        this.maxTenants = maxTenants;
    }

    public void setFailureDomainsEnabled(boolean failureDomainsEnabled) {
        this.failureDomainsEnabled = failureDomainsEnabled;
    }

    public void setMetadataStoreSessionTimeoutMillis(long metadataStoreSessionTimeoutMillis) {
        this.metadataStoreSessionTimeoutMillis = metadataStoreSessionTimeoutMillis;
    }

    public void setMetadataStoreOperationTimeoutSeconds(int metadataStoreOperationTimeoutSeconds) {
        this.metadataStoreOperationTimeoutSeconds = metadataStoreOperationTimeoutSeconds;
    }

    public void setMetadataStoreCacheExpirySeconds(int metadataStoreCacheExpirySeconds) {
        this.metadataStoreCacheExpirySeconds = metadataStoreCacheExpirySeconds;
    }

    @Deprecated
    public void setZooKeeperSessionTimeoutMillis(long zooKeeperSessionTimeoutMillis) {
        this.zooKeeperSessionTimeoutMillis = zooKeeperSessionTimeoutMillis;
    }

    @Deprecated
    public void setZooKeeperOperationTimeoutSeconds(int zooKeeperOperationTimeoutSeconds) {
        this.zooKeeperOperationTimeoutSeconds = zooKeeperOperationTimeoutSeconds;
    }

    @Deprecated
    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    public void setBrokerShutdownTimeoutMs(long brokerShutdownTimeoutMs) {
        this.brokerShutdownTimeoutMs = brokerShutdownTimeoutMs;
    }

    public void setSkipBrokerShutdownOnOOM(boolean skipBrokerShutdownOnOOM) {
        this.skipBrokerShutdownOnOOM = skipBrokerShutdownOnOOM;
    }

    public void setTopicLoadTimeoutSeconds(long topicLoadTimeoutSeconds) {
        this.topicLoadTimeoutSeconds = topicLoadTimeoutSeconds;
    }

    public void setMetadataStoreBatchingEnabled(boolean metadataStoreBatchingEnabled) {
        this.metadataStoreBatchingEnabled = metadataStoreBatchingEnabled;
    }

    public void setMetadataStoreBatchingMaxDelayMillis(int metadataStoreBatchingMaxDelayMillis) {
        this.metadataStoreBatchingMaxDelayMillis = metadataStoreBatchingMaxDelayMillis;
    }

    public void setMetadataStoreBatchingMaxOperations(int metadataStoreBatchingMaxOperations) {
        this.metadataStoreBatchingMaxOperations = metadataStoreBatchingMaxOperations;
    }

    public void setMetadataStoreBatchingMaxSizeKb(int metadataStoreBatchingMaxSizeKb) {
        this.metadataStoreBatchingMaxSizeKb = metadataStoreBatchingMaxSizeKb;
    }

    public void setMetadataStoreConfigPath(String metadataStoreConfigPath) {
        this.metadataStoreConfigPath = metadataStoreConfigPath;
    }

    public void setBacklogQuotaCheckEnabled(boolean backlogQuotaCheckEnabled) {
        this.backlogQuotaCheckEnabled = backlogQuotaCheckEnabled;
    }

    public void setPreciseTimeBasedBacklogQuotaCheck(boolean preciseTimeBasedBacklogQuotaCheck) {
        this.preciseTimeBasedBacklogQuotaCheck = preciseTimeBasedBacklogQuotaCheck;
    }

    public void setBacklogQuotaCheckIntervalInSeconds(int backlogQuotaCheckIntervalInSeconds) {
        this.backlogQuotaCheckIntervalInSeconds = backlogQuotaCheckIntervalInSeconds;
    }

    @Deprecated
    public void setBacklogQuotaDefaultLimitGB(double backlogQuotaDefaultLimitGB) {
        this.backlogQuotaDefaultLimitGB = backlogQuotaDefaultLimitGB;
    }

    public void setBacklogQuotaDefaultLimitBytes(long backlogQuotaDefaultLimitBytes) {
        this.backlogQuotaDefaultLimitBytes = backlogQuotaDefaultLimitBytes;
    }

    public void setBacklogQuotaDefaultLimitSecond(int backlogQuotaDefaultLimitSecond) {
        this.backlogQuotaDefaultLimitSecond = backlogQuotaDefaultLimitSecond;
    }

    public void setBacklogQuotaDefaultRetentionPolicy(BacklogQuota.RetentionPolicy backlogQuotaDefaultRetentionPolicy) {
        this.backlogQuotaDefaultRetentionPolicy = backlogQuotaDefaultRetentionPolicy;
    }

    public void setTtlDurationDefaultInSeconds(int ttlDurationDefaultInSeconds) {
        this.ttlDurationDefaultInSeconds = ttlDurationDefaultInSeconds;
    }

    public void setBrokerDeleteInactiveTopicsEnabled(boolean brokerDeleteInactiveTopicsEnabled) {
        this.brokerDeleteInactiveTopicsEnabled = brokerDeleteInactiveTopicsEnabled;
    }

    public void setBrokerDeleteInactivePartitionedTopicMetadataEnabled(boolean brokerDeleteInactivePartitionedTopicMetadataEnabled) {
        this.brokerDeleteInactivePartitionedTopicMetadataEnabled = brokerDeleteInactivePartitionedTopicMetadataEnabled;
    }

    public void setBrokerDeleteInactiveTopicsFrequencySeconds(int brokerDeleteInactiveTopicsFrequencySeconds) {
        this.brokerDeleteInactiveTopicsFrequencySeconds = brokerDeleteInactiveTopicsFrequencySeconds;
    }

    public void setBrokerDeleteInactiveTopicsMode(InactiveTopicDeleteMode brokerDeleteInactiveTopicsMode) {
        this.brokerDeleteInactiveTopicsMode = brokerDeleteInactiveTopicsMode;
    }

    public void setBrokerDeleteInactiveTopicsMaxInactiveDurationSeconds(Integer brokerDeleteInactiveTopicsMaxInactiveDurationSeconds) {
        this.brokerDeleteInactiveTopicsMaxInactiveDurationSeconds = brokerDeleteInactiveTopicsMaxInactiveDurationSeconds;
    }

    public void setForceDeleteTenantAllowed(boolean forceDeleteTenantAllowed) {
        this.forceDeleteTenantAllowed = forceDeleteTenantAllowed;
    }

    public void setForceDeleteNamespaceAllowed(boolean forceDeleteNamespaceAllowed) {
        this.forceDeleteNamespaceAllowed = forceDeleteNamespaceAllowed;
    }

    public void setMaxPendingPublishRequestsPerConnection(int maxPendingPublishRequestsPerConnection) {
        this.maxPendingPublishRequestsPerConnection = maxPendingPublishRequestsPerConnection;
    }

    public void setMessageExpiryCheckIntervalInMinutes(int messageExpiryCheckIntervalInMinutes) {
        this.messageExpiryCheckIntervalInMinutes = messageExpiryCheckIntervalInMinutes;
    }

    public void setActiveConsumerFailoverDelayTimeMillis(int activeConsumerFailoverDelayTimeMillis) {
        this.activeConsumerFailoverDelayTimeMillis = activeConsumerFailoverDelayTimeMillis;
    }

    public void setSubscriptionExpirationTimeMinutes(int subscriptionExpirationTimeMinutes) {
        this.subscriptionExpirationTimeMinutes = subscriptionExpirationTimeMinutes;
    }

    public void setSubscriptionRedeliveryTrackerEnabled(boolean subscriptionRedeliveryTrackerEnabled) {
        this.subscriptionRedeliveryTrackerEnabled = subscriptionRedeliveryTrackerEnabled;
    }

    public void setSubscriptionExpiryCheckIntervalInMinutes(int subscriptionExpiryCheckIntervalInMinutes) {
        this.subscriptionExpiryCheckIntervalInMinutes = subscriptionExpiryCheckIntervalInMinutes;
    }

    public void setSubscriptionTypesEnabled(Set<String> subscriptionTypesEnabled) {
        this.subscriptionTypesEnabled = subscriptionTypesEnabled;
    }

    @Deprecated
    public void setSubscriptionKeySharedEnable(boolean subscriptionKeySharedEnable) {
        this.subscriptionKeySharedEnable = subscriptionKeySharedEnable;
    }

    public void setSubscriptionKeySharedUseConsistentHashing(boolean subscriptionKeySharedUseConsistentHashing) {
        this.subscriptionKeySharedUseConsistentHashing = subscriptionKeySharedUseConsistentHashing;
    }

    public void setSubscriptionKeySharedConsistentHashingReplicaPoints(int subscriptionKeySharedConsistentHashingReplicaPoints) {
        this.subscriptionKeySharedConsistentHashingReplicaPoints = subscriptionKeySharedConsistentHashingReplicaPoints;
    }

    public void setBrokerDeduplicationEnabled(boolean brokerDeduplicationEnabled) {
        this.brokerDeduplicationEnabled = brokerDeduplicationEnabled;
    }

    public void setBrokerDeduplicationMaxNumberOfProducers(int brokerDeduplicationMaxNumberOfProducers) {
        this.brokerDeduplicationMaxNumberOfProducers = brokerDeduplicationMaxNumberOfProducers;
    }

    public void setBrokerDeduplicationSnapshotFrequencyInSeconds(int brokerDeduplicationSnapshotFrequencyInSeconds) {
        this.brokerDeduplicationSnapshotFrequencyInSeconds = brokerDeduplicationSnapshotFrequencyInSeconds;
    }

    public void setBrokerDeduplicationSnapshotIntervalSeconds(Integer brokerDeduplicationSnapshotIntervalSeconds) {
        this.brokerDeduplicationSnapshotIntervalSeconds = brokerDeduplicationSnapshotIntervalSeconds;
    }

    public void setBrokerDeduplicationEntriesInterval(int brokerDeduplicationEntriesInterval) {
        this.brokerDeduplicationEntriesInterval = brokerDeduplicationEntriesInterval;
    }

    public void setBrokerDeduplicationProducerInactivityTimeoutMinutes(int brokerDeduplicationProducerInactivityTimeoutMinutes) {
        this.brokerDeduplicationProducerInactivityTimeoutMinutes = brokerDeduplicationProducerInactivityTimeoutMinutes;
    }

    public void setDefaultNumberOfNamespaceBundles(int defaultNumberOfNamespaceBundles) {
        this.defaultNumberOfNamespaceBundles = defaultNumberOfNamespaceBundles;
    }

    public void setMaxNamespacesPerTenant(int maxNamespacesPerTenant) {
        this.maxNamespacesPerTenant = maxNamespacesPerTenant;
    }

    public void setMaxTopicsPerNamespace(int maxTopicsPerNamespace) {
        this.maxTopicsPerNamespace = maxTopicsPerNamespace;
    }

    public void setBrokerMaxConnections(int brokerMaxConnections) {
        this.brokerMaxConnections = brokerMaxConnections;
    }

    public void setBrokerMaxConnectionsPerIp(int brokerMaxConnectionsPerIp) {
        this.brokerMaxConnectionsPerIp = brokerMaxConnectionsPerIp;
    }

    public void setAllowAutoUpdateSchemaEnabled(boolean isAllowAutoUpdateSchemaEnabled) {
        this.isAllowAutoUpdateSchemaEnabled = isAllowAutoUpdateSchemaEnabled;
    }

    public void setAutoShrinkForConsumerPendingAcksMap(boolean autoShrinkForConsumerPendingAcksMap) {
        this.autoShrinkForConsumerPendingAcksMap = autoShrinkForConsumerPendingAcksMap;
    }

    public void setClientLibraryVersionCheckEnabled(boolean clientLibraryVersionCheckEnabled) {
        this.clientLibraryVersionCheckEnabled = clientLibraryVersionCheckEnabled;
    }

    public void setStatusFilePath(String statusFilePath) {
        this.statusFilePath = statusFilePath;
    }

    public void setMaxUnackedMessagesPerConsumer(int maxUnackedMessagesPerConsumer) {
        this.maxUnackedMessagesPerConsumer = maxUnackedMessagesPerConsumer;
    }

    public void setMaxUnackedMessagesPerSubscription(int maxUnackedMessagesPerSubscription) {
        this.maxUnackedMessagesPerSubscription = maxUnackedMessagesPerSubscription;
    }

    public void setMaxUnackedMessagesPerBroker(int maxUnackedMessagesPerBroker) {
        this.maxUnackedMessagesPerBroker = maxUnackedMessagesPerBroker;
    }

    public void setMaxUnackedMessagesPerSubscriptionOnBrokerBlocked(double maxUnackedMessagesPerSubscriptionOnBrokerBlocked) {
        this.maxUnackedMessagesPerSubscriptionOnBrokerBlocked = maxUnackedMessagesPerSubscriptionOnBrokerBlocked;
    }

    public void setUnblockStuckSubscriptionEnabled(boolean unblockStuckSubscriptionEnabled) {
        this.unblockStuckSubscriptionEnabled = unblockStuckSubscriptionEnabled;
    }

    public void setTopicPublisherThrottlingTickTimeMillis(int topicPublisherThrottlingTickTimeMillis) {
        this.topicPublisherThrottlingTickTimeMillis = topicPublisherThrottlingTickTimeMillis;
    }

    public void setPreciseTopicPublishRateLimiterEnable(boolean preciseTopicPublishRateLimiterEnable) {
        this.preciseTopicPublishRateLimiterEnable = preciseTopicPublishRateLimiterEnable;
    }

    public void setBrokerPublisherThrottlingTickTimeMillis(int brokerPublisherThrottlingTickTimeMillis) {
        this.brokerPublisherThrottlingTickTimeMillis = brokerPublisherThrottlingTickTimeMillis;
    }

    public void setBrokerPublisherThrottlingMaxMessageRate(int brokerPublisherThrottlingMaxMessageRate) {
        this.brokerPublisherThrottlingMaxMessageRate = brokerPublisherThrottlingMaxMessageRate;
    }

    public void setBrokerPublisherThrottlingMaxByteRate(long brokerPublisherThrottlingMaxByteRate) {
        this.brokerPublisherThrottlingMaxByteRate = brokerPublisherThrottlingMaxByteRate;
    }

    public void setDispatchThrottlingRateInMsg(int dispatchThrottlingRateInMsg) {
        this.dispatchThrottlingRateInMsg = dispatchThrottlingRateInMsg;
    }

    public void setDispatchThrottlingRateInByte(long dispatchThrottlingRateInByte) {
        this.dispatchThrottlingRateInByte = dispatchThrottlingRateInByte;
    }

    public void setMaxPublishRatePerTopicInMessages(int maxPublishRatePerTopicInMessages) {
        this.maxPublishRatePerTopicInMessages = maxPublishRatePerTopicInMessages;
    }

    public void setMaxPublishRatePerTopicInBytes(long maxPublishRatePerTopicInBytes) {
        this.maxPublishRatePerTopicInBytes = maxPublishRatePerTopicInBytes;
    }

    public void setSubscribeThrottlingRatePerConsumer(int subscribeThrottlingRatePerConsumer) {
        this.subscribeThrottlingRatePerConsumer = subscribeThrottlingRatePerConsumer;
    }

    public void setSubscribeRatePeriodPerConsumerInSecond(int subscribeRatePeriodPerConsumerInSecond) {
        this.subscribeRatePeriodPerConsumerInSecond = subscribeRatePeriodPerConsumerInSecond;
    }

    public void setDispatchThrottlingRatePerTopicInMsg(int dispatchThrottlingRatePerTopicInMsg) {
        this.dispatchThrottlingRatePerTopicInMsg = dispatchThrottlingRatePerTopicInMsg;
    }

    public void setDispatchThrottlingRatePerTopicInByte(long dispatchThrottlingRatePerTopicInByte) {
        this.dispatchThrottlingRatePerTopicInByte = dispatchThrottlingRatePerTopicInByte;
    }

    public void setDispatchThrottlingOnBatchMessageEnabled(boolean dispatchThrottlingOnBatchMessageEnabled) {
        this.dispatchThrottlingOnBatchMessageEnabled = dispatchThrottlingOnBatchMessageEnabled;
    }

    public void setDispatchThrottlingRatePerSubscriptionInMsg(int dispatchThrottlingRatePerSubscriptionInMsg) {
        this.dispatchThrottlingRatePerSubscriptionInMsg = dispatchThrottlingRatePerSubscriptionInMsg;
    }

    public void setDispatchThrottlingRatePerSubscriptionInByte(long dispatchThrottlingRatePerSubscriptionInByte) {
        this.dispatchThrottlingRatePerSubscriptionInByte = dispatchThrottlingRatePerSubscriptionInByte;
    }

    public void setDispatchThrottlingRatePerReplicatorInMsg(int dispatchThrottlingRatePerReplicatorInMsg) {
        this.dispatchThrottlingRatePerReplicatorInMsg = dispatchThrottlingRatePerReplicatorInMsg;
    }

    public void setDispatchThrottlingRatePerReplicatorInByte(long dispatchThrottlingRatePerReplicatorInByte) {
        this.dispatchThrottlingRatePerReplicatorInByte = dispatchThrottlingRatePerReplicatorInByte;
    }

    public void setDispatchThrottlingRateRelativeToPublishRate(boolean dispatchThrottlingRateRelativeToPublishRate) {
        this.dispatchThrottlingRateRelativeToPublishRate = dispatchThrottlingRateRelativeToPublishRate;
    }

    public void setDispatchThrottlingOnNonBacklogConsumerEnabled(boolean dispatchThrottlingOnNonBacklogConsumerEnabled) {
        this.dispatchThrottlingOnNonBacklogConsumerEnabled = dispatchThrottlingOnNonBacklogConsumerEnabled;
    }

    public void setResourceUsageTransportClassName(String resourceUsageTransportClassName) {
        this.resourceUsageTransportClassName = resourceUsageTransportClassName;
    }

    public void setResourceUsageTransportPublishIntervalInSecs(int resourceUsageTransportPublishIntervalInSecs) {
        this.resourceUsageTransportPublishIntervalInSecs = resourceUsageTransportPublishIntervalInSecs;
    }

    public void setDispatcherMaxReadBatchSize(int dispatcherMaxReadBatchSize) {
        this.dispatcherMaxReadBatchSize = dispatcherMaxReadBatchSize;
    }

    public void setDispatcherMaxReadSizeBytes(int dispatcherMaxReadSizeBytes) {
        this.dispatcherMaxReadSizeBytes = dispatcherMaxReadSizeBytes;
    }

    public void setDispatcherMinReadBatchSize(int dispatcherMinReadBatchSize) {
        this.dispatcherMinReadBatchSize = dispatcherMinReadBatchSize;
    }

    public void setDispatcherReadFailureBackoffInitialTimeInMs(int dispatcherReadFailureBackoffInitialTimeInMs) {
        this.dispatcherReadFailureBackoffInitialTimeInMs = dispatcherReadFailureBackoffInitialTimeInMs;
    }

    public void setDispatcherReadFailureBackoffMaxTimeInMs(int dispatcherReadFailureBackoffMaxTimeInMs) {
        this.dispatcherReadFailureBackoffMaxTimeInMs = dispatcherReadFailureBackoffMaxTimeInMs;
    }

    public void setDispatcherReadFailureBackoffMandatoryStopTimeInMs(int dispatcherReadFailureBackoffMandatoryStopTimeInMs) {
        this.dispatcherReadFailureBackoffMandatoryStopTimeInMs = dispatcherReadFailureBackoffMandatoryStopTimeInMs;
    }

    public void setDispatcherMaxRoundRobinBatchSize(int dispatcherMaxRoundRobinBatchSize) {
        this.dispatcherMaxRoundRobinBatchSize = dispatcherMaxRoundRobinBatchSize;
    }

    public void setPreciseDispatcherFlowControl(boolean preciseDispatcherFlowControl) {
        this.preciseDispatcherFlowControl = preciseDispatcherFlowControl;
    }

    public void setEntryFilterNames(List<String> entryFilterNames) {
        this.entryFilterNames = entryFilterNames;
    }

    public void setEntryFiltersDirectory(String entryFiltersDirectory) {
        this.entryFiltersDirectory = entryFiltersDirectory;
    }

    public void setStreamingDispatch(boolean streamingDispatch) {
        this.streamingDispatch = streamingDispatch;
    }

    public void setMaxConcurrentLookupRequest(int maxConcurrentLookupRequest) {
        this.maxConcurrentLookupRequest = maxConcurrentLookupRequest;
    }

    public void setMaxConcurrentTopicLoadRequest(int maxConcurrentTopicLoadRequest) {
        this.maxConcurrentTopicLoadRequest = maxConcurrentTopicLoadRequest;
    }

    public void setMaxConcurrentNonPersistentMessagePerConnection(int maxConcurrentNonPersistentMessagePerConnection) {
        this.maxConcurrentNonPersistentMessagePerConnection = maxConcurrentNonPersistentMessagePerConnection;
    }

    public void setNumWorkerThreadsForNonPersistentTopic(int numWorkerThreadsForNonPersistentTopic) {
        this.numWorkerThreadsForNonPersistentTopic = numWorkerThreadsForNonPersistentTopic;
    }

    public void setEnablePersistentTopics(boolean enablePersistentTopics) {
        this.enablePersistentTopics = enablePersistentTopics;
    }

    public void setEnableNonPersistentTopics(boolean enableNonPersistentTopics) {
        this.enableNonPersistentTopics = enableNonPersistentTopics;
    }

    public void setEnableRunBookieTogether(boolean enableRunBookieTogether) {
        this.enableRunBookieTogether = enableRunBookieTogether;
    }

    public void setEnableRunBookieAutoRecoveryTogether(boolean enableRunBookieAutoRecoveryTogether) {
        this.enableRunBookieAutoRecoveryTogether = enableRunBookieAutoRecoveryTogether;
    }

    public void setMaxProducersPerTopic(int maxProducersPerTopic) {
        this.maxProducersPerTopic = maxProducersPerTopic;
    }

    public void setMaxSameAddressProducersPerTopic(int maxSameAddressProducersPerTopic) {
        this.maxSameAddressProducersPerTopic = maxSameAddressProducersPerTopic;
    }

    public void setEncryptionRequireOnProducer(boolean encryptionRequireOnProducer) {
        this.encryptionRequireOnProducer = encryptionRequireOnProducer;
    }

    public void setMaxConsumersPerTopic(int maxConsumersPerTopic) {
        this.maxConsumersPerTopic = maxConsumersPerTopic;
    }

    public void setMaxSameAddressConsumersPerTopic(int maxSameAddressConsumersPerTopic) {
        this.maxSameAddressConsumersPerTopic = maxSameAddressConsumersPerTopic;
    }

    public void setMaxSubscriptionsPerTopic(int maxSubscriptionsPerTopic) {
        this.maxSubscriptionsPerTopic = maxSubscriptionsPerTopic;
    }

    public void setMaxConsumersPerSubscription(int maxConsumersPerSubscription) {
        this.maxConsumersPerSubscription = maxConsumersPerSubscription;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public void setEnableReplicatedSubscriptions(boolean enableReplicatedSubscriptions) {
        this.enableReplicatedSubscriptions = enableReplicatedSubscriptions;
    }

    public void setReplicatedSubscriptionsSnapshotFrequencyMillis(int replicatedSubscriptionsSnapshotFrequencyMillis) {
        this.replicatedSubscriptionsSnapshotFrequencyMillis = replicatedSubscriptionsSnapshotFrequencyMillis;
    }

    public void setReplicatedSubscriptionsSnapshotTimeoutSeconds(int replicatedSubscriptionsSnapshotTimeoutSeconds) {
        this.replicatedSubscriptionsSnapshotTimeoutSeconds = replicatedSubscriptionsSnapshotTimeoutSeconds;
    }

    public void setReplicatedSubscriptionsSnapshotMaxCachedPerSubscription(int replicatedSubscriptionsSnapshotMaxCachedPerSubscription) {
        this.replicatedSubscriptionsSnapshotMaxCachedPerSubscription = replicatedSubscriptionsSnapshotMaxCachedPerSubscription;
    }

    public void setMaxMessagePublishBufferSizeInMB(int maxMessagePublishBufferSizeInMB) {
        this.maxMessagePublishBufferSizeInMB = maxMessagePublishBufferSizeInMB;
    }

    public void setMessagePublishBufferCheckIntervalInMillis(int messagePublishBufferCheckIntervalInMillis) {
        this.messagePublishBufferCheckIntervalInMillis = messagePublishBufferCheckIntervalInMillis;
    }

    public void setLazyCursorRecovery(boolean lazyCursorRecovery) {
        this.lazyCursorRecovery = lazyCursorRecovery;
    }

    public void setRetentionCheckIntervalInSeconds(int retentionCheckIntervalInSeconds) {
        this.retentionCheckIntervalInSeconds = retentionCheckIntervalInSeconds;
    }

    public void setMaxNumPartitionsPerPartitionedTopic(int maxNumPartitionsPerPartitionedTopic) {
        this.maxNumPartitionsPerPartitionedTopic = maxNumPartitionsPerPartitionedTopic;
    }

    public void setBrokerInterceptorsDirectory(String brokerInterceptorsDirectory) {
        this.brokerInterceptorsDirectory = brokerInterceptorsDirectory;
    }

    public void setBrokerInterceptors(Set<String> brokerInterceptors) {
        this.brokerInterceptors = brokerInterceptors;
    }

    public void setDisableBrokerInterceptors(boolean disableBrokerInterceptors) {
        this.disableBrokerInterceptors = disableBrokerInterceptors;
    }

    public void setBrokerEntryPayloadProcessors(Set<String> brokerEntryPayloadProcessors) {
        this.brokerEntryPayloadProcessors = brokerEntryPayloadProcessors;
    }

    public void setZookeeperSessionExpiredPolicy(MetadataSessionExpiredPolicy zookeeperSessionExpiredPolicy) {
        this.zookeeperSessionExpiredPolicy = zookeeperSessionExpiredPolicy;
    }

    public void setTopicFencingTimeoutSeconds(int topicFencingTimeoutSeconds) {
        this.topicFencingTimeoutSeconds = topicFencingTimeoutSeconds;
    }

    public void setProtocolHandlerDirectory(String protocolHandlerDirectory) {
        this.protocolHandlerDirectory = protocolHandlerDirectory;
    }

    public void setUseSeparateThreadPoolForProtocolHandlers(boolean useSeparateThreadPoolForProtocolHandlers) {
        this.useSeparateThreadPoolForProtocolHandlers = useSeparateThreadPoolForProtocolHandlers;
    }

    public void setMessagingProtocols(Set<String> messagingProtocols) {
        this.messagingProtocols = messagingProtocols;
    }

    public void setSystemTopicEnabled(boolean systemTopicEnabled) {
        this.systemTopicEnabled = systemTopicEnabled;
    }

    public void setSystemTopicSchemaCompatibilityStrategy(SchemaCompatibilityStrategy systemTopicSchemaCompatibilityStrategy) {
        this.systemTopicSchemaCompatibilityStrategy = systemTopicSchemaCompatibilityStrategy;
    }

    public void setTopicLevelPoliciesEnabled(boolean topicLevelPoliciesEnabled) {
        this.topicLevelPoliciesEnabled = topicLevelPoliciesEnabled;
    }

    public void setBrokerEntryMetadataInterceptors(Set<String> brokerEntryMetadataInterceptors) {
        this.brokerEntryMetadataInterceptors = brokerEntryMetadataInterceptors;
    }

    public void setExposingBrokerEntryMetadataToClientEnabled(boolean exposingBrokerEntryMetadataToClientEnabled) {
        this.exposingBrokerEntryMetadataToClientEnabled = exposingBrokerEntryMetadataToClientEnabled;
    }

    public void setEnableNamespaceIsolationUpdateOnTime(boolean enableNamespaceIsolationUpdateOnTime) {
        this.enableNamespaceIsolationUpdateOnTime = enableNamespaceIsolationUpdateOnTime;
    }

    @Deprecated
    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsProtocols(Set<String> tlsProtocols) {
        this.tlsProtocols = tlsProtocols;
    }

    public void setTlsCiphers(Set<String> tlsCiphers) {
        this.tlsCiphers = tlsCiphers;
    }

    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    public void setAuthenticationRefreshCheckSeconds(int authenticationRefreshCheckSeconds) {
        this.authenticationRefreshCheckSeconds = authenticationRefreshCheckSeconds;
    }

    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    public void setProxyRoles(Set<String> proxyRoles) {
        this.proxyRoles = proxyRoles;
    }

    public void setAuthenticateOriginalAuthData(boolean authenticateOriginalAuthData) {
        this.authenticateOriginalAuthData = authenticateOriginalAuthData;
    }

    public void setAuthorizationAllowWildcardsMatching(boolean authorizationAllowWildcardsMatching) {
        this.authorizationAllowWildcardsMatching = authorizationAllowWildcardsMatching;
    }

    public void setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
    }

    public void setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
    }

    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    public void setAnonymousUserRole(String anonymousUserRole) {
        this.anonymousUserRole = anonymousUserRole;
    }

    public void setHttpMaxRequestSize(long httpMaxRequestSize) {
        this.httpMaxRequestSize = httpMaxRequestSize;
    }

    public void setDisableHttpDebugMethods(boolean disableHttpDebugMethods) {
        this.disableHttpDebugMethods = disableHttpDebugMethods;
    }

    public void setHttpRequestsLimitEnabled(boolean httpRequestsLimitEnabled) {
        this.httpRequestsLimitEnabled = httpRequestsLimitEnabled;
    }

    public void setHttpRequestsMaxPerSecond(double httpRequestsMaxPerSecond) {
        this.httpRequestsMaxPerSecond = httpRequestsMaxPerSecond;
    }

    public void setSaslJaasClientAllowedIds(String saslJaasClientAllowedIds) {
        this.saslJaasClientAllowedIds = saslJaasClientAllowedIds;
    }

    public void setSaslJaasServerSectionName(String saslJaasServerSectionName) {
        this.saslJaasServerSectionName = saslJaasServerSectionName;
    }

    public void setKinitCommand(String kinitCommand) {
        this.kinitCommand = kinitCommand;
    }

    public void setBookkeeperMetadataServiceUri(String bookkeeperMetadataServiceUri) {
        this.bookkeeperMetadataServiceUri = bookkeeperMetadataServiceUri;
    }

    public void setBookkeeperClientAuthenticationPlugin(String bookkeeperClientAuthenticationPlugin) {
        this.bookkeeperClientAuthenticationPlugin = bookkeeperClientAuthenticationPlugin;
    }

    public void setBookkeeperClientAuthenticationParametersName(String bookkeeperClientAuthenticationParametersName) {
        this.bookkeeperClientAuthenticationParametersName = bookkeeperClientAuthenticationParametersName;
    }

    public void setBookkeeperClientAuthenticationParameters(String bookkeeperClientAuthenticationParameters) {
        this.bookkeeperClientAuthenticationParameters = bookkeeperClientAuthenticationParameters;
    }

    public void setBookkeeperClientTimeoutInSeconds(long bookkeeperClientTimeoutInSeconds) {
        this.bookkeeperClientTimeoutInSeconds = bookkeeperClientTimeoutInSeconds;
    }

    public void setBookkeeperClientSpeculativeReadTimeoutInMillis(int bookkeeperClientSpeculativeReadTimeoutInMillis) {
        this.bookkeeperClientSpeculativeReadTimeoutInMillis = bookkeeperClientSpeculativeReadTimeoutInMillis;
    }

    public void setBookkeeperNumberOfChannelsPerBookie(int bookkeeperNumberOfChannelsPerBookie) {
        this.bookkeeperNumberOfChannelsPerBookie = bookkeeperNumberOfChannelsPerBookie;
    }

    public void setBookkeeperUseV2WireProtocol(boolean bookkeeperUseV2WireProtocol) {
        this.bookkeeperUseV2WireProtocol = bookkeeperUseV2WireProtocol;
    }

    public void setBookkeeperClientHealthCheckEnabled(boolean bookkeeperClientHealthCheckEnabled) {
        this.bookkeeperClientHealthCheckEnabled = bookkeeperClientHealthCheckEnabled;
    }

    public void setBookkeeperClientHealthCheckIntervalSeconds(long bookkeeperClientHealthCheckIntervalSeconds) {
        this.bookkeeperClientHealthCheckIntervalSeconds = bookkeeperClientHealthCheckIntervalSeconds;
    }

    public void setBookkeeperClientHealthCheckErrorThresholdPerInterval(long bookkeeperClientHealthCheckErrorThresholdPerInterval) {
        this.bookkeeperClientHealthCheckErrorThresholdPerInterval = bookkeeperClientHealthCheckErrorThresholdPerInterval;
    }

    public void setBookkeeperClientHealthCheckQuarantineTimeInSeconds(long bookkeeperClientHealthCheckQuarantineTimeInSeconds) {
        this.bookkeeperClientHealthCheckQuarantineTimeInSeconds = bookkeeperClientHealthCheckQuarantineTimeInSeconds;
    }

    public void setBookkeeperClientQuarantineRatio(double bookkeeperClientQuarantineRatio) {
        this.bookkeeperClientQuarantineRatio = bookkeeperClientQuarantineRatio;
    }

    public void setBookkeeperClientRackawarePolicyEnabled(boolean bookkeeperClientRackawarePolicyEnabled) {
        this.bookkeeperClientRackawarePolicyEnabled = bookkeeperClientRackawarePolicyEnabled;
    }

    public void setBookkeeperClientRegionawarePolicyEnabled(boolean bookkeeperClientRegionawarePolicyEnabled) {
        this.bookkeeperClientRegionawarePolicyEnabled = bookkeeperClientRegionawarePolicyEnabled;
    }

    public void setBookkeeperClientMinNumRacksPerWriteQuorum(int bookkeeperClientMinNumRacksPerWriteQuorum) {
        this.bookkeeperClientMinNumRacksPerWriteQuorum = bookkeeperClientMinNumRacksPerWriteQuorum;
    }

    public void setBookkeeperClientEnforceMinNumRacksPerWriteQuorum(boolean bookkeeperClientEnforceMinNumRacksPerWriteQuorum) {
        this.bookkeeperClientEnforceMinNumRacksPerWriteQuorum = bookkeeperClientEnforceMinNumRacksPerWriteQuorum;
    }

    public void setBookkeeperClientReorderReadSequenceEnabled(boolean bookkeeperClientReorderReadSequenceEnabled) {
        this.bookkeeperClientReorderReadSequenceEnabled = bookkeeperClientReorderReadSequenceEnabled;
    }

    public void setBookkeeperClientIsolationGroups(String bookkeeperClientIsolationGroups) {
        this.bookkeeperClientIsolationGroups = bookkeeperClientIsolationGroups;
    }

    public void setBookkeeperClientSecondaryIsolationGroups(String bookkeeperClientSecondaryIsolationGroups) {
        this.bookkeeperClientSecondaryIsolationGroups = bookkeeperClientSecondaryIsolationGroups;
    }

    public void setBookkeeperClientGetBookieInfoIntervalSeconds(int bookkeeperClientGetBookieInfoIntervalSeconds) {
        this.bookkeeperClientGetBookieInfoIntervalSeconds = bookkeeperClientGetBookieInfoIntervalSeconds;
    }

    public void setBookkeeperClientGetBookieInfoRetryIntervalSeconds(int bookkeeperClientGetBookieInfoRetryIntervalSeconds) {
        this.bookkeeperClientGetBookieInfoRetryIntervalSeconds = bookkeeperClientGetBookieInfoRetryIntervalSeconds;
    }

    public void setBookkeeperEnableStickyReads(boolean bookkeeperEnableStickyReads) {
        this.bookkeeperEnableStickyReads = bookkeeperEnableStickyReads;
    }

    public void setBookkeeperTLSProviderFactoryClass(String bookkeeperTLSProviderFactoryClass) {
        this.bookkeeperTLSProviderFactoryClass = bookkeeperTLSProviderFactoryClass;
    }

    public void setBookkeeperTLSClientAuthentication(boolean bookkeeperTLSClientAuthentication) {
        this.bookkeeperTLSClientAuthentication = bookkeeperTLSClientAuthentication;
    }

    public void setBookkeeperTLSKeyFileType(String bookkeeperTLSKeyFileType) {
        this.bookkeeperTLSKeyFileType = bookkeeperTLSKeyFileType;
    }

    public void setBookkeeperTLSTrustCertTypes(String bookkeeperTLSTrustCertTypes) {
        this.bookkeeperTLSTrustCertTypes = bookkeeperTLSTrustCertTypes;
    }

    public void setBookkeeperTLSKeyStorePasswordPath(String bookkeeperTLSKeyStorePasswordPath) {
        this.bookkeeperTLSKeyStorePasswordPath = bookkeeperTLSKeyStorePasswordPath;
    }

    public void setBookkeeperTLSTrustStorePasswordPath(String bookkeeperTLSTrustStorePasswordPath) {
        this.bookkeeperTLSTrustStorePasswordPath = bookkeeperTLSTrustStorePasswordPath;
    }

    public void setBookkeeperTLSKeyFilePath(String bookkeeperTLSKeyFilePath) {
        this.bookkeeperTLSKeyFilePath = bookkeeperTLSKeyFilePath;
    }

    public void setBookkeeperTLSCertificateFilePath(String bookkeeperTLSCertificateFilePath) {
        this.bookkeeperTLSCertificateFilePath = bookkeeperTLSCertificateFilePath;
    }

    public void setBookkeeperTLSTrustCertsFilePath(String bookkeeperTLSTrustCertsFilePath) {
        this.bookkeeperTLSTrustCertsFilePath = bookkeeperTLSTrustCertsFilePath;
    }

    public void setBookkeeperTlsCertFilesRefreshDurationSeconds(int bookkeeperTlsCertFilesRefreshDurationSeconds) {
        this.bookkeeperTlsCertFilesRefreshDurationSeconds = bookkeeperTlsCertFilesRefreshDurationSeconds;
    }

    public void setBookkeeperDiskWeightBasedPlacementEnabled(boolean bookkeeperDiskWeightBasedPlacementEnabled) {
        this.bookkeeperDiskWeightBasedPlacementEnabled = bookkeeperDiskWeightBasedPlacementEnabled;
    }

    public void setBookkeeperExplicitLacIntervalInMills(int bookkeeperExplicitLacIntervalInMills) {
        this.bookkeeperExplicitLacIntervalInMills = bookkeeperExplicitLacIntervalInMills;
    }

    public void setBookkeeperClientExposeStatsToPrometheus(boolean bookkeeperClientExposeStatsToPrometheus) {
        this.bookkeeperClientExposeStatsToPrometheus = bookkeeperClientExposeStatsToPrometheus;
    }

    public void setBookkeeperClientThrottleValue(int bookkeeperClientThrottleValue) {
        this.bookkeeperClientThrottleValue = bookkeeperClientThrottleValue;
    }

    public void setBookkeeperClientNumWorkerThreads(int bookkeeperClientNumWorkerThreads) {
        this.bookkeeperClientNumWorkerThreads = bookkeeperClientNumWorkerThreads;
    }

    public void setManagedLedgerDefaultEnsembleSize(int managedLedgerDefaultEnsembleSize) {
        this.managedLedgerDefaultEnsembleSize = managedLedgerDefaultEnsembleSize;
    }

    public void setManagedLedgerDefaultWriteQuorum(int managedLedgerDefaultWriteQuorum) {
        this.managedLedgerDefaultWriteQuorum = managedLedgerDefaultWriteQuorum;
    }

    public void setManagedLedgerDefaultAckQuorum(int managedLedgerDefaultAckQuorum) {
        this.managedLedgerDefaultAckQuorum = managedLedgerDefaultAckQuorum;
    }

    public void setManagedLedgerCursorPositionFlushSeconds(int managedLedgerCursorPositionFlushSeconds) {
        this.managedLedgerCursorPositionFlushSeconds = managedLedgerCursorPositionFlushSeconds;
    }

    public void setManagedLedgerStatsPeriodSeconds(int managedLedgerStatsPeriodSeconds) {
        this.managedLedgerStatsPeriodSeconds = managedLedgerStatsPeriodSeconds;
    }

    public void setManagedLedgerDigestType(DigestType managedLedgerDigestType) {
        this.managedLedgerDigestType = managedLedgerDigestType;
    }

    public void setManagedLedgerPassword(String managedLedgerPassword) {
        this.managedLedgerPassword = managedLedgerPassword;
    }

    public void setManagedLedgerMaxEnsembleSize(int managedLedgerMaxEnsembleSize) {
        this.managedLedgerMaxEnsembleSize = managedLedgerMaxEnsembleSize;
    }

    public void setManagedLedgerMaxWriteQuorum(int managedLedgerMaxWriteQuorum) {
        this.managedLedgerMaxWriteQuorum = managedLedgerMaxWriteQuorum;
    }

    public void setManagedLedgerMaxAckQuorum(int managedLedgerMaxAckQuorum) {
        this.managedLedgerMaxAckQuorum = managedLedgerMaxAckQuorum;
    }

    public void setManagedLedgerCacheSizeMB(int managedLedgerCacheSizeMB) {
        this.managedLedgerCacheSizeMB = managedLedgerCacheSizeMB;
    }

    public void setManagedLedgerCacheCopyEntries(boolean managedLedgerCacheCopyEntries) {
        this.managedLedgerCacheCopyEntries = managedLedgerCacheCopyEntries;
    }

    public void setManagedLedgerCacheEvictionWatermark(double managedLedgerCacheEvictionWatermark) {
        this.managedLedgerCacheEvictionWatermark = managedLedgerCacheEvictionWatermark;
    }

    public void setManagedLedgerCacheEvictionFrequency(double managedLedgerCacheEvictionFrequency) {
        this.managedLedgerCacheEvictionFrequency = managedLedgerCacheEvictionFrequency;
    }

    public void setManagedLedgerCacheEvictionTimeThresholdMillis(long managedLedgerCacheEvictionTimeThresholdMillis) {
        this.managedLedgerCacheEvictionTimeThresholdMillis = managedLedgerCacheEvictionTimeThresholdMillis;
    }

    public void setManagedLedgerCursorBackloggedThreshold(long managedLedgerCursorBackloggedThreshold) {
        this.managedLedgerCursorBackloggedThreshold = managedLedgerCursorBackloggedThreshold;
    }

    public void setManagedLedgerDefaultMarkDeleteRateLimit(double managedLedgerDefaultMarkDeleteRateLimit) {
        this.managedLedgerDefaultMarkDeleteRateLimit = managedLedgerDefaultMarkDeleteRateLimit;
    }

    public void setAllowAutoTopicCreation(boolean allowAutoTopicCreation) {
        this.allowAutoTopicCreation = allowAutoTopicCreation;
    }

    public void setAllowAutoTopicCreationType(String allowAutoTopicCreationType) {
        this.allowAutoTopicCreationType = allowAutoTopicCreationType;
    }

    public void setAllowAutoSubscriptionCreation(boolean allowAutoSubscriptionCreation) {
        this.allowAutoSubscriptionCreation = allowAutoSubscriptionCreation;
    }

    public void setDefaultNumPartitions(int defaultNumPartitions) {
        this.defaultNumPartitions = defaultNumPartitions;
    }

    public void setManagedLedgerStorageClassName(String managedLedgerStorageClassName) {
        this.managedLedgerStorageClassName = managedLedgerStorageClassName;
    }

    public void setManagedLedgerNumWorkerThreads(int managedLedgerNumWorkerThreads) {
        this.managedLedgerNumWorkerThreads = managedLedgerNumWorkerThreads;
    }

    public void setManagedLedgerNumSchedulerThreads(int managedLedgerNumSchedulerThreads) {
        this.managedLedgerNumSchedulerThreads = managedLedgerNumSchedulerThreads;
    }

    public void setManagedLedgerMaxEntriesPerLedger(int managedLedgerMaxEntriesPerLedger) {
        this.managedLedgerMaxEntriesPerLedger = managedLedgerMaxEntriesPerLedger;
    }

    public void setManagedLedgerMinLedgerRolloverTimeMinutes(int managedLedgerMinLedgerRolloverTimeMinutes) {
        this.managedLedgerMinLedgerRolloverTimeMinutes = managedLedgerMinLedgerRolloverTimeMinutes;
    }

    public void setManagedLedgerMaxLedgerRolloverTimeMinutes(int managedLedgerMaxLedgerRolloverTimeMinutes) {
        this.managedLedgerMaxLedgerRolloverTimeMinutes = managedLedgerMaxLedgerRolloverTimeMinutes;
    }

    public void setManagedLedgerMaxSizePerLedgerMbytes(int managedLedgerMaxSizePerLedgerMbytes) {
        this.managedLedgerMaxSizePerLedgerMbytes = managedLedgerMaxSizePerLedgerMbytes;
    }

    public void setManagedLedgerOffloadDeletionLagMs(long managedLedgerOffloadDeletionLagMs) {
        this.managedLedgerOffloadDeletionLagMs = managedLedgerOffloadDeletionLagMs;
    }

    public void setManagedLedgerOffloadAutoTriggerSizeThresholdBytes(long managedLedgerOffloadAutoTriggerSizeThresholdBytes) {
        this.managedLedgerOffloadAutoTriggerSizeThresholdBytes = managedLedgerOffloadAutoTriggerSizeThresholdBytes;
    }

    public void setManagedLedgerCursorMaxEntriesPerLedger(int managedLedgerCursorMaxEntriesPerLedger) {
        this.managedLedgerCursorMaxEntriesPerLedger = managedLedgerCursorMaxEntriesPerLedger;
    }

    public void setManagedLedgerCursorRolloverTimeInSeconds(int managedLedgerCursorRolloverTimeInSeconds) {
        this.managedLedgerCursorRolloverTimeInSeconds = managedLedgerCursorRolloverTimeInSeconds;
    }

    public void setManagedLedgerMaxUnackedRangesToPersist(int managedLedgerMaxUnackedRangesToPersist) {
        this.managedLedgerMaxUnackedRangesToPersist = managedLedgerMaxUnackedRangesToPersist;
    }

    public void setManagedLedgerMaxUnackedRangesToPersistInZooKeeper(int managedLedgerMaxUnackedRangesToPersistInZooKeeper) {
        this.managedLedgerMaxUnackedRangesToPersistInZooKeeper = managedLedgerMaxUnackedRangesToPersistInZooKeeper;
    }

    public void setManagedLedgerUnackedRangesOpenCacheSetEnabled(boolean managedLedgerUnackedRangesOpenCacheSetEnabled) {
        this.managedLedgerUnackedRangesOpenCacheSetEnabled = managedLedgerUnackedRangesOpenCacheSetEnabled;
    }

    public void setAutoSkipNonRecoverableData(boolean autoSkipNonRecoverableData) {
        this.autoSkipNonRecoverableData = autoSkipNonRecoverableData;
    }

    public void setManagedLedgerMetadataOperationsTimeoutSeconds(long managedLedgerMetadataOperationsTimeoutSeconds) {
        this.managedLedgerMetadataOperationsTimeoutSeconds = managedLedgerMetadataOperationsTimeoutSeconds;
    }

    public void setManagedLedgerReadEntryTimeoutSeconds(long managedLedgerReadEntryTimeoutSeconds) {
        this.managedLedgerReadEntryTimeoutSeconds = managedLedgerReadEntryTimeoutSeconds;
    }

    public void setManagedLedgerAddEntryTimeoutSeconds(long managedLedgerAddEntryTimeoutSeconds) {
        this.managedLedgerAddEntryTimeoutSeconds = managedLedgerAddEntryTimeoutSeconds;
    }

    public void setManagedLedgerPrometheusStatsLatencyRolloverSeconds(int managedLedgerPrometheusStatsLatencyRolloverSeconds) {
        this.managedLedgerPrometheusStatsLatencyRolloverSeconds = managedLedgerPrometheusStatsLatencyRolloverSeconds;
    }

    public void setManagedLedgerTraceTaskExecution(boolean managedLedgerTraceTaskExecution) {
        this.managedLedgerTraceTaskExecution = managedLedgerTraceTaskExecution;
    }

    public void setManagedLedgerNewEntriesCheckDelayInMillis(int managedLedgerNewEntriesCheckDelayInMillis) {
        this.managedLedgerNewEntriesCheckDelayInMillis = managedLedgerNewEntriesCheckDelayInMillis;
    }

    public void setManagedLedgerDataReadPriority(String managedLedgerDataReadPriority) {
        this.managedLedgerDataReadPriority = managedLedgerDataReadPriority;
    }

    public void setManagedLedgerInfoCompressionType(String managedLedgerInfoCompressionType) {
        this.managedLedgerInfoCompressionType = managedLedgerInfoCompressionType;
    }

    public void setLoadBalancerEnabled(boolean loadBalancerEnabled) {
        this.loadBalancerEnabled = loadBalancerEnabled;
    }

    @Deprecated
    public void setLoadBalancerPlacementStrategy(String loadBalancerPlacementStrategy) {
        this.loadBalancerPlacementStrategy = loadBalancerPlacementStrategy;
    }

    public void setLoadBalancerLoadSheddingStrategy(String loadBalancerLoadSheddingStrategy) {
        this.loadBalancerLoadSheddingStrategy = loadBalancerLoadSheddingStrategy;
    }

    public void setLoadBalancerReportUpdateThresholdPercentage(int loadBalancerReportUpdateThresholdPercentage) {
        this.loadBalancerReportUpdateThresholdPercentage = loadBalancerReportUpdateThresholdPercentage;
    }

    public void setLoadBalancerReportUpdateMaxIntervalMinutes(int loadBalancerReportUpdateMaxIntervalMinutes) {
        this.loadBalancerReportUpdateMaxIntervalMinutes = loadBalancerReportUpdateMaxIntervalMinutes;
    }

    public void setLoadBalancerHostUsageCheckIntervalMinutes(int loadBalancerHostUsageCheckIntervalMinutes) {
        this.loadBalancerHostUsageCheckIntervalMinutes = loadBalancerHostUsageCheckIntervalMinutes;
    }

    public void setLoadBalancerSheddingEnabled(boolean loadBalancerSheddingEnabled) {
        this.loadBalancerSheddingEnabled = loadBalancerSheddingEnabled;
    }

    public void setLoadBalancerSheddingIntervalMinutes(int loadBalancerSheddingIntervalMinutes) {
        this.loadBalancerSheddingIntervalMinutes = loadBalancerSheddingIntervalMinutes;
    }

    public void setLoadBalancerSheddingGracePeriodMinutes(long loadBalancerSheddingGracePeriodMinutes) {
        this.loadBalancerSheddingGracePeriodMinutes = loadBalancerSheddingGracePeriodMinutes;
    }

    @Deprecated
    public void setLoadBalancerBrokerUnderloadedThresholdPercentage(int loadBalancerBrokerUnderloadedThresholdPercentage) {
        this.loadBalancerBrokerUnderloadedThresholdPercentage = loadBalancerBrokerUnderloadedThresholdPercentage;
    }

    public void setLoadBalancerBrokerMaxTopics(int loadBalancerBrokerMaxTopics) {
        this.loadBalancerBrokerMaxTopics = loadBalancerBrokerMaxTopics;
    }

    public void setLoadBalancerBrokerOverloadedThresholdPercentage(int loadBalancerBrokerOverloadedThresholdPercentage) {
        this.loadBalancerBrokerOverloadedThresholdPercentage = loadBalancerBrokerOverloadedThresholdPercentage;
    }

    public void setLoadBalancerBrokerThresholdShedderPercentage(int loadBalancerBrokerThresholdShedderPercentage) {
        this.loadBalancerBrokerThresholdShedderPercentage = loadBalancerBrokerThresholdShedderPercentage;
    }

    public void setLoadBalancerMsgRateDifferenceShedderThreshold(double loadBalancerMsgRateDifferenceShedderThreshold) {
        this.loadBalancerMsgRateDifferenceShedderThreshold = loadBalancerMsgRateDifferenceShedderThreshold;
    }

    public void setLoadBalancerMsgThroughputMultiplierDifferenceShedderThreshold(double loadBalancerMsgThroughputMultiplierDifferenceShedderThreshold) {
        this.loadBalancerMsgThroughputMultiplierDifferenceShedderThreshold = loadBalancerMsgThroughputMultiplierDifferenceShedderThreshold;
    }

    public void setLoadBalancerHistoryResourcePercentage(double loadBalancerHistoryResourcePercentage) {
        this.loadBalancerHistoryResourcePercentage = loadBalancerHistoryResourcePercentage;
    }

    public void setLoadBalancerBandwithInResourceWeight(double loadBalancerBandwithInResourceWeight) {
        this.loadBalancerBandwithInResourceWeight = loadBalancerBandwithInResourceWeight;
    }

    public void setLoadBalancerBandwithOutResourceWeight(double loadBalancerBandwithOutResourceWeight) {
        this.loadBalancerBandwithOutResourceWeight = loadBalancerBandwithOutResourceWeight;
    }

    public void setLoadBalancerCPUResourceWeight(double loadBalancerCPUResourceWeight) {
        this.loadBalancerCPUResourceWeight = loadBalancerCPUResourceWeight;
    }

    public void setLoadBalancerMemoryResourceWeight(double loadBalancerMemoryResourceWeight) {
        this.loadBalancerMemoryResourceWeight = loadBalancerMemoryResourceWeight;
    }

    public void setLoadBalancerDirectMemoryResourceWeight(double loadBalancerDirectMemoryResourceWeight) {
        this.loadBalancerDirectMemoryResourceWeight = loadBalancerDirectMemoryResourceWeight;
    }

    public void setLoadBalancerBundleUnloadMinThroughputThreshold(double loadBalancerBundleUnloadMinThroughputThreshold) {
        this.loadBalancerBundleUnloadMinThroughputThreshold = loadBalancerBundleUnloadMinThroughputThreshold;
    }

    public void setLoadBalancerResourceQuotaUpdateIntervalMinutes(int loadBalancerResourceQuotaUpdateIntervalMinutes) {
        this.loadBalancerResourceQuotaUpdateIntervalMinutes = loadBalancerResourceQuotaUpdateIntervalMinutes;
    }

    @Deprecated
    public void setLoadBalancerBrokerComfortLoadLevelPercentage(int loadBalancerBrokerComfortLoadLevelPercentage) {
        this.loadBalancerBrokerComfortLoadLevelPercentage = loadBalancerBrokerComfortLoadLevelPercentage;
    }

    public void setLoadBalancerAutoBundleSplitEnabled(boolean loadBalancerAutoBundleSplitEnabled) {
        this.loadBalancerAutoBundleSplitEnabled = loadBalancerAutoBundleSplitEnabled;
    }

    public void setLoadBalancerAutoUnloadSplitBundlesEnabled(boolean loadBalancerAutoUnloadSplitBundlesEnabled) {
        this.loadBalancerAutoUnloadSplitBundlesEnabled = loadBalancerAutoUnloadSplitBundlesEnabled;
    }

    public void setLoadBalancerNamespaceBundleMaxTopics(int loadBalancerNamespaceBundleMaxTopics) {
        this.loadBalancerNamespaceBundleMaxTopics = loadBalancerNamespaceBundleMaxTopics;
    }

    public void setLoadBalancerNamespaceBundleMaxSessions(int loadBalancerNamespaceBundleMaxSessions) {
        this.loadBalancerNamespaceBundleMaxSessions = loadBalancerNamespaceBundleMaxSessions;
    }

    public void setLoadBalancerNamespaceBundleMaxMsgRate(int loadBalancerNamespaceBundleMaxMsgRate) {
        this.loadBalancerNamespaceBundleMaxMsgRate = loadBalancerNamespaceBundleMaxMsgRate;
    }

    public void setLoadBalancerNamespaceBundleMaxBandwidthMbytes(int loadBalancerNamespaceBundleMaxBandwidthMbytes) {
        this.loadBalancerNamespaceBundleMaxBandwidthMbytes = loadBalancerNamespaceBundleMaxBandwidthMbytes;
    }

    public void setLoadBalancerNamespaceMaximumBundles(int loadBalancerNamespaceMaximumBundles) {
        this.loadBalancerNamespaceMaximumBundles = loadBalancerNamespaceMaximumBundles;
    }

    public void setLoadManagerClassName(String loadManagerClassName) {
        this.loadManagerClassName = loadManagerClassName;
    }

    public void setSupportedNamespaceBundleSplitAlgorithms(List<String> supportedNamespaceBundleSplitAlgorithms) {
        this.supportedNamespaceBundleSplitAlgorithms = supportedNamespaceBundleSplitAlgorithms;
    }

    public void setDefaultNamespaceBundleSplitAlgorithm(String defaultNamespaceBundleSplitAlgorithm) {
        this.defaultNamespaceBundleSplitAlgorithm = defaultNamespaceBundleSplitAlgorithm;
    }

    public void setLoadBalancerOverrideBrokerNicSpeedGbps(Optional<Double> loadBalancerOverrideBrokerNicSpeedGbps) {
        this.loadBalancerOverrideBrokerNicSpeedGbps = loadBalancerOverrideBrokerNicSpeedGbps;
    }

    public void setNamespaceBundleUnloadingTimeoutMs(long namespaceBundleUnloadingTimeoutMs) {
        this.namespaceBundleUnloadingTimeoutMs = namespaceBundleUnloadingTimeoutMs;
    }

    public void setReplicationMetricsEnabled(boolean replicationMetricsEnabled) {
        this.replicationMetricsEnabled = replicationMetricsEnabled;
    }

    public void setReplicationConnectionsPerBroker(int replicationConnectionsPerBroker) {
        this.replicationConnectionsPerBroker = replicationConnectionsPerBroker;
    }

    public void setReplicatorPrefix(String replicatorPrefix) {
        this.replicatorPrefix = replicatorPrefix;
    }

    public void setReplicationProducerQueueSize(int replicationProducerQueueSize) {
        this.replicationProducerQueueSize = replicationProducerQueueSize;
    }

    public void setReplicationPolicyCheckDurationSeconds(int replicationPolicyCheckDurationSeconds) {
        this.replicationPolicyCheckDurationSeconds = replicationPolicyCheckDurationSeconds;
    }

    @Deprecated
    public void setReplicationTlsEnabled(boolean replicationTlsEnabled) {
        this.replicationTlsEnabled = replicationTlsEnabled;
    }

    public void setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
    }

    public void setDefaultRetentionTimeInMinutes(int defaultRetentionTimeInMinutes) {
        this.defaultRetentionTimeInMinutes = defaultRetentionTimeInMinutes;
    }

    public void setDefaultRetentionSizeInMB(int defaultRetentionSizeInMB) {
        this.defaultRetentionSizeInMB = defaultRetentionSizeInMB;
    }

    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    @Deprecated
    public void setBrokerServicePurgeInactiveFrequencyInSeconds(int brokerServicePurgeInactiveFrequencyInSeconds) {
        this.brokerServicePurgeInactiveFrequencyInSeconds = brokerServicePurgeInactiveFrequencyInSeconds;
    }

    public void setBootstrapNamespaces(List<String> bootstrapNamespaces) {
        this.bootstrapNamespaces = bootstrapNamespaces;
    }

    public void setPreferLaterVersions(boolean preferLaterVersions) {
        this.preferLaterVersions = preferLaterVersions;
    }

    public void setBrokerServiceCompactionMonitorIntervalInSeconds(int brokerServiceCompactionMonitorIntervalInSeconds) {
        this.brokerServiceCompactionMonitorIntervalInSeconds = brokerServiceCompactionMonitorIntervalInSeconds;
    }

    public void setBrokerServiceCompactionThresholdInBytes(long brokerServiceCompactionThresholdInBytes) {
        this.brokerServiceCompactionThresholdInBytes = brokerServiceCompactionThresholdInBytes;
    }

    public void setBrokerServiceCompactionPhaseOneLoopTimeInSeconds(long brokerServiceCompactionPhaseOneLoopTimeInSeconds) {
        this.brokerServiceCompactionPhaseOneLoopTimeInSeconds = brokerServiceCompactionPhaseOneLoopTimeInSeconds;
    }

    public void setSchemaValidationEnforced(boolean isSchemaValidationEnforced) {
        this.isSchemaValidationEnforced = isSchemaValidationEnforced;
    }

    public void setSchemaRegistryStorageClassName(String schemaRegistryStorageClassName) {
        this.schemaRegistryStorageClassName = schemaRegistryStorageClassName;
    }

    public void setSchemaRegistryCompatibilityCheckers(Set<String> schemaRegistryCompatibilityCheckers) {
        this.schemaRegistryCompatibilityCheckers = schemaRegistryCompatibilityCheckers;
    }

    public void setSchemaCompatibilityStrategy(SchemaCompatibilityStrategy schemaCompatibilityStrategy) {
        this.schemaCompatibilityStrategy = schemaCompatibilityStrategy;
    }

    public void setWebSocketNumIoThreads(int webSocketNumIoThreads) {
        this.webSocketNumIoThreads = webSocketNumIoThreads;
    }

    public void setWebSocketConnectionsPerBroker(int webSocketConnectionsPerBroker) {
        this.webSocketConnectionsPerBroker = webSocketConnectionsPerBroker;
    }

    public void setWebSocketSessionIdleTimeoutMillis(int webSocketSessionIdleTimeoutMillis) {
        this.webSocketSessionIdleTimeoutMillis = webSocketSessionIdleTimeoutMillis;
    }

    public void setWebSocketMaxTextFrameSize(int webSocketMaxTextFrameSize) {
        this.webSocketMaxTextFrameSize = webSocketMaxTextFrameSize;
    }

    public void setExposeTopicLevelMetricsInPrometheus(boolean exposeTopicLevelMetricsInPrometheus) {
        this.exposeTopicLevelMetricsInPrometheus = exposeTopicLevelMetricsInPrometheus;
    }

    public void setExposeConsumerLevelMetricsInPrometheus(boolean exposeConsumerLevelMetricsInPrometheus) {
        this.exposeConsumerLevelMetricsInPrometheus = exposeConsumerLevelMetricsInPrometheus;
    }

    public void setExposeProducerLevelMetricsInPrometheus(boolean exposeProducerLevelMetricsInPrometheus) {
        this.exposeProducerLevelMetricsInPrometheus = exposeProducerLevelMetricsInPrometheus;
    }

    public void setExposeManagedLedgerMetricsInPrometheus(boolean exposeManagedLedgerMetricsInPrometheus) {
        this.exposeManagedLedgerMetricsInPrometheus = exposeManagedLedgerMetricsInPrometheus;
    }

    public void setExposeManagedCursorMetricsInPrometheus(boolean exposeManagedCursorMetricsInPrometheus) {
        this.exposeManagedCursorMetricsInPrometheus = exposeManagedCursorMetricsInPrometheus;
    }

    public void setJvmGCMetricsLoggerClassName(String jvmGCMetricsLoggerClassName) {
        this.jvmGCMetricsLoggerClassName = jvmGCMetricsLoggerClassName;
    }

    public void setExposePreciseBacklogInPrometheus(boolean exposePreciseBacklogInPrometheus) {
        this.exposePreciseBacklogInPrometheus = exposePreciseBacklogInPrometheus;
    }

    public void setMetricsServletTimeoutMs(long metricsServletTimeoutMs) {
        this.metricsServletTimeoutMs = metricsServletTimeoutMs;
    }

    public void setExposeSubscriptionBacklogSizeInPrometheus(boolean exposeSubscriptionBacklogSizeInPrometheus) {
        this.exposeSubscriptionBacklogSizeInPrometheus = exposeSubscriptionBacklogSizeInPrometheus;
    }

    public void setSplitTopicAndPartitionLabelInPrometheus(boolean splitTopicAndPartitionLabelInPrometheus) {
        this.splitTopicAndPartitionLabelInPrometheus = splitTopicAndPartitionLabelInPrometheus;
    }

    public void setExposeBundlesMetricsInPrometheus(boolean exposeBundlesMetricsInPrometheus) {
        this.exposeBundlesMetricsInPrometheus = exposeBundlesMetricsInPrometheus;
    }

    public void setFunctionsWorkerEnabled(boolean functionsWorkerEnabled) {
        this.functionsWorkerEnabled = functionsWorkerEnabled;
    }

    public void setFunctionsWorkerServiceNarPackage(String functionsWorkerServiceNarPackage) {
        this.functionsWorkerServiceNarPackage = functionsWorkerServiceNarPackage;
    }

    public void setExposePublisherStats(boolean exposePublisherStats) {
        this.exposePublisherStats = exposePublisherStats;
    }

    public void setStatsUpdateFrequencyInSecs(int statsUpdateFrequencyInSecs) {
        this.statsUpdateFrequencyInSecs = statsUpdateFrequencyInSecs;
    }

    public void setStatsUpdateInitialDelayInSecs(int statsUpdateInitialDelayInSecs) {
        this.statsUpdateInitialDelayInSecs = statsUpdateInitialDelayInSecs;
    }

    public void setAggregatePublisherStatsByProducerName(boolean aggregatePublisherStatsByProducerName) {
        this.aggregatePublisherStatsByProducerName = aggregatePublisherStatsByProducerName;
    }

    public void setOffloadersDirectory(String offloadersDirectory) {
        this.offloadersDirectory = offloadersDirectory;
    }

    public void setManagedLedgerOffloadDriver(String managedLedgerOffloadDriver) {
        this.managedLedgerOffloadDriver = managedLedgerOffloadDriver;
    }

    public void setManagedLedgerOffloadMaxThreads(int managedLedgerOffloadMaxThreads) {
        this.managedLedgerOffloadMaxThreads = managedLedgerOffloadMaxThreads;
    }

    public void setNarExtractionDirectory(String narExtractionDirectory) {
        this.narExtractionDirectory = narExtractionDirectory;
    }

    public void setManagedLedgerOffloadPrefetchRounds(int managedLedgerOffloadPrefetchRounds) {
        this.managedLedgerOffloadPrefetchRounds = managedLedgerOffloadPrefetchRounds;
    }

    public void setManagedLedgerInactiveLedgerRolloverTimeSeconds(int managedLedgerInactiveLedgerRolloverTimeSeconds) {
        this.managedLedgerInactiveLedgerRolloverTimeSeconds = managedLedgerInactiveLedgerRolloverTimeSeconds;
    }

    public void setTransactionCoordinatorEnabled(boolean transactionCoordinatorEnabled) {
        this.transactionCoordinatorEnabled = transactionCoordinatorEnabled;
    }

    public void setTransactionMetadataStoreProviderClassName(String transactionMetadataStoreProviderClassName) {
        this.transactionMetadataStoreProviderClassName = transactionMetadataStoreProviderClassName;
    }

    public void setTransactionBufferProviderClassName(String transactionBufferProviderClassName) {
        this.transactionBufferProviderClassName = transactionBufferProviderClassName;
    }

    public void setTransactionPendingAckStoreProviderClassName(String transactionPendingAckStoreProviderClassName) {
        this.transactionPendingAckStoreProviderClassName = transactionPendingAckStoreProviderClassName;
    }

    public void setNumTransactionReplayThreadPoolSize(int numTransactionReplayThreadPoolSize) {
        this.numTransactionReplayThreadPoolSize = numTransactionReplayThreadPoolSize;
    }

    public void setTransactionBufferSnapshotMaxTransactionCount(int transactionBufferSnapshotMaxTransactionCount) {
        this.transactionBufferSnapshotMaxTransactionCount = transactionBufferSnapshotMaxTransactionCount;
    }

    public void setTransactionBufferSnapshotMinTimeInMillis(int transactionBufferSnapshotMinTimeInMillis) {
        this.transactionBufferSnapshotMinTimeInMillis = transactionBufferSnapshotMinTimeInMillis;
    }

    public void setTlsEnabledWithKeyStore(boolean tlsEnabledWithKeyStore) {
        this.tlsEnabledWithKeyStore = tlsEnabledWithKeyStore;
    }

    public void setTlsProvider(String tlsProvider) {
        this.tlsProvider = tlsProvider;
    }

    public void setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
    }

    public void setTlsKeyStore(String tlsKeyStore) {
        this.tlsKeyStore = tlsKeyStore;
    }

    public void setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
    }

    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    public void setTlsTrustStore(String tlsTrustStore) {
        this.tlsTrustStore = tlsTrustStore;
    }

    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    public void setBrokerClientTlsEnabledWithKeyStore(boolean brokerClientTlsEnabledWithKeyStore) {
        this.brokerClientTlsEnabledWithKeyStore = brokerClientTlsEnabledWithKeyStore;
    }

    public void setBrokerClientSslProvider(String brokerClientSslProvider) {
        this.brokerClientSslProvider = brokerClientSslProvider;
    }

    public void setBrokerClientTlsTrustStoreType(String brokerClientTlsTrustStoreType) {
        this.brokerClientTlsTrustStoreType = brokerClientTlsTrustStoreType;
    }

    public void setBrokerClientTlsTrustStore(String brokerClientTlsTrustStore) {
        this.brokerClientTlsTrustStore = brokerClientTlsTrustStore;
    }

    public void setBrokerClientTlsTrustStorePassword(String brokerClientTlsTrustStorePassword) {
        this.brokerClientTlsTrustStorePassword = brokerClientTlsTrustStorePassword;
    }

    public void setBrokerClientTlsCiphers(Set<String> brokerClientTlsCiphers) {
        this.brokerClientTlsCiphers = brokerClientTlsCiphers;
    }

    public void setBrokerClientTlsProtocols(Set<String> brokerClientTlsProtocols) {
        this.brokerClientTlsProtocols = brokerClientTlsProtocols;
    }

    public void setEnablePackagesManagement(boolean enablePackagesManagement) {
        this.enablePackagesManagement = enablePackagesManagement;
    }

    public void setPackagesManagementStorageProvider(String packagesManagementStorageProvider) {
        this.packagesManagementStorageProvider = packagesManagementStorageProvider;
    }

    public void setPackagesReplicas(int packagesReplicas) {
        this.packagesReplicas = packagesReplicas;
    }

    public void setPackagesManagementLedgerRootPath(String packagesManagementLedgerRootPath) {
        this.packagesManagementLedgerRootPath = packagesManagementLedgerRootPath;
    }

    public void setAdditionalServletDirectory(String additionalServletDirectory) {
        this.additionalServletDirectory = additionalServletDirectory;
    }

    public void setAdditionalServlets(Set<String> additionalServlets) {
        this.additionalServlets = additionalServlets;
    }
}

