/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.decoders;

import org.apache.pulsar.shade.javax.websocket.DecodeException;
import org.apache.pulsar.shade.javax.websocket.Decoder;
import org.apache.pulsar.shade.org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class DoubleDecoder
extends AbstractDecoder
implements Decoder.Text<Double> {
    public static final DoubleDecoder INSTANCE = new DoubleDecoder();

    @Override
    public Double decode(String s) throws DecodeException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse double", (Throwable)e);
        }
    }

    @Override
    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

