/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.zookeeper.server.watch;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.pulsar.shade.org.apache.zookeeper.Watcher;
import org.apache.pulsar.shade.org.apache.zookeeper.server.watch.WatcherMode;

class WatcherModeManager {
    private final Map<Key, WatcherMode> watcherModes = new ConcurrentHashMap<Key, WatcherMode>();
    private final AtomicInteger recursiveQty = new AtomicInteger(0);

    WatcherModeManager() {
    }

    Map<Key, WatcherMode> getWatcherModes() {
        return this.watcherModes;
    }

    void setWatcherMode(Watcher watcher, String path, WatcherMode mode) {
        if (mode == WatcherMode.DEFAULT_WATCHER_MODE) {
            this.removeWatcher(watcher, path);
        } else {
            this.adjustRecursiveQty(this.watcherModes.put(new Key(watcher, path), mode), mode);
        }
    }

    WatcherMode getWatcherMode(Watcher watcher, String path) {
        return this.watcherModes.getOrDefault(new Key(watcher, path), WatcherMode.DEFAULT_WATCHER_MODE);
    }

    void removeWatcher(Watcher watcher, String path) {
        this.adjustRecursiveQty(this.watcherModes.remove(new Key(watcher, path)), WatcherMode.DEFAULT_WATCHER_MODE);
    }

    int getRecursiveQty() {
        return this.recursiveQty.get();
    }

    private void adjustRecursiveQty(WatcherMode oldMode, WatcherMode newMode) {
        if (oldMode == null) {
            oldMode = WatcherMode.DEFAULT_WATCHER_MODE;
        }
        if (oldMode.isRecursive() != newMode.isRecursive()) {
            if (newMode.isRecursive()) {
                this.recursiveQty.incrementAndGet();
            } else {
                this.recursiveQty.decrementAndGet();
            }
        }
    }

    private static class Key {
        private final Watcher watcher;
        private final String path;

        Key(Watcher watcher, String path) {
            this.watcher = watcher;
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.watcher.equals(key.watcher) && this.path.equals(key.path);
        }

        public int hashCode() {
            return Objects.hash(this.watcher, this.path);
        }
    }
}

