/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.commands.bookie;

import java.io.File;
import java.io.IOException;
import org.apache.pulsar.shade.com.beust.jcommander.Parameter;
import org.apache.pulsar.shade.com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.bookie.ReadOnlyEntryLogger;
import org.apache.pulsar.shade.org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.pulsar.shade.org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.pulsar.shade.org.apache.bookkeeper.util.LedgerIdFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadLogMetadataCommand
extends BookieCommand<ReadLogMetadataFlags> {
    static final Logger LOG = LoggerFactory.getLogger(ReadLogMetadataCommand.class);
    private static final String NAME = "readlogmetadata";
    private static final String DESC = "Prints entrylog's metadata";
    private static final long DEFAULT_LOGID = -1L;
    private static final String DEFAULT_FILENAME = "";
    private static final String DEFAULT = "";
    private LedgerIdFormatter ledgerIdFormatter;
    EntryLogger entryLogger = null;

    public ReadLogMetadataCommand() {
        this(new ReadLogMetadataFlags());
    }

    public ReadLogMetadataCommand(LedgerIdFormatter ledgerIdFormatter) {
        this(new ReadLogMetadataFlags());
        this.ledgerIdFormatter = ledgerIdFormatter;
    }

    private ReadLogMetadataCommand(ReadLogMetadataFlags flags) {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags(flags).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, ReadLogMetadataFlags cmdFlags) {
        if (!cmdFlags.ledgerIdFormatter.equals("") && this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(cmdFlags.ledgerIdFormatter, conf);
        } else if (this.ledgerIdFormatter == null) {
            this.ledgerIdFormatter = LedgerIdFormatter.newLedgerIdFormatter(conf);
        }
        if (cmdFlags.logId == -1L && cmdFlags.logFilename.equals("")) {
            LOG.error("Missing entry log id or entry log file name");
            return false;
        }
        try {
            return this.readLogMetadata(conf, cmdFlags);
        }
        catch (IOException e) {
            throw new UncheckedExecutionException(e.getMessage(), e);
        }
    }

    public boolean readLogMetadata(ServerConfiguration conf, ReadLogMetadataFlags flags) throws IOException {
        long logid = -1L;
        if (flags.logId != -1L) {
            logid = flags.logId;
        } else if (!flags.logFilename.equals("")) {
            File f = new File(flags.logFilename);
            String name = f.getName();
            if (!name.endsWith(".log")) {
                LOG.error("ERROR: invalid entry log file name " + flags.logFilename);
                return false;
            }
            String idString = name.split("\\.")[0];
            logid = Long.parseLong(idString, 16);
        }
        this.printEntryLogMetadata(conf, logid);
        return true;
    }

    private void printEntryLogMetadata(ServerConfiguration conf, long logId) throws IOException {
        LOG.info("Print entryLogMetadata of entrylog {} ({}.log)", (Object)logId, (Object)Long.toHexString(logId));
        this.initEntryLogger(conf);
        EntryLogMetadata entryLogMetadata = this.entryLogger.getEntryLogMetadata(logId);
        entryLogMetadata.getLedgersMap().forEach((ledgerId, size) -> LOG.info("--------- Lid={}, TotalSizeOfEntriesOfLedger={}  ---------", (Object)this.ledgerIdFormatter.formatLedgerId(ledgerId), (Object)size));
    }

    private synchronized void initEntryLogger(ServerConfiguration conf) throws IOException {
        if (null == this.entryLogger) {
            this.entryLogger = new ReadOnlyEntryLogger(conf);
        }
    }

    public static class ReadLogMetadataFlags
    extends CliFlags {
        @Parameter(names={"-l", "--logid"}, description="Entry log id")
        private long logId;
        @Parameter(names={"-f", "--filename"}, description="Entry log filename")
        private String logFilename;
        @Parameter(names={"-lf", "--ledgeridformatter"}, description="Set ledger id formatter")
        private String ledgerIdFormatter = "";

        public ReadLogMetadataFlags logId(long logId) {
            this.logId = logId;
            return this;
        }

        public ReadLogMetadataFlags logFilename(String logFilename) {
            this.logFilename = logFilename;
            return this;
        }

        public ReadLogMetadataFlags ledgerIdFormatter(String ledgerIdFormatter) {
            this.ledgerIdFormatter = ledgerIdFormatter;
            return this;
        }
    }
}

