/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.bookkeeper.common.util;

import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;

public class JsonUtil {
    private static ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object object) throws ParseJsonException {
        try {
            return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (Exception e) {
            throw new ParseJsonException("Failed to serialize Object to Json string", e);
        }
    }

    public static <T> T fromJson(String jsonStr, Class<T> valueType) throws ParseJsonException {
        try {
            return mapper.readValue(jsonStr, valueType);
        }
        catch (Exception e) {
            throw new ParseJsonException("Failed to deserialize Object from Json string", e);
        }
    }

    public static class ParseJsonException
    extends Exception {
        public ParseJsonException(String message) {
            super(message);
        }

        public ParseJsonException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

