/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.shade.io.prometheus.client.CollectorRegistry;
import org.apache.pulsar.shade.io.prometheus.client.exporter.common.TextFormat;
import org.apache.pulsar.shade.javax.ws.rs.GET;
import org.apache.pulsar.shade.javax.ws.rs.Path;
import org.apache.pulsar.shade.javax.ws.rs.Produces;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.javax.ws.rs.core.StreamingOutput;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.SimpleTextOutputStream;

@Path(value="/")
public class FunctionsMetricsResource
extends FunctionApiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="metrics")
    @GET
    @Produces(value={"text/plain"})
    public Response getMetrics() throws IOException {
        WorkerService workerService = this.get();
        ByteBuf buf = ByteBufAllocator.DEFAULT.heapBuffer();
        if (workerService.getWorkerConfig().isIncludeStandardPrometheusMetrics()) {
            BufWriter writer = new BufWriter(buf);
            TextFormat.write004(writer, CollectorRegistry.defaultRegistry.metricFamilySamples());
        }
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            workerService.generateFunctionsStats(stream);
            byte[] payload = buf.array();
            int arrayOffset = buf.arrayOffset();
            int readableBytes = buf.readableBytes();
            StreamingOutput streamOut = out -> {
                out.write(payload, arrayOffset, readableBytes);
                out.flush();
            };
            Response response = Response.ok(streamOut).type(MediaType.TEXT_PLAIN_TYPE).build();
            return response;
        }
        finally {
            buf.release();
        }
    }

    private static class BufWriter
    extends Writer {
        private final ByteBuf buf;

        public BufWriter(ByteBuf buf) {
            this.buf = buf;
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.buf.writeCharSequence(CharBuffer.wrap(cbuf, off, len), StandardCharsets.UTF_8);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

