/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import net.jodah.typetools.TypeResolver;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.TopicMessageIdImpl;
import org.apache.pulsar.functions.api.WindowFunction;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.io.core.BatchSource;
import org.apache.pulsar.io.core.Sink;
import org.apache.pulsar.io.core.Source;
import org.apache.pulsar.shade.com.google.protobuf.AbstractMessage;
import org.apache.pulsar.shade.com.google.protobuf.Message;
import org.apache.pulsar.shade.com.google.protobuf.MessageOrBuilder;
import org.apache.pulsar.shade.com.google.protobuf.util.JsonFormat;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.shade.org.apache.pulsar.common.nar.NarClassLoaderBuilder;
import org.apache.pulsar.shade.org.apache.pulsar.common.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionCommon {
    private static final Logger log = LoggerFactory.getLogger(FunctionCommon.class);

    public static String printJson(MessageOrBuilder msg) throws IOException {
        return JsonFormat.printer().print(msg);
    }

    public static void mergeJson(String json, AbstractMessage.Builder builder) throws IOException {
        JsonFormat.parser().merge(json, (Message.Builder)builder);
    }

    public static int findAvailablePort() {
        try {
            ServerSocket socket = new ServerSocket(0);
            int port = socket.getLocalPort();
            socket.close();
            return port;
        }
        catch (IOException ex) {
            throw new RuntimeException("No free port found", ex);
        }
    }

    public static Class<?>[] getFunctionTypes(FunctionConfig functionConfig, ClassLoader classLoader) throws ClassNotFoundException {
        boolean isWindowConfigPresent = functionConfig.getWindowConfig() != null;
        Class<?> functionClass = classLoader.loadClass(functionConfig.getClassName());
        return FunctionCommon.getFunctionTypes(functionClass, isWindowConfigPresent);
    }

    public static Class<?>[] getFunctionTypes(Class userClass, boolean isWindowConfigPresent) {
        Class[] typeArgs;
        if (isWindowConfigPresent) {
            if (WindowFunction.class.isAssignableFrom(userClass)) {
                typeArgs = TypeResolver.resolveRawArguments(WindowFunction.class, (Class)userClass);
            } else {
                typeArgs = TypeResolver.resolveRawArguments(Function.class, (Class)userClass);
                if (!typeArgs[0].equals(Collection.class)) {
                    throw new IllegalArgumentException("Window function must take a collection as input");
                }
                Type type = TypeResolver.resolveGenericType(Function.class, (Type)userClass);
                Type collectionType = ((ParameterizedType)type).getActualTypeArguments()[0];
                Type actualInputType = ((ParameterizedType)collectionType).getActualTypeArguments()[0];
                typeArgs[0] = (Class)actualInputType;
            }
        } else {
            typeArgs = org.apache.pulsar.functions.api.Function.class.isAssignableFrom(userClass) ? TypeResolver.resolveRawArguments(org.apache.pulsar.functions.api.Function.class, (Class)userClass) : TypeResolver.resolveRawArguments(Function.class, (Class)userClass);
        }
        return typeArgs;
    }

    public static Object createInstance(String userClassName, ClassLoader classLoader) {
        Object result;
        Class<?> theCls;
        try {
            theCls = Class.forName(userClassName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError cnfe) {
            try {
                theCls = Class.forName(userClassName, true, classLoader);
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                throw new RuntimeException("User class must be in class path", cnfe);
            }
        }
        try {
            Constructor<?> meth = theCls.getDeclaredConstructor(new Class[0]);
            meth.setAccessible(true);
            result = meth.newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("User class must be concrete", ie);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("User class doesn't have such method", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("User class must have a no-arg constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("User class constructor throws exception", e);
        }
        return result;
    }

    public static Function.FunctionDetails.Runtime convertRuntime(FunctionConfig.Runtime runtime) {
        for (Function.FunctionDetails.Runtime type : Function.FunctionDetails.Runtime.values()) {
            if (!type.name().equals(runtime.name())) continue;
            return type;
        }
        throw new RuntimeException("Unrecognized runtime: " + runtime.name());
    }

    public static FunctionConfig.Runtime convertRuntime(Function.FunctionDetails.Runtime runtime) {
        for (FunctionConfig.Runtime type : FunctionConfig.Runtime.values()) {
            if (!type.name().equals(runtime.name())) continue;
            return type;
        }
        throw new RuntimeException("Unrecognized runtime: " + runtime.name());
    }

    public static Function.ProcessingGuarantees convertProcessingGuarantee(FunctionConfig.ProcessingGuarantees processingGuarantees) {
        for (Function.ProcessingGuarantees type : Function.ProcessingGuarantees.values()) {
            if (!type.name().equals(processingGuarantees.name())) continue;
            return type;
        }
        throw new RuntimeException("Unrecognized processing guarantee: " + processingGuarantees.name());
    }

    public static FunctionConfig.ProcessingGuarantees convertProcessingGuarantee(Function.ProcessingGuarantees processingGuarantees) {
        for (FunctionConfig.ProcessingGuarantees type : FunctionConfig.ProcessingGuarantees.values()) {
            if (!type.name().equals(processingGuarantees.name())) continue;
            return type;
        }
        throw new RuntimeException("Unrecognized processing guarantee: " + processingGuarantees.name());
    }

    public static Class<?> getSourceType(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return FunctionCommon.getSourceType(classLoader.loadClass(className));
    }

    public static Class<?> getSourceType(Class sourceClass) {
        if (Source.class.isAssignableFrom(sourceClass)) {
            return TypeResolver.resolveRawArgument(Source.class, (Class)sourceClass);
        }
        if (BatchSource.class.isAssignableFrom(sourceClass)) {
            return TypeResolver.resolveRawArgument(BatchSource.class, (Class)sourceClass);
        }
        throw new IllegalArgumentException(String.format("Source class %s does not implement the correct interface", sourceClass.getName()));
    }

    public static Class<?> getSinkType(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return FunctionCommon.getSinkType(classLoader.loadClass(className));
    }

    public static Class<?> getSinkType(Class sinkClass) {
        return TypeResolver.resolveRawArgument(Sink.class, (Class)sinkClass);
    }

    public static void downloadFromHttpUrl(String destPkgUrl, File targetFile) throws IOException {
        URL website = new URL(destPkgUrl);
        try (InputStream in = website.openStream();){
            log.info("Downloading function package from {} to {} ...", (Object)destPkgUrl, (Object)targetFile.getAbsoluteFile());
            Files.copy(in, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        log.info("Downloading function package from {} to {} completed!", (Object)destPkgUrl, (Object)targetFile.getAbsoluteFile());
    }

    public static ClassLoader extractClassLoader(String destPkgUrl) throws IOException, URISyntaxException {
        File file = FunctionCommon.extractFileFromPkgURL(destPkgUrl);
        try {
            return ClassLoaderUtils.loadJar(file);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Corrupt User PackageFile " + file + " with error " + e.getMessage());
        }
    }

    public static File createPkgTempFile() throws IOException {
        return File.createTempFile("functions", ".tmp");
    }

    public static File extractFileFromPkgURL(String destPkgUrl) throws IOException, URISyntaxException {
        if (destPkgUrl.startsWith("file")) {
            URL url = new URL(destPkgUrl);
            File file = new File(url.toURI());
            if (!file.exists()) {
                throw new IOException(destPkgUrl + " does not exists locally");
            }
            return file;
        }
        if (destPkgUrl.startsWith("http")) {
            File tempFile = FunctionCommon.createPkgTempFile();
            tempFile.deleteOnExit();
            FunctionCommon.downloadFromHttpUrl(destPkgUrl, tempFile);
            return tempFile;
        }
        throw new IllegalArgumentException("Unsupported url protocol " + destPkgUrl + ", supported url protocols: [file/http/https]");
    }

    public static NarClassLoader extractNarClassLoader(File packageFile, String narExtractionDirectory) {
        if (packageFile != null) {
            try {
                return NarClassLoaderBuilder.builder().narFile(packageFile).extractionDirectory(narExtractionDirectory).build();
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return null;
    }

    public static String getFullyQualifiedInstanceId(Function.Instance instance) {
        return FunctionCommon.getFullyQualifiedInstanceId(instance.getFunctionMetaData().getFunctionDetails().getTenant(), instance.getFunctionMetaData().getFunctionDetails().getNamespace(), instance.getFunctionMetaData().getFunctionDetails().getName(), instance.getInstanceId());
    }

    public static String getFullyQualifiedInstanceId(String tenant, String namespace, String functionName, int instanceId) {
        return String.format("%s/%s/%s:%d", tenant, namespace, functionName, instanceId);
    }

    public static final long getSequenceId(MessageId messageId) {
        MessageIdImpl msgId = (MessageIdImpl)(messageId instanceof TopicMessageIdImpl ? ((TopicMessageIdImpl)messageId).getInnerMessageId() : messageId);
        long ledgerId = msgId.getLedgerId();
        long entryId = msgId.getEntryId();
        long offset = ledgerId << 28 | entryId;
        return offset;
    }

    public static final MessageId getMessageId(long sequenceId) {
        long ledgerId = sequenceId >>> 28;
        long entryId = sequenceId & 0xFFFFFFFL;
        return new MessageIdImpl(ledgerId, entryId, -1);
    }

    public static byte[] toByteArray(Object obj) throws IOException {
        byte[] bytes = null;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream oos = new ObjectOutputStream(bos);){
            oos.writeObject(obj);
            oos.flush();
            bytes = bos.toByteArray();
        }
        return bytes;
    }

    public static String getUniquePackageName(String packageName) {
        return String.format("%s-%s", UUID.randomUUID().toString(), packageName);
    }

    public static String getStateNamespace(String tenant, String namespace) {
        return String.format("%s_%s", tenant, namespace).replace("-", "_");
    }

    public static String getFullyQualifiedName(Function.FunctionDetails functionDetails) {
        return FunctionCommon.getFullyQualifiedName(functionDetails.getTenant(), functionDetails.getNamespace(), functionDetails.getName());
    }

    public static String getFullyQualifiedName(String tenant, String namespace, String functionName) {
        return String.format("%s/%s/%s", tenant, namespace, functionName);
    }

    public static String extractTenantFromFullyQualifiedName(String fqfn) {
        return FunctionCommon.extractFromFullyQualifiedName(fqfn, 0);
    }

    public static String extractNamespaceFromFullyQualifiedName(String fqfn) {
        return FunctionCommon.extractFromFullyQualifiedName(fqfn, 1);
    }

    public static String extractNameFromFullyQualifiedName(String fqfn) {
        return FunctionCommon.extractFromFullyQualifiedName(fqfn, 2);
    }

    private static String extractFromFullyQualifiedName(String fqfn, int index) {
        String[] parts = fqfn.split("/");
        if (parts.length >= 3) {
            return parts[index];
        }
        throw new RuntimeException("Invalid Fully Qualified Function Name " + fqfn);
    }

    public static Class<?> getTypeArg(String className, Class<?> funClass, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> loadedClass = classLoader.loadClass(className);
        if (!funClass.isAssignableFrom(loadedClass)) {
            throw new IllegalArgumentException(String.format("class %s is not type of %s", className, funClass.getName()));
        }
        return TypeResolver.resolveRawArgument(funClass, loadedClass);
    }

    public static double roundDecimal(double value, int places) {
        double scale = Math.pow(10.0, places);
        return (double)Math.round(value * scale) / scale;
    }

    /*
     * Exception decompiling
     */
    public static ClassLoader getClassLoaderFromPackage(Function.FunctionDetails.ComponentType componentType, String className, File packageFile, String narExtractionDirectory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String capFirstLetter(Enum en) {
        return StringUtils.capitalize(en.toString().toLowerCase());
    }

    public static boolean isFunctionCodeBuiltin(Function.FunctionDetailsOrBuilder functionDetails) {
        Function.SinkSpec sinkSpec;
        Function.SourceSpec sourceSpec;
        if (functionDetails.hasSource() && !StringUtils.isEmpty((sourceSpec = functionDetails.getSource()).getBuiltin())) {
            return true;
        }
        if (functionDetails.hasSink() && !StringUtils.isEmpty((sinkSpec = functionDetails.getSink()).getBuiltin())) {
            return true;
        }
        return !StringUtils.isEmpty(functionDetails.getBuiltin());
    }

    public static SubscriptionInitialPosition convertFromFunctionDetailsSubscriptionPosition(Function.SubscriptionPosition subscriptionPosition) {
        if (Function.SubscriptionPosition.EARLIEST.equals(subscriptionPosition)) {
            return SubscriptionInitialPosition.Earliest;
        }
        return SubscriptionInitialPosition.Latest;
    }

    private FunctionCommon() {
    }
}

